/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mediashape.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 15:17:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_slideshow.hxx"

// must be first
#include <canvas/debug.hxx>
#include <canvas/verbosetrace.hxx>
#include <canvas/canvastools.hxx>

#include "mediashape.hxx"
#include "tools.hxx"

#include <boost/bind.hpp>
#include <boost/mem_fn.hpp>
#include <algorithm>


using namespace ::com::sun::star;


namespace slideshow
{
    namespace internal
    {
        MediaShape::MediaShape( const uno::Reference< drawing::XShape >& xShape,
                              	double									 nPrio,
                                const SlideShowContext&                  rContext ) :
            ExternalShapeBase( xShape, nPrio, rContext ),
            maViewMediaShapes() 
        {
        }

		// ---------------------------------------------------------------------
		
        void MediaShape::addViewLayer( const ViewLayerSharedPtr& rNewLayer,
                                       bool						 bRedrawLayer )
        {
            ViewMediaShapeVector::iterator aEnd( maViewMediaShapes.end() );

            // already added?
            if( ::std::find_if( maViewMediaShapes.begin(), 
                                aEnd, 
                                ::boost::bind<bool>( 
                                    ::std::equal_to< ViewLayerSharedPtr >(),
                                    ::boost::bind( &ViewMediaShape::getViewLayer,
                                                   _1 ),
                                    ::boost::cref( rNewLayer ) ) ) == aEnd )
            {
				maViewMediaShapes.push_back( 
					ViewMediaShapeSharedPtr( new ViewMediaShape( rNewLayer, 
                                                                 getXShape(),
                                                                 mxComponentContext )));
                
                // push new size to view shape
                maViewMediaShapes.back()->resize( MediaShape::getPosSize() );
                
				// render the Shape on the newly added ViewLayer
				if( bRedrawLayer )
					maViewMediaShapes.back()->render( MediaShape::getPosSize() );
			}
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::removeViewLayer( const ViewLayerSharedPtr& rLayer )
        {
            const ViewMediaShapeVector::iterator aEnd( maViewMediaShapes.end() );

            OSL_ENSURE( ::std::count_if(maViewMediaShapes.begin(), 
                                        aEnd, 
                                        ::boost::bind<bool>( 
                                            ::std::equal_to< ViewLayerSharedPtr >(),
                                            ::boost::bind( &ViewMediaShape::getViewLayer, _1 ),
                                            ::boost::cref( rLayer ) ) ) < 2,
                        "MediaShape::removeViewLayer(): Duplicate ViewLayer entries!" );

            ViewMediaShapeVector::iterator aIter;

            if( (aIter=::std::remove_if( maViewMediaShapes.begin(), 
                                         aEnd, 
                                         ::boost::bind<bool>( 
                                             ::std::equal_to< ViewLayerSharedPtr >(),
                                             ::boost::bind( &ViewMediaShape::getViewLayer,
                                                            _1 ),
                                             ::boost::cref( rLayer ) ) )) == aEnd )
            {
                // view layer seemingly was not added, failed
                return false;
            }

            // actually erase from container
            maViewMediaShapes.erase( aIter, aEnd );

            return true;
        }

		// ---------------------------------------------------------------------
		
        bool MediaShape::clearAllViewLayers()
        {
            maViewMediaShapes.clear();
            return true;
        }

		// ---------------------------------------------------------------------

        void MediaShape::viewLayerChanged( const ViewLayerSharedPtr& /*rNewLayer*/ )
        {
            ::std::for_each( maViewMediaShapes.begin(),
                             maViewMediaShapes.end(),
                             ::boost::bind( 
                                 &ViewMediaShape::resize, 
                                 _1,
                                 ::boost::cref( MediaShape::getPosSize())) );
        }

		// ---------------------------------------------------------------------

        bool MediaShape::implRender( const ::basegfx::B2DRange& rCurrBounds ) const
        {
            // redraw all view shapes, by calling their update() method
            if( ::std::count_if( maViewMediaShapes.begin(),
                                 maViewMediaShapes.end(),
                                 ::boost::bind<bool>( 
                                     ::boost::mem_fn( &ViewMediaShape::render ), 
                                     _1,
                                     ::boost::cref( rCurrBounds ) ) ) 
                != static_cast<ViewMediaShapeVector::difference_type>(maViewMediaShapes.size()) )
            {
                // at least one of the ViewShape::update() calls did return 
                // false - update failed on at least one ViewLayer
                return false;
            }

            return true;
        }

		// ---------------------------------------------------------------------
    
        bool MediaShape::implStartIntrinsicAnimation( const SlideShowContext& /*rContext*/,
                                                      const ShapeSharedPtr&	  /*rShape*/ )
        {
            ::std::for_each( maViewMediaShapes.begin(),
                             maViewMediaShapes.end(),
                             ::boost::mem_fn( &ViewMediaShape::startMedia ) );
            
            return true;
        }
        
		// ---------------------------------------------------------------------
        
        bool MediaShape::implEndIntrinsicAnimation()
        {
            ::std::for_each( maViewMediaShapes.begin(),
                             maViewMediaShapes.end(),
                             ::boost::mem_fn( &ViewMediaShape::endMedia ) );

            return true;
        }
    }
}
