/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: drawdoc4.cxx,v $
 *
 *  $Revision: 1.52 $
 *
 *  last change: $Author: ihi $ $Date: 2006/12/19 12:57:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include <tools/urlobj.hxx>
#include <sfx2/docfile.hxx>
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef SD_OUTLINER_HXX
#include "Outliner.hxx"
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _OUTLINER_HXX //autogen wg. Outliner
#include <svx/outliner.hxx>
#endif
#ifndef SD_DRAW_DOC_SHELL_HXX
#ifdef MAC
#include "::ui:inc:DrawDocShell.hxx"
#else
#ifdef UNX
#include "../ui/inc/DrawDocShell.hxx"
#else
#include "..\ui\inc\DrawDocShell.hxx"
#endif
#endif
#endif

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#include <vcl/svapp.hxx>
#include <eetext.hxx>

#define ITEMID_SEARCH               SID_SEARCH_ITEM
#define ITEMID_LANGUAGE             EE_CHAR_LANGUAGE
#define ITEMID_EMPHASISMARK         EE_CHAR_EMPHASISMARK
#define ITEMID_CHARRELIEF           EE_CHAR_RELIEF
#define ITEMID_FRAMEDIR             EE_PARA_WRITINGDIR

#define ITEMID_AUTOKERN EE_CHAR_PAIRKERNING
#include <svx/akrnitem.hxx>

#include <svx/svxids.hrc>
#ifndef _SFX_SRCHITEM_HXX
#include <sfx2/srchitem.hxx>
#endif
#include <svx/lrspitem.hxx>
#include <svx/ulspitem.hxx>
#include <svx/lspcitem.hxx>
#include <svx/adjitem.hxx>
#include <svx/dialogs.hrc>
#include <svx/dialmgr.hxx>					// SVX_RESSTR
#include <svx/bulitem.hxx>
#include <svx/xtable.hxx>
#include <svx/sxmsuitm.hxx>
#ifndef _SVX_XIT_HXX //autogen
#include <svx/xit.hxx>
#endif
#ifndef _SVX_XLINEIT0_HXX //autogen
#include <svx/xlineit0.hxx>
#endif
#ifndef _SDSHITM_HXX //autogen
#include <svx/sdshitm.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif
#ifndef SVX_XFILLIT0_HXX //autogen
#include <svx/xfillit0.hxx>
#endif
#ifndef _SDSHCITM_HXX //autogen
#include <svx/sdshcitm.hxx>
#endif
#ifndef _EDITSTAT_HXX //autogen
#include <svx/editstat.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <svx/fhgtitem.hxx>
#endif
#ifndef _SVX_WGHTITEM_HXX //autogen
#include <svx/wghtitem.hxx>
#endif
#ifndef _SVX_POSTITEM_HXX //autogen
#include <svx/postitem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX //autogen
#include <svx/crsditem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <svx/udlnitem.hxx>
#endif
#ifndef _SVX_ITEM_HXX //autogen
#include <svx/cntritem.hxx>
#endif
#ifndef _SVX_EMPHITEM_HXX
#include <svx/emphitem.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_SHDDITEM_HXX //autogen
#include <svx/shdditem.hxx>
#endif
#ifndef _SVX_XBTMPIT_HXX //autogen
#include <svx/xbtmpit.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX //autogen
#include <svx/xflhtit.hxx>
#endif
#ifndef _SVX_XFLGRIT_HXX //autogen
#include <svx/xflgrit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNEDCIT_HXX //autogen
#include <svx/xlnedcit.hxx>
#endif
#ifndef _SVX_XLNSTCIT_HXX //autogen
#include <svx/xlnstcit.hxx>
#endif
#ifndef _SVX_XLNEDWIT_HXX //autogen
#include <svx/xlnedwit.hxx>
#endif
#ifndef _SVX_XLNSTWIT_HXX //autogen
#include <svx/xlnstwit.hxx>
#endif
#ifndef _SVX_XLNEDIT_HXX //autogen
#include <svx/xlnedit.hxx>
#endif
#ifndef _SVX_CHARRELIEFITEM_HXX
#include <svx/charreliefitem.hxx>
#endif
#ifndef _SVX_XLNSTIT_HXX //autogen
#include <svx/xlnstit.hxx>
#endif
#ifndef _SVX_XLNDSIT_HXX //autogen
#include <svx/xlndsit.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif
#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SVX_NUMITEM_HXX
#include <svx/numitem.hxx>
#endif
#ifndef _MyEDITENG_HXX //autogen
#include <svx/editeng.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XHYPHENATOR_HPP_
#include <com/sun/star/linguistic2/XHyphenator.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _OUTLOBJ_HXX
#include <svx/outlobj.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX
#include <svx/langitem.hxx>
#endif
#ifndef _SVX_FRMDIRITEM_HXX
#include <svx/frmdiritem.hxx>
#endif

#include "sdresid.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "glob.hrc"
#include "glob.hxx"
#include "stlpool.hxx"
#include "helpids.h"
#include "sdiocmpt.hxx"
#ifndef _SHAPELIST_HXX
#include "shapelist.hxx"
#endif

#ifndef _BGFX_POINT_B2DPOINT_HXX
#include <basegfx/point/b2dpoint.hxx>
#endif

#ifndef _BGFX_POLYGON_B2DPOLYGON_HXX
#include <basegfx/polygon/b2dpolygon.hxx>
#endif

using ::rtl::OUString;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;
using namespace ::sd;

/*************************************************************************
|*
|* CreateLayoutTemplates, Layoutvorlagen erzeugen
|*
|* Z.Zt. (31.03.95) speichert der StyleSheetPool nur diejenigen Sheets, die
|* ein ItemSet haben. Damit alle Sheets gespeichert werden, wird die ItemSet-
|* Erzeugung mit einem GetItemSet-Aufruf erzwungen.
|* Dies kann entfallen, sobald der Pool auch Sheets ohne ItemSet speichert.
|*
\************************************************************************/

void SdDrawDocument::CreateLayoutTemplates()
{
	SdStyleSheetPool*       pSSPool = (SdStyleSheetPool*)GetStyleSheetPool();
	SfxStyleSheetBase*      pSheet = NULL;
	String                  aHelpFile;
	String                  aStdName = String(SdResId(STR_STANDARD_STYLESHEET_NAME));

	// ---- Standardvorlage -----------------------------------------------

	// nicht benutzt, nicht benutzerdefiniert
	// SB hatte wahrscheinlich Probleme mit SFXSTYLEBIT_AUTO, da dann gar nichts
	// mehr im Gestalter angezeigt wird. Dieses Problem ist zu 364 j behoben worden
	// USHORT nMask = SFXSTYLEBIT_ALL & ~(SFXSTYLEBIT_USED | SFXSTYLEBIT_USERDEF);
	USHORT nMask = SFXSTYLEBIT_AUTO;

	String aName(aStdName);
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetHelpId( aHelpFile, HID_STANDARD_STYLESHEET_NAME );
	SfxItemSet& rISet = pSheet->GetItemSet();
	SfxItemPool* pPool = rISet.GetPool();

	String	 aNullStr;

	::basegfx::B2DPolyPolygon aNullPolyPolygon;
	Color	 aNullCol(RGB_Color(COL_BLACK));

	XDash	  aNullDash;
	XGradient aNullGrad(aNullCol,RGB_Color(COL_WHITE));
			  aNullGrad.SetStartIntens( 100 );
			  aNullGrad.SetEndIntens( 100 );
	XHatch	  aNullHatch(aNullCol);

					// Linienattribute (Extended OutputDevice)
	rISet.Put(XLineStyleItem(XLINE_SOLID));
	rISet.Put(XLineColorItem(String(), RGB_Color(COL_BLACK)));
	rISet.Put(XLineWidthItem(0));
	rISet.Put(XLineDashItem(pPool,aNullDash));
	rISet.Put(XLineStartItem(pPool,aNullPolyPolygon));
	rISet.Put(XLineEndItem(pPool,aNullPolyPolygon));
	rISet.Put(XLineStartWidthItem(300));
	rISet.Put(XLineEndWidthItem(300));
	rISet.Put(XLineStartCenterItem());
	rISet.Put(XLineEndCenterItem());

					// Fuellattribute (Extended OutputDevice)
	rISet.Put(XFillStyleItem(XFILL_SOLID));
	rISet.Put(XFillColorItem(String(), RGB_Color(COL_DEFAULT_SHAPE_FILLING))); // "Blue 8"

	rISet.Put(XFillGradientItem(pPool,aNullGrad));
	rISet.Put(XFillHatchItem(pPool,aNullHatch));
    Size    aNullSize( 32, 32 );
    Color   aNullColor( COL_WHITE );
	Bitmap  aNullBmp( aNullSize, 8 );
    aNullBmp.Erase( aNullColor );
	rISet.Put(XFillBitmapItem(pPool,aNullBmp));

					// Schattenattribute (Drawing Engine)
	rISet.Put(SdrShadowItem(FALSE));
	rISet.Put(SdrShadowColorItem(aNullStr, RGB_Color(COL_GRAY)));
	rISet.Put(SdrShadowXDistItem(300)); 		// 3 mm Schattendistanz
	rISet.Put(SdrShadowYDistItem(300));

	Font aLatinFont, aCJKFont, aCTLFont;

	getDefaultFonts( aLatinFont, aCJKFont, aCTLFont );

	SvxFontItem aSvxFontItem( aLatinFont.GetFamily(), aLatinFont.GetName(), aLatinFont.GetStyleName(), aLatinFont.GetPitch(),
		                      aLatinFont.GetCharSet(), EE_CHAR_FONTINFO );

	SvxFontItem aSvxFontItemCJK( aCJKFont.GetFamily(), aCJKFont.GetName(), aCJKFont.GetStyleName(), aCJKFont.GetPitch(),
		                         aCJKFont.GetCharSet(), EE_CHAR_FONTINFO_CJK );

	SvxFontItem aSvxFontItemCTL( aCTLFont.GetFamily(), aCTLFont.GetName(), aCTLFont.GetStyleName(), aCTLFont.GetPitch(),
		                         aCTLFont.GetCharSet(), EE_CHAR_FONTINFO_CTL );

	rISet.Put( aSvxFontItem );
	rISet.Put( aSvxFontItemCJK );
	rISet.Put( aSvxFontItemCTL );

	rISet.Put( SvxFontHeightItem( 635, 100, EE_CHAR_FONTHEIGHT ) );     // sj: (i33745) changed default from 24 to 18 pt
	rISet.Put( SvxFontHeightItem( 635, 100, EE_CHAR_FONTHEIGHT_CJK ) ); // 18 pt
	rISet.Put( SvxFontHeightItem( convertFontHeightToCTL( 635 ), 100, EE_CHAR_FONTHEIGHT_CTL ) ); // 18 pt

	rISet.Put( SvxWeightItem( WEIGHT_NORMAL, EE_CHAR_WEIGHT ) );
	rISet.Put( SvxWeightItem( WEIGHT_NORMAL, EE_CHAR_WEIGHT_CJK ) );
	rISet.Put( SvxWeightItem( WEIGHT_NORMAL, EE_CHAR_WEIGHT_CTL ) );

	rISet.Put( SvxPostureItem( ITALIC_NONE, EE_CHAR_ITALIC ) );
	rISet.Put( SvxPostureItem( ITALIC_NONE, EE_CHAR_ITALIC_CJK ) );
	rISet.Put( SvxPostureItem( ITALIC_NONE, EE_CHAR_ITALIC_CTL ) );

	rISet.Put(SvxContourItem(FALSE));
	rISet.Put(SvxShadowedItem(FALSE));
	rISet.Put(SvxUnderlineItem(UNDERLINE_NONE));
	rISet.Put(SvxCrossedOutItem(STRIKEOUT_NONE));
	rISet.Put(SvxEmphasisMarkItem(EMPHASISMARK_NONE));
	rISet.Put(SvxCharReliefItem(RELIEF_NONE));
	rISet.Put(SvxColorItem(Color(COL_AUTO)));

    // Absatzattribute (Edit Engine)
	rISet.Put(SvxLRSpaceItem());
	rISet.Put(SvxULSpaceItem());

    // only change paragraph text direction,
    // if this is a new document and
    // text direction is set explicitly to RTL
/*
    if( mpDocSh &&
        mpDocSh->IsNewDocument() &&
        SD_MOD()->GetDefaultWritingMode() == ::com::sun::star::text::WritingMode_RL_TB )
    {
        SvxAdjustItem           aAdjust( SVX_ADJUST_RIGHT );
        SvxFrameDirectionItem   aFrameDirectionItem( FRMDIR_HORI_RIGHT_TOP, EE_PARA_WRITINGDIR );

        rISet.Put( aAdjust );
        rISet.Put( aFrameDirectionItem );

        pItemPool->SetPoolDefaultItem( aAdjust );
        pItemPool->SetPoolDefaultItem( aFrameDirectionItem );
    }
    else
        rISet.Put( SvxAdjustItem() );
*/
	rISet.Put( SdrTextLeftDistItem( 250 ) );	// sj: (i33745) using text frame distances seems to be a better default
	rISet.Put( SdrTextRightDistItem( 250 ) );
	rISet.Put( SdrTextUpperDistItem( 125 ) );
	rISet.Put( SdrTextLowerDistItem( 125 ) );
	
	rISet.Put( SvxLineSpacingItem() );

	// #i16874# enable kerning by default but only for new documents
	rISet.Put( SvxAutoKernItem( TRUE, EE_CHAR_PAIRKERNING ) );

	// Bullet
	// BulletItem und BulletFont fuer Titel und Gliederung
	SvxBulletItem aBulletItem(EE_PARA_BULLET);
							// die sind in allen Ebenen identisch
	aBulletItem.SetStyle(BS_BULLET);
	aBulletItem.SetStart(1);
	aBulletItem.SetScale(45);			// in Prozent

	Font aBulletFont( pSSPool->GetBulletFont() );

	aBulletFont.SetSize(Size(0,635));	// sj: (i33745) changed default from 24 to 18 pt

	aBulletItem.SetFont(aBulletFont);
	aBulletItem.SetSymbol( 0x25CF );					// Punkt
	rISet.Put(aBulletItem);

	SfxUInt16Item aBulletStateItem(EE_PARA_BULLETSTATE, 0); // Bullets nicht sichtbar
	rISet.Put(aBulletStateItem);

	// Neues BulletItem
	pSSPool->PutNumBulletItem( pSheet, aBulletFont );

	SfxItemSet* pISet = NULL;

	// ---- Objekt mit Pfeilspitze ----------------------------------------

	aName = String(SdResId(STR_POOLSHEET_OBJWITHARROW));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_OBJWITHARROW );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_SOLID));
	pISet->Put(XLineColorItem(String(), RGB_Color(COL_BLACK)));
	pISet->Put(XLineWidthItem(150));

	::basegfx::B2DPolygon aArrow;
	aArrow.append(::basegfx::B2DPoint(10.0, 0.0));
	aArrow.append(::basegfx::B2DPoint(0.0, 30.0));
	aArrow.append(::basegfx::B2DPoint(20.0, 30.0));
	aArrow.setClosed(true);
	pISet->Put(XLineStartItem(SVX_RESSTR(RID_SVXSTR_ARROW),::basegfx::B2DPolyPolygon(aArrow)));

	pISet->Put(XLineStartWidthItem(700));
	pISet->Put(XLineEndWidthItem(300));
	pISet->Put(XLineStartCenterItem(TRUE));

	// ---- Objekt mit Schatten -------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_OBJWITHSHADOW));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_OBJWITHSHADOW );
	pISet = &pSheet->GetItemSet();

	pISet->Put(SdrShadowItem(TRUE));
	pISet->Put(SdrShadowColorItem(aNullStr, RGB_Color(COL_GRAY)));
	pISet->Put(SdrShadowXDistItem(300));		// 3 mm Schattendistanz
	pISet->Put(SdrShadowYDistItem(300));

	// ---- Objekt ohne Fllung -------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_OBJWITHOUTFILL));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_OBJWITHOUTFILL );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XFillStyleItem(XFILL_NONE));

	// ---- Text ----------------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TEXT));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TEXT );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	// ---- Textkrper ----------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TEXTBODY));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TEXTBODY );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxFontHeightItem(564)); 		// 16 pt

	// ---- Textkrper mit Blocksatz --------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TEXTBODY_JUSTIFY));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TEXTBODY_JUSTIFY );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxAdjustItem(SVX_ADJUST_BLOCK));

	// ---- Textkoerper mit Einzug -----------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TEXTBODY_INDENT));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TEXTBODY_INDENT );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	SvxLRSpaceItem aLRSpaceItem;
	aLRSpaceItem.SetTxtFirstLineOfst(600); 		// Erstzeileneinzug 6mm, rechts 0
	pISet->Put(aLRSpaceItem);

	// SvxLRSpaceItem hart gesetzt: NumBulletItem anpassen
	SvxNumBulletItem aNumBullet( (const SvxNumBulletItem&) pISet->Get(EE_PARA_NUMBULLET) );
	EditEngine::ImportBulletItem( aNumBullet, 0, NULL, &aLRSpaceItem );
	pISet->Put( aNumBullet );

	// ---- Titel ---------------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TITLE));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TITLE );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxFontHeightItem(1551));		// 44 pt

	// ---- Titel1 --------------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TITLE1));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TITLE1 );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_SOLID));
	pISet->Put(XFillColorItem(String(), RGB_Color(COL_CYAN)));

	pISet->Put(SdrShadowItem(TRUE));
	pISet->Put(SdrShadowColorItem(aNullStr, RGB_Color(COL_GRAY)));
	pISet->Put(SdrShadowXDistItem(200));		// 2 mm Schattendistanz
	pISet->Put(SdrShadowYDistItem(200));

	pISet->Put(SvxFontHeightItem(846)); 		// 24 pt

	pISet->Put(SvxAdjustItem(SVX_ADJUST_CENTER));

	// ---- Titel2 --------------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_TITLE2));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_TITLE2 );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineWidthItem(50));

	// Farbe nicht aus der Farbtabelle holen, denn da kann diese Farbe
	// geloescht oder veraendert sein
	Color aOrange4(255, 204, 153);
	pISet->Put(XFillColorItem(String(), aOrange4));

	pISet->Put(SdrShadowItem(TRUE));
	pISet->Put(SdrShadowColorItem(aNullStr, RGB_Color(COL_GRAY)));
	pISet->Put(SdrShadowXDistItem(200));		// 2 mm Schattendistanz
	pISet->Put(SdrShadowYDistItem(200));

	pISet->Put(SvxFontHeightItem(1270));		// 36 pt

	SvxLRSpaceItem aLRSpItem(0, 200, 200);
	pISet->Put( aLRSpItem );	// Erstzeileneinzug 0 mm, links und rechts 2 mm
	// SvxLRSpaceItem hart gesetzt: NumBulletItem anpassen
	SvxNumBulletItem aNmBullet( (const SvxNumBulletItem&) pISet->Get(EE_PARA_NUMBULLET) );
	EditEngine::ImportBulletItem( aNmBullet, 0, NULL, &aLRSpItem );
	pISet->Put( aNmBullet );

	pISet->Put(SvxULSpaceItem(100, 100));		// Absatzrand oben/unten 1 mm

	pISet->Put(SvxAdjustItem(SVX_ADJUST_CENTER));

	// ---- Ueberschrift ---------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_HEADLINE));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_HEADLINE );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxFontHeightItem(846)); 		// 24 pt

	pISet->Put(SvxULSpaceItem(420, 210));		// Absatzrand oben 4,2 mm,
												// unten 2,1 mm

	// ---- Ueberschrift1 --------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_HEADLINE1));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_HEADLINE1 );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxWeightItem(WEIGHT_BOLD));

	pISet->Put(SvxFontHeightItem(635)); 		// 18 pt

	pISet->Put(SvxULSpaceItem(420, 210));		// Absatzrand oben 4,2 mm,
												// unten 2,1 mm

	// ---- Ueberschrift2 --------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_HEADLINE2));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_HEADLINE2 );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XLineStyleItem(XLINE_NONE));
	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxPostureItem(ITALIC_NORMAL));
	pISet->Put(SvxWeightItem(WEIGHT_BOLD));

	pISet->Put(SvxFontHeightItem(494)); 		// 14 pt

	pISet->Put(SvxULSpaceItem(420, 210));		// Absatzrand oben 4,2 mm,
												// unten 2,1 mm

	// ---- Bemassung --------------------------------------------------

	aName = String(SdResId(STR_POOLSHEET_MEASURE));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pSheet->SetParent(aStdName);
	pSheet->SetHelpId( aHelpFile, HID_POOLSHEET_MEASURE );
	pISet = &pSheet->GetItemSet();

	pISet->Put(XFillStyleItem(XFILL_NONE));

	pISet->Put(SvxFontHeightItem(423));         // 12 pt

	pISet->Put(XLineStartItem(SVX_RESSTR(RID_SVXSTR_ARROW),::basegfx::B2DPolyPolygon(aArrow)));
	pISet->Put(XLineStartWidthItem(200));
	pISet->Put(XLineEndItem(SVX_RESSTR(RID_SVXSTR_ARROW),::basegfx::B2DPolyPolygon(aArrow)));
	pISet->Put(XLineEndWidthItem(200));
	pISet->Put(XLineStyleItem(XLINE_SOLID));
	pISet->Put(SdrMeasureShowUnitItem(true));

/*

	invalidierte Items koennen nicht gespeichert werden;
	da muessen wir uns was anderes ueberlegen

	// ---- leere Vorlage --------------------------------------------------

	aName = String(SdResId(STR_EMPTY_STYLESHEET_NAME));
	pSheet = &(pSSPool->Make(aName, SFX_STYLE_FAMILY_PARA, nMask));
	pISet = &pSheet->GetItemSet();
	pISet->InvalidateAllItems();	  // alle auf DONTCARE setzen
*/


	// Praesentationsvorlagen fuer das Standardlayout erzeugen
	String aPrefix = String(SdResId(STR_LAYOUT_DEFAULT_NAME));
	pSSPool->CreateLayoutStyleSheets(aPrefix);
}


/*************************************************************************
|*
|* Anzahl der Seiten, die eine masterPage referenzieren
|*
\************************************************************************/

USHORT SdDrawDocument::GetMasterPageUserCount(SdrPage* pMaster) const
{
	USHORT nResult = 0;
	USHORT nPage;
	USHORT nPageCount = GetPageCount();

	for (nPage = 0; nPage < nPageCount; nPage++)
	{
		const SdrPage* pPage = GetPage(nPage);

		if(pPage->TRG_HasMasterPage())
		{
			if(&(pPage->TRG_GetMasterPage()) == pMaster)
			{
				nResult++;
			}
		}
	}
	return nResult;
}


/*************************************************************************
|*
|* OnlineSpelling im Hintergrund beenden
|*
\************************************************************************/

void SdDrawDocument::StopOnlineSpelling()
{
	if (mpOnlineSpellingTimer && mpOnlineSpellingTimer->IsActive())
	{
		mpOnlineSpellingTimer->Stop();
	}

	delete mpOnlineSpellingTimer;
	mpOnlineSpellingTimer = NULL;

	delete mpOnlineSpellingList;
	mpOnlineSpellingList = NULL;
}

/*************************************************************************
|*
|* OnlineSpelling im Hintergrund starten
|*
\************************************************************************/

void SdDrawDocument::StartOnlineSpelling(BOOL bForceSpelling)
{
	if (mbOnlineSpell && (bForceSpelling || mbInitialOnlineSpellingEnabled) &&
	    mpDocSh && !mpDocSh->IsReadOnly() )
	{
		StopOnlineSpelling();

		::sd::Outliner* pOutl = GetInternalOutliner(TRUE);

	    Reference< XSpellChecker1 > xSpellChecker( LinguMgr::GetSpellChecker() );
	    if ( xSpellChecker.is() )
		    pOutl->SetSpeller( xSpellChecker );

	    Reference< XHyphenator > xHyphenator( LinguMgr::GetHyphenator() );
	    if( xHyphenator.is() )
		    pOutl->SetHyphenator( xHyphenator );

		pOutl->SetDefaultLanguage( meLanguage );

		mpOnlineSpellingList = new ShapeList;
		USHORT nPage;

		for ( nPage = 0; nPage < GetPageCount(); nPage++ )
		{
			// Alle Pages durchsuchen
			FillOnlineSpellingList((SdPage*) GetPage(nPage));
		}

		for (nPage = 0; nPage < GetMasterPageCount(); nPage++)
		{
			// Alle MasterPages durchsuchen
			FillOnlineSpellingList((SdPage*) GetMasterPage(nPage));
		}

		mpOnlineSpellingList->seekShape(0);
		mpOnlineSpellingTimer = new Timer();
		mpOnlineSpellingTimer->SetTimeoutHdl( LINK(this, SdDrawDocument, OnlineSpellingHdl) );
		mpOnlineSpellingTimer->SetTimeout(250);
		mpOnlineSpellingTimer->Start();
	}
}

/*************************************************************************
|*
|* OnlineSpelling-Liste fuellen
|*
\************************************************************************/

void SdDrawDocument::FillOnlineSpellingList(SdPage* pPage)
{
	SdrObject* pObj = NULL;
	SdrObjListIter aIter(*pPage, IM_FLAT);

	while (aIter.IsMore())
	{
		pObj = aIter.Next();

		if( !pObj )
			continue;

		if (pObj->GetOutlinerParaObject())
		{
			// Textobjekt gefunden
			mpOnlineSpellingList->addShape(*pObj);
		}
		else if (pObj->GetObjIdentifier() == OBJ_GRUP)
		{
			// Gruppenobjekt gefunden
			SdrObjListIter aGroupIter(*((SdrObjGroup*)pObj)->GetSubList(),
									  IM_DEEPNOGROUPS);

			BOOL bSubTextObjFound = FALSE;

			while (aGroupIter.IsMore() && !bSubTextObjFound)
			{
				if (aGroupIter.Next()->GetOutlinerParaObject())
				{
					// Textobjekt im Gruppenobjekt gefunden
					bSubTextObjFound = TRUE;
				}
			}

			if (bSubTextObjFound)
			{
				mpOnlineSpellingList->addShape(*pObj);
			}
		}
	}
}

/*************************************************************************
|*
|* OnlineSpelling im Hintergrund
|*
\************************************************************************/

IMPL_LINK(SdDrawDocument, OnlineSpellingHdl, Timer*, EMPTYARG )
{
	if (mpOnlineSpellingList!=NULL
        && ( !mbOnlineSpell || mpOnlineSpellingList->hasMore()))
	{
		/**********************************************************************
		* Naechstes Objekt spellen
		**********************************************************************/
		SdrObject* pObj = mpOnlineSpellingList->getNextShape();

		if (pObj)
		{
			if (pObj->GetOutlinerParaObject() && pObj->ISA(SdrTextObj))
			{
				// Textobjekt spellen
				SpellObject((SdrTextObj*) pObj);
			}
			else if (pObj->GetObjIdentifier() == OBJ_GRUP)
			{
				// Gruppenobjekt gefunden
				SdrObjListIter aGroupIter(*((SdrObjGroup*)pObj)->GetSubList(),
										  IM_DEEPNOGROUPS);

				SdrObject* pSubObj = NULL;

				while (aGroupIter.IsMore())
				{
					pSubObj = aGroupIter.Next();

					if (pSubObj->GetOutlinerParaObject() && pSubObj->ISA(SdrTextObj))
					{
						// Textobjekt im Gruppenobjekt gefunden
						SpellObject((SdrTextObj*) pSubObj);
					}
				}
			}
		}

		// Weitersuchen
		mpOnlineSpellingTimer->Start();
	}
	else
	{
		// Spelling wurde initial durchgefuehrt
		mbInitialOnlineSpellingEnabled = FALSE;

		// Suche beenden
		StopOnlineSpelling();

		delete mpOnlineSearchItem;
		mpOnlineSearchItem = NULL;
	}

	return(0);
}

/*************************************************************************
|*
|* Objekt spellen (fuer OnlineSpelling)
|*
\************************************************************************/

void SdDrawDocument::SpellObject(SdrTextObj* pObj)
{
	if (pObj && pObj->GetOutlinerParaObject() /* && pObj != pView->GetTextEditObject() */)
	{
		mbHasOnlineSpellErrors = FALSE;
		::sd::Outliner* pOutl = GetInternalOutliner(TRUE);
		pOutl->SetUpdateMode(TRUE);
		Link aEvtHdl = pOutl->GetStatusEventHdl();
		pOutl->SetStatusEventHdl(LINK(this, SdDrawDocument, OnlineSpellEventHdl));

		USHORT nOldOutlMode = pOutl->GetMode();
		USHORT nOutlMode = OUTLINERMODE_TEXTOBJECT;
		if (((SdrTextObj*) pObj)->GetObjInventor() == SdrInventor &&
			((SdrTextObj*) pObj)->GetObjIdentifier() == OBJ_OUTLINETEXT)
		{
			nOutlMode = OUTLINERMODE_OUTLINEOBJECT;
			pOutl->SetMinDepth(1);
		}
		pOutl->Init( nOutlMode );

		// Text in den Outliner setzen
		pOutl->SetText(*((SdrTextObj*) pObj)->GetOutlinerParaObject());

		if (!mpOnlineSearchItem || pOutl->HasText(*mpOnlineSearchItem))
		{
			// Spelling
			pOutl->CompleteOnlineSpelling();

			if (mbHasOnlineSpellErrors)
			{
				sd::ModifyGuard aGuard( this );

				// Text aus Outliner holen
				((SdrTextObj*) pObj)->SetOutlinerParaObject( pOutl->CreateParaObject() );

				pObj->BroadcastObjectChange();
			}
		}

		pOutl->SetStatusEventHdl(aEvtHdl);
		pOutl->SetUpdateMode(FALSE);
		pOutl->Init( nOldOutlMode );
		mbHasOnlineSpellErrors = FALSE;
	}
}

/*************************************************************************
|*
|* Objekt wurde ins Model eingefuegt
|*
\************************************************************************/
void SdDrawDocument::InsertObject(SdrObject* pObj, SdPage* /*pPage*/)
{
	if(mpOnlineSpellingList && pObj)
	{
		if (pObj->GetOutlinerParaObject() || (pObj->GetObjIdentifier() == OBJ_GRUP))
		{
			// Objekt in OnlineSpelling-Liste aufnehmen
			mpOnlineSpellingList->addShape(*pObj);
		}
	}
}

/*************************************************************************
|*
|* Objekt wurde aus dem Model entfernt
|*
\************************************************************************/
void SdDrawDocument::RemoveObject(SdrObject* pObj, SdPage* /*pPage*/)
{
	if(mpOnlineSpellingList && pObj)
	{
		if (pObj->GetOutlinerParaObject() || (pObj->GetObjIdentifier() == OBJ_GRUP))
		{
			// Objekt in OnlineSpelling-Liste durch NULL-Pointer ersetzt
			mpOnlineSpellingList->removeShape(*pObj);
		}
	}
}

/*************************************************************************
|*
|* Callback fuer ExecuteSpellPopup()
|*
\************************************************************************/
IMPL_LINK(SdDrawDocument, OnlineSpellEventHdl, EditStatus*, pEditStat)
{
	ULONG nStat = pEditStat->GetStatusWord();
	mbHasOnlineSpellErrors = (nStat & EE_STAT_WRONGWORDCHANGED) != 0;

	return(0);
}

/*************************************************************************
|*
|* Callback fuer ExecuteSpellPopup()
|*
\************************************************************************/

// #91457# removed link and replaced with Imp method
void SdDrawDocument::ImpOnlineSpellCallback(SpellCallbackInfo* pInfo, SdrObject* pObj, SdrOutliner* pOutl)
{
	delete mpOnlineSearchItem;
	mpOnlineSearchItem = NULL;

	USHORT nCommand = pInfo->nCommand;

	if (nCommand == SPELLCMD_IGNOREWORD
		// #91457# restart when add to dictionary takes place, too.
		|| nCommand == SPELLCMD_ADDTODICTIONARY)
	{
		if(pObj && pOutl && pObj->ISA(SdrTextObj))
		{
			BOOL bModified(IsChanged());
			((SdrTextObj*)pObj)->SetOutlinerParaObject(pOutl->CreateParaObject());
			SetChanged(bModified);
			pObj->BroadcastObjectChange();
		}

		mpOnlineSearchItem = new SvxSearchItem();
		mpOnlineSearchItem->SetSearchString(pInfo->aWord);
		StartOnlineSpelling();
	}
	else if (nCommand == SPELLCMD_STARTSPELLDLG)
	{
		SfxViewFrame::Current()->GetDispatcher()->Execute( SID_SPELL_DIALOG,
            SFX_CALLMODE_ASYNCHRON );
	}
}

/*************************************************************************
|*
|* Sprachabhaengige Namen der StandardLayer durch eindeutigen Namen ersetzen
|*
\************************************************************************/

void SdDrawDocument::MakeUniqueLayerNames()
{
	String aLayerLayout(SdResId(STR_LAYER_LAYOUT));
	String aLayerBckgrnd(SdResId(STR_LAYER_BCKGRND));
	String aLayerBckgrndObj(SdResId(STR_LAYER_BCKGRNDOBJ));
	String aLayerControls(SdResId(STR_LAYER_CONTROLS));
	String aLayerMeasurelines(SdResId(STR_LAYER_MEASURELINES));
	SdrLayerAdmin& rLayerAdmin = GetLayerAdmin();
	USHORT nStandardLayer = 5;
	USHORT nLayerCount = Min(rLayerAdmin.GetLayerCount(), nStandardLayer);

	for (USHORT nLayer = 0; nLayer < nLayerCount; nLayer++)
	{
		// Die sprachabhaengigen Namen der Default-Layer werden nicht mehr
		// gespeichert. Es werden stattdessen eindeutige Namen verwendet.
		SdrLayer* pLayer = rLayerAdmin.GetLayer(nLayer);

		if (pLayer)
		{
			String aLayerName(pLayer->GetName());

			if (aLayerName == aLayerLayout)
			{
				pLayer->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "LAYER_LAYOUT" )));
			}
			else if (aLayerName == aLayerBckgrnd)
			{
				pLayer->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "LAYER_BCKGRND" )));
			}
			else if (aLayerName == aLayerBckgrndObj)
			{
				pLayer->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "LAYER_BACKGRNDOBJ" )));
			}
			else if (aLayerName == aLayerControls)
			{
				pLayer->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "LAYER_CONTROLS" )));
			}
			else if (aLayerName == aLayerMeasurelines)
			{
				pLayer->SetName( String( RTL_CONSTASCII_USTRINGPARAM( "LAYER_MEASURELINES" )));
			}
		}
	}
}

/*************************************************************************
|*
|* Eindeutige Namen der StandardLayer durch sprachabhaengige Namen ersetzen
|*
\************************************************************************/
void SdDrawDocument::RestoreLayerNames()
{
	SdrLayerAdmin& rLayerAdmin = GetLayerAdmin();
	USHORT nLayerCount = rLayerAdmin.GetLayerCount();

	for (USHORT nLayer = 0; nLayer < nLayerCount; nLayer++)
	{
		SdrLayer* pLayer = rLayerAdmin.GetLayer(nLayer);

		if (pLayer)
		{
			String aLayerName(pLayer->GetName());

			if (aLayerName.EqualsAscii( "LAYER_LAYOUT" ))
			{
				pLayer->SetName(String(SdResId(STR_LAYER_LAYOUT)));
			}
			else if (aLayerName.EqualsAscii( "LAYER_BCKGRND" ))
			{
				pLayer->SetName(String(SdResId(STR_LAYER_BCKGRND)));
			}
			else if (aLayerName.EqualsAscii( "LAYER_BACKGRNDOBJ" ))
			{
				pLayer->SetName(String(SdResId(STR_LAYER_BCKGRNDOBJ)));
			}
			else if (aLayerName.EqualsAscii( "LAYER_CONTROLS" ))
			{
				pLayer->SetName(String(SdResId(STR_LAYER_CONTROLS)));
			}
			else if (aLayerName.EqualsAscii( "LAYER_MEASURELINES" ))
			{
				pLayer->SetName(String(SdResId(STR_LAYER_MEASURELINES)));
			}
		}
	}
}

/*************************************************************************
|*
|* Formatierte Seitennummer zurueckgeben (1, I, i, a, usw.)
|*
\************************************************************************/

String SdDrawDocument::CreatePageNumValue(USHORT nNum) const
{
	String aPageNumValue;
	BOOL bUpper = FALSE;

	switch (mePageNumType)
	{
		case SVX_CHARS_UPPER_LETTER:
			aPageNumValue += (sal_Unicode)(char)((nNum - 1) % 26 + 'A');
			break;
		case SVX_CHARS_LOWER_LETTER:
			aPageNumValue += (sal_Unicode)(char)((nNum - 1) % 26 + 'a');
			break;
		case SVX_ROMAN_UPPER:
			bUpper = TRUE;
		case SVX_ROMAN_LOWER:
			aPageNumValue += SvxNumberFormat::CreateRomanString(nNum, bUpper);
			break;
		case SVX_NUMBER_NONE:
			aPageNumValue.Erase();
			aPageNumValue += sal_Unicode(' ');
			break;
		default:
			aPageNumValue += String::CreateFromInt32( (sal_Int32)nNum );
	}

	return(aPageNumValue);
}



/*************************************************************************
|*
|* Layout-Template umbenennen
|* Zu beachten ist, das rOldLayoutName im Gegensatz zu rNewName den
|* kompletten Layout(!)-Namen enthaelt (inkl. ~LT~)!
|*
\************************************************************************/

void SdDrawDocument::RenameLayoutTemplate(const String& rOldLayoutName, const String& rNewName)
{
	String aOldName(rOldLayoutName);
	USHORT nPos = aOldName.SearchAscii( SD_LT_SEPARATOR );

	// erase everything after '~LT~'
	aOldName.Erase(nPos + sizeof(SD_LT_SEPARATOR) - 1 );
	USHORT nLen = aOldName.Len();

	List aReplList;
	SfxStyleSheetIterator aIter(pStyleSheetPool, SD_LT_FAMILY);
	SfxStyleSheetBase* pSheet = aIter.First();

	while (pSheet)
	{
		String aSheetName = pSheet->GetName();

		// if the sheetname starts with aOldName + "~LT~"
		if (aSheetName.Match(aOldName) == nLen)
		{
			aSheetName.Erase(0, nLen - sizeof(SD_LT_SEPARATOR) + 1 );
			aSheetName.Insert(rNewName, 0);

			StyleReplaceData* pReplData = new StyleReplaceData;
			pReplData->nFamily	  = pSheet->GetFamily();
			pReplData->nNewFamily = pSheet->GetFamily();
			pReplData->aName	  = pSheet->GetName();
			pReplData->aNewName   = aSheetName;
			aReplList.Insert(pReplData, LIST_APPEND);

			pSheet->SetName(aSheetName);
		}

		pSheet = aIter.Next();
	}

	// jetzt noch den Layoutnamen der Zeichen- und der Notizseite
	// sowie ihrer Masterpages setzen
	String aPageLayoutName(rNewName);
	aPageLayoutName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( SD_LT_SEPARATOR ));
	aPageLayoutName += String(SdResId(STR_LAYOUT_OUTLINE));

	// an allen Seiten, die das jetzt umbeannte Layout benutzen, die
	// Textobjekte von der Aenderung unterrichten und Layoutnamen setzen
	USHORT nPage;
	for (nPage = 0; nPage < GetPageCount(); nPage++)
	{
		SdPage* pPage = (SdPage*) GetPage(nPage);
		String aTemp(pPage->GetLayoutName());

		if (aTemp == rOldLayoutName)
		{
			pPage->SetLayoutName(aPageLayoutName);

			for (ULONG nObj = 0; nObj < pPage->GetObjCount(); nObj++)
			{
				SdrObject* pObj = pPage->GetObj(nObj);

				if (pObj->GetObjInventor() == SdrInventor)
				{
					switch( pObj->GetObjIdentifier() )
					{
						case OBJ_TEXT:
						case OBJ_OUTLINETEXT:
						case OBJ_TITLETEXT:
						{
							OutlinerParaObject* pOPO = ((SdrTextObj*) pObj)->GetOutlinerParaObject();

							if (pOPO)
							{
								StyleReplaceData* pReplData = (StyleReplaceData*) aReplList.First();

								while( pReplData )
								{
									pOPO->ChangeStyleSheets( pReplData->aName, pReplData->nFamily, pReplData->aNewName, pReplData->nNewFamily );
									pReplData = (StyleReplaceData*) aReplList.Next();
								}
							}
						}
						break;

						default:
						break;
					}
				}
			}
		}
	}

	// und nochmal fuer die Masterpages
	// die betroffenen Masterpages erhalten als Seitennamen den Namen
	// des Layouts
	for (nPage = 0; nPage < GetMasterPageCount(); nPage++)
	{
		SdPage* pPage = (SdPage*) GetMasterPage(nPage);
		String aTemp(pPage->GetLayoutName());

		if (aTemp == rOldLayoutName)
		{
			pPage->SetLayoutName(aPageLayoutName);
			pPage->SetName(rNewName);

			for (ULONG nObj = 0; nObj < pPage->GetObjCount(); nObj++)
			{
				SdrObject* pObj = pPage->GetObj(nObj);

				if (pObj->GetObjInventor() == SdrInventor)
				{
					switch(pObj->GetObjIdentifier())
					{
						case OBJ_TEXT:
						case OBJ_OUTLINETEXT:
						case OBJ_TITLETEXT:
						{
							OutlinerParaObject* pOPO = ((SdrTextObj*)pObj)->GetOutlinerParaObject();

							if (pOPO)
							{
								StyleReplaceData* pReplData = (StyleReplaceData*) aReplList.First();

								while( pReplData )
								{
									pOPO->ChangeStyleSheets( pReplData->aName, pReplData->nFamily, pReplData->aNewName, pReplData->nNewFamily );
									pReplData = (StyleReplaceData*) aReplList.Next();
								}
							}
						}
						break;

						default:
						break;
					}
				}
			}
		}
	}
}

/*************************************************************************
|*
|* Outliner-Defaults setzen (Pool-Defaults)
|*
\************************************************************************/
void SdDrawDocument::SetTextDefaults() const
{
	// BulletItem und BulletFont fuer Titel und Gliederung
	SvxBulletItem aBulletItem(EE_PARA_BULLET);
	Font aBulletFont( ((SdStyleSheetPool*) pStyleSheetPool)->GetBulletFont() );
	aBulletFont.SetSize(Size(0,846));		// 24 pt
	aBulletItem.SetFont(aBulletFont);
	aBulletItem.SetStyle(BS_BULLET);
	aBulletItem.SetStart(1);
	aBulletItem.SetScale(45);				// in Prozent
	aBulletItem.SetSymbol( 0x25CF );				// Punkt
	pItemPool->SetPoolDefaultItem( aBulletItem );

	// Bullets nicht sichtbar
	SfxUInt16Item aBulletStateItem(EE_PARA_BULLETSTATE, 0);
	pItemPool->SetPoolDefaultItem( aBulletStateItem );

	// Neues BulletItem
	SvxNumberFormat aNumberFormat(SVX_NUM_CHAR_SPECIAL);
	aNumberFormat.SetBulletFont(&aBulletFont);
	aNumberFormat.SetBulletChar( 0x25CF );  // StarBats: 0xF000 + 34
	aNumberFormat.SetBulletRelSize(45);
	aNumberFormat.SetBulletColor(Color(COL_AUTO));
	aNumberFormat.SetStart(1);
	aNumberFormat.SetNumAdjust(SVX_ADJUST_LEFT);

	SvxNumRule aNumRule( NUM_BULLET_REL_SIZE|NUM_BULLET_COLOR|NUM_CHAR_TEXT_DISTANCE, 10 , FALSE);

	aNumberFormat.SetLSpace( 0 );
	aNumberFormat.SetAbsLSpace( 0 );
	aNumberFormat.SetFirstLineOffset( 0 );
	aNumRule.SetLevel( 0, aNumberFormat );

	for( USHORT i = 1; i < 10; i++ )
	{
		const short nLSpace = (i + 1) * 600;
		aNumberFormat.SetLSpace(nLSpace);
		aNumberFormat.SetAbsLSpace(nLSpace);
		aNumberFormat.SetFirstLineOffset(-600);
		aNumRule.SetLevel( i, aNumberFormat );
	}

	SvxNumBulletItem aNumBulletItem( aNumRule, EE_PARA_NUMBULLET );
	pItemPool->SetPoolDefaultItem( aNumBulletItem );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

::com::sun::star::text::WritingMode SdDrawDocument::GetDefaultWritingMode() const
{
    const SfxPoolItem*                  pItem = ( pItemPool ? pItemPool->GetPoolDefaultItem( EE_PARA_WRITINGDIR ) : NULL );
    ::com::sun::star::text::WritingMode eRet = ::com::sun::star::text::WritingMode_LR_TB;

    if( pItem )
    {
        switch( ( (SvxFrameDirectionItem&)( *pItem ) ).GetValue() )
        {
            case( FRMDIR_HORI_LEFT_TOP ): eRet = ::com::sun::star::text::WritingMode_LR_TB; break;
            case( FRMDIR_HORI_RIGHT_TOP ): eRet = ::com::sun::star::text::WritingMode_RL_TB; break;
            case( FRMDIR_VERT_TOP_RIGHT ): eRet = ::com::sun::star::text::WritingMode_TB_RL; break;

            default:
                DBG_ERROR( "Frame direction not supported yet" );
            break;
        }
    }

    return eRet;
}

void SdDrawDocument::SetDefaultWritingMode(::com::sun::star::text::WritingMode eMode )
{
	if( pItemPool )
	{
		SvxFrameDirection nVal;
		switch( eMode )
		{
		case ::com::sun::star::text::WritingMode_LR_TB: nVal = FRMDIR_HORI_LEFT_TOP; break;
		case ::com::sun::star::text::WritingMode_RL_TB: nVal = FRMDIR_HORI_RIGHT_TOP; break;
		case ::com::sun::star::text::WritingMode_TB_RL: nVal = FRMDIR_VERT_TOP_RIGHT; break;
		default:
			DBG_ERROR( "Frame direction not supported yet" );
			return;
		}

		SvxFrameDirectionItem aModeItem( nVal, EE_PARA_WRITINGDIR );
		pItemPool->SetPoolDefaultItem( aModeItem );

        SvxAdjustItem aAdjust;

		if( eMode == ::com::sun::star::text::WritingMode_RL_TB )
			aAdjust.SetEnumValue( SVX_ADJUST_RIGHT );

		pItemPool->SetPoolDefaultItem( aAdjust );


	}
}

void SdDrawDocument::getDefaultFonts( Font& rLatinFont, Font& rCJKFont, Font& rCTLFont )
{
	LanguageType eLatin = GetLanguage( EE_CHAR_LANGUAGE );

	//	#108374# / #107782#: If the UI language is Korean, the default Latin font has to
	//	be queried for Korean, too (the Latin language from the document can't be Korean).
	//	This is the same logic as in SwDocShell::InitNew.
	LanguageType eUiLanguage = Application::GetSettings().GetUILanguage();
	switch( eUiLanguage )
	{
		case LANGUAGE_KOREAN:
		case LANGUAGE_KOREAN_JOHAB:
			eLatin = eUiLanguage;
		break;
	}

	rLatinFont = OutputDevice::GetDefaultFont( DEFAULTFONT_LATIN_PRESENTATION, eLatin, DEFAULTFONT_FLAGS_ONLYONE );
	rCJKFont = OutputDevice::GetDefaultFont( DEFAULTFONT_CJK_PRESENTATION, GetLanguage( EE_CHAR_LANGUAGE_CJK ), DEFAULTFONT_FLAGS_ONLYONE );
	rCTLFont = OutputDevice::GetDefaultFont( DEFAULTFONT_CTL_PRESENTATION, GetLanguage( EE_CHAR_LANGUAGE_CTL ), DEFAULTFONT_FLAGS_ONLYONE ) ;
}

/* converts the given western font height to a corresponding ctl font height, deppending on the system language */
sal_uInt32 SdDrawDocument::convertFontHeightToCTL( sal_uInt32 nWesternFontHeight )
{
	LanguageType eRealCTLLanguage = Application::GetSettings().GetLanguage();
	if( LANGUAGE_THAI == eRealCTLLanguage )
	{
		// http://specs.openoffice.org/g11n/font_sizes/42775_42725_Individual_configurable_font_size_for_default_fonts.odt
		double fTemp = double(nWesternFontHeight) * 1.333;
		nWesternFontHeight = (sal_uInt32)fTemp;
		// make some nice values for UI that displays PT instead of 1/100th mm
		nWesternFontHeight = ((nWesternFontHeight * 72) + 1270) / 2540L;
		nWesternFontHeight = ((nWesternFontHeight * 2540L) + 36) / 72;
	}
	return nWesternFontHeight;
}

ModifyGuard::ModifyGuard( DrawDocShell* pDocShell )
: mpDocShell( pDocShell ), mpDoc( 0 )
{
	init();
}

ModifyGuard::ModifyGuard( SdDrawDocument* pDoc )
: mpDocShell( 0 ), mpDoc( pDoc )
{
	init();
}

void ModifyGuard::init()
{
	if( mpDocShell )
	{
		mpDoc = mpDocShell->GetDoc();
	}
	else if( mpDoc )
	{
		mpDocShell = mpDoc->GetDocSh();
	}

	mbIsEnableSetModified = mpDocShell ? mpDocShell->IsEnableSetModified() : FALSE;
	mbIsDocumentChanged = mpDoc ? mpDoc->IsChanged() : FALSE;

	if( mbIsEnableSetModified )
		mpDocShell->EnableSetModified( FALSE );
}

ModifyGuard::~ModifyGuard()
{
	if( mbIsEnableSetModified )
		mpDocShell->EnableSetModified( TRUE );

	if( mpDoc && (mpDoc->IsChanged() != mbIsDocumentChanged) )
		mpDoc->SetChanged(mbIsDocumentChanged);
}
