/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chtm3d2.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:54:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#include "chtmodel.hxx"
#include <svx/obj3d.hxx>
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _CAMERA3D_HXX //autogen
#include <svx/camera3d.hxx>
#endif
#ifndef _E3D_EXTRUD3D_HXX //autogen
#include <svx/extrud3d.hxx>
#endif
#ifndef _E3D_POLYGON3D_HXX //autogen
#include <svx/polygn3d.hxx>
#endif

#ifndef _SVX_SVXIDS_HRC //autogen
#include <svx/svxids.hrc>
#endif

#include "chmod3d.hxx"
#include "schattr.hxx"
#include "objid.hxx"

#include "axisobj.hxx"

#ifndef _SVX3DITEMS_HXX
#include <svx/svx3ditems.hxx>
#endif

#define SCH_MIN(a, b) (((a) < (b))? (a): (b))

long ChartModel::GetChartShapeType()
{
	long nShape   =CHART_SHAPE3D_IGNORE;   // BM: ANY instead of IGNORE
	long nOldShape=CHART_SHAPE3D_IGNORE;

    if( Is3DChart() &&
        ( GetBaseType() == CHTYPE_BAR ||
          GetBaseType() == CHTYPE_COLUMN ))
    {
        const SfxPoolItem *pPoolItem;
        long nRowCnt=GetRowCount();
        long nColCnt=GetColCount();
        for(long nRow=0;nRow<nRowCnt;nRow++)
        {
            for(long nCol=0;nCol<nColCnt;nCol++)
            {
                const SfxItemSet& rAttr=GetDataPointAttr(nCol,nRow);
                if(rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
                {
                    nShape=((const SfxInt32Item*) pPoolItem)->GetValue();
                }
                else
                {
                    if(!GetDataPointObj(nCol,nRow))
                    {
                        nShape=nOldShape;
                    }
                    else
                    {
                        nShape=CHART_SHAPE3D_SQUARE;
                    }
                }


                if( (nShape!=nOldShape) && nOldShape!=CHART_SHAPE3D_IGNORE)
                    return CHART_SHAPE3D_ANY;

                nOldShape=nShape;
            }
        }
    }

    return nShape;
}
long ChartModel::GetChartShapeType(long nRow)
{
	long nShape   =CHART_SHAPE3D_IGNORE;
	long nOldShape=CHART_SHAPE3D_IGNORE;
	const SfxPoolItem *pPoolItem;
	long nColCnt=GetColCount();
	for(long nCol=0;nCol<nColCnt;nCol++)
	{
		const SfxItemSet& rAttr=GetDataPointAttr(nCol,nRow);
		if(rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		{
			nShape=((const SfxInt32Item*) pPoolItem)->GetValue();
		}
		else
		{
			if(!GetDataPointObj(nCol,nRow))
			{
				nShape=nOldShape;
			}
			else
			{
				nShape=CHART_SHAPE3D_SQUARE;
			}
		}

		if( (nShape!=nOldShape) && nOldShape!=CHART_SHAPE3D_IGNORE)
				return CHART_SHAPE3D_ANY;

		nOldShape=nShape;
	}
	return nShape;
}
/*************************************************************************
|*                                                 |
|* 3D-Balken erzeugen; aPos: links, unten, hinten  |__
|*                                                /
\************************************************************************/
E3dCompoundObject* ChartModel::Create3DBar(::basegfx::B3DPoint aPos,
										   ::basegfx::B3DPoint aSizeVec,
										   long				nCol,
										   long				nRow,
										   SfxItemSet		&rAttr,
										   BOOL				bIsSimple,
										   double			fMinPos,
										   double			fOriPos,
										   double			fMaxPos)
{
	::basegfx::B3DHomMatrix aTransMat;

	long mode=CHART_SHAPE3D_SQUARE;
	double fHeight=fMaxPos-fMinPos;
	double a,b;


	const SfxPoolItem *pPoolItem = NULL;
	if (rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		mode=((const SfxInt32Item*) pPoolItem)->GetValue();
	if( (mode==CHART_SHAPE3D_ANY) ||
		(mode==CHART_SHAPE3D_IGNORE)		// BM #66527# shouldn't happen but actually does :-(
	  )
		mode=CHART_SHAPE3D_SQUARE;

	CHART_TRACE1( "Create3DBar Mode=%ld", mode );

	::basegfx::B2DPolyPolygon aPolyPoly;
	::basegfx::B3DPoint aDestCenter;
	E3dCompoundObject* pObj;
	E3dDefaultAttributes aDefltAttr3D;

	long nSegs=32;

	double fBase =
		( IsBar()
		  ? SCH_MIN( aSizeVec.getY(), aSizeVec.getZ())
		  : SCH_MIN( aSizeVec.getX(), aSizeVec.getZ()) )
		/ 2.0 - 1.0;

	aDestCenter = aPos + (aSizeVec / 2.0);

	double fTmp = IsBar()
		? aDestCenter.getX()
		: aDestCenter.getY();
	BOOL bNegativ=(fTmp < fOriPos);

	if(mode!=CHART_SHAPE3D_SQUARE && IsBar())
	{
		a = aPos.getX() - fOriPos;
		b = aPos.getX() + aSizeVec.getX() - fOriPos;

		double fTmp = aSizeVec.getX();
		aSizeVec.setX(aSizeVec.getY());
		aSizeVec.setY(fTmp);
		aSizeVec.setZ(-aSizeVec.getZ()); //90Grad drehen
	}
	else
	{
		a = aPos.getY() - fOriPos;
		b = aPos.getY() + aSizeVec.getY() - fOriPos;
	}

	const double fRelH  =(double)( (bNegativ) ? fOriPos-fMaxPos : fMinPos-fOriPos);

	a = fRelH - a;
	b = fRelH - b;

	if(bNegativ)
	{
		double tmp = a;
		a = b;
		b = tmp;
	}


	if(mode==CHART_SHAPE3D_HANOI)
	{
		b = a;
		mode = CHART_SHAPE3D_CONE;
	}

	// add extra points to extrusion-rectangle, to get a uniformly light-distribution
	// the distance of these offset points is dependent of the setting of "edge-rounding"
	double fRoundedEdge = 0.0;

	fRoundedEdge = ((double)((const Svx3DPercentDiagonalItem&)
		rAttr.Get(SDRATTR_3DOBJ_PERCENT_DIAGONAL)).GetValue()) / 200.0;
//-/	SfxItemState nState = rAttr.GetItemState( SID_ATTR_3D_PERCENT_DIAGONAL, TRUE, &pPoolItem );
//-/	if( nState == SFX_ITEM_DEFAULT )
//-/		fRoundedEdge = aDefltAttr3D.GetDefaultPercentDiag();
//-/	else if( nState == SFX_ITEM_SET && pPoolItem )
//-/		fRoundedEdge = SAL_STATIC_CAST( double, ( SAL_STATIC_CAST( const SfxUInt16Item*, pPoolItem )->GetValue() ))
//-/			/ 200.0;

	// always use extra points, so set percent diagonal to 0.4 which is 0% in the UI
	if( fRoundedEdge == 0.0 )
		fRoundedEdge = 0.4 / 200.0;

	switch( mode )
	{
		case CHART_SHAPE3D_CYLINDER:
			{
				double fOffset = (fBase * 2.0 * fRoundedEdge) * 1.05;		// increase by 5% for safety

				aPos = ::basegfx::B3DPoint( 0.0, 0.0, 0.0 );
				if( 2.0 * fOffset < fBase &&
					2.0 * fOffset < aSizeVec.getY() )
				{
					::basegfx::B2DPolygon aPoly;
					aPoly.append(::basegfx::B2DPoint( aPos.getX(), aPos.getY() ));
						  
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase - fOffset, aPos.getY() ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase, aPos.getY() ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase, aPos.getY() + fOffset ));
						  
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase, aPos.getY() + aSizeVec.getY() - fOffset ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase, aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fBase - fOffset, aPos.getY() + aSizeVec.getY()));
					  
					aPoly.append(::basegfx::B2DPoint( aPos.getX(), aPos.getY() + aSizeVec.getY()));

					aPolyPoly.append( aPoly );
				}
				else
				{
					::basegfx::B2DPolygon aPoly;

					aPoly.append(::basegfx::B2DPoint(aPos.getX() , aPos.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX() + fBase , aPos.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX() + fBase , aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX() , aPos.getY() + aSizeVec.getY()));
					
					aPolyPoly.append(aPoly);
				}
			
				pObj = new SchE3dLatheObj(aDefltAttr3D, aPolyPoly);
  				((E3dLatheObj*)pObj)->SetMergedItem( Svx3DHorizontalSegmentsItem( nSegs ));


				// #67170# just write the necessary attributes
//-/				SfxItemSet aSegmentAttr(*pItemPool, SID_ATTR_3D_START, SID_ATTR_3D_END,
//-/													SCHATTR_STYLE_START, SCHATTR_STYLE_END,
//-/													0);
				SfxItemSet aSegmentAttr(*pItemPool, 
					SDRATTR_3D_FIRST, SDRATTR_3D_LAST,
					SCHATTR_STYLE_START, SCHATTR_STYLE_END,
					0, 0);

  				rAttr.Put( Svx3DHorizontalSegmentsItem( nSegs ));

				aSegmentAttr.Put(rAttr);
				PutDataPointAttr(nCol, nRow, aSegmentAttr);
			}
			break;


		case CHART_SHAPE3D_PYRAMID:
			nSegs = 4;
			aTransMat.rotate(0.0, F_PI / 4.0, 0.0);		// rotate edge to front
			// continue with same code as for cone

		case CHART_SHAPE3D_CONE:
			{
				aPos = ::basegfx::B3DPoint( 0.0, 0.0, 0.0 );
				double fOffset = (fBase * fRoundedEdge) * 1.05;		// increase by 5% for safety

				BOOL bIsTip = (fRelH == 0.0 || fHeight == 0.0) ||	// nonstacked chart
					(fBase * b <= fOffset * fRelH);					// tip of stacked chart

				double r1, r2;
				if( bIsTip )
				{
					r1 = 0.0;
					r2 = ( fRelH == 0.0 )? fBase : ( fBase * a ) / fRelH;
				}
				else
				{
					r1 = ( fBase * b ) / fRelH;
					r2 = ( fBase * a ) / fRelH;
				}
				double fTemp	= ((r2-r1) * (r2-r1)) / (aSizeVec.getY() * aSizeVec.getY());
				double fOffsetX = sqrt( fOffset * fOffset / (1.0 + 1.0/fTemp ));
				double fOffsetY = sqrt( fOffset * fOffset / (1.0 + fTemp ));

				::basegfx::B2DPolygon aPoly;

				if( ! bIsTip )		// skip these points for the tip
				{
					aPoly.append(::basegfx::B2DPoint( aPos.getX(), aPos.getY()));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + r1 - fOffset,	aPos.getY()));
				}

				aPoly.append(::basegfx::B2DPoint( aPos.getX() + r1, aPos.getY()));
				aPoly.append(::basegfx::B2DPoint( aPos.getX() + r1 + fOffsetX, aPos.getY() + fOffsetY));
				aPoly.append(::basegfx::B2DPoint( aPos.getX() + r2 - fOffsetX, aPos.getY() + aSizeVec.getY() - fOffsetY));
				aPoly.append(::basegfx::B2DPoint( aPos.getX() + r2, aPos.getY() + aSizeVec.getY()));
				aPoly.append(::basegfx::B2DPoint( aPos.getX() + r2 - fOffset, aPos.getY() + aSizeVec.getY()));
				aPoly.append(::basegfx::B2DPoint( aPos.getX(), aPos.getY() + aSizeVec.getY()));

				aPolyPoly.append( aPoly );

				pObj = new SchE3dLatheObj( aDefltAttr3D, aPolyPoly );
  				((E3dLatheObj*)pObj)->SetMergedItem( Svx3DHorizontalSegmentsItem( nSegs ));

				// #67170# just write the necessary attributes
//-/				SfxItemSet aSegmentAttr(*pItemPool, SID_ATTR_3D_START, SID_ATTR_3D_END,
//-/													SCHATTR_STYLE_START, SCHATTR_STYLE_END,
//-/													0);
				SfxItemSet aSegmentAttr(*pItemPool, 
					SDRATTR_3D_FIRST,		SDRATTR_3D_LAST,
					SCHATTR_STYLE_START,	SCHATTR_STYLE_END,
					0, 0);

				rAttr.Put( Svx3DHorizontalSegmentsItem( nSegs ));

				aSegmentAttr.Put(rAttr);
				PutDataPointAttr(nCol, nRow, aSegmentAttr);
			}
			break;
		default:
		case CHART_SHAPE3D_SQUARE:
			{
				double fOffset = (aSizeVec.getZ() * fRoundedEdge) * 1.05;		// increase by 5% for safety

				if( 2.0 * fOffset < aSizeVec.getX() &&
					2.0 * fOffset < aSizeVec.getY() )
				{
					::basegfx::B2DPolygon aPoly;

					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fOffset,					aPos.getY() ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX(),							aPos.getY() ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX(),							aPos.getY() + fOffset ));

					aPoly.append(::basegfx::B2DPoint( aPos.getX(),							aPos.getY() + aSizeVec.getY() - fOffset ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX(),							aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + fOffset,					aPos.getY() + aSizeVec.getY()));

					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX() - fOffset,	aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX(),				aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX(),				aPos.getY() + aSizeVec.getY() - fOffset ));

					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX(),				aPos.getY() + fOffset ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX(),				aPos.getY() ));
					aPoly.append(::basegfx::B2DPoint( aPos.getX() + aSizeVec.getX() - fOffset,	aPos.getY() ));

					aPoly.setClosed(true);
					aPolyPoly.append( aPoly );
				}
				else
				{
					::basegfx::B2DPolygon aPoly;
					
					aPoly.append(::basegfx::B2DPoint(aPos.getX(), aPos.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX(), aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX() + aSizeVec.getX(), aPos.getY() + aSizeVec.getY()));
					aPoly.append(::basegfx::B2DPoint(aPos.getX() + aSizeVec.getX(), aPos.getY()));
					
					aPoly.setClosed(true);
					aPolyPoly.append(aPoly);
				}

				pObj = new SchE3dExtrudeObj(aDefltAttr3D, aPolyPoly, aSizeVec.getZ());
			}
			break;

	}

	::basegfx::B3DPoint aOldCenter(pObj->GetCenter());
	if(mode!=CHART_SHAPE3D_SQUARE)
	{
		if(IsBar())
		{
			aTransMat.translate(-aOldCenter.getX(), -aOldCenter.getY(), -aOldCenter.getZ());//Zentrum in Nullpunkt setzen
			aTransMat.rotate(0.0, 0.0, -3.1415927/2.0);//Saeule umwerfen (90Grad nach rechts)
			if(bNegativ)
				aTransMat.rotate(0.0, 0.0, 3.1415927);//Spitze nach unten oder links(Kegel, etc.)
			aOldCenter = ::basegfx::B3DPoint(0.0, 0.0, 0.0);
		}
		else if(bNegativ)
		{
			aTransMat.translate(-aOldCenter.getX(), -aOldCenter.getY(), -aOldCenter.getZ());//Zentrum in Nullpunkt setzen
			if(bNegativ)
				aTransMat.rotate(0.0, 0.0, 3.1415927);//Spitze nach unten oder links(Kegel, etc.)
			aOldCenter = ::basegfx::B3DPoint(0.0, 0.0, 0.0);
		}
	}

	const ::basegfx::B3DPoint aTransDiff(aDestCenter - aOldCenter);
	aTransMat.translate(aTransDiff.getX(), aTransDiff.getY(), aTransDiff.getZ());//An die gewuenschte Position schieben
	//aTransMat=pObj->GetTransform()*aTransMat;
	pObj->NbcSetTransform(aTransMat);

	pObj->SetModel (this);
    // #106658# the ChartModel has a different Pool default for the
    // Svx3DPercentDiagonalItem.  The Geometry is created while using a global
    // pool (Model is not set). Ensure recreating the geometry with new Model
    pObj->DestroyGeometry();

	pObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));

	// the number vertical segments is always fixed
	rAttr.ClearItem( SDRATTR_3DOBJ_VERT_SEGS );
	pObj->SetMergedItemSet(rAttr);

	pObj->InsertUserData(new SchDataPoint(nCol, nRow));

	return  pObj;
}
/*************************************************************************
|*
|* Neues 3D-Object erzeugen
|*
\************************************************************************/
E3dObject* ChartModel::Create3DObject (UINT16     ID)
{
	E3dObject *pMyObject = new SchE3dObject;
	pMyObject->SetModel (this);
	pMyObject->InsertUserData(new SchObjectId(ID));
	return pMyObject;
}

E3dScene* ChartModel::Create3DScene (UINT16     ID)
{
	E3dScene* pMyObject = new ChartScene( this );
	pMyObject->InsertUserData(new SchObjectId(ID));
	return pMyObject;
}

E3dObject* ChartModel::Create3DAxisObj( UINT16 nId )
{
	E3dObject *pMyObject = new Sch3dAxisObj;
	pMyObject->SetModel( this );
	pMyObject->InsertUserData( new SchObjectId( nId ) );
	return pMyObject;
}

/*************************************************************************
|*
|* 3D-Polygon erzeugen
|*
\************************************************************************/
void  ChartModel::Create3DPolyObject (const SfxItemSet  *pAttr,
						 E3dPolygonObj     *pMyObject,
						 UINT16            nID,
						 E3dObject *pParent)
{
	pMyObject->InsertUserData(new SchObjectId(nID));
	pParent->Insert3DObj (pMyObject);
	pMyObject->SetModel (this);

//-/	pMyObject->NbcSetAttributes(*pAttr, FALSE);
	pMyObject->SetMergedItemSet(*pAttr);

}


void  ChartModel::Create3DExtrudePolyObj(const SfxItemSet  *pAttr,
						 E3dExtrudeObj     *pMyObject,
						 UINT16            nID,
						 E3dObject *pParent)
{
	pMyObject->InsertUserData(new SchObjectId(nID));
	pParent->Insert3DObj (pMyObject);
	pMyObject->SetModel (this);

//-/	pMyObject->NbcSetAttributes(*pAttr, FALSE);
	pMyObject->SetMergedItemSet(*pAttr);

}

/*************************************************************************
|*
|* 3D-Scene erzeugen
|*
\************************************************************************/

ChartScene* ChartModel::CreateScene (const Rectangle &rRect,
						 const ::basegfx::B3DVector& aLightVec,
						 double          fSpotIntensity,
						 Color&          rSpotColor,
						 double          fAmbientIntensity,
						 Color&          rAmbientColor)
{
	ChartScene *pMyScene = new ChartScene (this);

	pMyScene->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM));
	pMyScene->NbcSetSnapRect(rRect);

	return pMyScene;
}

//////////////////////////////////////////////////////////////////////////////

void ImpStoreObjcetsAttr(SdrObject *pObj)
{
	ChartModel* pModel = (ChartModel*)pObj->GetModel();
	if(pModel)
		pModel->StoreObjectsAttributes(pObj, pObj->GetMergedItemSet(), FALSE);
}

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void SchRectangleProperties::ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem)
		{
			// call parent
			RectangleProperties::ItemChange(nWhich, pNewItem);

			// do chart specific things
			ImpStoreObjcetsAttr(&GetSdrObject());
		}

		SchRectangleProperties::SchRectangleProperties(SdrObject& rObj)
		:	RectangleProperties(rObj)
		{
		}

		SchRectangleProperties::SchRectangleProperties(const SchRectangleProperties& rProps, SdrObject& rObj)
		:	RectangleProperties(rProps, rObj)
		{
		}

		SchRectangleProperties::~SchRectangleProperties()
		{
		}

		BaseProperties& SchRectangleProperties::Clone(SdrObject& rObj) const
		{
			return *(new SchRectangleProperties(*this, rObj));
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties* SchRectObj::CreateObjectSpecificProperties()
{
	return new sdr::properties::SchRectangleProperties(*this);
}

//////////////////////////////////////////////////////////////////////////////

void SchRectObj::NbcSetOutlinerParaObject(OutlinerParaObject* pTextObject)
{
	SdrRectObj::NbcSetOutlinerParaObject(pTextObject);
	ChartModel* pModel=(ChartModel*)GetModel();
	if(pModel)
		pModel->SetTextFromObject(this,pTextObject);
}

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void SchExtrudeProperties::ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem)
		{
			// call parent
			E3dExtrudeProperties::ItemChange(nWhich, pNewItem);

			// do chart specific things
			ImpStoreObjcetsAttr(&GetSdrObject());
		}

		SchExtrudeProperties::SchExtrudeProperties(SdrObject& rObj)
		:	E3dExtrudeProperties(rObj)
		{
		}

		SchExtrudeProperties::SchExtrudeProperties(const SchExtrudeProperties& rProps, SdrObject& rObj)
		:	E3dExtrudeProperties(rProps, rObj)
		{
		}

		SchExtrudeProperties::~SchExtrudeProperties()
		{
		}

		BaseProperties& SchExtrudeProperties::Clone(SdrObject& rObj) const
		{
			return *(new SchExtrudeProperties(*this, rObj));
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties* SchE3dExtrudeObj::CreateObjectSpecificProperties()
{
	return new sdr::properties::SchExtrudeProperties(*this);
}

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void SchPolygonProperties::ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem)
		{
			// call parent
			E3dCompoundProperties::ItemChange(nWhich, pNewItem);

			// do chart specific things
			ImpStoreObjcetsAttr(&GetSdrObject());
		}

		SchPolygonProperties::SchPolygonProperties(SdrObject& rObj)
		:	E3dCompoundProperties(rObj)
		{
		}

		SchPolygonProperties::SchPolygonProperties(const SchPolygonProperties& rProps, SdrObject& rObj)
		:	E3dCompoundProperties(rProps, rObj)
		{
		}

		SchPolygonProperties::~SchPolygonProperties()
		{
		}

		BaseProperties& SchPolygonProperties::Clone(SdrObject& rObj) const
		{
			return *(new SchPolygonProperties(*this, rObj));
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties* SchE3dPolygonObj::CreateObjectSpecificProperties()
{
	return new sdr::properties::SchPolygonProperties(*this);
}

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void SchLatheProperties::ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem)
		{
			// call parent
			E3dLatheProperties::ItemChange(nWhich, pNewItem);

			// do chart specific things
			ImpStoreObjcetsAttr(&GetSdrObject());
		}

		SchLatheProperties::SchLatheProperties(SdrObject& rObj)
		:	E3dLatheProperties(rObj)
		{
		}

		SchLatheProperties::SchLatheProperties(const SchLatheProperties& rProps, SdrObject& rObj)
		:	E3dLatheProperties(rProps, rObj)
		{
		}

		SchLatheProperties::~SchLatheProperties()
		{
		}

		BaseProperties& SchLatheProperties::Clone(SdrObject& rObj) const
		{
			return *(new SchLatheProperties(*this, rObj));
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties* SchE3dLatheObj::CreateObjectSpecificProperties()
{
	return new sdr::properties::SchLatheProperties(*this);
}

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		void Sch3DProperties::ItemChange(const sal_uInt16 nWhich, const SfxPoolItem* pNewItem)
		{
			// call parent
			E3dProperties::ItemChange(nWhich, pNewItem);

			// do chart specific things
			ImpStoreObjcetsAttr(&GetSdrObject());
		}

		Sch3DProperties::Sch3DProperties(SdrObject& rObj)
		:	E3dProperties(rObj)
		{
		}

		Sch3DProperties::Sch3DProperties(const Sch3DProperties& rProps, SdrObject& rObj)
		:	E3dProperties(rProps, rObj)
		{
		}

		Sch3DProperties::~Sch3DProperties()
		{
		}

		BaseProperties& Sch3DProperties::Clone(SdrObject& rObj) const
		{
			return *(new Sch3DProperties(*this, rObj));
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties* SchE3dObject::CreateObjectSpecificProperties()
{
	return new sdr::properties::Sch3DProperties(*this);
}

//////////////////////////////////////////////////////////////////////////////
// eof
