#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.5.146.1 $
#
#   last change: $Author: rt $ $Date: 2007/01/19 12:57:02 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
TARGET=osxbundle

# --- Settings -------------------------------------------------

.INCLUDE :	settings.mk

# --- Files ----------------------------------------------------

.IF "$(OS)"!="MACOSX"

dummy:
        @echo "Nothing to build for OS $(OS)"

.ELSE           # "$(OS)"!="MACOSX"

BUNDLE = $(MISC)$/OpenOffice.org.app
CONTENTS = $(BUNDLE)$/Contents

mainscript= \
	$(CONTENTS)$/Resources$/Scripts$/main.scpt


scriptfiles = \
	$(CONTENTS)$/Resources$/Scripts$/PostInstall.scpt

plistfiles  = $(CONTENTS)$/Info.plist \
		$(CONTENTS)$/Resources$/InfoPlist.strings		

ZIPFLAGS = -r
ZIP1TARGET = osxbundle
ZIP1DIR = $(CONTENTS)
ZIP1LIST = *

ZIP2TARGET = osxicons
ZIP2DIR = icons
ZIP2LIST = *.icns

.IF "$(GUIBASE)"!="aqua"
CREATOR_TYPE=OOo2
.ELSE
CREATOR_TYPE=OOO2
.ENDIF

.ENDIF		# "$(OS)"!="MACOSX"	

# --- Targets --------------------------------------------------

.INCLUDE : target.mk

.IF "$(OS)"=="MACOSX"

$(ZIP1TARGETN) : $(mainscript) $(scriptfiles) $(plistfiles)

$(plistfiles) : $(mainscript)

# create application bundle from apple script source
# Info.plist will be deleted to trigger copy rule of our own Info.plist  
$(mainscript) : $$(@:b).applescript
	$(RM) -r $(BUNDLE)
	osacompile -o $(BUNDLE) -c $(CREATOR_TYPE) -s $<
	echo "APPL$(CREATOR_TYPE)" > $(CONTENTS)$/PkgInfo
	$(RM) $(CONTENTS)$/Info.plist

$(scriptfiles) : $(mainscript)

$(CONTENTS)$/Resources$/Scripts$/%.scpt : %.applescript
	osacompile -d -o "$@" $<

# Info.plist and icns are just copied into the bundle	
$(CONTENTS)$/%.plist : %.plist
	+$(COPY) $< $@
	
$(CONTENTS)$/Resources$/InfoPlist.strings : InfoPlist.strings	
	+$(COPY) $< $@
	
.ENDIF		# "$(OS)"!="MACOSX"	

