/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FileDataProvider.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:11:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"
#include "FileDataProvider.hxx"
#include "FileDataSource.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart.FileDataProvider" ));
}  // anonymous namespace

namespace chart
{

FileDataProvider::FileDataProvider(
    const uno::Reference< uno::XComponentContext > & xContext ) :
        m_xContext( xContext )
{
}

FileDataProvider::~FileDataProvider()
{}

uno::Sequence< ::rtl::OUString > FileDataProvider::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 2 );
    aServices[ 0 ] = lcl_aServiceName;
    aServices[ 1 ] = C2U( "com.sun.star.chart2.DataProvider" );
    return aServices;
}

APPHELPER_XSERVICEINFO_IMPL( FileDataProvider, lcl_aServiceName )

// ----------------------------------------

// ____ XDataProvider ____

uno::Reference< chart2::XDataSource > SAL_CALL
    FileDataProvider::getDataByRangeRepresentation( const ::rtl::OUString& aRangeRepresentation )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // aRangeRepresentation is interpreted as FileName

    m_xChartData.set( m_xContext->getServiceManager()->createInstanceWithContext(
                          C2U( "com.sun.star.comp.chart.FileDataSource" ),
                          m_xContext ), uno::UNO_QUERY );

    uno::Reference< lang::XInitialization > xInit( m_xChartData, uno::UNO_QUERY );
    if( xInit.is())
    {
        uno::Sequence< uno::Any > aArgs( 1 );
        aArgs[ 0 ] <<= aRangeRepresentation;
        xInit->initialize( aArgs );
    }

    return m_xChartData;
}

uno::Reference< chart2::XDataSequence > SAL_CALL
    FileDataProvider::getDataSequenceByRangeIdentifier( const ::rtl::OUString& aRangeIdentifier )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // n.i.
    return uno::Reference< chart2::XDataSequence >();
}

uno::Reference< chart2::XDataSequence > SAL_CALL
    FileDataProvider::replaceRange( const uno::Reference< chart2::XDataSequence >& aSeq )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // n.i.
    return aSeq;
}

void SAL_CALL FileDataProvider::addDataChangeListener(
    const uno::Reference< chart2::XDataChangeListener >& aListener,
    const uno::Reference< chart2::XDataSource >& aData )
    throw (::com::sun::star::uno::RuntimeException)
{}

void SAL_CALL FileDataProvider::removeDataChangeListener(
    const uno::Reference< chart2::XDataChangeListener >& aListener,
    const uno::Reference< chart2::XDataSource >& aData )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{}

} //  namespace chart
