/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: st_access.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:05:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_ST_ACCESS_HXX
#define ARY_STORE_ST_ACCESS_HXX

// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <ary/x_ary.hxx>
#include <getncast.hxx>
#include "st_root.hxx"


namespace ary
{

namespace store
{

/** find() assumes the data to be there,
    else it throws exception x_CorruptData
    or x_InvalidCast.
*/
template <class STORAGE, class DEST>
inline const DEST &
find(
    const STORAGE &     i_rStorage,
    typename STORAGE::key
                        i_nId,
    T2T<DEST>            )
{
    return ary_cast<DEST>( i_rStorage[i_nId].Entity() );
}

/** find_access() assumes the data to be there,
    else it throws exception x_CorruptData
    or x_InvalidCast.
*/
template <class STORAGE, class DEST>
inline DEST &
find_access(
    STORAGE &           i_rStorage,
    typename STORAGE::key
                        i_nId,
    T2T<DEST>            )
{
    return ary_cast<DEST>( i_rStorage[i_nId].Entity() );
}



/** @return 0, if data are not there.
*/
template <class STORAGE, class DEST>
inline const DEST *
search(
    const STORAGE &     i_rStorage,
    typename STORAGE::key
                        i_nId,
    T2T<DEST>            )
{
    return ary_cast<DEST>( i_rStorage[i_nId].EntityPtr() );
}

/** @return 0, if data are not there.
*/
template <class STORAGE, class DEST>
inline DEST *
search_access(
    STORAGE &           i_rStorage,
    typename STORAGE::key
                        i_nId,
    T2T<DEST>            )
{
    return ary_cast<DEST>( i_rStorage[i_nId].EntityPtr() );
}




}   // namespace store
}   // namespace ary

#endif
