/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: project.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:54:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_PROJECT_HXX
#define ARY_PROJECT_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/arygroup.hxx>
#include <ary/re.hxx>
	// COMPONENTS
	// PARAMETERS
#include <ary/idlists.hxx>


namespace ary
{


class Project : public AryGroup
{
  public:
	// LIFECYCLE
	virtual				~Project() {}
	// OPERATIONS
	// INQUIRY
    const udmstri &     Name() const            { return inq_Name(); }


  private:
    virtual const udmstri &
                        inq_Name() const = 0;
};



class TopProject : public Project,
                   public RepositoryEntity 
{
  public:
    enum E_Slots
    {
        SLOT_MetaProjects,
        SLOT_CppLocationBases
    };

	// LIFECYCLE
                        TopProject(
                            Gid                 i_nProject );
	virtual			   	~TopProject();

	// OPERATIONS
    void                Add_Project(
                            Gid                 i_nProject );

	// INQUIRY
  private:
    // Interface ary::RepositoryEntity
	virtual Rid 		inq_Id() const;
    virtual void        do_StoreAt(
                            ary::Display &      o_rOut ) const;
	virtual RCid 		inq_RC() const;
	virtual const Documentation &
            	        inq_Info() const;
    virtual void        do_Add_Documentation(
	                        DYN Documentation & let_drInfo );

    // Interface ary::AryGroup
	virtual Gid 		inq_Id_Group() const;
    virtual const RepositoryEntity &
                        inq_RE_Group() const;
	virtual const group::SlotList &
                        inq_Slots() const;
    virtual DYN Slot *  inq_Create_Slot(
                            SlotAccessId        i_nSlot ) const;

    // Interface ary::Project
	virtual const udmstri &
						inq_Name() const;

	// DATA
	Gid                 nId;
	udmstri             sName;
	Set_Rid             aCppProjects;
};



/** Abstract base class for code from the same area of locations.
*/
class LocationBase : public Project
{
  public:
	// LIFECYCLE
	virtual			   	~LocationBase() {}

	// OPERATIONS
	// INQUIRY
//    Lid                 LocationRoot() const;        // TODO
//	virtual Gid 		Id_Group() const;

  protected:
						LocationBase() {}

  private:
/*
	virtual DYN Slot *  Create_SlotOfLocations() const;

	Lid                 RelatedLocation() const;
*/
};




}   // namespace ary


#endif



