/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: VectorBtreeParameters.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:27:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.io.File;

public final class VectorBtreeParameters extends BlockManagerParameters {
  private int _vectorLength;

  // some form of this is needed for starting new DBs
  public VectorBtreeParameters(File file, int blockSize, int root, int vecLen) {
    super(file, blockSize, root);
    _vectorLength = vecLen;
  }
  
  public VectorBtreeParameters(Schema schema, String partName)
    throws Exception {
      super(schema, partName);
      _vectorLength = integerParameter("vl");
  }
  
  public void updateSchema() {
    super.updateSchema("vl="+_vectorLength);
  }
  
  public VectorBtreeParameters(Schema schema, String partName, int vecLen)
    throws Exception {
      super(schema, partName);
      _vectorLength = vecLen;
  }
  
  public int getVectorLength() {
    return _vectorLength;
  }

  public void setBlockSize(int size) {
    super.setBlockSize(size);
  }

  public boolean readState() {
    return super.readState();
  }
}
