/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbmp.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 12:25:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_vcl.hxx"

#include <dbmp.hxx>
#include <bmpacc.hxx>

// -------------
// - SalBitmap -
// -------------

DummyBitmap::DummyBitmap() :
	mpDIB( NULL )
{
}

// -----------------------------------------------------------------------------

DummyBitmap::~DummyBitmap()
{
	Destroy();
}

// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------

BitmapBuffer* DummyBitmap::ImplCreateDIB( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )
{
	DBG_ASSERT( nBitCount == 1 || nBitCount == 4 || nBitCount == 8 || nBitCount == 24, "Unsupported BitCount!" );

	BitmapBuffer* pDIB;

	if( rSize.Width() && rSize.Height() )
	{
		pDIB = new BitmapBuffer;

		if( pDIB )
		{
			const USHORT nColors = ( nBitCount <= 8 ) ? ( 1 << nBitCount ) : 0;
			
			pDIB->mnFormat = BMP_FORMAT_BOTTOM_UP;

			switch( nBitCount )
			{
				case( 1 ): pDIB->mnFormat |= BMP_FORMAT_1BIT_MSB_PAL; break;
				case( 4 ): pDIB->mnFormat |= BMP_FORMAT_4BIT_MSN_PAL; break;
				case( 8 ): pDIB->mnFormat |= BMP_FORMAT_8BIT_PAL; break;
			
				default:
					pDIB->mnFormat |= BMP_FORMAT_24BIT_TC_BGR;
				break;
			}

			pDIB->mnWidth = rSize.Width();
			pDIB->mnHeight = rSize.Height();
			pDIB->mnScanlineSize = AlignedWidth4Bytes( pDIB->mnWidth * nBitCount );
			pDIB->mnBitCount = nBitCount;
			
			if( nColors )
			{
				pDIB->maPalette = rPal;
				pDIB->maPalette.SetEntryCount( nColors );
			}

			pDIB->mpBits = new BYTE[ pDIB->mnScanlineSize * pDIB->mnHeight ];
			rtl_zeroMemory( pDIB->mpBits, pDIB->mnScanlineSize * pDIB->mnHeight );
		}
	}
	else
		pDIB = NULL;

	return pDIB;
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )
{
	Destroy();
	mpDIB = ImplCreateDIB( rSize, nBitCount, rPal );

	return( mpDIB != NULL );
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap& rSSalBmp )
{
	Destroy();

    const DummyBitmap& rSalBmp = static_cast<const DummyBitmap&>( rSSalBmp );

	if( rSalBmp.mpDIB )
	{
		mpDIB = ImplCreateDIB( rSalBmp.GetSize(), rSalBmp.GetBitCount(), rSalBmp.mpDIB->maPalette );
		
		if( mpDIB )
			memcpy( mpDIB->mpBits, rSalBmp.mpDIB->mpBits, mpDIB->mnScanlineSize * mpDIB->mnHeight );
	}
	return( ! rSalBmp.mpDIB  || 
			( rSalBmp.mpDIB && ( mpDIB != NULL ) )
            );
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap&, SalGraphics* )
{
	return FALSE;
}

// -----------------------------------------------------------------------------

bool DummyBitmap::Create( const SalBitmap&, USHORT )
{
	return FALSE;
}

// -----------------------------------------------------------------------------

void DummyBitmap::Destroy()
{
	if( mpDIB )
	{
		delete[] mpDIB->mpBits;
		delete mpDIB, mpDIB = NULL;
	}
}

// -----------------------------------------------------------------------------

Size DummyBitmap::GetSize() const
{
	Size aSize;

	if( mpDIB )
		aSize.Width() = mpDIB->mnWidth, aSize.Height() = mpDIB->mnHeight;
	
	return aSize;
}

// -----------------------------------------------------------------------------

USHORT DummyBitmap::GetBitCount() const
{
	USHORT nBitCount;

	if( mpDIB )
		nBitCount = mpDIB->mnBitCount;
	else
		nBitCount = 0;

	return nBitCount;
}

// -----------------------------------------------------------------------------

BitmapBuffer* DummyBitmap::AcquireBuffer( bool )
{
	return mpDIB;
}

// -----------------------------------------------------------------------------

void DummyBitmap::ReleaseBuffer( BitmapBuffer*, bool )
{
}

// -----------------------------------------------------------------------------

bool DummyBitmap::GetSystemData( BitmapSystemData& )
{
    return false;
}
