/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shutil.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 01:08:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_tools.hxx"

#ifndef _SHUTIL_H_
#include <shutil.h>
#endif

#include <string.h>


#define PROTOCOL_FILE	"file:"

extern "C" {

//--------------------------------------------------------------------------
//	SHGetPathFromIDListEx
//--------------------------------------------------------------------------

/*
BOOL WINAPI WIN_SHGetPathFromIDListEx( LPCITEMIDLIST pidl, LPSTR pszPath, UINT uFlags )
{
	if ( uFlags & SHGP_CLSID )
	{
		while ( pidl->mkid.cb )
		{
			pszPath += WIN_CreateStringFromBinary( pidl, pidl->mkid.cb, pszPath, 2048 );
			pidl = (LPCITEMIDLIST)((LPBYTE)pidl + pidl->mkid.cb);
			if ( pidl->mkid.cb )
				*pszPath++ = '/';
		}
		*pszPath = '\0';

		return TRUE;
	}
	else
		return WIN_SHGetPathFromIDList( pidl, pszPath );
}

*/

//--------------------------------------------------------------------------
//	SHGetPathFromURL
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetPathFromURL( LPCSTR pszURL, LPSTR pszPath )
{
	int nLeadingSlashes = 0;
	int	nLenFileProtocol = strlen(PROTOCOL_FILE);

	if ( strnicmp( pszURL, PROTOCOL_FILE, nLenFileProtocol) == 0 )
		pszURL += nLenFileProtocol;

	while ( *pszURL == '/' || *pszURL == '\\' )
	{
		pszURL++;
		nLeadingSlashes++;
	}

	if ( strlen(pszURL) >= 2 && pszURL[1] != ':' && pszURL[1] != '|' )
	{
		strcpy( pszPath, "\\\\" );
		pszPath += 2;
	}


	char	c;

	while ( c = *(pszURL++) )
	{
		switch ( c )
		{
		case '/':
			*(pszPath++) = '\\';
			break;
		case '|':
			*(pszPath++) = ':';
			break;
		default:
			*(pszPath++) = c;
			break;
		}
	};

	*pszPath = '\0';

	return TRUE;
}

//--------------------------------------------------------------------------
//	SHGetURLFromPath
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetURLFromPath( LPCSTR pszPath, LPSTR pszURL )
{
	BOOL	fIsUNC = FALSE;

	strcpy( pszURL, PROTOCOL_FILE );
	strcat( pszURL, "///" );

	while ( *pszPath == '\\' || *pszPath == '/' )
	{
		if ( ! fIsUNC )
		{
			strcat( pszURL, "/" );
			fIsUNC = TRUE;
		}

		pszPath++;
	}

	pszURL += strlen( pszURL );

	char c;

	while ( c = *(pszPath++) )
	{
		switch ( c )
		{
		case '\\':
			*(pszURL++) = '/';
			break;
		case ':':
			*(pszURL++) = '|';
			break;
		default:
			*(pszURL++) = c;
			break;
		}
	};

	*pszURL = '\0';

	return TRUE;
}

//--------------------------------------------------------------------------
//	SHGetFolderFromIDList
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetFolderFromIDList( LPCITEMIDLIST pidl, LPSHELLFOLDER *ppshf )
{
	LPSHELLFOLDER	pRootFolder;
	BOOL			fSuccess = FALSE;

	if ( NOERROR == SHGetDesktopFolder( &pRootFolder ) )
	{
		BOOL	bValid = TRUE;

		// Nachschauen ob die Laenge 2 gesetzt ist, als Zeichen fuer eine ungueltige PIDL
		// Sonst kommet es zum Absturz in NTDLL

		if ( pidl )
		{
			LPCITEMIDLIST	pidlTest = pidl;

			while ( bValid && pidlTest->mkid.cb )
			{
				if ( pidlTest->mkid.cb == sizeof(USHORT) )
					bValid = FALSE;
				pidlTest = (LPCITEMIDLIST)((LPBYTE)pidlTest + pidlTest->mkid.cb);
			}
		}
		else
			bValid = FALSE;

		// Gueltige PIDL ?

		if ( bValid )
		{
			if ( pidl->mkid.cb == 0 )
			{
				*ppshf = pRootFolder;
				fSuccess = TRUE;
			}
			else
			{
				fSuccess = (BOOL)(NOERROR == pRootFolder->BindToObject( pidl, NULL, IID_IShellFolder, (LPVOID *)ppshf ));
				pRootFolder->Release();
			}
		}
	}

	return fSuccess;
}


//--------------------------------------------------------------------------
//	SHGetFolderFromPath
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetFolderFromPath( LPCSTR pszPath, LPSHELLFOLDER *ppshf )
{
	LPITEMIDLIST	pidl = NULL;
	BOOL			fSuccess = FALSE;

	if ( WIN_SHGetIDListFromPath( pszPath, &pidl ) )
	{
		fSuccess = WIN_SHGetFolderFromIDList( pidl, ppshf );
		WIN_SHFree( pidl );
	}

	return fSuccess;
}


//--------------------------------------------------------------------------
//	SHGetSpecialFolder
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHGetSpecialFolder( int nFolder, LPSHELLFOLDER *ppshf  )
{
	LPITEMIDLIST	pidl = NULL;
	BOOL			fSuccess = FALSE;

	if ( nFolder == CSIDL_DESKTOP )
		fSuccess = SUCCEEDED(SHGetDesktopFolder( ppshf ));
	else if ( WIN_SHGetSpecialFolderLocation( nFolder, &pidl ) )
	{
		fSuccess = WIN_SHGetFolderFromIDList( pidl, ppshf );
		WIN_SHFree( pidl );
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHGetSpecialPath
//--------------------------------------------------------------------------

BOOL	WINAPI WIN_SHGetSpecialFolderPath( int nFolder, LPSTR pszPath )
{
	LPITEMIDLIST	pidl = NULL;
	BOOL			fSuccess = FALSE;

	if ( WIN_SHGetSpecialFolderLocation( nFolder, &pidl ) )
	{
		fSuccess = WIN_SHGetPathFromIDList( pidl, pszPath );
		WIN_SHFree( pidl );
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHStrRetToMultiByte
//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHStrRetToMultiByte( LPCITEMIDLIST pidl, const STRRET *pStr, LPSTR lpMultiByte, int cchMultiByte )
{
	BOOL	fSuccess = FALSE;

	if ( pStr && lpMultiByte )
	{
		switch ( pStr->uType )
		{
		case STRRET_CSTR:
			strcpy( lpMultiByte, pStr->cStr );
			fSuccess = TRUE;
			break;
		case STRRET_OFFSET:
			if ( pidl )
			{
				strcpy( lpMultiByte, (LPCSTR)((LPBYTE)pidl + pStr->uOffset) );
				fSuccess = TRUE;
			}
			break;
		case STRRET_WSTR:
			WideCharToMultiByte( CP_ACP, 0, pStr->pOleStr, -1, lpMultiByte, cchMultiByte, NULL, NULL );
//			WIN_SHFree( pStr->pOleStr );
			fSuccess = TRUE;
			break;
		default:
			break;
		}
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
//	SHBuildCRC
//--------------------------------------------------------------------------

DWORD WIN_SHBuildCRC( LPVOID pv, ULONG nBytes )
{
	DWORD	dwCRC = 0;
	LPBYTE	pBytes = (LPBYTE)pv;
	ULONG	nDoubleWords = (nBytes + 0x03) >> 2;
	LPDWORD	pDoubleWords = (LPDWORD)pBytes;
	LPBYTE	pbCRC = (LPBYTE)&dwCRC;

	while ( nDoubleWords-- )
		dwCRC ^= *(pDoubleWords++);

	nBytes &= 0x03;
	pBytes = (LPBYTE)pDoubleWords;

	while ( nBytes-- )
		*(pbCRC++) ^= *(pBytes++);

	return dwCRC;
}

//--------------------------------------------------------------------------
//	GetShellVersion
//--------------------------------------------------------------------------

//	Version  Platform  
//	4.00	Windows 95, Windows NT 4.0, Internet Explorer 3.0, and
//			Internet Explorer 4.0 without Web Integrated Desktop.  
//	4.71	Internet Explorer 4.0 with Web Integrated Desktop.  

//  Return: LowWord -> Major
//			HighWord -> Minor

// #include <shlwapi.h>




typedef struct _DllVersionInfo
{
	DWORD	cbSize;
	DWORD	dwMajorVersion;
	DWORD	dwMinorVersion;
	DWORD	dwBuildNumber;
	DWORD	dwPlatformID;
} DLLVERSIONINFO;

typedef HRESULT (CALLBACK* DLLGETVERSIONPROC)(DLLVERSIONINFO *);



DWORD WINAPI WIN_GetShellVersion(VOID)
{
	HINSTANCE   hShell32;
	DWORD		dwVersion = 0;

	//Load the DLL.
	hShell32 = LoadLibrary(TEXT("shell32.dll"));

	if ( hShell32 )
	{
		HRESULT           hr = S_OK;
		DLLGETVERSIONPROC pDllGetVersion;
   
		//	You must get this function explicitly because earlier versions
		//	of the DLL 	don't implement this function. That makes the lack
		//	of implementation of the function a version marker in itself.

		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hShell32, TEXT("DllGetVersion"));
   
		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;

			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);
   
			hr = (*pDllGetVersion)(&dvi);
      
			if ( SUCCEEDED(hr) )
				dwVersion = MAKELONG( dvi.dwMajorVersion, dvi.dwMinorVersion );
		}
		else
		{
			//	If GetProcAddress failed, the DLL is a version previous to 
			//	the one shipped with IE 3.x.
			dwVersion = MAKELONG( 4, 0 );
		}
   
		FreeLibrary(hShell32);

	}

	return dwVersion;
}

//--------------------------------------------------------------------------
//	SHGetSystemImageList
//--------------------------------------------------------------------------

HIMAGELIST WINAPI WIN_SHGetSystemImageList( UINT uFlags )
{
	SHFILEINFO	sfi;
	DWORD		dwRet;
	
	dwRet = SHGetFileInfo( "", 0, &sfi, sizeof(sfi), SHGFI_SYSICONINDEX | uFlags );

	return (HIMAGELIST)dwRet;
}


/*

//--------------------------------------------------------------------------
// Binary strings
//--------------------------------------------------------------------------

#define HINIBBLE( byte )	(((BYTE)(byte) & 0xF0) >> 4)
#define LONIBBLE( byte )	((BYTE)(byte) & 0x0F)
#define MAKEBYTE( lo, hi )	( ((BYTE)(lo) & 0x0F) | (((BYTE)(hi) & 0x0F) << 4) )

//--------------------------------------------------------------------------

static CHAR NibbleToChar( BYTE nibble )
{
	if ( nibble < 0x0A )
		return '0' + nibble;
	else if ( nibble < 0x10 )
		return 'A' + ( nibble - 0x0A );
	else
		return '?';
}

//--------------------------------------------------------------------------

static BYTE CharToNibble( CHAR c )
{
	if ( c >= '0' && c <= '9' )
		return c - '0';
	else if ( c >= 'A' && c <= 'F' )
		return c - 'A' + 0x0A;
	else if ( c >= 'a' && c <= 'f' )
		return c - 'a' + 0x0a;
	else
		return (BYTE)-1;
}

//--------------------------------------------------------------------------
//	CreateStringFromBinary
//--------------------------------------------------------------------------

ULONG WINAPI WIN_CreateStringFromBinary ( LPCVOID pv, ULONG cbSize, LPSTR pszString, ULONG cbStringSize )
{
	LPBYTE	pBytes = (LPBYTE)pv;
	ULONG	cbRequired = 2 * cbSize;
	BYTE	b;

	if ( cbRequired < cbStringSize )
	{
		while ( cbSize-- )
		{
			b = *(pBytes++);
			*(pszString++) = NibbleToChar( LONIBBLE( b ) );
			*(pszString++) = NibbleToChar( HINIBBLE( b ) );
		}
		*pszString = '\0';
	}

	return cbRequired;
}

//--------------------------------------------------------------------------
//	CreateBinaryFromString
//--------------------------------------------------------------------------

ULONG WINAPI WIN_CreateBinaryFromString( LPCSTR pszStr, LPVOID pBuffer, ULONG cbSize )
{
	LPBYTE	pBytes = (LPBYTE)pBuffer;
	ULONG	cbRequired = 0;
	CHAR	c;
	BYTE	bLo, bHi;

	while ( cbSize-- && (c = *(pszStr++)) != 0 )
	{
		bLo = CharToNibble(c);

		c = *(pszStr++);
		bHi = CharToNibble( c );
		*(pBytes++) = MAKEBYTE( bLo, bHi );

		cbRequired++;

		if ( !c )
			break;
	}

	return cbRequired;
}

*/

//--------------------------------------------------------------------------
//	SHInvokeCommand
//--------------------------------------------------------------------------

#define CMDID_SUBMENU	((UINT)-1)

static UINT FindMenuItemID( IContextMenu *pMenu, HMENU hMenu, LPCSTR lpVerb )
{
	int nCount = GetMenuItemCount( hMenu );
	BOOL	fIsString = (BOOL)(HIWORD((DWORD)lpVerb) != 0);
	BOOL	fIsDefault = (BOOL)(lpVerb == NULL);
	UINT	uVerb = LOWORD((DWORD)lpVerb);

	for ( int nItem = 0; nItem < nCount; nItem++ )
	{
		CHAR	szVerb[256];

		UINT	uCmdID = GetMenuItemID( hMenu, nItem );
		UINT	uState = GetMenuState( hMenu, nItem, MF_BYPOSITION );

		if ( !(uState & MF_SEPARATOR) && uCmdID != CMDID_SUBMENU )
		{
			if ( fIsDefault && (uState & MF_DEFAULT) )
			{
				HRESULT	hResult;
				
				// Wenn das DefaultKommando "Oeffnen mit" ist, dann nichts zurueckliefern
				// um unsere Filterbox nicht abzuklemmen.

				hResult = pMenu->GetCommandString( uCmdID, GCS_VERB, NULL, szVerb, sizeof(szVerb) );
				if ( NOERROR == hResult && !stricmp(szVerb,"openas") )
					return 0;
				else
					return uCmdID;
			}
			
			// Wenn es sich bei dem Verb um einen String handelt, das Verb vergleichen

			if ( fIsString )
			{
				HRESULT	hResult;
				
				hResult = pMenu->GetCommandString( uCmdID, GCS_VERB, NULL, szVerb, sizeof(szVerb) );
				if ( NOERROR == hResult && !stricmp(szVerb, lpVerb) )
					return uCmdID;

			}	// anderenfalls ist das Verb als ID zu interpretieren
			else if ( uVerb == uCmdID )
				return uCmdID;
		}
	}

	return 0;
}

//--------------------------------------------------------------------------

BOOL WINAPI WIN_SHInvokeCommand(
	HWND	hwndOwner,
	DWORD	dwFlags,
	LPCTSTR	lpPath,
	LPCSTR	lpVerb,
	LPCSTR	lpParameters,
	LPCSTR	lpDirectory,
	int		nShow
	)
{
	// NT Version bestimmen

	DWORD	dwVersion = GetVersion();
	DWORD	dwMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));

	// Fuer NT 3.51 nutzen wir ShellExecute

	if ( dwMajorVersion < 4 )
		return (BOOL)((UINT)ShellExecute( hwndOwner, lpVerb, lpPath, lpParameters, lpDirectory, nShow ) > (UINT)HINSTANCE_ERROR);
	
	BOOL			fSuccess = FALSE;
	LPITEMIDLIST	pidl = NULL;

	// Wenn lpDirectory leer ist, wird es auf den Ort des Ziels gesetzt

	TCHAR	szDirectory[_MAX_PATH] = "";

	// Um die gleiche Funktionalitaet wie ShellExecute zu liefern muss erst ein SearchPath aufgerufen werden,
	// um auch mit nicht vollstaendigen Pfadangaben zurechtuzkommen

	if ( !(dwFlags & SHIC_PIDL) )
	{
		TCHAR	szFullPath[MAX_PATH];
		LPTSTR	lpName;

		if ( SearchPath( NULL, lpPath, ".exe", MAX_PATH, szFullPath, &lpName ) == 0 )
			return FALSE;
		else
		{
			WIN_SHGetIDListFromPath( szFullPath, &pidl );

			if ( !lpDirectory || !*lpDirectory )
			{
				TCHAR	szDrive[_MAX_DRIVE];
				TCHAR	szDir[_MAX_DIR];
				TCHAR	szFName[_MAX_FNAME];
				TCHAR	szExt[_MAX_EXT];

				_splitpath( szFullPath, szDrive, szDir, szFName, szExt );

				lstrcpy( szDirectory, szDrive );
				lstrcat( szDirectory, szDir );

				lpDirectory = szDirectory;
			}
		}
	}
	else
		WIN_SHCloneIDList( (LPCITEMIDLIST)lpPath, &pidl );

	if ( pidl )
	{
		LPITEMIDLIST	pidlFolder, pidlItem;
		LPSHELLFOLDER	pFolder;

		WIN_SHSplitIDList( pidl, &pidlFolder, &pidlItem );
		if ( WIN_SHGetFolderFromIDList( pidlFolder, &pFolder ) )
		{
			IContextMenu *pMenu;

			if ( NOERROR == pFolder->GetUIObjectOf( hwndOwner, 1, (LPCITEMIDLIST *)&pidlItem, IID_IContextMenu, NULL, (LPVOID *)&pMenu ) )
			{
				HMENU	hMenu = CreatePopupMenu();

				if ( hMenu )
				{
					HRESULT hResult = pMenu->QueryContextMenu( hMenu, 0, 0, 1000, CMF_NORMAL | CMF_CANRENAME | CMF_INCLUDESTATIC );

					if ( SUCCEEDED(hResult) )
					{
						CMINVOKECOMMANDINFO	ici;
						UINT	uCmdID = FindMenuItemID( pMenu, hMenu, lpVerb );

						if ( uCmdID )
						{
							ici.cbSize = sizeof(ici);
							ici.fMask = (dwFlags & SHIC_NO_UI) ? CMIC_MASK_FLAG_NO_UI : 0;
							ici.hwnd = NULL;
							ici.lpParameters = lpParameters;
							ici.lpDirectory = lpDirectory;
							ici.nShow = nShow;
							ici.dwHotKey = 0;
							ici.hIcon = NULL;
							ici.lpVerb = MAKEINTRESOURCE(uCmdID);

							fSuccess = (BOOL)(NOERROR == pMenu->InvokeCommand( &ici ));
						}
					}

					DestroyMenu( hMenu );
				}


				pMenu->Release();
			}

			pFolder->Release();
		}

		WIN_SHFree( pidlItem );
		WIN_SHFree( pidlFolder );
		WIN_SHFree( pidl );
	}

	return fSuccess;
}

//-----------------------------------------------------------------------------
//	SHSetValue
//-----------------------------------------------------------------------------

DWORD WINAPI WIN_SHSetValue( 
	HKEY	hKey,
	LPCTSTR	pszSubKey,
	LPCTSTR	pszValue,
	DWORD	dwType,
	LPCVOID	pvData,
	DWORD	cbData
	)
{
	HKEY	hSubKey;
	DWORD	dwError;

	dwError = RegCreateKey( hKey, pszSubKey, &hSubKey );

	if ( ERROR_SUCCESS == dwError )
	{
		dwError = RegSetValueEx( hSubKey, pszValue, 0, dwType, (const BYTE *)pvData, cbData );
		RegCloseKey( hSubKey );
	}

	return dwError;
}

//-----------------------------------------------------------------------------
//	SHGetValue
//-----------------------------------------------------------------------------

DWORD WINAPI WIN_SHGetValue( 
	HKEY	hKey,
	LPCTSTR	pszSubKey,
	LPCTSTR	pszValue,
	LPDWORD	pdwType,
	LPVOID	pvData,
	LPDWORD	pcbData
	)
{
	HKEY	hSubKey;
	DWORD	dwError;

	dwError = RegOpenKey( hKey, pszSubKey, &hSubKey );

	if ( ERROR_SUCCESS == dwError )
	{
		dwError = RegQueryValueEx( hSubKey, pszValue, 0, pdwType, (LPBYTE)pvData, pcbData );
		RegCloseKey( hSubKey );
	}

	return dwError;
}

//-----------------------------------------------------------------------------
//	SHDeleteValue
//-----------------------------------------------------------------------------

DWORD WINAPI WIN_SHDeleteValue(
	HKEY	hKey,
	LPCTSTR	pszSubKey,
	LPCTSTR	pszValue
	)
{
	HKEY	hSubKey;
	DWORD	dwError;

	dwError = RegOpenKey( hKey, pszSubKey, &hSubKey );

	if ( ERROR_SUCCESS == dwError );
	{
		dwError = RegDeleteValue( hSubKey, pszValue );
		RegCloseKey( hSubKey );
	}

	return dwError;
}

//--------------------------------------------------------------------------

}	// extern "C"
