/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: drawdoc.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 21:03:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#include <sot/storage.hxx>
#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _FORBIDDENCHARACTERSTABLE_HXX
#include <svx/forbiddencharacterstable.hxx>
#endif

#include <unotools/ucbstreamhelper.hxx>
#include <svx/xtable.hxx>

#define ITEMID_COLOR_TABLE      SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST    SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST       SID_HATCH_LIST
#define ITEMID_BITMAP_LIST      SID_BITMAP_LIST
#define ITEMID_DASH_LIST        SID_DASH_LIST
#define ITEMID_LINEEND_LIST 	SID_LINEEND_LIST
#ifndef _SVX_DRAWITEM_HXX
#include <svx/drawitem.hxx>
#endif

#ifndef _VIEWSH_HXX
#include <viewsh.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>
#endif
#ifndef _DRAWDOC_HXX
#include <drawdoc.hxx>
#endif
#ifndef _DPAGE_HXX
#include <dpage.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _COM_SUN_STAR_EMBED_ELEMENTMODES_HPP_
#include <com/sun/star/embed/ElementModes.hpp>
#endif

using namespace com::sun::star;

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

const String GetPalettePath()
{
	SvtPathOptions aPathOpt;
	return aPathOpt.GetPalettePath();
}

SwDrawDocument::SwDrawDocument( SwDoc* pD ) :
	FmFormModel( ::GetPalettePath(), &pD->GetAttrPool(),
				 pD->GetDocShell(), TRUE ),
	pDoc( pD )
{
	SetScaleUnit( MAP_TWIP );
	SetSwapGraphics( TRUE );

	SwDocShell* pDocSh = pDoc->GetDocShell();
	if ( pDocSh )
	{
		SetObjectShell( pDocSh );
		SvxColorTableItem* pColItem = ( SvxColorTableItem* )
								( pDocSh->GetItem( ITEMID_COLOR_TABLE ) );
		XColorTable *pXCol = pColItem ? pColItem->GetColorTable() :
										XColorTable::GetStdColorTable();
		SetColorTable( pXCol );

		if ( !pColItem )
			pDocSh->PutItem( SvxColorTableItem( pXCol ) );

		pDocSh->PutItem( SvxGradientListItem( GetGradientList() ));
		pDocSh->PutItem( SvxHatchListItem( GetHatchList() ) );
		pDocSh->PutItem( SvxBitmapListItem( GetBitmapList() ) );
		pDocSh->PutItem( SvxDashListItem( GetDashList() ) );
		pDocSh->PutItem( SvxLineEndListItem( GetLineEndList() ) );
		pDocSh->PutItem( SfxUInt16Item(SID_ATTR_LINEEND_WIDTH_DEFAULT, 111) );
		SetObjectShell( pDocSh );
	}
	else
		SetColorTable( XColorTable::GetStdColorTable() );

	// copy all the default values to the SdrModel
	SfxItemPool* pSdrPool = pD->GetAttrPool().GetSecondaryPool();
	if( pSdrPool )
	{
		const USHORT aWhichRanges[] =
			{
				RES_CHRATR_BEGIN, RES_CHRATR_END,
				RES_PARATR_BEGIN, RES_PARATR_END,
				0
			};

		SfxItemPool& rDocPool = pD->GetAttrPool();
		USHORT nEdtWhich, nSlotId;
		const SfxPoolItem* pItem;
		for( const USHORT* pRangeArr = aWhichRanges;
			*pRangeArr; pRangeArr += 2 )
			for( USHORT nW = *pRangeArr, nEnd = *(pRangeArr+1);
					nW < nEnd; ++nW )
				if( 0 != (pItem = rDocPool.GetPoolDefaultItem( nW )) &&
					0 != (nSlotId = rDocPool.GetSlotId( nW ) ) &&
					nSlotId != nW &&
					0 != (nEdtWhich = pSdrPool->GetWhich( nSlotId )) &&
					nSlotId != nEdtWhich )
				{
					SfxPoolItem* pCpy = pItem->Clone();
					pCpy->SetWhich( nEdtWhich );
					pSdrPool->SetPoolDefaultItem( *pCpy );
					delete pCpy;
				}
	}

    SetForbiddenCharsTable( pD->getForbiddenCharacterTable() );
	// #87795# Implementation for asian compression
    SetCharCompressType( pD->getCharacterCompressionType() );
}

/*************************************************************************
|*
|* Konstruktor, fuer einfuegen Document
|*
\************************************************************************/


SwDrawDocument::SwDrawDocument( SfxItemPool *pPool, SwDocShell *pDocSh )
	: FmFormModel( ::GetPalettePath(), pPool, pDocSh, TRUE ),
	pDoc( pDocSh->GetDoc() )
{
	SetScaleUnit( MAP_TWIP );
	SetDefaultFontHeight( 240 );
	SetSwapGraphics( TRUE );

	ASSERT( pDocSh, "DocShell not found" );
	SvxColorTableItem* pColItem = ( SvxColorTableItem* )
								( pDocSh->GetItem( ITEMID_COLOR_TABLE ) );
	XColorTable *pXCol = pColItem ? pColItem->GetColorTable() :
									XColorTable::GetStdColorTable();
	SetColorTable( pXCol );

	if ( !pColItem )
		pDocSh->PutItem( SvxColorTableItem( pXCol ) );

	// Bug 35371:
	// 	fuers "Datei einfuegen" NIE die anderen Items an der DocShell setzen!!!
	// Diese zeigen sonst immer in das temporaere SdrModel !
	SetObjectShell( pDocSh );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/


SwDrawDocument::~SwDrawDocument()
{
	Broadcast(SdrHint(HINT_MODELCLEARED));

	// #116168#
	ClearModel(sal_True);
	//Clear();
}

/*************************************************************************
|*
|* Diese Methode erzeugt eine neue Seite (SdPage) und gibt einen Zeiger
|* darauf zurueck. Die Drawing Engine benutzt diese Methode beim Laden
|* zur Erzeugung von Seiten (deren Typ sie ja nicht kennt, da es ABLEITUNGEN
|* der SdrPage sind).
|*
\************************************************************************/


SdrPage* SwDrawDocument::AllocPage(FASTBOOL bMasterPage)
{
	SwDPage* pPage = new SwDPage(*this, bMasterPage);
	pPage->SetName( String::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM( "Controls" )) );
	return pPage;
}


SvStream* SwDrawDocument::GetDocumentStream( SdrDocumentStreamInfo& rInfo ) const
{
	SvStream* pRet = NULL;
    uno::Reference < embed::XStorage > xRoot( pDoc->GetDocStorage() );
    if( xRoot.is() )
    {
	    if( rInfo.maUserData.Len() &&
		    ( rInfo.maUserData.GetToken( 0, ':' ) ==
		      String( RTL_CONSTASCII_USTRINGPARAM( "vnd.sun.star.Package" ) ) ) )
	    {
		    const String aPicturePath( rInfo.maUserData.GetToken( 1, ':' ) );

		    // graphic from picture stream in picture storage in XML package
		    if( aPicturePath.GetTokenCount( '/' ) == 2 )
		    {
			    const String    aPictureStorageName( aPicturePath.GetToken( 0, '/' ) );
                const String    aPictureStreamName( aPicturePath.GetToken( 1, '/' ) );

                try
                {
                    uno::Reference < embed::XStorage > xPictureStorage = xRoot->openStorageElement(
                            aPictureStorageName, embed::ElementModes::READ );
                    uno::Reference < io::XStream > xStream = xPictureStorage->openStreamElement(
                            aPictureStreamName, embed::ElementModes::READ );
                    pRet = utl::UcbStreamHelper::CreateStream( xStream );
				    if( pRet )
				    {
                        rInfo.mbDeleteAfterUse = TRUE;
                        rInfo.mxStorageRef = xPictureStorage;
				    }
			    }
                catch ( uno::Exception& )
                {
                }
		    }
	    }
    }
	return pRet;
}

SdrLayerID SwDrawDocument::GetControlExportLayerId( const SdrObject & ) const
{
	//fuer Versionen < 5.0, es gab nur Hell und Heaven
	return (SdrLayerID)pDoc->GetHeavenId();
}

// --> OD 2006-03-01 #b6382898#
uno::Reference< uno::XInterface > SwDrawDocument::createUnoModel()
{

    uno::Reference< uno::XInterface > xModel;

    try
    {
        if ( GetDoc().GetDocShell() )
        {
            xModel = GetDoc().GetDocShell()->GetModel();
        }
    }
    catch( uno::RuntimeException& )
    {
        ASSERT( false,
                "<SwDrawDocument::createUnoModel()> - could *not* retrieve model at <SwDocShell>" );
    }

    return xModel;
}

// <--
