/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fmsearch.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 05:08:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif // _SVX_FMRESIDS_HRC

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _SVX_DIALMGR_HXX //autogen
#include <dialmgr.hxx>
#endif

//CHINA001 #ifndef _SVX_SRCHXTRA_HXX
//CHINA001 #include "srchxtra.hxx"
//CHINA001 #endif // _SVX_SRCHXTRA_HXX
#include <sfx2/tabdlg.hxx> //add by CHINA001 for SfxItemSet
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif

#ifndef _SFXFILEREC_HXX //autogen
#include <svtools/filerec.hxx>
#endif

#ifndef _FMSRCIMP_HXX
#include "fmsrcimp.hxx"
#endif //  _FMSRCIMP_HXX

#ifndef _FMSRCCF_HXX_
#include "fmsrccfg.hxx"
#endif // _FMSRCCF_HXX_

#ifndef _FMSEARCH_HRC
#include "fmsearch.hrc"
#endif // _FMSEARCH_HRC

#ifndef _FMSEARCH_HXX
#include "fmsearch.hxx"
#endif // _FMSEARCH_HXX

#ifndef _SVX_SRCHDLG_HXX
#include "srchdlg.hxx"
#endif

#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
#include <com/sun/star/i18n/TransliterationModules.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "svxdlg.hxx" //CHINA001

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::i18n;
using namespace ::svxform;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::util;

//------------------------------------------------------------------------
sal_Bool IsSearchableControl(const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface>& _xControl, ::rtl::OUString* pCurrentText)
{
	if (!_xControl.is())
		return sal_False;

	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTextComponent> xAsText(_xControl, ::com::sun::star::uno::UNO_QUERY);
	if (xAsText.is())
	{
		if (pCurrentText)
			*pCurrentText = xAsText->getText();
		return sal_True;
	}

	::com::sun::star::uno::Reference< ::com::sun::star::awt::XListBox> xListBox(_xControl, ::com::sun::star::uno::UNO_QUERY);
	if (xListBox.is())
	{
		if (pCurrentText)
			*pCurrentText = xListBox->getSelectedItem();
		return sal_True;
	}

	::com::sun::star::uno::Reference< ::com::sun::star::awt::XCheckBox> xCheckBox(_xControl, ::com::sun::star::uno::UNO_QUERY);
	if (xCheckBox.is())
	{
		if (pCurrentText)
		{
			switch ((TriState)xCheckBox->getState())
			{
				case STATE_NOCHECK: *pCurrentText = ::rtl::OUString::createFromAscii("0"); break;
				case STATE_CHECK: *pCurrentText = ::rtl::OUString::createFromAscii("1"); break;
				default: *pCurrentText = ::rtl::OUString::createFromAscii(""); break;
			}
		}
		return sal_True;
	}

	return sal_False;
}


