/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svlink.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2006/10/24 14:12:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVLINK_HXX
#define _SVLINK_HXX

#ifndef _IFACE_HXX
#include <iface.hxx>
#endif

#ifndef INCLUDED_SO3DLLAPI_H
#include "so3/so3dllapi.h"
#endif

/*************************************************************************
*************************************************************************/
class  SvLinkName;
struct IOleLink;
#ifndef SO2_DECL_SVLINKNAME_DEFINED
#define SO2_DECL_SVLINKNAME_DEFINED
SO2_DECL_REF(SvLinkName)
#endif

class SO3_DLLPUBLIC SvLinkObject : virtual public SvObject
{
	IOleLink *              pObjI;
protected:
	SO3_DLLPRIVATE 				~SvLinkObject();
public:
					SvLinkObject();
					SO2_DECL_STANDARD_CLASS_DLL(SvLinkObject,SOAPP)
	IOleLink *      GetOleLink() const;

	void            SetLinkSourceName( SvLinkName *,
									   const SvUniqueName & rClassname );
	SvLinkNameRef   GetLinkSourceName() const;

	void            SetAutomaticUpdate( BOOL bAuto );
	BOOL            IsAutomaticUpdate() const;
	BOOL            Update();
};
SO2_DECL_IMPL_REF(SvLinkObject)

#endif // _SVLINK_HXX
