/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tools.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/13 16:05:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_TOOLS_HXX
#define _SLIDESHOW_TOOLS_HXX

#include <com/sun/star/uno/Sequence.hxx>
#include <com/sun/star/beans/XPropertySet.hpp>

#include <basegfx/matrix/b2dhommatrix.hxx>
#include <basegfx/range/b2drectangle.hxx>
#include <basegfx/tuple/b2dtuple.hxx>
#include <basegfx/vector/b2dsize.hxx>

#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>

#include "shapeattributelayer.hxx"
#include "shape.hxx"
#include "rgbcolor.hxx"
#include "hslcolor.hxx"

#include <string.h> // for strcmp
#include <algorithm>

#include <boost/optional.hpp>
#include <functional>
#include <cstdlib>

#define OUSTR(x) ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(x) )


namespace com { namespace sun { namespace star { namespace beans {
    struct NamedValue;
} } } }

class GDIMetaFile;

/* Definition of some animation tools */
namespace slideshow
{
    namespace internal
    {
        typedef ::boost::shared_ptr< GDIMetaFile > GDIMetaFileSharedPtr;

        // xxx todo: remove with boost::hash when 1.33 is available
        template <typename T>
        struct hash : ::std::unary_function<T, ::std::size_t>
        {
            ::std::size_t operator()( T const& val ) const {
                return hash_value(val);
            }
        };
        template <typename T>
        inline ::std::size_t hash_value( T * const& p )
        {
            ::std::size_t d = static_cast< ::std::size_t >(
                reinterpret_cast< ::std::ptrdiff_t >(p) );
            return d + (d >> 3);
        }
    
        // xxx todo: shift to namespace com::sun::star::uno when
        //           1.33 is available
        template <typename T>
        inline ::std::size_t hash_value(
            ::com::sun::star::uno::Reference<T> const& x )
        {
            // normalize to object root, because _only_ XInterface is defined
            // to be stable during object lifetime:
            ::com::sun::star::uno::Reference<
                  ::com::sun::star::uno::XInterface> const xRoot(
                      x, ::com::sun::star::uno::UNO_QUERY );
            return hash<void *>()(xRoot.get());
        }

        /** Cycle mode of intrinsic animations
         */
        enum CycleMode
        {
            /// loop the animation back to back
            CYCLE_LOOP,
            /// loop, but play backwards from end to start
            CYCLE_PINGPONGLOOP
        };
        
    
        // Value extraction from Any
        // =========================

        class LayerManager;
        typedef ::boost::shared_ptr< LayerManager > LayerManagerSharedPtr;
    
        /// extract unary double value from Any
		bool extractValue( double&								o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract int from Any
        bool extractValue( sal_Int32&							o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract enum/constant group value from Any
        bool extractValue( sal_Int16&							o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract color value from Any
        bool extractValue( RGBColor&							o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract color value from Any
        bool extractValue( HSLColor&							o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract plain string from Any
        bool extractValue( ::rtl::OUString&						o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract bool value from Any
        bool extractValue( bool&								o_rValue, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /// extract double 2-tuple from Any
        bool extractValue( ::basegfx::B2DTuple&					o_rPair, 
                           const ::com::sun::star::uno::Any& 	rSourceAny, 
                           const ShapeSharedPtr&				rShape,
                           const LayerManagerSharedPtr&			rLayerManager );

        /** Search a sequence of NamedValues for a given element.

        	@return true, if the sequence contains the specified
        	element.
         */
        bool findNamedValue( ::com::sun::star::uno::Sequence< 
                             	::com::sun::star::beans::NamedValue > const& rSequence, 
                             const ::com::sun::star::beans::NamedValue&	rSearchKey );
        
        /** Search a sequence of NamedValues for an element with a given name.

        	@param o_pRet
            If non-NULL, receives the full NamedValue found (if it was
            found, that is).

        	@return true, if the sequence contains the specified
        	element.
         */
        bool findNamedValue( ::com::sun::star::beans::NamedValue* 		o_pRet, 
                             const ::com::sun::star::uno::Sequence< 
                             	::com::sun::star::beans::NamedValue >& 	rSequence, 
                             const ::rtl::OUString&						rSearchString );

        inline ::basegfx::B2DRectangle calcRelativeShapeBounds( const ::basegfx::B2DRectangle& rPageBounds,
                                                                const ::basegfx::B2DRectangle& rShapeBounds )
        {
            return ::basegfx::B2DRectangle( rShapeBounds.getMinX() / rPageBounds.getWidth(),
                                            rShapeBounds.getMinY() / rPageBounds.getHeight(),
                                            rShapeBounds.getMaxX() / rPageBounds.getWidth(),
                                            rShapeBounds.getMaxY() / rPageBounds.getHeight() );
		}

        /** Get the shape transformation from the attribute set

	        @param rBounds
            Original shape bound rect (to substitute default attribute
            layer values)
            
            @param pAttr
            Attribute set. Might be NULL (then, rBounds is used to set
            a simple scale and translate of the unit rect to rBounds).
        */
        ::basegfx::B2DHomMatrix getShapeTransformation( const ::basegfx::B2DRectangle&		rBounds,
                                                        const ShapeAttributeLayerSharedPtr&	pAttr );

        /** Get a shape's sprite transformation from the attribute set

	        @param rPixelSize
            Pixel size of the sprite
            
            @param rOrigSize
            Original shape size (i.e. the size of the actual sprite
            content, in the user coordinate system)

            @param pAttr
            Attribute set. Might be NULL (then, rBounds is used to set
            a simple scale and translate of the unit rect to rBounds).

            @return the transformation to be applied to the sprite.
        */
        ::basegfx::B2DHomMatrix getSpriteTransformation( const ::basegfx::B2DSize&				rPixelSize,
                                                         const ::basegfx::B2DSize&				rOrigSize,
                                                         const ShapeAttributeLayerSharedPtr&	pAttr );

        /** Calc update area for a shape.

        	This method calculates the 'covered' area for the shape,
        	i.e. the rectangle that is affected when rendering the
        	shape. Apart from applying the given transformation to the
        	shape rectangle, this method also takes attributes into
        	account, which further scale the output (e.g. character
        	sizes).

            @param rUnitBounds
            Shape bounds, in the unit rect coordinate space

            @param rShapeTransform
            Transformation matrix the shape should undergo.

            @param pAttr
            Current shape attributes
         */
        ::basegfx::B2DRectangle getShapeUpdateArea( const ::basegfx::B2DRectangle&		rUnitBounds,
                                                    const ::basegfx::B2DHomMatrix&		rShapeTransform, 
                                                    const ShapeAttributeLayerSharedPtr&	pAttr );

        /** Calc update area for a shape.

        	This method calculates the 'covered' area for the shape,
        	i.e. the rectangle that is affected when rendering the
        	shape. The difference from the other getShapeUpdateArea()
        	method is the fact that this one works without
        	ShapeAttributeLayer, and only scales up the given shape
        	user coordinate bound rect. The method is typically used
        	to retrieve user coordinate system bound rects for shapes
        	which are smaller than the default unit bound rect
        	(because e.g. of subsetting)

            @param rUnitBounds
            Shape bounds, in the unit rect coordinate space

            @param rShapeBounds
            Current shape bounding box in user coordinate space.
         */
        ::basegfx::B2DRectangle getShapeUpdateArea( const ::basegfx::B2DRectangle&		rUnitBounds,
                                                    const ::basegfx::B2DRectangle&		rShapeBounds );

        /** Calc output position and size of shape, according to given
            attribute layer.

            Rotations, shears etc. and not taken into account,
            i.e. the returned rectangle is NOT the bounding box. Use
            it as if aBounds.getMinimum() is the output position and
            aBounds.getRange() the scaling of the shape.
         */
        ::basegfx::B2DRectangle getShapePosSize( const ::basegfx::B2DRectangle&			rOrigBounds,
                                                 const ShapeAttributeLayerSharedPtr&	pAttr );

        /** Convert a plain UNO API 32 bit int to RGBColor
         */
        RGBColor unoColor2RGBColor( sal_Int32 );

        /** Fill a plain rectangle on the given canvas with the given color
         */
        void fillRect( const ::cppcanvas::CanvasSharedPtr& rCanvas,
                       const ::basegfx::B2DRectangle&	   rRect,
                       ::cppcanvas::Color::IntSRGBA        aFillColor );

        /** Init canvas with default background (white)
         */
        void initSlideBackground( const ::cppcanvas::CanvasSharedPtr& rCanvas,
                                  const ::basegfx::B2ISize&			  rSize );
    
        /// Gets a random ordinal [0,n)
        inline ::std::size_t getRandomOrdinal( const ::std::size_t n )
        {
            return static_cast< ::std::size_t >(
                double(n) * rand() / (RAND_MAX + 1.0) );
        }
    
        /// To work around ternary operator in initializer lists
        /// (Solaris compiler problems)
        template <typename T>
        inline T const & ternary_op(
            const bool cond, T const & arg1, T const & arg2 )
        {
            if (cond)
                return arg1;
            else
                return arg2;
        }
    
        template <typename ValueType>
        inline bool getPropertyValue(
            ValueType & rValue, 
            com::sun::star::uno::Reference<
            com::sun::star::beans::XPropertySet> const & xPropSet, 
            rtl::OUString const & propName )
        {
            try {
                const com::sun::star::uno::Any& a(
                    xPropSet->getPropertyValue( propName ) );
                bool const bRet = (a >>= rValue);
#if OSL_DEBUG_LEVEL > 0
                if( !bRet )
                    OSL_TRACE( "%s: while retrieving property %s, cannot extract Any of type %s\n",
                               ::rtl::OUStringToOString( propName,
                                                         RTL_TEXTENCODING_ASCII_US ).getStr(),
                               BOOST_CURRENT_FUNCTION,
                               ::rtl::OUStringToOString( a.getValueTypeRef()->pTypeName,
                                                         RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                return bRet;
            }
            catch (com::sun::star::uno::RuntimeException &) 
            {
                throw;
            }
            catch (com::sun::star::uno::Exception &) 
            {
                return false;
            }
        }

        template <typename ValueType>
        inline bool getPropertyValue(
            com::sun::star::uno::Reference< ValueType >& rIfc, 
            com::sun::star::uno::Reference<
            com::sun::star::beans::XPropertySet> const & xPropSet, 
            rtl::OUString const & propName )
        {
            try 
            {
                const com::sun::star::uno::Any& a( 
                    xPropSet->getPropertyValue( propName ));
                rIfc.set( a,
                          com::sun::star::uno::UNO_QUERY );
                
                bool const bRet = rIfc.is();
#if OSL_DEBUG_LEVEL > 0
                if( !bRet )
                    OSL_TRACE( "%s: while retrieving property %s, cannot extract Any of type %s to interface\n",
                               ::rtl::OUStringToOString( propName,
                                                         RTL_TEXTENCODING_ASCII_US ).getStr(),
                               BOOST_CURRENT_FUNCTION,
                               ::rtl::OUStringToOString( a.getValueTypeRef()->pTypeName,
                                                         RTL_TEXTENCODING_ASCII_US ).getStr() );
#endif
                return bRet;
            }
            catch (com::sun::star::uno::RuntimeException &) 
            {
                throw;
            }
            catch (com::sun::star::uno::Exception &) 
            {
                return false;
            }
        }

        /// Get the content of the BoundRect shape property
        ::basegfx::B2DRectangle getAPIShapeBounds( const ::com::sun::star::uno::Reference< 
                                                         ::com::sun::star::drawing::XShape >& xShape );

        /// Get the content of the ZOrder shape property
        double getAPIShapePrio( const ::com::sun::star::uno::Reference< 
                                      ::com::sun::star::drawing::XShape >& xShape );
    }
}

#endif /* _SLIDESHOW_TOOLS_HXX */
