/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlgpage.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/12 17:04:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#ifdef SD_DLLIMPLEMENTATION
#undef SD_DLLIMPLEMENTATION
#endif

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST	SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST		SID_HATCH_LIST
#define ITEMID_BITMAP_LIST		SID_BITMAP_LIST
#include <svtools/intitem.hxx>
#ifndef _SVX_DIALOGS_HRC
#include <svx/dialogs.hrc>
#endif
#ifndef _SVX_TAB_AREA_HXX
#include <svx/tabarea.hxx>
#endif
#ifndef _SVX_DRAWITEM_HXX
#include <svx/drawitem.hxx>
#endif

#ifndef _SD_SDRESID_HXX
#include "sdresid.hxx"
#endif
#include "dlgpage.hxx"

#include "DrawDocShell.hxx"

#ifndef _AEITEM_HXX
#include <svtools/aeitem.hxx>
#endif
#include <svx/flagsdef.hxx>
#include <svx/svxenum.hxx>

/*************************************************************************
|*
|* Konstruktor des Tab-Dialogs: Fuegt die Seiten zum Dialog hinzu
|*
\************************************************************************/

SdPageDlg::SdPageDlg( SfxObjectShell* pDocSh, Window* pParent, const SfxItemSet* pAttr, BOOL bAreaPage ) :
		SfxTabDialog ( pParent, SdResId( TAB_PAGE ), pAttr ),
		mrOutAttrs			( *pAttr ),
		mpDocShell			( pDocSh )
{
	SvxColorTableItem aColorTableItem(*( (const SvxColorTableItem*)
		( mpDocShell->GetItem( SID_COLOR_TABLE ) ) ) );
	SvxGradientListItem aGradientListItem(*( (const SvxGradientListItem*)
		( mpDocShell->GetItem( SID_GRADIENT_LIST ) ) ) );
	SvxBitmapListItem aBitmapListItem(*( (const SvxBitmapListItem*)
		( mpDocShell->GetItem( SID_BITMAP_LIST ) ) ) );
	SvxHatchListItem aHatchListItem(*( (const SvxHatchListItem*)
		( mpDocShell->GetItem( SID_HATCH_LIST ) ) ) );

	mpColorTab = aColorTableItem.GetColorTable();
	mpGradientList = aGradientListItem.GetGradientList();
	mpHatchingList = aHatchListItem.GetHatchList();
	mpBitmapList = aBitmapListItem.GetBitmapList();

	FreeResource();

	AddTabPage( RID_SVXPAGE_PAGE);
	AddTabPage( RID_SVXPAGE_AREA);

	if(!bAreaPage)  // I have to add the page before I remove it !
		RemoveTabPage( RID_SVXPAGE_AREA );
}


/*************************************************************************
|*
|* Seite wird erzeugt
|*
\************************************************************************/

void SdPageDlg::PageCreated(USHORT nId, SfxTabPage& rPage)
{
	SfxAllItemSet aSet(*(GetInputSetImpl()->GetPool()));
	switch(nId)
	{
	case RID_SVXPAGE_PAGE:
		aSet.Put (SfxAllEnumItem((const USHORT)SID_ENUM_PAGE_MODE, SVX_PAGE_MODE_PRESENTATION));
		aSet.Put (SfxAllEnumItem((const USHORT)SID_PAPER_START, SVX_PAPER_A0));
		aSet.Put (SfxAllEnumItem((const USHORT)SID_PAPER_END, SVX_PAPER_E));
		rPage.PageCreated(aSet);
		break;
	case RID_SVXPAGE_AREA:
			aSet.Put (SvxColorTableItem(mpColorTab,SID_COLOR_TABLE));
			aSet.Put (SvxGradientListItem(mpGradientList,SID_GRADIENT_LIST));
			aSet.Put (SvxHatchListItem(mpHatchingList,SID_HATCH_LIST));
			aSet.Put (SvxBitmapListItem(mpBitmapList,SID_BITMAP_LIST));
			aSet.Put (SfxUInt16Item(SID_PAGE_TYPE,0));
			aSet.Put (SfxUInt16Item(SID_DLG_TYPE,1));
			aSet.Put (SfxUInt16Item(SID_TABPAGE_POS,0));
			rPage.PageCreated(aSet);
		break;
	}
}



