/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuline.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:13:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"



#ifndef _SVX_TAB_LINE_HXX //autogen
#include <svx/tabline.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif

#include <svx/svxids.hrc>

#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "fuline.hxx"
#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuLine::SchFuLine(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	BOOL bHasMarked = pView->AreObjectsMarked();

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxBindings& rBind = pViewSh->GetViewFrame()->GetBindings();

	if (!pArgs)
	{
		SfxItemSet aNewAttr(pView->GetDefaultAttr());

		if (bHasMarked)	pView->MergeAttrFromMarked(aNewAttr);

		//CHINA001 SvxLineTabDialog* pDlg = new SvxLineTabDialog(&(pViewSh->GetViewFrame()->GetWindow()),
//CHINA001 													  &aNewAttr, pDoc);
		SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
		DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
		SfxAbstractTabDialog * pDlg = pFact->CreateSvxLineTabDialog( &(pViewSh->GetViewFrame()->GetWindow()),
					&aNewAttr, 
				pDoc,
				ResId(RID_SVXDLG_LINE)
				);
		DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*(pDlg->GetOutputItemSet()));
			pArgs = rReq.GetArgs();
		}
		else
		{
			delete pDlg;

			// Attribute wurden geaendert, Listboxes in Objectbars muessen aktualisiert werden
			rBind.Invalidate(SID_ATTR_LINE_STYLE);
			rBind.Invalidate(SID_ATTR_LINE_DASH);
			rBind.Invalidate(SID_ATTR_LINE_WIDTH);
			rBind.Invalidate(SID_ATTR_LINE_COLOR);
			return; // Abbruch
		}
		delete pDlg;
	}
	if (bHasMarked)	pView->SetAttrToMarked(*pArgs);
	else pView->SetDefaultAttr(*pArgs);

	// Attribute wurden geaendert, Listboxes in Objectbars muessen aktualisiert werden
	rBind.Invalidate(SID_ATTR_LINE_STYLE);
	rBind.Invalidate(SID_ATTR_LINE_DASH);
	rBind.Invalidate(SID_ATTR_LINE_WIDTH);
	rBind.Invalidate(SID_ATTR_LINE_COLOR);
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuLine::~SchFuLine()
{
}



