/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: datapoin.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:56:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include <svx/svditer.hxx>

#include "datapoin.hxx"
#include "glob.hxx"



/*************************************************************************
|*
|* Datenpunkt ermitteln
|*
\************************************************************************/

SchDataPoint* GetDataPoint(const SdrObject& rObj)
{//#63904 2x Schleife (15%), 50% pData, 18% id
	USHORT i=rObj.GetUserDataCount();
	while(i--)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);
		if (pData && pData->GetId() == SCH_DATAPOINT_ID)
			return (SchDataPoint*)pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Objekt mit Datenpunkt-Indizes suchen;
|* liefert NULL, wenn kein Objekt gefunden wurde.
|*
\************************************************************************/

SdrObject* GetObjWithColRow(short nCol, short nRow,
						 const SdrObjList& rObjList, ULONG* pIndex)
{
	ULONG nIndex = 0;

	SdrObjListIter aIterator(rObjList, IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchDataPoint* pDataPoint = GetDataPoint(*pObj);
		if (pDataPoint && pDataPoint->GetCol() == nCol &&
						  pDataPoint->GetRow() == nRow)
		{
			if (pIndex)
				*pIndex = nIndex;
			return pObj;
		}

		nIndex++;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDataPoint::SchDataPoint() :
	SdrObjUserData(SchInventor, SCH_DATAPOINT_ID, 0),
	nCol(0),
	nRow(0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDataPoint::SchDataPoint(short nC, short nR) :
	SdrObjUserData(SchInventor, SCH_DATAPOINT_ID, 0),
	nCol(nC),
	nRow(nR)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchDataPoint::SchDataPoint(const SchDataPoint& rDataPoint) :
	SdrObjUserData(rDataPoint),
	nCol(rDataPoint.nCol),
	nRow(rDataPoint.nRow)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchDataPoint::Clone(SdrObject *pObj) const
{
	return new SchDataPoint(*this);
}

// eof
