/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.FileSystem;
import sun.management.jmxremote.SingleEntryRegistry;
import sun.management.snmp.util.MibLogger;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;

public final class ConnectorBootstrap {
    private static final MibLogger log = new MibLogger(ConnectorBootstrap.class);

    public static synchronized JMXConnectorServer initialize() {
        Properties properties = Agent.loadManagementProperties();
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("com.sun.management.jmxremote.port");
        return ConnectorBootstrap.initialize(string, properties);
    }

    public static synchronized JMXConnectorServer initialize(String string, Properties properties) {
        int n;
        Object object;
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", numberFormatException, string);
        }
        if (n2 < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", string);
        }
        String string2 = properties.getProperty("com.sun.management.jmxremote.authenticate", "true");
        boolean bl = Boolean.valueOf(string2);
        String string3 = properties.getProperty("com.sun.management.jmxremote.ssl", "true");
        boolean bl2 = Boolean.valueOf(string3);
        String string4 = properties.getProperty("com.sun.management.jmxremote.registry.ssl", "false");
        boolean bl3 = Boolean.valueOf(string4);
        String string5 = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
        String[] stringArray = null;
        if (string5 != null) {
            object = new StringTokenizer(string5, ",");
            int n3 = ((StringTokenizer)object).countTokens();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = ((StringTokenizer)object).nextToken();
            }
        }
        object = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        String[] stringArray2 = null;
        if (object != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            n = stringTokenizer.countTokens();
            stringArray2 = new String[n];
            for (int i = 0; i < n; i += 1) {
                stringArray2[i] = stringTokenizer.nextToken();
            }
        }
        String string6 = properties.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "false");
        n = Boolean.valueOf(string6).booleanValue() ? 1 : 0;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (bl) {
            string7 = properties.getProperty("com.sun.management.jmxremote.login.config");
            if (string7 == null) {
                string8 = properties.getProperty("com.sun.management.jmxremote.password.file", ConnectorBootstrap.getDefaultFileName("jmxremote.password"));
                ConnectorBootstrap.checkPasswordFile(string8);
            }
            string9 = properties.getProperty("com.sun.management.jmxremote.access.file", ConnectorBootstrap.getDefaultFileName("jmxremote.access"));
            ConnectorBootstrap.checkAccessFile(string9);
        }
        if (log.isDebugOn()) {
            log.debug("initialize", Agent.getText("jmxremote.ConnectorBootstrap.initialize") + "\n\t" + "com.sun.management.jmxremote.port" + "=" + n2 + "\n\t" + "com.sun.management.jmxremote.ssl" + "=" + bl2 + "\n\t" + "com.sun.management.jmxremote.registry.ssl" + "=" + bl3 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.cipher.suites" + "=" + string5 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.protocols" + "=" + (String)object + "\n\t" + "com.sun.management.jmxremote.ssl.need.client.auth" + "=" + (n != 0) + "\n\t" + "com.sun.management.jmxremote.authenticate" + "=" + bl + (bl ? (string7 == null ? "\n\tcom.sun.management.jmxremote.password.file=" + string8 : "\n\tcom.sun.management.jmxremote.login.config=" + string7) : "\n\t" + Agent.getText("jmxremote.ConnectorBootstrap.initialize.noAuthentication")) + (bl ? "\n\tcom.sun.management.jmxremote.access.file=" + string9 : "") + "");
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        JMXConnectorServer jMXConnectorServer = null;
        try {
            jMXConnectorServer = ConnectorBootstrap.exportMBeanServer(mBeanServer, n2, bl2, bl3, stringArray, stringArray2, n != 0, bl, string7, string8, string9);
            JMXServiceURL jMXServiceURL = jMXConnectorServer.getAddress();
            log.config("initialize", Agent.getText("jmxremote.ConnectorBootstrap.initialize.ready", new JMXServiceURL(jMXServiceURL.getProtocol(), jMXServiceURL.getHost(), jMXServiceURL.getPort(), "/jndi/rmi://" + jMXServiceURL.getHost() + ":" + n2 + "/" + "jmxrmi").toString()));
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", exception, exception.toString());
        }
        return jMXConnectorServer;
    }

    public static JMXConnectorServer startLocalConnectorServer() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        HashMap<String, PermanentExporter> hashMap = new HashMap<String, PermanentExporter>();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", new PermanentExporter());
        String string = "localhost";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress == null || !inetAddress.isLoopbackAddress()) {
            string = "127.0.0.1";
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", string, 0);
            JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            jMXConnectorServer.start();
            return jMXConnectorServer;
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", exception, exception.toString());
        }
    }

    private static void checkPasswordFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.password.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.password.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.password.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                String string2 = Agent.getText("jmxremote.ConnectorBootstrap.initialize.password.readonly", string);
                log.config("initialize", string2);
                throw new AgentConfigurationError("agent.err.password.file.access.notrestricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.password.file.read.failed", iOException, string);
        }
    }

    private static void checkAccessFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.access.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.access.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.access.file.not.readable", string);
        }
    }

    private static String getDefaultFileName(String string) {
        String string2 = File.separator;
        return System.getProperty("java.home") + string2 + "lib" + string2 + "management" + string2 + string;
    }

    private static JMXConnectorServer exportMBeanServer(MBeanServer mBeanServer, int n, boolean bl, boolean bl2, String[] stringArray, String[] stringArray2, boolean bl3, boolean bl4, String string, String string2, String string3) throws IOException, MalformedURLException {
        System.setProperty("java.rmi.server.randomIDs", "true");
        JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", null, 0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PermanentExporter permanentExporter = new PermanentExporter();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", permanentExporter);
        if (bl4) {
            if (string != null) {
                hashMap.put("jmx.remote.x.login.config", string);
            }
            if (string2 != null) {
                hashMap.put("jmx.remote.x.password.file", string2);
            }
            hashMap.put("jmx.remote.x.access.file", string3);
            if (hashMap.get("jmx.remote.x.password.file") != null || hashMap.get("jmx.remote.x.login.config") != null) {
                hashMap.put("jmx.remote.authenticator", new AccessFileCheckerAuthenticator(hashMap));
            }
        }
        SslRMIClientSocketFactory sslRMIClientSocketFactory = null;
        SslRMIServerSocketFactory sslRMIServerSocketFactory = null;
        if (bl || bl2) {
            sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
            sslRMIServerSocketFactory = new SslRMIServerSocketFactory(stringArray, stringArray2, bl3);
        }
        if (bl) {
            hashMap.put("jmx.remote.rmi.client.socket.factory", sslRMIClientSocketFactory);
            hashMap.put("jmx.remote.rmi.server.socket.factory", sslRMIServerSocketFactory);
        }
        JMXConnectorServer jMXConnectorServer = null;
        try {
            jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            jMXConnectorServer.start();
        }
        catch (IOException iOException) {
            if (jMXConnectorServer == null) {
                throw new AgentConfigurationError("agent.err.connector.server.io.error", iOException, jMXServiceURL.toString());
            }
            throw new AgentConfigurationError("agent.err.connector.server.io.error", iOException, jMXConnectorServer.getAddress().toString());
        }
        if (bl2) {
            SingleEntryRegistry singleEntryRegistry = new SingleEntryRegistry(n, sslRMIClientSocketFactory, sslRMIServerSocketFactory, "jmxrmi", permanentExporter.firstExported);
        } else {
            SingleEntryRegistry singleEntryRegistry = new SingleEntryRegistry(n, "jmxrmi", permanentExporter.firstExported);
        }
        return jMXConnectorServer;
    }

    private ConnectorBootstrap() {
    }

    private static class AccessFileCheckerAuthenticator
    implements JMXAuthenticator {
        private final Map environment;
        private final Properties properties;
        private final String accessFile;

        public AccessFileCheckerAuthenticator(Map map) throws IOException {
            this.environment = map;
            this.accessFile = (String)map.get("jmx.remote.x.access.file");
            this.properties = AccessFileCheckerAuthenticator.propertiesFromFile(this.accessFile);
        }

        public Subject authenticate(Object object) {
            JMXPluggableAuthenticator jMXPluggableAuthenticator = new JMXPluggableAuthenticator(this.environment);
            Subject subject = jMXPluggableAuthenticator.authenticate(object);
            this.checkAccessFileEntries(subject);
            return subject;
        }

        private void checkAccessFileEntries(Subject subject) {
            if (subject == null) {
                throw new SecurityException("Access denied! No matching entries found in the access file [" + this.accessFile + "] as the " + "authenticated Subject is null");
            }
            Set<Principal> set = subject.getPrincipals();
            for (Principal object : set) {
                if (!this.properties.containsKey(object.getName())) continue;
                return;
            }
            HashSet hashSet = new HashSet();
            for (Principal principal : set) {
                hashSet.add(principal.getName());
            }
            throw new SecurityException("Access denied! No entries found in the access file [" + this.accessFile + "] for any of the authenticated identities " + hashSet);
        }

        private static Properties propertiesFromFile(String string) throws IOException {
            Properties properties = new Properties();
            if (string == null) {
                return properties;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
    }

    public static interface DefaultValues {
        public static final String PORT = "0";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String USE_SSL = "true";
        public static final String USE_REGISTRY_SSL = "false";
        public static final String USE_AUTHENTICATION = "true";
        public static final String PASSWORD_FILE_NAME = "jmxremote.password";
        public static final String ACCESS_FILE_NAME = "jmxremote.access";
        public static final String SSL_NEED_CLIENT_AUTH = "false";
    }

    private static class PermanentExporter
    implements RMIExporter {
        Remote firstExported;

        private PermanentExporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Remote exportObject(Remote remote, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            Object object = this;
            synchronized (object) {
                if (this.firstExported == null) {
                    this.firstExported = remote;
                }
            }
            object = rMIClientSocketFactory == null && rMIServerSocketFactory == null ? new UnicastServerRef(n) : new UnicastServerRef2(n, rMIClientSocketFactory, rMIServerSocketFactory);
            return ((UnicastServerRef)object).exportObject(remote, null, true);
        }

        public boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
            return UnicastRemoteObject.unexportObject(remote, bl);
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.jmxremote.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String USE_SSL = "com.sun.management.jmxremote.ssl";
        public static final String USE_REGISTRY_SSL = "com.sun.management.jmxremote.registry.ssl";
        public static final String USE_AUTHENTICATION = "com.sun.management.jmxremote.authenticate";
        public static final String PASSWORD_FILE_NAME = "com.sun.management.jmxremote.password.file";
        public static final String ACCESS_FILE_NAME = "com.sun.management.jmxremote.access.file";
        public static final String LOGIN_CONFIG_NAME = "com.sun.management.jmxremote.login.config";
        public static final String SSL_ENABLED_CIPHER_SUITES = "com.sun.management.jmxremote.ssl.enabled.cipher.suites";
        public static final String SSL_ENABLED_PROTOCOLS = "com.sun.management.jmxremote.ssl.enabled.protocols";
        public static final String SSL_NEED_CLIENT_AUTH = "com.sun.management.jmxremote.ssl.need.client.auth";
    }
}

