*** orig/jri_md.h	Wed Aug 30 11:20:44 2000
--- modified/jri_md.h	Wed Aug 30 11:20:44 2000
***************
*** 1,244 ****
! /* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
!  *
!  * The contents of this file are subject to the Netscape Public
!  * License Version 1.1 (the "License"); you may not use this file
!  * except in compliance with the License. You may obtain a copy of
!  * the License at http://www.mozilla.org/NPL/
!  *
!  * Software distributed under the License is distributed on an "AS
!  * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
!  * implied. See the License for the specific language governing
!  * rights and limitations under the License.
!  *
!  * The Original Code is mozilla.org code.
!  *
!  * The Initial Developer of the Original Code is Netscape
!  * Communications Corporation.  Portions created by Netscape are
!  * Copyright (C) 1998 Netscape Communications Corporation. All
!  * Rights Reserved.
!  *
!  * Contributor(s): 
!  */
! 
  /*******************************************************************************
   * Java Runtime Interface - Machine Dependent Types
   ******************************************************************************/
   
  #ifndef JRI_MD_H
  #define JRI_MD_H
  
  #include <assert.h>
  
  #ifdef __cplusplus
  extern "C" {
  #endif
  
  /*******************************************************************************
   * WHAT'S UP WITH THIS FILE?
   * 
   * This is where we define the mystical JRI_PUBLIC_API macro that works on all
   * platforms. If you're running with Visual C++, Symantec C, or Borland's 
   * development environment on the PC, you're all set. Or if you're on the Mac
   * with Metrowerks, Symantec or MPW with SC you're ok too. For UNIX it shouldn't
   * matter.
   *
   * On UNIX though you probably care about a couple of other symbols though:
   *	IS_LITTLE_ENDIAN must be defined for little-endian systems
   *	HAVE_LONG_LONG must be defined on systems that have 'long long' integers
   *	HAVE_ALIGNED_LONGLONGS must be defined if long-longs must be 8 byte aligned
   *	HAVE_ALIGNED_DOUBLES must be defined if doubles must be 8 byte aligned
   *	IS_64 must be defined on 64-bit machines (like Dec Alpha)
   ******************************************************************************/
  
  /* DLL Entry modifiers... */
  
  /* PC */
! #if defined(XP_OS2)
! #  ifdef XP_OS2_VACPP
! #	  define JRI_PUBLIC_API(ResultType)	    ResultType _Optlink
! #	  define JRI_PUBLIC_VAR(VarType)        VarType
! #     define JRI_CALLBACK
! #  else
! #	  define JRI_PUBLIC_API(ResultType)	    ResultType
! #	  define JRI_PUBLIC_VAR(VarType)        VarType
! #     define JRI_CALLBACK
! #  endif
! #elif defined(XP_PC) || defined(_WINDOWS) || defined(WIN32) || defined(_WIN32)
  #	include <windows.h>
  #	if defined(_MSC_VER)
  #		if defined(WIN32) || defined(_WIN32)
  #			define JRI_PUBLIC_API(ResultType)	_declspec(dllexport) ResultType
- #			define JRI_PUBLIC_VAR(VarType)		VarType
- #			define JRI_PUBLIC_VAR_EXP(VarType)	_declspec(dllexport) VarType
- #			define JRI_PUBLIC_VAR_IMP(VarType)	_declspec(dllimport) VarType
- #			define JRI_NATIVE_STUB(ResultType)	_declspec(dllexport) ResultType
  #			define JRI_CALLBACK
  #		else /* !_WIN32 */
  #		    if defined(_WINDLL)
  #			define JRI_PUBLIC_API(ResultType)	ResultType __cdecl __export __loadds 
- #			define JRI_PUBLIC_VAR(VarType)		VarType
- #			define JRI_PUBLIC_VAR_EXP(VarType)	JRI_PUBLIC_VAR(VarType)
- #			define JRI_PUBLIC_VAR_IMP(VarType)	JRI_PUBLIC_VAR(VarType)
- #			define JRI_NATIVE_STUB(ResultType)	ResultType __cdecl __loadds
  #			define JRI_CALLBACK			__loadds
! #		else /* !WINDLL */
  #			define JRI_PUBLIC_API(ResultType)	ResultType __cdecl __export
- #			define JRI_PUBLIC_VAR(VarType)		VarType
- #			define JRI_PUBLIC_VAR_EXP(VarType)	JRI_PUBLIC_VAR(VarType)
- #			define JRI_PUBLIC_VAR_IMP(VarType)	JRI_PUBLIC_VAR(VarType)
- #			define JRI_NATIVE_STUB(ResultType)	ResultType __cdecl __export
  #			define JRI_CALLBACK			__export
  #                   endif /* !WINDLL */
  #		endif /* !_WIN32 */
  #	elif defined(__BORLANDC__)
  #		if defined(WIN32) || defined(_WIN32)
  #			define JRI_PUBLIC_API(ResultType)	__export ResultType
- #			define JRI_PUBLIC_VAR(VarType)		VarType
- #			define JRI_PUBLIC_VAR_EXP(VarType)	__export VarType
- #			define JRI_PUBLIC_VAR_IMP(VarType)	__import VarType
- #			define JRI_NATIVE_STUB(ResultType)	 __export ResultType
  #			define JRI_CALLBACK
  #		else /* !_WIN32 */
  #			define JRI_PUBLIC_API(ResultType)	ResultType _cdecl _export _loadds 
! #			define JRI_PUBLIC_VAR(VarType)		VarType
! #			define JRI_PUBLIC_VAR_EXP(VarType)	__cdecl __export VarType
! #			define JRI_PUBLIC_VAR_IMP(VarType)	__cdecl __import VarType
! #			define JRI_NATIVE_STUB(ResultType)	ResultType _cdecl _loadds
! #			define JRI_CALLBACK			_loadds
  #		endif
  #	else
  #		error Unsupported PC development environment.	
  #	endif
  #	ifndef IS_LITTLE_ENDIAN
  #		define IS_LITTLE_ENDIAN
  #	endif
  
  /* Mac */
! #elif defined (macintosh) || Macintosh || THINK_C
  #	if defined(__MWERKS__)				/* Metrowerks */
  #		if !__option(enumsalwaysint)
  #			error You need to define 'Enums Always Int' for your project.
  #		endif
  #		if defined(GENERATING68K) && !GENERATINGCFM 
  #			if !__option(fourbyteints) 
  #				error You need to define 'Struct Alignment: 68k' for your project.
  #			endif
  #		endif /* !GENERATINGCFM */
- #		define JRI_PUBLIC_API(ResultType)	__declspec(export) ResultType
- #		define JRI_PUBLIC_VAR(VarType)		JRI_PUBLIC_API(VarType)
- #		define JRI_PUBLIC_VAR_EXP(VarType)	JRI_PUBLIC_API(VarType)
- #		define JRI_PUBLIC_VAR_IMP(VarType)	JRI_PUBLIC_API(VarType)
- #		define JRI_NATIVE_STUB(ResultType)	JRI_PUBLIC_API(ResultType)
  #	elif defined(__SC__)				/* Symantec */
  #		error What are the Symantec defines? (warren@netscape.com)
  #	elif macintosh && applec			/* MPW */
  #		error Please upgrade to the latest MPW compiler (SC).
  #	else
  #		error Unsupported Mac development environment.
  #	endif
  #	define JRI_CALLBACK
  
  /* Unix or else */
  #else
  #	define JRI_PUBLIC_API(ResultType)		ResultType
- #   define JRI_PUBLIC_VAR(VarType)          VarType
- #   define JRI_PUBLIC_VAR_EXP(VarType)		JRI_PUBLIC_VAR(VarType)
- #   define JRI_PUBLIC_VAR_IMP(VarType)		JRI_PUBLIC_VAR(VarType)
- #   define JRI_NATIVE_STUB(ResultType)		ResultType
  #	define JRI_CALLBACK
  #endif
  
  #ifndef FAR		/* for non-Win16 */
  #define FAR
  #endif
  
  /******************************************************************************/
  
  /* Java Scalar Types */
  
- #if 0	/* now in jni.h */
- typedef short			jchar;
- typedef short			jshort;
- typedef float			jfloat;
- typedef double			jdouble;
- typedef juint			jsize;
- #endif
- 
- /* moved from jni.h -- Sun's new jni.h doesn't have this anymore */
- #ifdef __cplusplus
- typedef class _jobject *jref;
- #else
- typedef struct _jobject *jref;
- #endif
- 
  typedef unsigned char	jbool;
  typedef char			jbyte;
  #ifdef IS_64 /* XXX ok for alpha, but not right on all 64-bit architectures */
  typedef unsigned int	juint;
  typedef int				jint;
  #else
  typedef unsigned long	juint;
  typedef long			jint;
  #endif
  
  /*******************************************************************************
   * jlong : long long (64-bit signed integer type) support.
   ******************************************************************************/
  
  /*
  ** Bit masking macros.  (n must be <= 31 to be portable)
  */
  #define JRI_BIT(n)			((juint)1 << (n))
  #define JRI_BITMASK(n)		(JRI_BIT(n) - 1)
  
  #ifdef HAVE_LONG_LONG
  
! #ifdef OSF1
! 
! /* long is default 64-bit on OSF1, -std1 does not allow long long */
! typedef long                  jlong;
! typedef unsigned long         julong;
! #define jlong_MAXINT          0x7fffffffffffffffL
! #define jlong_MININT          0x8000000000000000L
! #define jlong_ZERO            0x0L
! 
! #elif (defined(WIN32) || defined(_WIN32))
! 
! typedef LONGLONG              jlong;
! typedef DWORDLONG             julong;
! #define jlong_MAXINT          0x7fffffffffffffffi64
! #define jlong_MININT          0x8000000000000000i64
! #define jlong_ZERO            0x0i64
  
  #else
  
! typedef long long             jlong;
! typedef unsigned long long    julong;
! #define jlong_MAXINT          0x7fffffffffffffffLL
! #define jlong_MININT          0x8000000000000000LL
! #define jlong_ZERO            0x0LL
  
  #endif
  
  #define jlong_IS_ZERO(a)	((a) == 0)
  #define jlong_EQ(a, b)		((a) == (b))
  #define jlong_NE(a, b)		((a) != (b))
  #define jlong_GE_ZERO(a)	((a) >= 0)
  #define jlong_CMP(a, op, b)	((a) op (b))
  
  #define jlong_AND(r, a, b)	((r) = (a) & (b))
  #define jlong_OR(r, a, b)	((r) = (a) | (b))
  #define jlong_XOR(r, a, b)	((r) = (a) ^ (b))
  #define jlong_OR2(r, a)		((r) = (r) | (a))
  #define jlong_NOT(r, a)		((r) = ~(a))
  
  #define jlong_NEG(r, a)		((r) = -(a))
  #define jlong_ADD(r, a, b)	((r) = (a) + (b))
  #define jlong_SUB(r, a, b)	((r) = (a) - (b))
  
  #define jlong_MUL(r, a, b)	((r) = (a) * (b))
  #define jlong_DIV(r, a, b)	((r) = (a) / (b))
  #define jlong_MOD(r, a, b)	((r) = (a) % (b))
  
  #define jlong_SHL(r, a, b)	((r) = (a) << (b))
  #define jlong_SHR(r, a, b)	((r) = (a) >> (b))
--- 1,168 ----
! /* -*- Mode: C; tab-width: 4; -*- */
  /*******************************************************************************
   * Java Runtime Interface - Machine Dependent Types
+  * Copyright (c) 1996 Netscape Communications Corporation. All rights reserved.
   ******************************************************************************/
   
  #ifndef JRI_MD_H
  #define JRI_MD_H
  
  #include <assert.h>
  
  #ifdef __cplusplus
  extern "C" {
  #endif
  
  /*******************************************************************************
   * WHAT'S UP WITH THIS FILE?
   * 
   * This is where we define the mystical JRI_PUBLIC_API macro that works on all
   * platforms. If you're running with Visual C++, Symantec C, or Borland's 
   * development environment on the PC, you're all set. Or if you're on the Mac
   * with Metrowerks, Symantec or MPW with SC you're ok too. For UNIX it shouldn't
   * matter.
   *
   * On UNIX though you probably care about a couple of other symbols though:
   *	IS_LITTLE_ENDIAN must be defined for little-endian systems
   *	HAVE_LONG_LONG must be defined on systems that have 'long long' integers
   *	HAVE_ALIGNED_LONGLONGS must be defined if long-longs must be 8 byte aligned
   *	HAVE_ALIGNED_DOUBLES must be defined if doubles must be 8 byte aligned
   *	IS_64 must be defined on 64-bit machines (like Dec Alpha)
   ******************************************************************************/
  
  /* DLL Entry modifiers... */
  
  /* PC */
! #if defined(XP_PC) || defined(_WINDOWS) || defined(WIN32) || defined(_WIN32)
  #	include <windows.h>
  #	if defined(_MSC_VER)
  #		if defined(WIN32) || defined(_WIN32)
  #			define JRI_PUBLIC_API(ResultType)	_declspec(dllexport) ResultType
  #			define JRI_CALLBACK
  #		else /* !_WIN32 */
  #		    if defined(_WINDLL)
  #			define JRI_PUBLIC_API(ResultType)	ResultType __cdecl __export __loadds 
  #			define JRI_CALLBACK			__loadds
! #		    else /* !WINDLL */
  #			define JRI_PUBLIC_API(ResultType)	ResultType __cdecl __export
  #			define JRI_CALLBACK			__export
  #                   endif /* !WINDLL */
  #		endif /* !_WIN32 */
  #	elif defined(__BORLANDC__)
  #		if defined(WIN32) || defined(_WIN32)
  #			define JRI_PUBLIC_API(ResultType)	__export ResultType
  #			define JRI_CALLBACK
  #		else /* !_WIN32 */
  #			define JRI_PUBLIC_API(ResultType)	ResultType _cdecl _export _loadds 
! #			define JRI_CALLBACK					_loadds
  #		endif
  #	else
  #		error Unsupported PC development environment.	
  #	endif
  #	ifndef IS_LITTLE_ENDIAN
  #		define IS_LITTLE_ENDIAN
  #	endif
  
  /* Mac */
! #elif macintosh || Macintosh || THINK_C
  #	if defined(__MWERKS__)				/* Metrowerks */
  #		if !__option(enumsalwaysint)
  #			error You need to define 'Enums Always Int' for your project.
  #		endif
  #		if defined(GENERATING68K) && !GENERATINGCFM 
  #			if !__option(fourbyteints) 
  #				error You need to define 'Struct Alignment: 68k' for your project.
  #			endif
  #		endif /* !GENERATINGCFM */
  #	elif defined(__SC__)				/* Symantec */
  #		error What are the Symantec defines? (warren@netscape.com)
  #	elif macintosh && applec			/* MPW */
  #		error Please upgrade to the latest MPW compiler (SC).
  #	else
  #		error Unsupported Mac development environment.
  #	endif
+ #	define JRI_PUBLIC_API(ResultType)		ResultType
  #	define JRI_CALLBACK
  
  /* Unix or else */
  #else
  #	define JRI_PUBLIC_API(ResultType)		ResultType
  #	define JRI_CALLBACK
  #endif
  
  #ifndef FAR		/* for non-Win16 */
  #define FAR
  #endif
  
  /******************************************************************************/
  
  /* Java Scalar Types */
  
  typedef unsigned char	jbool;
  typedef char			jbyte;
+ typedef short			jchar;
+ typedef short			jshort;
  #ifdef IS_64 /* XXX ok for alpha, but not right on all 64-bit architectures */
  typedef unsigned int	juint;
  typedef int				jint;
  #else
  typedef unsigned long	juint;
  typedef long			jint;
  #endif
+ typedef float			jfloat;
+ typedef double			jdouble;
+ 
+ typedef juint			jsize;
  
  /*******************************************************************************
   * jlong : long long (64-bit signed integer type) support.
   ******************************************************************************/
  
  /*
  ** Bit masking macros.  (n must be <= 31 to be portable)
  */
  #define JRI_BIT(n)			((juint)1 << (n))
  #define JRI_BITMASK(n)		(JRI_BIT(n) - 1)
  
  #ifdef HAVE_LONG_LONG
  
! #if !(defined(WIN32) || defined(_WIN32))
! typedef long long			jlong;
! typedef unsigned long long	julong;
! 
! #define jlong_MAXINT		0x7fffffffffffffffLL
! #define jlong_MININT		0x8000000000000000LL
! #define jlong_ZERO			0x0LL
  
  #else
+ typedef LONGLONG			jlong;
+ typedef DWORDLONG			julong;
  
! #define jlong_MAXINT		0x7fffffffffffffffi64
! #define jlong_MININT		0x8000000000000000i64
! #define jlong_ZERO			0x0i64
  
  #endif
  
  #define jlong_IS_ZERO(a)	((a) == 0)
  #define jlong_EQ(a, b)		((a) == (b))
  #define jlong_NE(a, b)		((a) != (b))
  #define jlong_GE_ZERO(a)	((a) >= 0)
  #define jlong_CMP(a, op, b)	((a) op (b))
  
  #define jlong_AND(r, a, b)	((r) = (a) & (b))
  #define jlong_OR(r, a, b)	((r) = (a) | (b))
  #define jlong_XOR(r, a, b)	((r) = (a) ^ (b))
  #define jlong_OR2(r, a)		((r) = (r) | (a))
  #define jlong_NOT(r, a)		((r) = ~(a))
  
  #define jlong_NEG(r, a)		((r) = -(a))
  #define jlong_ADD(r, a, b)	((r) = (a) + (b))
  #define jlong_SUB(r, a, b)	((r) = (a) - (b))
  
  #define jlong_MUL(r, a, b)	((r) = (a) * (b))
  #define jlong_DIV(r, a, b)	((r) = (a) / (b))
  #define jlong_MOD(r, a, b)	((r) = (a) % (b))
  
  #define jlong_SHL(r, a, b)	((r) = (a) << (b))
  #define jlong_SHR(r, a, b)	((r) = (a) >> (b))
***************
*** 493,542 ****
--- 417,493 ----
      jlong _lo_d;                                                          \
                                                                            \
      _negative = ((d) < 0);                                                \
      _absval = _negative ? -(d) : (d);                                     \
                                                                            \
      (l).hi = (juint)(_absval / 4.294967296e9);                            \
      (l).lo = 0;                                                           \
      jlong_L2D(_d_hi, l);                                                  \
      _absval -= _d_hi;                                                     \
      _lo_d.hi = 0;                                                         \
      if (_absval < 0) {                                                    \
  	_lo_d.lo = (juint) -_absval;                                          \
  	jlong_SUB(l, l, _lo_d);                                               \
      } else {                                                              \
  	_lo_d.lo = (juint) _absval;                                           \
  	jlong_ADD(l, l, _lo_d);                                               \
      }                                                                     \
                                                                            \
      if (_negative)                                                        \
  	jlong_NEG(l, l);                                                      \
  }
  
  #endif /* !HAVE_LONG_LONG */
  
  /******************************************************************************/
+ /*
+ ** JDK Stuff -- This stuff is still needed while we're using the JDK
+ ** dynamic linking strategy to call native methods.
+ */
+ 
+ typedef union JRI_JDK_stack_item {
+     /* Non pointer items */
+     jint           i;
+     jfloat         f;
+     jint           o;
+     /* Pointer items */
+     void          *h;
+     void          *p;
+     unsigned char *addr;
+ #ifdef IS_64
+     double         d;
+     long           l;		/* == 64bits! */
+ #endif
+ } JRI_JDK_stack_item;
+ 
+ typedef union JRI_JDK_Java8Str {
+     jint x[2];
+     jdouble d;
+     jlong l;
+     void *p;
+     float f;
+ } JRI_JDK_Java8;
  
  #ifdef HAVE_ALIGNED_LONGLONGS
  #define JRI_GET_INT64(_t,_addr) ( ((_t).x[0] = ((jint*)(_addr))[0]), \
                                ((_t).x[1] = ((jint*)(_addr))[1]),      \
                                (_t).l )
  #define JRI_SET_INT64(_t, _addr, _v) ( (_t).l = (_v),                \
                                     ((jint*)(_addr))[0] = (_t).x[0], \
                                     ((jint*)(_addr))[1] = (_t).x[1] )
  #else
  #define JRI_GET_INT64(_t,_addr) (*(jlong*)(_addr))
  #define JRI_SET_INT64(_t, _addr, _v) (*(jlong*)(_addr) = (_v))
  #endif
  
  /* If double's must be aligned on doubleword boundaries then define this */
  #ifdef HAVE_ALIGNED_DOUBLES
  #define JRI_GET_DOUBLE(_t,_addr) ( ((_t).x[0] = ((jint*)(_addr))[0]), \
                                 ((_t).x[1] = ((jint*)(_addr))[1]),      \
                                 (_t).d )
  #define JRI_SET_DOUBLE(_t, _addr, _v) ( (_t).d = (_v),                \
                                      ((jint*)(_addr))[0] = (_t).x[0], \
                                      ((jint*)(_addr))[1] = (_t).x[1] )
  #else
  #define JRI_GET_DOUBLE(_t,_addr) (*(jdouble*)(_addr))
  #define JRI_SET_DOUBLE(_t, _addr, _v) (*(jdouble*)(_addr) = (_v))
  #endif
