/*************************************************************************
 *
 *  $RCSfile: indexdat.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "indexdat.h"

#include <string.h>
#include "new_del.h"
#include "sfldata.h"
#include "cr_html.h"


char C_sLineEnd[] = "\r\n";

char C_sFileBegin[] 	= "<HTML><HEAD></HEAD><BODY bgcolor=\"#ffffff\">\r\n";
char C_sFileEnd[]   	= "</BODY></HTML>\r\n";
char C_sTableBegin[] 	= "<TABLE WIDTH=100% BORDER=1 CELLPADDING=5 CELLSPACING=3><TBODY>\r\n";
char C_sTableEnd[]  	= "</TBODY></TABLE>\r\n";
char C_sService[]	    = "SupportedService";
char C_sModule[]	    = "ModuleName";
char C_sComponentname[]	= "ComponentName";



void				WriteTableFromHeap(
						TextFile *  		o_pOut,
						IndexHeap *			i_pHeap,
						char *              i_pIndexValue,
						char *				i_pIndexReference );

void
IndexData_CTOR( IndexData_THIS,
				ListCstring * i_pIndexedTags,
				char	*	  i_sOutputDirectory )
{
	int 		i = 0;
	LSIterator  aIter;
	IndexHeap *	pNew;

	IndexHeap_CTOR(MREF(aService2Module));
	IndexHeap_CTOR(MREF(aModule2Service));
	Cstring_CTOR(MREF(sOutputDirectory), i_sOutputDirectory);

	for ( i = 0; i < C_nNrOfSubTags; i++ )
	{
		THIS_->aTagHeaps[i] = 0;
	}

	for ( aIter = LS_Begin(i_pIndexedTags);
		  LSI_obool(&aIter);
		  LSI_opp(&aIter) )
	{
		for ( i = 0; i < C_nNrOfSubTags; i++ )
		{
			if (stricmp(C_sSubTags[i],Cs_Str(LSI_optr(&aIter))) == 0)
			{
				ASSIGN_NEW(pNew, IndexHeap);
				THIS_->aTagHeaps[i] = pNew;
				break;
			}
		}   /* end for (i) */
	}   /* end for (aIter) */
}

void
IndexData_DTOR( IndexData_THIS )
{
	int i = 0;
	for ( i = 0; i < C_nNrOfSubTags; i++ )
	{
		if (THIS_->aTagHeaps[i] != 0)
			DELETE(THIS_->aTagHeaps[i], IndexHeap);
	}
	Cstring_DTOR(MREF(sOutputDirectory));
	IndexHeap_DTOR(MREF(aModule2Service));
	IndexHeap_DTOR(MREF(aService2Module));
}

void
IDXD_GatherData( IndexData_THIS,
				 ListCstring * i_pInputFileList )
{
	LSIterator 		aFilesIter;

	for ( aFilesIter = LS_Begin(i_pInputFileList);
		  LSI_obool(&aFilesIter);
		  LSI_opp(&aFilesIter) )
	{
		IDXD_ReadFile( THIS_, Cs_Str(LSI_optr(&aFilesIter)) );
	}
}

void
IDXD_WriteOutput( IndexData_THIS,
				  char * i_sOuputFile )
{
	TextFile aOut;
	int i = 0;

	TextFile_CTOR(&aOut, i_sOuputFile);

	if (NOT TF_Create(&aOut) )
	{
		fprintf(stderr, "Error: Outputfile %s could not be created.", i_sOuputFile);
		return;
	}

	TF_WriteStr(&aOut, C_sFileBegin);

	TF_WriteStr(&aOut, "<H2>Components Index</H2>");
	TF_WriteStr(&aOut, C_sLineEnd );


	WriteTableFromHeap( &aOut, MREF(aService2Module), C_sService, C_sModule );
	WriteTableFromHeap( &aOut, MREF(aModule2Service), C_sModule, C_sService );

	for ( i = 0; i < C_nNrOfSubTags; i++ )
	{
		if ( THIS_->aTagHeaps[i] == 0 )
			continue;

		WriteTableFromHeap( &aOut, THIS_->aTagHeaps[i], C_sSubTags[i], C_sComponentname );
	}

	TF_WriteStr(&aOut, C_sFileEnd);

	TF_Close(&aOut);
	TextFile_DTOR(&aOut);
}

void
IDXD_ReadFile( IndexData_THIS,
			   char * i_sFilename )
{
	static char				sOutputHtml[1020];

	SrcFileData 			aFileData;
	Bool                    bParseResult = False;
	int 					i = 0;
	ListComponentDescription *
							pListDescriptions = 0;
	ListDataList * 			pDataLists = 0;
	LCDIterator				aDescrIter;
	LDLIterator             aTagIter;
	LTDIterator             aDataIter;
	IndexHeap *				pHeap;
	char *					pModuleName = 0;

	CreatorHtml 			aHtmlCreator;
	char *					pFileName = 0;


	/* Init local variables */
	SrcFileData_CTOR( &aFileData,
					  C_sTagDescription,
					  C_sSubTags,
					  C_nNrOfSubTags );

	/* Parse */
	bParseResult = SFD_Parse( &aFileData, i_sFilename );
	if (NOT bParseResult)
	{
		fprintf( stderr, "Error: File %s could not be parsed.", i_sFilename );
	}
	else
	{
		/* Create Html: */
		strcpy( sOutputHtml, Cs_Str(MREF(sOutputDirectory)) );
#ifdef WNT
		strcat(sOutputHtml, "\\");
		pFileName = strrchr(i_sFilename, '\\');
#elif defined(UNX)
		strcat(sOutputHtml, "/");
		pFileName = strrchr(i_sFilename, '/');
#endif
		if (pFileName == 0)
			pFileName = i_sFilename;
		else
			pFileName++;
		strcat(sOutputHtml, pFileName);
		pFileName = strrchr(sOutputHtml,'.');
		if (pFileName != 0)
			strcpy(pFileName+1,"html");
		else
			strcat(sOutputHtml,".html");
		CH_Create( &aHtmlCreator, sOutputHtml, &aFileData );

		/* GetResults: */
		pListDescriptions = SFD_Descriptions(&aFileData);
		for ( aDescrIter = LCD_Begin(pListDescriptions);
			  LCDI_obool(&aDescrIter);
			  LCDI_opp(&aDescrIter) )
		{   /*  loop descriptions */
			pModuleName = CD_Module(LCDI_optr(&aDescrIter));

			pDataLists = CD_ListOfDataLists(LCDI_optr(&aDescrIter));
			i = 0;
			for ( aTagIter = LDL_Begin(pDataLists);
				  LDLI_obool(&aTagIter);
				  LDLI_opp(&aTagIter), i++ )
			{   /*  loop tags */
				if (i == 4)   /* Services */
				{
					/* Fill Service-Module-Heaps*/
					for ( aDataIter = LTD_Begin(LDLI_optr(&aTagIter));
						  LTDI_obool(&aDataIter);
						  LTDI_opp(&aDataIter)     )
					{   /* Loop Services */
						IXH_InsertValueExplicit( MREF(aService2Module),
												 TD_Data(LTDI_optr(&aDataIter)),
												 pModuleName,
												 True );
						IXH_InsertValueExplicit( MREF(aModule2Service),
												 pModuleName,
												 TD_Data(LTDI_optr(&aDataIter)),
												 True );
					}	/* end for aDataIter */
				}	/* endif (i == 4) */

				if ( THIS_->aTagHeaps[i] == 0 )
					continue;

				pHeap = THIS_->aTagHeaps[i];

				for ( aDataIter = LTD_Begin(LDLI_optr(&aTagIter));
					  LTDI_obool(&aDataIter);
					  LTDI_opp(&aDataIter)     )
				{	/* loop data for one tag */
					IXH_InsertValue( pHeap,
									 LTDI_optr(&aDataIter),
									 LCDI_optr(&aDescrIter) );
				}	/* end for aDataIter */
			} 	/* end for (aTagIter) */
		}	/* end for (aDescrIter) */
	}	/* endif (NOT bParseResult) else */

	SrcFileData_DTOR( &aFileData );
}

void
IndexHeap_CTOR( IndexHeap_THIS )
{
	intt i = 0;

	THIS_->nActiveColumn = -1;
	for ( i = 0; i < C_nHEAP_WIDTH; i++)
	{
		THIS_->aValueListsArray[i] = 0;
	}  // end for
}

void
IndexHeap_DTOR( IndexHeap_THIS )
{
	IndexValue * pValue = 0;
	int i = 0;

	for ( i = 0; i < C_nHEAP_WIDTH; i++)
	{
		while (THIS_->aValueListsArray[i] != 0)
		{
			pValue = THIS_->aValueListsArray[i];
			THIS_->aValueListsArray[i] = IXV_Next(pValue);
            DELETE(pValue,IndexValue);
		}
	}  // end for
}

void
IXH_InsertValue( IndexHeap_THIS,
				 TagData *				i_pData,
				 ComponentDescription * i_pDescription )
{
	IndexValue * pSearch1 = 0;
	IndexValue * pSearch2 = 0;
	IndexValue * pNew = 0;


	THIS_->nActiveColumn++;
	if (THIS_->nActiveColumn >= C_nHEAP_WIDTH)
		THIS_->nActiveColumn = 0;

	ASSIGN_NEW3(pNew, IndexValue, TD_Data(i_pData), CD_Name(i_pDescription), True );

	pSearch1 = THIS_->aValueListsArray[THIS_->nActiveColumn];

	if ( pSearch1 != 0 ? IXV_oless( pNew, pSearch1 ) : True )
	{
		IXV_SetNext(pNew, pSearch1 );
		THIS_->aValueListsArray[THIS_->nActiveColumn] = pNew;
		return;
	}

	do
	{
		pSearch2 = pSearch1;
		pSearch1 = IXV_Next(pSearch1);

		if ( pSearch1 != 0 ? IXV_oless( pNew, pSearch1 ) : True )
		{
			IXV_SetNext(pNew, pSearch1);
			IXV_SetNext(pSearch2, pNew);
		}
	} while (IXV_Next(pSearch2) != pNew);
}

void
IXH_InsertValueExplicit( IndexHeap_THIS,
						 char *				i_pKeyData,
						 char *				i_pReferencedData,
						 Bool				i_bChangeNameDisplay )
{
	IndexValue * pSearch1 = 0;
	IndexValue * pSearch2 = 0;
	IndexValue * pNew = 0;


	THIS_->nActiveColumn++;
	if (THIS_->nActiveColumn >= C_nHEAP_WIDTH)
		THIS_->nActiveColumn = 0;

	ASSIGN_NEW3(pNew, IndexValue, i_pKeyData, i_pReferencedData, i_bChangeNameDisplay );

	pSearch1 = THIS_->aValueListsArray[THIS_->nActiveColumn];

	if ( pSearch1 != 0 ? IXV_oless( pNew, pSearch1 ) : True )
	{
		IXV_SetNext(pNew, pSearch1 );
		THIS_->aValueListsArray[THIS_->nActiveColumn] = pNew;
		return;
	}

	do
	{
		pSearch2 = pSearch1;
		pSearch1 = IXV_Next(pSearch1);

		if ( pSearch1 != 0 ? IXV_oless( pNew, pSearch1 ) : True )
		{
			IXV_SetNext(pNew, pSearch1);
			IXV_SetNext(pSearch2, pNew);
		}
	} while (IXV_Next(pSearch2) != pNew);
}

void
IXH_WriteHeap( IndexHeap_THIS,
			   TextFile * o_pFile )
{
	IndexValue * pHeapTop = 0;
	intt		 nValueLength = 0;

	for ( pHeapTop = IXH_RemoveTop(THIS_);
		  pHeapTop != 0;
		  pHeapTop = IXH_RemoveTop(THIS_) )
	{
		TF_WriteStr(o_pFile, "<TR><TD width=33%>");
		TF_WriteStr(o_pFile, IXV_Value(pHeapTop));
		TF_WriteStr(o_pFile, "</TD><TD width=66%>");
		TF_WriteStr(o_pFile, IXV_ComponentName(pHeapTop) );
		TF_WriteStr(o_pFile, "</TD></TR>\r\n");
		DELETE(pHeapTop,IndexValue);
	}
}

IndexValue *
IXH_RemoveTop( IndexHeap_THIS )
{
	intt		 nRetColumn = 0;
	IndexValue * ret = THIS_->aValueListsArray[nRetColumn];
	intt		 i = 0;
	IndexValue * pSearch = 0;

	for ( i = 1; i < C_nHEAP_WIDTH; ++i )
	{
		pSearch = THIS_->aValueListsArray[i];
		if (pSearch != 0)
		{
			if (ret == 0)
			{
				ret = pSearch;
				nRetColumn = i;
			}
			else if ( IXV_oless(pSearch, ret) )
			{
				ret = pSearch;
				nRetColumn = i;
			}
		}
	}	// for

	if (ret != 0)
		THIS_->aValueListsArray[nRetColumn] = IXV_Next(ret);
	return ret;
}

void
IndexValue_CTOR( IndexValue_THIS,
				 char *				i_sKeyValue,
				 char *				i_sReferencedValue,
				 Bool				i_bChangeNameDisplay )
{
	static 		char sNameInverter[500];
	char * 	    pPt = strrchr(i_sKeyValue,'.');
	unsigned    nLen = strlen(i_sKeyValue);
	unsigned    nDiff = 0;
	unsigned 	nRest = 0;


	if (pPt == 0 OR NOT i_bChangeNameDisplay)
	{
		Cstring_CTOR(MREF(sTagValue),i_sKeyValue);
	}
	else
	{
		nDiff = (pPt + 1) - i_sKeyValue;
		nRest = nLen - nDiff;

		strcpy( sNameInverter, pPt+1 );
		strncpy( sNameInverter + nRest + 2, i_sKeyValue, nDiff );
		sNameInverter[nRest] = ' ';
		sNameInverter[nRest+1] = '(';
		sNameInverter[nLen+2] = ')';
		sNameInverter[nLen+3] = '\0';
		Cstring_CTOR(MREF(sTagValue),sNameInverter);
	}

	pPt = strrchr(i_sReferencedValue,'.');
	if (pPt == 0)
	{
		Cstring_CTOR(MREF(sReferencedName), i_sReferencedValue);
	}
	else
	{
		nLen = strlen(i_sReferencedValue);
		nDiff = (pPt + 1) - i_sReferencedValue;
		nRest = nLen - nDiff;

		strcpy( sNameInverter, pPt+1 );
		strncpy( sNameInverter + nRest + 2, i_sReferencedValue, nDiff );
		sNameInverter[nRest] = ' ';
		sNameInverter[nRest+1] = '(';
		sNameInverter[nLen+2] = ')';
		sNameInverter[nLen+3] = '\0';
		Cstring_CTOR(MREF(sReferencedName),sNameInverter);
	}


	THIS_->pNextValue = 0;
}

void
IndexValue_DTOR( IndexValue_THIS )
{
	Cstring_DTOR(MREF(sReferencedName));
	Cstring_DTOR(MREF(sTagValue));
}

Bool
IXV_oless( IndexValue_THIS,
		   IndexValue *	i_pOther )
{
	return stricmp(Cs_Str(MREF(sTagValue)),IXV_Value(i_pOther)) < 0;
}

char *
IXV_Value( IndexValue_THIS )
{
	return Cs_Str(MREF(sTagValue));
}

char *
IXV_ComponentName( IndexValue_THIS )
{
	return Cs_Str(MREF(sComponentName));
}

IndexValue *
IXV_Next( IndexValue_THIS )
{
	return THIS_->pNextValue;
}

void
IXV_SetNext( IndexValue_THIS,
			 IndexValue * i_pNext )
{
	THIS_->pNextValue = i_pNext;
}


void
WriteTableFromHeap( TextFile *  o_pOut,
					IndexHeap *	i_pHeap,
					char *      i_pIndexValue,
					char *	  	i_pIndexReference )
{
	TF_WriteStr(o_pOut, "<H3><BR>");
	TF_WriteStr(o_pOut, i_pIndexValue );
	TF_WriteStr(o_pOut, " to ");
	TF_WriteStr(o_pOut, i_pIndexReference );
	TF_WriteStr(o_pOut, "</H3>\r\n");

	TF_WriteStr(o_pOut, C_sTableBegin);
	IXH_WriteHeap( i_pHeap, o_pOut );
	TF_WriteStr(o_pOut, C_sTableEnd);
}

