/*************************************************************************
 *
 *  $RCSfile: lst_str.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "lst_str.h"

#include "new_del.h"



/*** List ***/

void
ListCstring_CTOR( ListCstring_THIS,
				  Bool      i_bAutoDeleteData )
{
	THIS_->dpStart = 0;
	THIS_->pEnd = 0;
	THIS_->bAutoDeleteData = i_bAutoDeleteData;
}

void
ListCstring_DTOR( ListCstring_THIS )
{
	LS_Empty(THIS_,THIS_->bAutoDeleteData);
}

void
LS_Add( ListCstring_THIS,
		Cstring *	   i_pData )
{
	LSElem * dpNewElem = 0;
	ASSIGN_NEW1(dpNewElem,LSElem,i_pData);

	if ( pThis->dpStart != 0)
	{
		LSE_SetNext(pThis->pEnd,dpNewElem);
		pThis->pEnd = dpNewElem;
	}
	else
	{
		pThis->dpStart = dpNewElem;
		pThis->pEnd = pThis->dpStart;
	}
}

void
LS_Empty( ListCstring_THIS,
		  Bool	i_bDeleteData )
{
	LSElem * pIter = 0;
	LSElem * pDel =  0;

	if (pThis->dpStart == 0)
		return;

	pIter = LSE_Next(pThis->dpStart);
	pDel =  pThis->dpStart;
	if (i_bDeleteData)
	{
		LSE_DeleteData( pDel );
	}
	DELETE( pDel, LSElem );


	while( pIter != 0 )
	{
		pDel = pIter;
		pIter = LSE_Next(pIter);
		if (i_bDeleteData)
		{
			LSE_DeleteData( pDel );
		}
		DELETE( pDel, LSElem );
	}	/* end while; */

	pThis->dpStart = 0;
	pThis->pEnd = 0;
}

void
LS_Append( ListCstring_THIS,
		   char *  i_sStrings[],
		   intt    i_nNrOfStrings )
{
	Cstring * aAdd;
	int i = 0;

	for ( i = 0; i < i_nNrOfStrings; i++ )
	{
		ASSIGN_NEW1(aAdd,Cstring,i_sStrings[i]);
		LS_Add(THIS_,aAdd);
	}
}


LSIterator
LS_Begin( ListCstring_THIS )
{
	LSIterator ret;
	LSIterator_CTOR( REF(ret), THIS_->dpStart );
	return ret;
}

Bool
LS_IsEmpty( ListCstring_THIS )
{
	return THIS_->dpStart == 0;
}

/*** ListIterator ***/

void
LSIterator_CTOR( LSIterator_THIS,
				  LSElem *     i_pElement )
{
	pThis->pElement = i_pElement;
}

void
LSI_opp( LSIterator_THIS )
{
	if (pThis->pElement != 0)
		pThis->pElement = LSE_Next(pThis->pElement);
}


Bool
LSI_obool( LSIterator_THIS )
{
	return pThis->pElement != 0;
}

Cstring *
LSI_optr( LSIterator_THIS )
{
	return pThis->pElement != 0
			? LSE_Data(pThis->pElement)
			: 0;
}


/*** ListElement ***/

void
LSElem_CTOR( LSElem_THIS,
			  Cstring *	i_pData )
{
	pThis->pData = i_pData;
	pThis->pNext = 0;
}

void
LSElem_DTOR( LSElem_THIS )
{
}

Cstring *
LSE_Data( LSElem_THIS )
{
	return pThis->pData;
}

LSElem *
LSE_Next( LSElem_THIS )
{
	return pThis->pNext;
}

void
LSE_SetNext( LSElem_THIS,
			  LSElem *	i_pNext )
{
	pThis->pNext = i_pNext;
}

void
LSE_DeleteData( LSElem_THIS )
{
	DELETE(THIS_->pData,Cstring);
}

