/*************************************************************************
 *
 *  $RCSfile: ipxsock.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <iostream.h>
#include <string.h>
#include <vos/socket.hxx>
#include <vos/thrdsrv.hxx>
#include <vos/ref.hxx>
#include <vos/thread.hxx>
#include <vos/future.hxx>

NAMESPACE_VOS(OFutureRef<NAMESPACE_VOS(OIpxSocketAddr)>) IpxListenerAddr;

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class OIPXReceiver : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{

		cout << "creating IPX receiver-socket" << endl;
		NAMESPACE_VOS(OAcceptorSocket) Socket(ISocketTypes::af_ipx, 
											  ISocketTypes::protocol_spx);

		if(!Socket.isValid())
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "Creating IPX Receiver failed: " << err << endl;
			return False;
		}

		char net[]= {0x00, 0x00, 0x00, 0x00};
		char node[]= {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
		NAMESPACE_VOS(OIpxSocketAddr) Addr(net, node, 0x0500);

		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding receiver failed with error: " << err << endl;
			return False;
		}


		NAMESPACE_VOS(OIpxSocketAddr) LocalAddr;

		Socket.getLocalAddr(LocalAddr);

		char Buf[30];
		LocalAddr.getAddressString(Buf, sizeof(Buf));
		cout << "bound on address: " << Buf << endl;
		IpxListenerAddr= LocalAddr;
		IpxListenerAddr.dataValid();

		cout << endl << "listen" << endl << endl;

		if(!Socket.listen(1))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "listen failed with error: " << err << endl;
			return False;
		}


		NAMESPACE_VOS(OStreamSocket) Connection;
		
		if(Socket.acceptConnection(Connection) != ISocketTypes::result_ok)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "accept failed with error: " << err << endl;
			return False;
		}
		
		char Buffer[80];
		memset(Buffer, 0, sizeof(Buffer));
		if(Connection.recv(Buffer, 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "recv failed with error: " << err << endl;
			return False;
		}
		
		cout << Buffer << endl;

		cout << endl << "Receiver closes connection." << endl;

		if(!Connection.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		Connection.close();
		cout << "Connection closed" << endl;

		cout << "Receiver done" << endl;

		return False;
	}
};

class OIPXSender : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{
		NAMESPACE_VOS(OConnectorSocket) Socket(ISocketTypes::af_ipx,
											   ISocketTypes::protocol_spx);

		NAMESPACE_VOS(OIpxSocketAddr) Addr; 
		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding ipx-sender failed with error: " << err << endl;
			return False;
		}

		char Buf[80];
		IpxListenerAddr.getData().getAddressString(Buf, sizeof(Buf));

		cout << "connecting to " << Buf << endl;

		if(Socket.connect(IpxListenerAddr.getData()) != ISocketTypes::result_ok) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "connect failed with error: " << err << endl;
			return False;
		}

		if(Socket.send("Hallo", 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "send failed with error: " << err << endl;
			return False;
		}

		if(!Socket.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		return False;
	}
};



void __cdecl main() {

	// create sender/receiver-threads
	ORef<NAMESPACE_VOS(OThreadingServer)> server(new NAMESPACE_VOS(OThreadingServer));

	IpxListenerAddr.create();

	server->add(new OIPXReceiver);
	server->add(new OIPXSender);

	server->complete();

}
