/*************************************************************************
 *
 *  $RCSfile: reactor.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_REACTOR_HXX_
#define _VOS_REACTOR_HXX_

#ifndef __LIST__
#	include <list>
#endif

#ifndef _VOS_MUTEX_HXX_
#	include <vos/mutex.hxx>
#endif

#ifndef _VOS_REF_HXX_
#	include <vos/ref.hxx>
#endif

#ifndef _VOS_SOCKET_HXX_
#	include <vos/socket.hxx>
#endif

#ifndef _VOS_THREAD_HXX_
#	include <vos/thread.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#	include <vos/macros.hxx>
#endif

/*========================================================================
 *
 * OReactor interface.
 *
 *======================================================================*/

#ifdef _USE_NAMESPACE
namespace vos {
#endif

typedef NAMESPACE_VOS(ORef)<NAMESPACE_VOS(OSocket)> OSocketRef;

#define REACTOR_EVENT_READ  0x0001
#define REACTOR_EVENT_WRITE 0x0002
#define REACTOR_EVENT_OOB   0x0004

typedef void SAL_CALL OReactorCallback (
	OSocketRef xSocket, sal_uInt32 nEvent, void *pData);

struct OReactorCallbackContext {
	OSocketRef       m_xSocket;
	sal_uInt32             m_nEventMask;
	OReactorCallback *m_pfnCallback;
	void             *m_pData;
};

class OReactor : public NAMESPACE_VOS(OThread)
{
	VOS_DECLARE_CLASSINFO(NAMESPACE_VOS(OReactor));

private:
	// Not implemented.
	OReactor (const OReactor& rOther);
	OReactor& SAL_CALL operator= (const OReactor& rOther);

private:
	NAMESPACE_VOS(OMutex)                         		m_Lock;

	NAMESPACE_VOS(ORef)<NAMESPACE_VOS(ODatagramSocket)> m_xSocket;
	NAMESPACE_VOS(OInetSocketAddr)                      m_SocketAddr;

	NAMESPACE_STD(list<OReactorCallbackContext*>)       m_Incoming;
	NAMESPACE_STD(list<OReactorCallbackContext*>)       m_Outgoing;
	NAMESPACE_STD(list<OReactorCallbackContext*>)       m_OutOfBand;

	void SAL_CALL unblock(void);

	virtual void SAL_CALL terminate(void);
	virtual void SAL_CALL kill(void);
	virtual void SAL_CALL run(void);

public:
	OReactor(void);
	virtual ~OReactor(void);

	void SAL_CALL registerCallback(OSocketRef xSocket, sal_uInt32 nEventMask,
						  OReactorCallback *pfnCallback, void *pData);

	void SAL_CALL deregisterCallback(OSocketRef xSocket, sal_uInt32 nEventMask);
};

#ifdef _USE_NAMESPACE
}
#endif

#endif // _VOS_REACTOR_HXX_

