/*************************************************************************
 *
 *  $RCSfile: floatwin.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ssa $ $Date: 2001/10/31 19:28:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_FLOATWIN_HXX
#define _SV_FLOATWIN_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_SYSWIN_HXX
#include <syswin.hxx>
#endif

class ToolBox;
class PopupModeEvent;

// ------------------------
// - FloatingWindow-Types -
// ------------------------

#define FLOATWIN_POPUPMODE_ALLOWTEAROFF 		((ULONG)0x00000001)
#define FLOATWIN_POPUPMODE_ANIMATIONSLIDE		((ULONG)0x00000002)
#define FLOATWIN_POPUPMODE_NOAUTOARRANGE		((ULONG)0x00000004)
#define FLOATWIN_POPUPMODE_NOANIMATION			((ULONG)0x00000008)
#define FLOATWIN_POPUPMODE_DOWN 				((ULONG)0x00000010)
#define FLOATWIN_POPUPMODE_UP					((ULONG)0x00000020)
#define FLOATWIN_POPUPMODE_LEFT 				((ULONG)0x00000040)
#define FLOATWIN_POPUPMODE_RIGHT				((ULONG)0x00000080)
#define FLOATWIN_POPUPMODE_NOFOCUSCLOSE 		((ULONG)0x00000100)
#define FLOATWIN_POPUPMODE_NOKEYCLOSE			((ULONG)0x00000200)
#define FLOATWIN_POPUPMODE_NOMOUSECLOSE 		((ULONG)0x00000400)
#define FLOATWIN_POPUPMODE_NOMOUSERECTCLOSE 	((ULONG)0x00000800)
#define FLOATWIN_POPUPMODE_ALLMOUSEBUTTONCLOSE	((ULONG)0x00001000)
#define FLOATWIN_POPUPMODE_NOAPPFOCUSCLOSE		((ULONG)0x00002000)
#define FLOATWIN_POPUPMODE_PATHMOUSECANCELCLICK ((ULONG)0x00004000)
#define FLOATWIN_POPUPMODE_NEWLEVEL 			((ULONG)0x00008000)
#define FLOATWIN_POPUPMODE_NOMOUSEUPCLOSE		((ULONG)0x00010000)
#define FLOATWIN_POPUPMODE_GRABFOCUS        	((ULONG)0x00020000)

#define FLOATWIN_POPUPMODEEND_CANCEL			((USHORT)0x0001)
#define FLOATWIN_POPUPMODEEND_TEAROFF			((USHORT)0x0002)
#define FLOATWIN_POPUPMODEEND_DONTCALLHDL		((USHORT)0x0004)
#define FLOATWIN_POPUPMODEEND_CLOSEALL			((USHORT)0x0008)

#define FLOATWIN_TITLE_NORMAL					((USHORT)0x0001)
#define FLOATWIN_TITLE_TEAROFF					((USHORT)0x0002)
#define FLOATWIN_TITLE_NONE 					((USHORT)0x0004)

// ------------------
// - FloatingWindow -
// ------------------

class FloatingWindow : public SystemWindow
{
private:
	FloatingWindow* mpNextFloat;
	Window* 		mpFirstPopupModeWin;
	ToolBox*		mpBox;
	void*			mpDummy;
	Rectangle		maFloatRect;
	ULONG			mnPostId;
	ULONG			mnPopupModeFlags;
	USHORT			mnTitle;
	USHORT			mnOldTitle;
	BOOL			mbInPopupMode;
	BOOL			mbPopupMode;
	BOOL			mbPopupModeCanceled;
	BOOL			mbPopupModeTearOff;
	BOOL			mbMouseDown;
	BOOL			mbOldSaveBackMode;
	BOOL			mbGrabFocus;    // act as key input window, although focus is not set
	BOOL			mbInCleanUp;
	Link			maPopupModeEndHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_FLOATWIN_CXX
	void			ImplCallPopupModeEnd();
					DECL_LINK( ImplEndPopupModeHdl, void* );
#endif

protected:
	void			ImplInit( Window* pParent, WinBits nStyle );
	void			ImplInitSettings();
	void			ImplLoadRes( const ResId& rResId );

public:
#define IMPL_FLOATWIN_HITTEST_OUTSIDE		((USHORT)0x0001)
#define IMPL_FLOATWIN_HITTEST_WINDOW		((USHORT)0x0002)
#define IMPL_FLOATWIN_HITTEST_RECT			((USHORT)0x0004)
	FloatingWindow* ImplFloatHitTest( Window* pReference, const Point& rPos, USHORT& rHitTest );
	FloatingWindow* ImplFindLastLevelFloat();
	BOOL			ImplIsFloatPopupModeWindow( const Window* pWindow );
	void			ImplSetMouseDown() { mbMouseDown = TRUE; }
	BOOL			ImplIsMouseDown() const  { return mbMouseDown; }
	static Point	ImplCalcPos( Window* pWindow,
								 const Rectangle& rRect, ULONG nFlags,
								 USHORT& rArrangeIndex );
	void			ImplEndPopupMode( USHORT nFlags = 0, ULONG nFocusId = 0 );
#endif

public:
					FloatingWindow( Window* pParent, WinBits nStyle = WB_STDFLOATWIN );
					FloatingWindow( Window* pParent, const ResId& rResId );
					~FloatingWindow();

	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void	StateChanged( StateChangedType nType );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );

	virtual void	PopupModeEnd();

	void			SetTitleType( USHORT nTitle );
	USHORT			GetTitleType() const { return mnTitle; }

	void			StartPopupMode( const Rectangle& rRect, ULONG nFlags = 0 );
	void			StartPopupMode( ToolBox* pBox, ULONG nFlags = 0  );
	void			EndPopupMode( USHORT nFlags = 0 );
	void			AddPopupModeWindow( Window* pWindow );
	void			RemovePopupModeWindow( Window* pWindow );
	ULONG			GetPopupModeFlags() const { return mnPopupModeFlags; }
    void			SetPopupModeFlags( ULONG nFlags ) { mnPopupModeFlags = nFlags; }
	BOOL			IsInPopupMode() const { return mbPopupMode; }
	BOOL			IsInCleanUp() const { return mbInCleanUp; }
	BOOL			IsPopupModeCanceled() const { return mbPopupModeCanceled; }
	BOOL			IsPopupModeTearOff() const { return mbPopupModeTearOff; }

	void			SetPopupModeEndHdl( const Link& rLink ) { maPopupModeEndHdl = rLink; }
	const Link& 	GetPopupModeEndHdl() const	{ return maPopupModeEndHdl; }

    BOOL            GrabsFocus() const { return mbGrabFocus; }
};

#endif // _SV_FLOATWIN_HXX
