/*************************************************************************
 *
 *  $RCSfile: certpage.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:04:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _INETCERT_HXX
#include <inet/inetcert.hxx>
#endif

#include "certpage.hxx"
#include "certdlg.hxx"

#include "certdlg.hrc"
#include "goodies.hrc"

// class CertificatePage -------------------------------------------------

void CertificatePage::SetServerName( FixedText* pTextToRepl )
{
	if( pTextToRepl )
	{
		String aText = pTextToRepl->GetText();
		String aCommonName;
		GetCertificate().GetSubjectCommonName( aCommonName );

		aText.SearchAndReplace( "$1", aCommonName );
		pTextToRepl->SetText( aText );
	}
}

// -----------------------------------------------------------------------

FixedText* CertificatePage::GetTextToReplace()
{
	return NULL;
}

// class OpenPage --------------------------------------------------------

OpenPage::OpenPage( CertAcceptDialog* pParent, ResMgr* pResMgr ) :

	CertificatePage( pParent, ResId( PAGE_SSL_NEWCERT_OPEN, pResMgr ) ),

	m_aText1( this, ResId( FT_OPENPG_1 ) ),
	m_aText2( this, ResId( FT_OPENPG_2 ) )

{
	FreeResource();
}

// -----------------------------------------------------------------------

FixedText* OpenPage::GetTextToReplace()
{
	return &m_aText1;
}

// class ShowCertPage ----------------------------------------------------

ShowCertPage::ShowCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr) :

	CertificatePage( pParent, ResId( PAGE_SSL_NEWCERT_SHOWCERT, pResMgr ) ),

	m_aText1			( this, ResId( FT_SHOWCERT_1 ) ),
	m_aText2			( this, ResId( FT_SHOWCERT_2 ) ),
	m_aText3			( this, ResId( FT_SHOWCERT_3 ) ),
	m_aText4			( this, ResId( FT_SHOWCERT_4 ) ),
	m_aText5			( this, ResId( FT_SHOWCERT_5 ) ),
	m_aPBDetail			( this, ResId( PB_SHOWCERT_DETAIL ) ),
	m_aFTCertOwner		( this, ResId( FT_CERT_OWNER ) ),
	m_aFTCertAuthority	( this, ResId( FT_CERT_AUTHORITY ) ),
	m_aFTCertEncrypt	( this, ResId( FT_CERT_ENCRYPT ) ),
	m_aLine1			( this, ResId( FL_LINE1 ) ),
	m_aLine2			( this, ResId( FL_LINE2 ) ),
	m_pResMgr			( pResMgr )

{
	FreeResource();
	m_aPBDetail.SetClickHdl( LINK( this, ShowCertPage, ClickHdl ) );

	String aSubject;
	if ( GetCertificate().GetSubjectOrganizationName( aSubject ) )
		m_aFTCertOwner.SetText( aSubject );

	String aIssuer;
	if ( GetCertificate().GetIssuerOrganizationName( aIssuer ) )
		m_aFTCertAuthority.SetText( aIssuer );
}

// -----------------------------------------------------------------------

IMPL_LINK( ShowCertPage, ClickHdl, PushButton*, EMPTYARG )
{
	CertDetailDialog aDlg( this, m_pResMgr, GetCertificate() );
	aDlg.Execute();
	return 1;
}

// -----------------------------------------------------------------------

FixedText* ShowCertPage::GetTextToReplace()
{
	return &m_aText1;
}

// class AcceptCertPage --------------------------------------------------

AcceptCertPage::AcceptCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr) :

	CertificatePage( pParent, ResId( PAGE_SSL_NEWCERT_ACCEPTCERT, pResMgr ) ),

	m_aText1	( this, ResId( FT_ACCEPT1 ) ),
	m_aText2	( this, ResId( FT_ACCEPT2 ) ),
	m_aRBOnce	( this, ResId( RB_ACCEPT_ONCE ) ),
	m_aRBNone	( this, ResId( RB_ACCEPT_NONE ) ),
	m_aRBEver	( this, ResId( RB_ACCEPT_EVER ) )

{
	switch ( GetAcceptState() )
	{
		case ACCEPT_ONCE:
			m_aRBOnce.Check();
			break;
		case ACCEPT_EVER:
			m_aRBEver.Check();
			break;
		case ACCEPT_NONE:
			m_aRBNone.Check();
			break;
	}
	m_aRBOnce.SetClickHdl( LINK( this, AcceptCertPage, ClickHdl ) );
	m_aRBNone.SetClickHdl( LINK( this, AcceptCertPage, ClickHdl ) );
	m_aRBEver.SetClickHdl( LINK( this, AcceptCertPage, ClickHdl ) );

	FreeResource();
}

// -----------------------------------------------------------------------

IMPL_LINK( AcceptCertPage, ClickHdl, Control*, pCtrl )
{
	if ( pCtrl == &m_aRBOnce )
		SetAcceptState( ACCEPT_ONCE );
	else if ( pCtrl == &m_aRBEver )
		SetAcceptState( ACCEPT_EVER );
	else if ( pCtrl == &m_aRBNone )
		SetAcceptState( ACCEPT_NONE );
	return 1;
}

// -----------------------------------------------------------------------

FixedText* AcceptCertPage::GetTextToReplace()
{
	return &m_aText1;
}

// class WarnCertPage -----------------------------------------------------

WarnCertPage::WarnCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr ) :

	CertificatePage( pParent, ResId( PAGE_SSL_NEWCERT_WARNCERT, pResMgr ) ),

	m_aText1	( this, ResId( FT_WARN_1 ) ),
	m_aText2	( this, ResId( FT_WARN_2 ) ),
	m_aText3	( this, ResId( FT_WARN_3 ) ),
	m_aCBWarn	( this, ResId( CB_WARN ) )

{
	FreeResource();
	m_aCBWarn.SetClickHdl( LINK( this, WarnCertPage, ClickHdl ) );

	if ( GetWarningState() )
		m_aCBWarn.Check();
}

// -----------------------------------------------------------------------

IMPL_LINK( WarnCertPage, ClickHdl, Control*, EMPTYARG )
{
	if ( m_aCBWarn.IsChecked() )
		SetWarningState( TRUE );
	else
		SetWarningState( FALSE );
	return 1;
}

// -----------------------------------------------------------------------

FixedText* WarnCertPage::GetTextToReplace()
{
	return &m_aText1;
}

// class ReadyCertPage ---------------------------------------------------

ReadyCertPage::ReadyCertPage( CertAcceptDialog* pParent, ResMgr* pResMgr ) :

	CertificatePage( pParent, ResId( PAGE_SSL_NEWCERT_READYCERT, pResMgr ) ),

	m_aText1	( this, ResId( FT_READY_1 ) ),
	m_aText2	( this, ResId( FT_READY_2 ) ),
	m_aText3	( this, ResId( FT_READY_3 ) ),
	m_aText4	( this, ResId( FT_READY_4 ) ),
	m_aWarnOn	( 		ResId( STR_WARNON ) ),
	m_aWarnOff	( 		ResId( STR_WARNOFF ) )

{
	FreeResource();

	if( GetWarningState() )
		m_aText2.SetText( m_aWarnOn );
	else
		m_aText2.SetText( m_aWarnOff );
}


