/*************************************************************************
 *
 *  $RCSfile: certdlg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:04:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CERTDLG_HXX
#define _CERTDLG_HXX

#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif

// define ----------------------------------------------------------------

#define ACCEPT_NONE 	0
#define ACCEPT_ONCE 	1
#define ACCEPT_EVER 	2

// forward ---------------------------------------------------------------

class INetCoreCertificate;
class Window;
class ResMgr;
class Control;
class CertDetailWindow;
class CertDetailEdit;

struct CtrlImpl;

// class CertAcceptDialog ------------------------------------------------

class CertAcceptDialog : public ModalDialog
{
private:
	const INetCoreCertificate&	m_rCert;
	ResMgr*						m_pResMgr;
	CtrlImpl*					m_pImpl;
	Window*						m_pActPage;
	USHORT						m_nActPage;
	BYTE						m_nAcceptState;
	BOOL						m_bWarning;

	void						SetActPage();
	void						UpdateButton();

	DECL_LINK( ClickHdl, Control* );

public:
	CertAcceptDialog( Window* pParent, ResMgr* pResMgr, const INetCoreCertificate& rCert );
	virtual ~CertAcceptDialog();

	const INetCoreCertificate&	GetCertificate() const { return m_rCert; }

	BYTE						GetAcceptState() const { return m_nAcceptState; }
	void						SetAcceptState( BYTE nNew ) { m_nAcceptState = nNew; }

	BOOL						GetWarningState() const { return m_bWarning; }
	void						SetWarningState( BOOL bNew ) { m_bWarning = bNew; }
};

// class CertDetailDialog ------------------------------------------------

class CertDetailDialog : public ModalDialog
{
	const INetCoreCertificate&	m_rCert;
	ResMgr*						m_pResMgr;
	CertDetailWindow*			m_pInfoWin;
	CertDetailEdit*				m_pEditWin;
	OKButton					m_aOKBtn;
	String						m_aFromStr;
	String						m_aToStr;

	String						ParseParam( const String& rParam, const String& rSrc );

public:
	CertDetailDialog( Window* pParent, ResMgr* pResMgr, const INetCoreCertificate& rCert );
	virtual ~CertDetailDialog();

	void						ShowEditWindow();
};


#endif /* _CERTDLG_HXX */

