/*************************************************************************
 *
 *  $RCSfile: fpxcontentproviderservice.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/09/12 10:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_FPXCONTENTPROVIDERSERVICE_HXX
#include "fpxcontentproviderservice.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include "com/sun/star/lang/XServiceInfo.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_ILLEGALIDENTIFIEREXCEPTION_HPP_
#include "com/sun/star/ucb/IllegalIdentifierException.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include "com/sun/star/ucb/XContentProvider.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include "com/sun/star/ucb/XContentProviderManager.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include "com/sun/star/uno/Exception.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include "com/sun/star/uno/XInterface.hpp"
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include "cppuhelper/implbase2.hxx"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_STRING_H_
#include "rtl/string.h"
#endif
#ifndef _RTL_USTRING_H_
#include "rtl/ustring.h"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SVTOOLS_INETOPTIONS_HXX_
#include "svtools/inetoptions.hxx"
#endif
#ifndef _UCBHELPER_CONTENTBROKER_HXX
#include "ucbhelper/contentbroker.hxx"
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif
#ifndef INCLUDED_NEW
#include <new>
#define INCLUDED_NEW
#endif

using namespace com::sun;
using namespace ucb::fpx;

namespace {

class ContentProvider: cppu::WeakImplHelper2< star::lang::XServiceInfo,
                                              star::ucb::XContentProvider >
{
public:
    inline
    ContentProvider(
        star::uno::Reference< star::lang::XMultiServiceFactory > const &
            rServiceFactory)
        SAL_THROW(()):
        m_xServiceFactory(rServiceFactory) {}

    virtual inline rtl::OUString SAL_CALL getImplementationName()
        throw (star::uno::RuntimeException)
    { return ContentProviderService::getImplementationName(); }

    virtual sal_Bool SAL_CALL
    supportsService(rtl::OUString const & rServiceName)
        throw (star::uno::RuntimeException);

    virtual inline star::uno::Sequence< rtl::OUString > SAL_CALL
    getSupportedServiceNames()
        throw (star::uno::RuntimeException)
    { return ContentProviderService::getSupportedServiceNames(); }

    virtual star::uno::Reference< star::ucb::XContent > SAL_CALL
    queryContent(star::uno::Reference< star::ucb::XContentIdentifier > const &
                     rIdentifier)
        throw (star::ucb::IllegalIdentifierException,
               star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL
    compareContentIds(
        star::uno::Reference< star::ucb::XContentIdentifier > const & rId1,
        star::uno::Reference< star::ucb::XContentIdentifier > const & rId2)
        throw (star::uno::RuntimeException);

private:
    osl::Mutex m_aMutex;
    star::uno::Reference< star::lang::XMultiServiceFactory >
        m_xServiceFactory;
    star::uno::Reference< star::ucb::XContentProvider > m_xFtpProvider;
    star::uno::Reference< star::ucb::XContentProviderManager > m_xManager;
    std::auto_ptr< SvtInetOptions const > m_xInetOptions;

    inline SvtInetOptions const & getInetOptions()
        SAL_THROW((star::uno::RuntimeException));

    inline star::uno::Reference< star::ucb::XContentProvider >
    getFtpProvider()
        SAL_THROW((star::uno::RuntimeException));

    inline star::uno::Reference< star::ucb::XContentProvider >
    getHttpProvider()
        SAL_THROW((star::uno::RuntimeException));

    friend star::uno::Reference< star::uno::XInterface > SAL_CALL
    ContentProviderService::createInstance(
        star::uno::Reference< star::lang::XMultiServiceFactory > const &
            rServiceFactory)
        SAL_THROW(());
};

}

inline SvtInetOptions const & ContentProvider::getInetOptions()
    SAL_THROW((star::uno::RuntimeException))
{
    //TODO! double check pattern not really portable
    if (!m_xInetOptions.get())
    {
        osl::MutexGuard aGuard(m_aMutex);
        if (!m_xInetOptions.get())
            try
            {
                m_xInetOptions.reset(new SvtInetOptions);
            }
            catch (std::bad_alloc const &)
            {
                throw star::uno::RuntimeException(
                          rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                            "out of memory")),
                          *this);
            }
    }
    return *m_xInetOptions.get();
}

inline star::uno::Reference< star::ucb::XContentProvider >
ContentProvider::getFtpProvider()
    SAL_THROW((star::uno::RuntimeException))
{
    //TODO! double check pattern not really portable
    if (!m_xFtpProvider.is())
    {
        osl::MutexGuard aGuard(m_aMutex);
        if (!m_xFtpProvider.is())
        {
            if (m_xServiceFactory.is())
                try
                {
                    m_xFtpProvider
                        = star::uno::Reference< star::ucb::XContentProvider >(
                              m_xServiceFactory->
                                  createInstance(
                                      rtl::OUString(
                                          RTL_CONSTASCII_USTRINGPARAM(
                                   "com.sun.star.ucb.ChaosContentProvider"))),
                              star::uno::UNO_QUERY);
                }
                catch (star::uno::Exception const &)
                {}
            if (!m_xFtpProvider.is())
                throw star::uno::RuntimeException(
                          rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                            "no service com.sun.star.ucb."
                                                "ChaosContentProvider")),
                          *this);
        }
    }
    return m_xFtpProvider;
}

inline star::uno::Reference< star::ucb::XContentProvider >
ContentProvider::getHttpProvider()
    SAL_THROW((star::uno::RuntimeException))
{
    //TODO! double check pattern not really portable
    if (!m_xManager.is())
    {
        osl::MutexGuard aGuard(m_aMutex);
        if (!m_xManager.is())
        {
            ucb::ContentBroker * pBroker = ucb::ContentBroker::get();
            if (pBroker)
            {
                m_xManager = pBroker->getContentProviderManagerInterface();
                if (!m_xManager.is())
                    throw star::uno::RuntimeException(
                              rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                                "bad ucb::ContentBroker")),
                              *this);
            }
            if (!m_xManager.is())
                return 0;
        }
    }
    return m_xManager->
               queryContentProvider(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                                      "http:")));
                                        //TODO! input ok?
}

sal_Bool SAL_CALL
ContentProvider::supportsService(rtl::OUString const & rServiceName)
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< rtl::OUString > aNames(getSupportedServiceNames());
    for (sal_Int32 i = 0; i < aNames.getLength(); ++i)
        if (rServiceName == aNames[i])
            return true;
    return false;
}

star::uno::Reference< star::ucb::XContent > SAL_CALL
ContentProvider::queryContent(
    star::uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
    throw (star::ucb::IllegalIdentifierException,
           star::uno::RuntimeException)
{
    rtl::OUString aUri;
    if (rIdentifier.is())
        aUri = rIdentifier->getContentIdentifier();
    if (!aUri.matchIgnoreAsciiCaseAsciiL(RTL_CONSTASCII_STRINGPARAM("ftp:")))
        throw star::ucb::IllegalIdentifierException(aUri, *this);
    if (getInetOptions().ShouldUseFtpProxy(aUri))
    {
        star::uno::Reference< star::ucb::XContentProvider >
            xProvider(getHttpProvider());
        if (xProvider.is())
            try
            {
                return xProvider->queryContent(rIdentifier);
            }
            catch (star::ucb::IllegalIdentifierException const &)
            {}
        return 0; //TODO! throw exception?
    }
    else
        return getFtpProvider()->queryContent(rIdentifier);
}

sal_Int32 SAL_CALL
ContentProvider::compareContentIds(
    star::uno::Reference< star::ucb::XContentIdentifier > const & rId1,
    star::uno::Reference< star::ucb::XContentIdentifier > const & rId2)
    throw (star::uno::RuntimeException)
{
    rtl::OUString aUri1;
    if (rId1.is())
        aUri1 = rId1->getContentIdentifier();
    rtl::OUString aUri2;
    if (rId2.is())
        aUri2 = rId2->getContentIdentifier();
    return aUri1.compareTo(aUri2);
}

namespace ucb { namespace fpx {

namespace ContentProviderService {

    rtl::OUString getImplementationName()
        SAL_THROW((star::uno::RuntimeException))
    {
        return
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                              "com.sun.star.comp.ucb.fpx.ContentProvider"));
    }

    star::uno::Sequence< rtl::OUString > getSupportedServiceNames()
        SAL_THROW((star::uno::RuntimeException))
    {
        rtl::OUString aName
            = rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM(
                            "com.sun.star.ucb.fpx.ContentProvider"));
        return star::uno::Sequence< rtl::OUString >(&aName, 1);
    }

    star::uno::Reference< star::uno::XInterface > SAL_CALL
    createInstance(
        star::uno::Reference< star::lang::XMultiServiceFactory > const &
            rServiceFactory)
        SAL_THROW(())
    {
        try
        {
            return *new ContentProvider(rServiceFactory);
        }
        catch (std::bad_alloc const &)
        {
            throw star::uno::RuntimeException(rtl::OUString(
                                                  RTL_CONSTASCII_USTRINGPARAM(
                                                      "out of memory")),
                                              0);
        }
    }

}

} }
