/*************************************************************************
 *
 *  $RCSfile: persbcst.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: gh $ $Date: 2001/01/05 15:21:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "bcstdefs.hxx"
#include "siclient.hxx"
#include "persbcst.hxx"
#include "geninfo.hxx"

PersistentInformationBroadcaster::PersistentInformationBroadcaster( CommunicationManager *pManager, InformationClient *pIClient )
: InformationBroadcaster( pManager )
, mpIClient( pIClient )
, mpPersistentData( NULL )
{
}

PersistentInformationBroadcaster::~PersistentInformationBroadcaster()
{
	if ( mpPersistentData )
		delete mpPersistentData;
	if ( mpIClient )
		delete mpIClient;
}

void PersistentInformationBroadcaster::IMessageArrived( const BroadcastMessage &aMsg )
{
	InformationBroadcaster::IMessageArrived( aMsg );
	if ( !mpPersistentData )
		return;

	ByteString aKey;
	aKey += ByteString::CreateFromInt32(aMsg.GetBroadcastCategory());

	GenericInformation* pCategory = mpPersistentData->GetInfo( aKey, TRUE, FALSE );

	if ( !pCategory )
		return;

	pCategory->InsertSubInfo( BCSTKey( aMsg ), BCSTValue( aMsg ), TRUE, TRUE );
}

void PersistentInformationBroadcaster::Reconnect( InformationClient *pIClient )
{
	if ( mpIClient )
		delete mpIClient;

	mpIClient = pIClient;
}

GenericInformation* PersistentInformationBroadcaster::GetPersistentData( BroadcastCategory nType )
{
	if ( !mpPersistentData )
		mpPersistentData = new GenericInformationList();

	ByteString aKey;
	aKey += ByteString::CreateFromInt32( nType );

	GenericInformation* pCategory = mpPersistentData->GetInfo( aKey, TRUE, FALSE );

	if ( pCategory )
		return pCategory;

	// Dann wollen wir die Liste mal laden
	if ( !mpIClient )
	{
		mpIClient = new SimpleInformationClient( GetBroadcastHost() );
		mpIClient->SetApplication("PersistentBCST");
	}

	ByteString aPath( PERSISTENT_BROADCAST_ROOT );
	aPath += aKey;
	aPath += ".lst";

	mpIClient->SetCommand( "loadfile" ,aPath );
	mpIClient->Command_n_Wait();

	mpIClient->SetRequest( aPath, TRUE, TRUE );
	pCategory = (GenericInformation*)mpIClient->Send_n_Wait();

	if ( pCategory )
	{
		(*(ByteString*)pCategory) = aKey;
		pCategory = new GenericInformation( *pCategory );
		mpPersistentData->InsertInfo( pCategory );
	}

	return pCategory;
}

BOOL PersistentInformationBroadcaster::MakePersistent( const ByteString &aType )
{
	BroadcastCategory nType = Name2Id( aType );
	if ( BCST_CAT_INVALID != nType )
		return MakePersistent( nType );
	else
		return FALSE;
}

BOOL PersistentInformationBroadcaster::MakePersistent( BroadcastCategory nType )
{
	if ( !StartCommunicationIfNecessary() )
		return FALSE;
	CommunicationLinkRef xCL = mpManager->GetLastNewLink();
	DBG_ASSERT( xCL, "Kein CommunicationLink vorhanden" );
	if ( xCL )
	{
		SvStream *pData = xCL->GetBestCommunicationStream();

		*pData << BCST_CMD_MAKE_PERSISTENT;
		*pData << nType;

		BOOL bOK = xCL->TransferDataStream( pData, CM_PROTOCOL_BROADCASTER );
		delete pData;
		return bOK;
	}
	else
		return FALSE;
}

/*************************************************************************

	  Source Code Control System - Header

	  $Header: /cvs/util/tools/source/communi/persbcst.cxx,v 1.2 2001/01/05 15:21:13 gh Exp $

	  Source Code Control System - Update

	  $Log: persbcst.cxx,v $
	  Revision 1.2  2001/01/05 15:21:13  gh
	  added method to identify client to IServer
	
	  Revision 1.1.1.1  2000/09/18 17:03:06  hr
	  initial import
	
	  Revision 1.3  2000/09/18 10:01:15  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.2  2000/08/15 06:45:09  nf
	  Moved from r_tools
	
	  Revision 1.4  2000/05/23 15:27:22  gh
	  UNICODE changes

	  Revision 1.3  1999/11/18 16:28:48  nf
	  Fixes fuer Reconnect

	  Revision 1.2  1999/09/23 06:44:11  nf
	  Fixes

	  Revision 1.1  1999/09/09 09:13:57  gh
	  BCST Persistent machen

	  Revision 1.10  1999/09/01 12:02:05  gh
	  WaitForData returns after each Datapacket

	  Revision 1.9  1999/08/23 09:06:28  gh
	  new: Name2Id

	  Revision 1.8  1999/08/20 13:56:32  nf
	  neu: meherer Links

	  Revision 1.7  1999/08/18 10:05:06  nf
	  Neu: BCST_CAT_BSTRIGGER

	  Revision 1.6  1999/08/18 07:28:35  gh
	  Komfortableres Interface

	  Revision 1.5  1999/08/17 08:42:24  nf
	  PORT jetzt aus Header

	  Revision 1.4  1999/08/16 16:34:54  gh
	  Broadcast Message mit ChannelType

	  Revision 1.3  1999/08/16 14:13:20  gh
	  GetBroadcastHost liste Daten aus environment, bevor auf ISERVER defaulted wird

	  Revision 1.2  1999/08/16 13:23:19  gh
	  Protokoll auf Verwendung nur einer ID umgestellt

	  Revision 1.1  1999/08/09 15:43:03  gh
	  #67835# Broadcaster clients


*************************************************************************/
