/*************************************************************************
 *
 *  $RCSfile: shortcut.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:52:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svpm.h>
#include <folder.hxx>
#include <stream.hxx>
#include <extattr.hxx>

#include <vos/macros.hxx>
#include <utility>
#include <vector>

typedef NAMESPACE_STD(pair)   <String, String>      ShortcutEntry;
typedef NAMESPACE_STD(vector) <ShortcutEntry>       ShortcutVec;
typedef NAMESPACE_STD(pair)   <String, ShortcutVec> ShortcutGroup;
typedef NAMESPACE_STD(vector) <ShortcutGroup>       ShortcutData;

#define m_pShortcutData ((ShortcutData *) m_pData)
#define m_aCurrentGroup ((*m_pShortcutData)[m_nCurrentGroup])
#define m_aDefaultGroup ((*m_pShortcutData)[0])

/***************************************************************************************
 *
 * IfcShortcutImpl - Implementation
 *
 ***************************************************************************************
 */

IfcShortcutImpl::IfcShortcutImpl(const String& crLanguage, const ItemIDPath& crFolder)
{
    m_pData = new ShortcutData(1);

    if(crLanguage.Len())
    {
        // append group for language at the end
        m_pShortcutData->insert(m_pShortcutData->end());
        m_pShortcutData->back().first = crLanguage;
        m_nCurrentGroup = 1;
    }
    else
        m_nCurrentGroup = 0;

    m_aParent = crFolder;

    // insert default value names
    String aEmpty;

    m_aDefaultGroup.second.push_back(ShortcutEntry("Title", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("URL", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("TargetFrame", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("SOIcon", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("IconFile", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("IconIndex", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("WorkingDirectory", aEmpty));
    m_aDefaultGroup.second.push_back(ShortcutEntry("Arguments", aEmpty));
}

/*------------------------------------------------------------------------------------
 * Destructor()
 *------------------------------------------------------------------------------------
 */

IfcShortcutImpl::~IfcShortcutImpl()
{
    delete m_pShortcutData;
}

/*------------------------------------------------------------------------------------
 * GetValueNameCount()
 *------------------------------------------------------------------------------------
 */

UINT32 IfcShortcutImpl::GetValueNameCount() const
{
    return m_aDefaultGroup.second.size();
}

/*------------------------------------------------------------------------------------
 * GetValueName()
 *------------------------------------------------------------------------------------
 */

const String& IfcShortcutImpl::GetValueName(UINT32 nIndex) const
{
    return m_aDefaultGroup.second[nIndex].first;
}

/*------------------------------------------------------------------------------------
 * GetValueContent()
 *------------------------------------------------------------------------------------
 */

static String aEmptyString;

const String& IfcShortcutImpl::GetValueContent(const String& crValueName) const
{
    ShortcutVec::iterator iPos;

    // first search value in current group
    for(iPos = m_aCurrentGroup.second.begin(); iPos != m_aCurrentGroup.second.end(); iPos++)
        if(iPos->first == crValueName)
            return iPos->second;

    // if not found in current group, search in default group
    for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
        if(iPos->first == crValueName)
            return iPos->second;

    // key not found
	return aEmptyString;
}

/*------------------------------------------------------------------------------------
 * SetValueContent()
 *------------------------------------------------------------------------------------
 */

void IfcShortcutImpl::SetValueContent(const String& crValueName, const String& crValueContent)
{
    ShortcutVec::iterator iPos;

    // set value in current group
    for(iPos = m_aCurrentGroup.second.begin(); iPos != m_aCurrentGroup.second.end(); iPos++)
        if(iPos->first == crValueName)
        {
            iPos->second = crValueContent;
            break;
        }

    // if value name not found, append entry
    if(iPos == m_aCurrentGroup.second.end())
        m_aCurrentGroup.second.push_back(ShortcutEntry(crValueName, crValueContent));

    // if value in default group too
    for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
        if(iPos->first == crValueName)
        {
            iPos->second = crValueContent;
            break;
        }

    // if value name not found, append entry
    if(iPos == m_aDefaultGroup.second.end())
        m_aDefaultGroup.second.push_back(ShortcutEntry(crValueName, crValueContent));
}

/*------------------------------------------------------------------------------------
 * Load()
 *------------------------------------------------------------------------------------
 */

FSysError IfcShortcutImpl::Load(const ItemIDPath &crIDPath)
{
    String aFileName = (m_aParent + crIDPath).GetHostNotationPath();
    m_aIDPath = crIDPath;

    if(aFileName.Len())
    {
        /*
         * first read the target url from EAs if exist
         */

        // query file type
        String aTmp = StringEA(aFileName, ".TYPE");

        if(aTmp.Compare("UniformResourceLocator") == COMPARE_EQUAL)
        {
            // query URL info from EAs
            String aTargetURL = UrlEA(aFileName, ".CLASSINFO");
            aTmp = "URL";

            if(aTargetURL.Len())
            {
                ShortcutVec::iterator iPos;

                // set target url
                for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
                    if(iPos->first == aTmp)
                    {
                        iPos->second = aTargetURL;
                        break;
                    }

                // if target url not found, append entry
                if(iPos == m_aDefaultGroup.second.end())
                    m_aDefaultGroup.second.push_back(ShortcutEntry(aTmp, aTargetURL));
            }
        }

        SvFileStream aInputFile(aFileName, STREAM_READ);
        UINT32 nGroupIndex = 0;

        while(!aInputFile.IsEof())
        {
            String aLine;
            USHORT nPos = 0;

            aInputFile.ReadLine(aLine);

            // skip leading characters
            while(aLine[nPos] == ' ' || aLine[nPos] == '\t' || aLine[nPos] == '\r')
                nPos++;

            aLine.Erase(0, nPos);
            aLine.Convert(CHARSET_ANSI);

            if(aLine[0] == '[' && (nPos = aLine.Search(']')) != STRING_NOTFOUND)
            {
                String aGroup(aLine.Copy(1, nPos - 1));
                if(aGroup.ICompare("InternetShortcut", 16) == COMPARE_EQUAL)
                    aGroup.Erase(0, 16);

                if(aGroup.Len())
                {
                    aGroup.Erase(0,1);

                    ShortcutData::iterator iPos;

                    for(iPos =  m_pShortcutData->begin();
                        iPos != m_pShortcutData->end();
                        iPos++, nGroupIndex++)
                    {
                        if(iPos->first == aGroup)
                        {
                            break;
                        }
                    }

                    if(iPos == m_pShortcutData->end())
                    {
                        m_pShortcutData->push_back(ShortcutGroup(aGroup, ShortcutVec()));
                    }
                }
            }
            else if((nPos = aLine.Search('=')) != STRING_NOTFOUND)
            {
                ShortcutGroup& rGroup = (*m_pShortcutData)[nGroupIndex];
                ShortcutVec::iterator iPos;
                String aValueName = aLine.Copy(0, nPos);

                if(aValueName.ICompare("IconFile") != COMPARE_EQUAL &&
                   aValueName.ICompare("IconIndex") != COMPARE_EQUAL)
                {
                    // set value in current group
                    for(iPos = rGroup.second.begin(); iPos != rGroup.second.end(); iPos++)
                    {
                        if(iPos->first == aValueName)
                        {
                            iPos->second = aLine.Copy(nPos + 1);
                            break;
                        }
                    }

                    // if value name not found, append entry
                    if(iPos == rGroup.second.end())
                        rGroup.second.push_back(ShortcutEntry(aValueName, aLine.Copy(nPos + 1)));
                }
            }
        }
    }
    else
    {
        CHAR   szBuffer[3 * CCHMAXPATHCOMP];

        ItemIDPathData *pIDData = (ItemIDPathData *) crIDPath.GetDataPtr();

        if(!pIDData)
            return FSYS_ERR_UNKNOWN;

        String aObject = WinFolderImpl::GetValidObject(pIDData->sPath).Upper();

        if(aObject.Len() == 0)
            return FSYS_ERR_UNKNOWN;

        if(WinFolderImpl::queryLinkInfo((PSZ) aObject.GetStr(), szBuffer, sizeof(szBuffer)))
        {
            wps_linkInfo& rInfo = (wps_linkInfo&) szBuffer;
            String        aTmp;
            String        aTargetURL;

            // check if target path is fully quallified
            if(rInfo.szTarget[1] == ':' || rInfo.szTarget[0] == '<' ||
               (rInfo.szTarget[0] == '\\' && rInfo.szTarget[1] == '\\'))
            {
                ItemIDPath aTargetPath(rInfo.szTarget);
                aTargetURL = aTargetPath.GetFileDescription();

                if(aTargetURL.Len() == 0)
                    aTargetURL = aTargetPath.GetBinaryDescription();
            }
            else
                aTargetURL = rInfo.szTarget;

            // append trailing slash if target must be a directory
            if(rInfo.linkType & LINK_TYPE_DIR)
                aTargetURL += '/';

            if(aTargetURL.Len())
            {
                aTmp = "URL";
                ShortcutVec::iterator iPos;

                // set target url
                for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
                    if(iPos->first == aTmp)
                    {
                        iPos->second = aTargetURL;
                        break;
                    }

                // if target url not found, append entry
                if(iPos == m_aDefaultGroup.second.end())
                    m_aDefaultGroup.second.push_back(ShortcutEntry(aTmp, aTargetURL));

                if(rInfo.cbArguments)
                {
                    String aParams = &rInfo.szArguments[rInfo.cbTarget];
                    aTmp = "Arguments";

                    // search key in data structure
                    for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
                        if(iPos->first == aTmp)
                        {
                            iPos->second = aParams;
                            break;
                        }

                    // if key not found, append entry
                    if(iPos == m_aDefaultGroup.second.end())
                        m_aDefaultGroup.second.push_back(ShortcutEntry(aTmp, aParams));
                }

                if(rInfo.cbWorkingDir)
                {
                    String aParams = &rInfo.szWorkingDir[rInfo.cbTarget + rInfo.cbArguments];
                    aTmp = "WorkingDirectory";

                    // search key in data structure
                    for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
                        if(iPos->first == aTmp)
                        {
                            iPos->second = aParams;
                            break;
                        }

                    // if key not found, append entry
                    if(iPos == m_aDefaultGroup.second.end())
                        m_aDefaultGroup.second.push_back(ShortcutEntry(aTmp, aParams));
                }
            }

            String aIconFile;

            if(rInfo.hIcon)
            {
                aIconFile = WinFolderImpl::HandleToString(rInfo.hIcon);
            }


            if(aIconFile.Len())
            {
                aTmp = "SOIcon";
                ShortcutVec::iterator iPos;

                // search key in data structure
                for(iPos = m_aDefaultGroup.second.begin(); iPos != m_aDefaultGroup.second.end(); iPos++)
                    if(iPos->first == aTmp)
                    {
                        iPos->second = aIconFile;
                        break;
                    }

                // if key not found, append entry
                if(iPos == m_aDefaultGroup.second.end())
                    m_aDefaultGroup.second.push_back(ShortcutEntry(aTmp, aIconFile));
            }
        }
    }

	return FSYS_ERR_OK;
}

/*------------------------------------------------------------------------------------
 * Store()
 *------------------------------------------------------------------------------------
 */

FSysError IfcShortcutImpl::Store(const String& crTitle, ItemIDPath& rNewIDPath, ShortcutFormat ePreferred)
{
    ItemIDPath aIDPath;

    switch(ePreferred)
    {
    case SHORTCUT_FORMAT_BESTFIT:
        {
            ItemIDPathData *pIDData;
            ShortcutFormat  eFormat;

            // check if shortcut was loaded from a file
            pIDData = (ItemIDPathData *) m_aIDPath.GetDataPtr();

            if(pIDData)
            {
                // search extension
                String aExt;
                USHORT n;

                for( n = pIDData->sPath.Len() - 1;
                     n > 0 && pIDData->sPath.GetChar( n ) != '.';
                     n-- )
                    ;

                // extract extension if found
                if( n || pIDData->sPath.GetChar( 0 ) == '.' )
                    aExt = pIDData->sPath.Copy( n );

                if(aExt.ICompare(".url") != COMPARE_EQUAL)
                    eFormat = SHORTCUT_FORMAT_SYSTEM;
                else
                    eFormat = SHORTCUT_FORMAT_URL;
            }
            else
            {
                // if not loaded from file, decide from folder
                pIDData = (ItemIDPathData *) m_aParent.GetDataPtr();

                if(pIDData)
                {
                    // if failed to write system file, retry with url
                    if(pIDData->sPath.GetChar(0) == '<' &&
                       FSYS_ERR_OK == Store(crTitle, rNewIDPath, SHORTCUT_FORMAT_SYSTEM))
                    {
                        return FSYS_ERR_OK;
                    }

                    eFormat = SHORTCUT_FORMAT_URL;
                }
            }

            return Store(crTitle, rNewIDPath, eFormat);
        }

        break;

    case SHORTCUT_FORMAT_SYSTEM:
        {
            String  aTargetURL = GetValueContent("URL");

            if(aTargetURL.Compare("file://", 7) == COMPARE_EQUAL)
            {
//                ItemIDPath aIDPath(aTargetURL)
                String aExtension = aTargetURL.GetToken(aTargetURL.GetTokenCount('\\') - 1, '\\');
                aExtension.Erase(0, aExtension.SearchBackward('.'));

                if(aExtension.ICompare("com") || aExtension.ICompare("exe") ||
                   aExtension.ICompare("bat") || aExtension.ICompare("cmd"))
                {
                    String aParameters = GetValueContent("Parameters");
                    String aStartupDir = GetValueContent("StartupDir");

//                    aClass = "WPProgram";

                    if(aParameters.Len())
                    {
//                        aSetupString  = "PARAMETERS=";
//                        aSetupString += aParameters;

//                        if(aStartupDir.Len())
//                            aSetupString += ";";
                    }

                    if(aStartupDir.Len())
                    {
//                        aSetupString += "STARTUPDIR=";
//                        aSetupString += aStartupDir;
                    }
                }
                else
                {
                    if(m_aIDPath.GetDataPtr())
                    {
                        // WinQueryObject()
                        // WinDestroyObject()
                    }

//                    WinQueryObject()
                    //                   WinCreateShadow()

                    return FSYS_ERR_NOTSUPPORTED;
                }
            }
            else
            {
                HOBJECT hObject;

                if(m_aIDPath.GetDataPtr())
                {
//                hObject = WinQueryObject();
//                WinSetObjectData();
                }
                else
                {
                    String aSetupString("URL=");
                    aSetupString += aTargetURL;

                    hObject = WinCreateObject("WPUrl", crTitle, aSetupString.GetStr(),
                                              m_aParent.GetHostNotationPath().GetStr(),
                                              CO_REPLACEIFEXISTS);
                    if(!hObject)
                        return FSYS_ERR_ACCESSDENIED;

                    // query file path of new url
                    CHAR szBuffer[CCHMAXPATHCOMP];

                    if(WinQueryObjectPath(hObject, szBuffer, sizeof(szBuffer)))
                    {
                        ItemIDPath aAbsoluteID(szBuffer);
                        aIDPath = aAbsoluteID.GetToken(aAbsoluteID.GetTokenCount() - 1);
                    }
                    else
                        return FSYS_ERR_UNKNOWN;
                }
            }
        }

        break;

    case SHORTCUT_FORMAT_URL:
        {
            String aFileName;

            // check if file previous loaded
            if(m_aIDPath.GetDataPtr())
            {
                // rename file if necessary
                if(crTitle.Len() > 0)
                {
                    if(!Folder(m_aParent).RenameItem(m_aIDPath, aIDPath, crTitle))
                        return FSYS_ERR_ACCESSDENIED;
                }
                else
                    aIDPath = m_aIDPath;

                aFileName = (m_aParent + aIDPath).GetHostNotationPath();
            }

            // title for new shortcut given
            else if(crTitle.Len() > 0)
            {
                ItemIDPathData *pIDData = new ItemIDPathData;

                pIDData->nRefCount	= 0;
                pIDData->nImplFlags = 0;
                pIDData->sPath      = crTitle + ".url";

                aIDPath.SetData(pIDData, sizeof(ItemIDPathData));

                aFileName  = m_aParent.GetHostNotationPath();
                aFileName += '\\';
                aFileName += pIDData->sPath;
            }

            else
                return FSYS_ERR_UNKNOWN;

            SvFileStream aOutputFile(aFileName, STREAM_WRITE | STREAM_TRUNC);

            /*
             * write data to file
             */

            if(!aOutputFile.WriteLine(GetValueContent("URL")))
                return FSYS_ERR_UNKNOWN;

            ShortcutData::iterator iPos;

            for(iPos = m_pShortcutData->begin(); iPos != m_pShortcutData->end(); iPos++)
            {
                String aLine = "\n[InternetShortcut]";
                ShortcutVec::iterator iValue;

                // append section name
                if(iPos->first.Len())
                {
                    aLine.Insert('-', 18);
                    aLine.Insert(iPos->first, 19);
                }

                aLine.Convert(CHARSET_SYSTEM, CHARSET_ANSI);
                if(!aOutputFile.WriteLine(aLine))
                    break;

                for(iValue = iPos->second.begin(); iValue != iPos->second.end(); iValue++)
                {
                    aLine  = iValue->first;
                    aLine += '=';
                    aLine += iValue->second;

                    aLine.Convert(CHARSET_SYSTEM, CHARSET_ANSI);
                    if(!aOutputFile.WriteLine(aLine))
                        break;
                }

                if(iValue != iPos->second.end())
                    break;
            }

            if(iPos != m_pShortcutData->end())
                return FSYS_ERR_UNKNOWN;

            // close stream before writing
            aFileName = aOutputFile.GetFileName();
            aOutputFile.Close();

            // set type EA for file
            StringEA aType(String("UniformResourceLocator"));
            aType.storeTo(aFileName, ".TYPE");
       }
    }

    rNewIDPath = aIDPath;
    return FSYS_ERR_OK;
}

