/*************************************************************************

 *
 *  $RCSfile: zipdep.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hjs $ $Date: 2001/06/12 15:06:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef DEBUG
#define DEBUG_VERBOSE
#endif

#ifdef UNX
#include <unistd.h>
#endif

#include <sys/stat.h>
#include <stdio.h>
#include <string.h>

#include "prj.hxx"

#include <string.hxx>
#include <list.hxx>
#include <sstring.hxx>
#include <fsys.hxx>
#include <stream.hxx>

BOOL bRecursive = FALSE;
BOOL bHelp = FALSE;

class ZipDep
{
	SByteStringList*	pFileList;
	SByteStringList*	pSourceList;
	SByteStringList*	pExcludeList;
	SByteStringList*	pIncludeList;
	
private:
	void InsertDir( const String &sWildCards );
	BOOL IsExclude( const ByteString & aFileName );
	BOOL IsInclude( const ByteString & aFileName );
public:
					ZipDep();
	virtual			~ZipDep();

	BOOL AddSource( const char * aSource );
	BOOL AddInclude( const char * aSource );
	BOOL AddExclude( const char * aSource );
	SByteStringList*	GetDepList(){ return pFileList; };

	virtual void	Execute();
};

ZipDep::ZipDep()
{
	// init lists
	pFileList = new SByteStringList;
	pSourceList = new SByteStringList;
	pExcludeList = new SByteStringList;
	pIncludeList = new SByteStringList;
}

ZipDep::~ZipDep() 
{
	// remove list
	// content ???
	delete pFileList;
	delete pSourceList;
	delete pExcludeList;
	delete pIncludeList;
}

BOOL ZipDep::AddSource( const char * aSource )
{
	ByteString *pStr = new ByteString( aSource );
	pSourceList->PutString( pStr );
	return FALSE;
}

BOOL ZipDep::AddInclude( const char * aSource )
{
	ByteString *pStr = new ByteString( aSource );
	pIncludeList->PutString( pStr );
	return FALSE;
}

BOOL ZipDep::AddExclude( const char * aSource )
{
	ByteString *pStr = new ByteString( aSource );
	pExcludeList->PutString( pStr );
	return FALSE;
}

BOOL ZipDep::IsExclude( const ByteString & aFileName )
{
	return FALSE;
}

BOOL ZipDep::IsInclude( const ByteString & aFileName )
{
	return FALSE;
}

void ZipDep::InsertDir( const String &sWildCards )
{
	DirEntry aEntry( sWildCards );
	Dir aDir( aEntry, FSYS_KIND_FILE );

	for ( USHORT i = 0; i < aDir.Count(); i++ ) {
		ByteString *pFile = new ByteString( aDir[ i ].GetFull(), RTL_TEXTENCODING_ASCII_US );
//
// - match excludes
// - match includes
//
		if ( IsExclude( *pFile ) )
		{
			if ( IsInclude( *pFile ))
			{
				pFileList->PutString( pFile );
#ifdef DEBUG_VERBOSE
				fprintf( stderr, "%s\n", pFile->GetBuffer());
#endif
			}
		}
		else
		{
			pFileList->PutString( pFile );
#ifdef DEBUG_VERBOSE
			fprintf( stderr, "%s\n", pFile->GetBuffer());
#endif
		}
	}
	if ( bRecursive ) {
		Dir aDirDir( aEntry.GetPath(), FSYS_KIND_DIR );
		for ( USHORT j = 0; j < aDirDir.Count(); j++ ) {
			DirEntry aAct( aDirDir[ j ] );
			if (( aAct.GetName() != String::CreateFromAscii( "." )) &&
				( aAct.GetName() != String::CreateFromAscii( ".." )))
			{
				aAct += aEntry.GetName();
				InsertDir( aAct.GetFull());
			}
		}
	}
}

void ZipDep::Execute()
{
	ULONG nCount = pSourceList->Count();
	for ( ULONG n=0; n<nCount;n++)
	{
		ByteString *pStr = pSourceList->GetObject(n);
#ifdef DEBUG
		fprintf(stderr, "Source : %s\n", pStr->GetBuffer());
#endif
		if (( STRING_NOTFOUND != pStr->Search('*')) || ( STRING_NOTFOUND != pStr->Search('?')))
		{
			String sFile( *pStr, RTL_TEXTENCODING_ASCII_US );
			InsertDir( sFile );
		}
		else
		{
			DirEntry aEntry( *pStr );
			FileStat aStat( aEntry );
			if ( aStat.IsKind( FSYS_KIND_DIR ))
			{
#ifdef DEBUG_VERBOSE
				fprintf( stderr, "is directory: %s\n", pStr->GetBuffer());
#endif
				if ( bRecursive )
				{
					aEntry+=DirEntry( String::CreateFromAscii( "*" ));
					ByteString *ptttt = new ByteString( aEntry.GetFull(), RTL_TEXTENCODING_ASCII_US );
#ifdef DEBUG_VERBOSE
					fprintf( stderr, "inserting : %s\n", ptttt->GetBuffer());
#endif
					InsertDir( aEntry.GetFull());
				}
			}
			else
			{
				pFileList->PutString( pStr );
#ifdef DEBUG_VERBOSE
				fprintf( stderr, "insert single: %s\n", pStr->GetBuffer());
#endif
			}
		}
	}
}

static String aDelim = DirEntry::GetAccessDelimiter();
 
int
#ifdef WNT
_cdecl
#endif
main( int argc, char **argv )
{
	int c;
	int argpos = 0;
	int digit_optind = 0;
	char aBuf[255];
	char pOutputFileName[255];
	ByteString aSrsBaseName;
	BOOL bGotZipName = FALSE;
	BOOL bSource = FALSE;
	ByteString aRespArg;

	ZipDep *pDep = new ZipDep;

	for ( argpos = 1; argpos < argc; argpos++)
	{
#ifdef DEBUG
		fprintf(stderr, "Param : %d : %s\n", argpos, argv[argpos]);
#endif
		strcpy( aBuf, (const char *)argv[argpos] );
		if ( aBuf[0] != '-' )
		{
			if ( !bGotZipName )
			{
				strcpy(pOutputFileName, &aBuf[0]);
				bGotZipName = TRUE;
#ifdef DEBUG_VERBOSE
				fprintf(stderr, "outfile : %s\n", aBuf );
#endif
			}
			else
			{
				pDep->AddSource( argv[argpos]);
#ifdef DEBUG_VERBOSE
				fprintf(stderr, "source : %s\n", aBuf );
#endif
			}
		}
		else
		{
			c = aBuf[1];
			switch( c )
			{
				case 0:
#ifdef DEBUG_VERBOSE
					fprintf(stderr, "option \"-\" not useable with zipdep\n");
#endif
					break;
				case 'u' :
				case 'U' :
				case 'j' :
				case 'l' :
#ifdef DEBUG_VERBOSE
					fprintf(stderr, "option %c - ignored by zipdep\n",c );
#endif
					break;

				case 'r' :
#ifdef DEBUG_VERBOSE
					fprintf(stderr, "option r\n" );
#endif
					bRecursive = TRUE;
					break;
				case 'x' :
					while ( ++argpos < argc &&  *argv[argpos] != '-' )
					{
						pDep->AddExclude( argv[argpos]);
#ifdef DEBUG_VERBOSE
						strcpy( aBuf, (const char *)argv[argpos]);
						fprintf(stderr, "option x with Value %s\n", aBuf );
#endif
					}
					if ( argpos != argc )
						argpos--;
					break;

				case 'i' :
					while ( ++argpos < argc &&  *argv[argpos] != '-' )
					{
						pDep->AddInclude( argv[argpos]);
#ifdef DEBUG_VERBOSE
						strcpy( aBuf, (const char *)argv[argpos]);
						fprintf(stderr, "option i with Value %s\n", aBuf );
#endif
					}
					if ( argpos != argc )
						argpos--;
					break;

				case 'h' :
				case 'H' :
				case '?' :
					bHelp = TRUE;
					break;

				default:
#ifdef DEBUG_VERBOSE
					fprintf(stderr, "Unknown parameter error\n");
#endif
				;
			}
		}

	}

	if ( !bGotZipName )
		bHelp = TRUE;

	if ( bHelp )
	{
		fprintf(stderr, "ZipDep 0.1 (c)2000 StarOffice\n");
		fprintf( stderr, "No help available...\n");
		return 1;
	}

	ByteString aString;
	aString = ByteString( pOutputFileName );
	aString += ByteString(" : " );
	
	pDep->Execute();
	SByteStringList *pLst = pDep->GetDepList();
	ULONG nCount = pLst->Count();
	if ( nCount == 0 )
	{
		fprintf( stdout, "%s\n", aString.GetBuffer());
	}
	else
	{
		aString += ByteString( "\\" );
		fprintf( stdout, "%s\n", aString.GetBuffer());
	}

	for ( ULONG j=0; j<nCount; j++ )
	{
		ByteString *pStr = pLst->GetObject(j);
		if ( pStr->Search('*') == STRING_NOTFOUND )
		{
			if ( j != (nCount-1) )
				*pStr += ByteString( "\\" );
				fprintf( stdout, "\t%s\n", pStr->GetBuffer());
		}
	}
	delete pDep;
	
	return 0;
}




