/*************************************************************************
 *
 *  $RCSfile: optload.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: os $ $Date: 2001/07/10 06:28:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OPTLOAD_HXX
#define _OPTLOAD_HXX

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _GROUP_HXX
#include <vcl/group.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
#ifndef _SVX_STRARRAY_HXX
#include <svx/strarray.hxx>
#endif
#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif
#ifndef _SVX_CHECKLBX_HXX //autogen
#include <svx/checklbx.hxx>
#endif
#ifndef _SWLBOX_HXX
#include <swlbox.hxx>
#endif
#ifndef _CAPTION_HXX
#include <caption.hxx>
#endif

class SwFldMgr;
class SvLBoxEntry;
class SwWrtShell;

/*-----------------31.08.96 10.09-------------------

--------------------------------------------------*/

class SwLoadOptPage : public SfxTabPage
{
private:
    FixedLine   aUpdateFL;
    FixedText   aLinkFT;
    RadioButton aAlwaysRB;
	RadioButton	aRequestRB;
	RadioButton	aNeverRB;

    FixedText   aFieldFT;
    CheckBox    aAutoUpdateFields;
	CheckBox	aAutoUpdateCharts;

    FixedLine   aCaptionFL;
	CheckBox	aCaptionCB;
	FixedText	aCaptionFT;
	PushButton	aCaptionPB;

    FixedLine   aSettingsFL;
    FixedText   aMetricFT;
    ListBox     aMetricLB;
    FixedText   aTabFT;
	MetricField aTabMF;

    FixedLine   aCompatFL;
    CheckBox    aMergeDistCB;
	CheckBox 	aMergeDistPageStartCB;
    CheckBox    aTabAlignment;

	SwWrtShell*	pWrtShell;
    sal_Bool    bHTMLMode;
    UINT16      nLastTab;
    sal_Int32   nOldLinkMode;

    DECL_LINK(CaptionHdl, PushButton*);
    DECL_LINK(MetricHdl, ListBox*);
    DECL_LINK(UpdateHdl, CheckBox* );

public:
						SwLoadOptPage( Window* pParent,
										 const SfxItemSet& rSet );
						~SwLoadOptPage();

	static SfxTabPage*	Create( Window* pParent,
								const SfxItemSet& rAttrSet);

	virtual	BOOL 		FillItemSet( SfxItemSet& rSet );
	virtual	void 		Reset( const SfxItemSet& rSet );
};
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

class SwCaptionOptDlg : public SfxSingleTabDialog
{
public:
	 SwCaptionOptDlg(Window* pParent, const SfxItemSet& rSet);
	~SwCaptionOptDlg();
};
/* -----------------23.10.98 13:19-------------------
 *
 * --------------------------------------------------*/

class CaptionComboBox : public SwComboBox
{
protected:
	virtual void KeyInput( const KeyEvent& );

public:
	CaptionComboBox( Window* pParent, const ResId& rResId)
		: SwComboBox(pParent, rResId)
	{}
};

/*-----------------31.08.96 10.09-------------------

--------------------------------------------------*/
class SwCaptionOptPage : public SfxTabPage
{
private:
	SvxCheckListBox	aCheckLB;

	FixedText		aSampleText;
	FixedText		aCategoryText;
	CaptionComboBox	aCategoryBox;
	FixedText		aFormatText;
	ListBox			aFormatBox;
	FixedText		aTextText;
	Edit			aTextEdit;
	FixedText		aPosText;
	ListBox			aPosBox;
	FixedText 		aFtLevel;
	ListBox 		aLbLevel;
	FixedText 		aFtDelim;
	Edit 			aEdDelim;
    FixedLine       aSettingsGroupFL;

	String			sSWTable;
	String			sSWFrame;
	String			sSWGraphic;
	String			sOLE;

	String			sIllustration;
	String			sTable;
	String			sText;
    String          sDrawing;

	String			sBegin;
	String			sEnd;
	String			sAbove;
	String			sBelow;

	SwFldMgr		*pMgr;
	USHORT			eType;
	BOOL 			bHTMLMode;

	DECL_LINK( SelectHdl, ListBox *pLB = 0 );
	DECL_LINK( ModifyHdl, Edit *pEdt = 0 );
	DECL_LINK( ShowEntryHdl, SvxCheckListBox *pLB = 0 );
	DECL_LINK( SaveEntryHdl, SvxCheckListBox *pLB = 0 );

	void				DelUserData();
	void				SetOptions(	const USHORT nPos,
									const SwCapObjType eType,
									const SvGlobalName *pOleId = 0);
	void				SaveEntry( SvLBoxEntry* pEntry );
	void				DrawSample();

public:
						SwCaptionOptPage( Window* pParent,
										 const SfxItemSet& rSet );
						~SwCaptionOptPage();

	static SfxTabPage*	Create( Window* pParent,
								const SfxItemSet& rAttrSet);

	virtual	BOOL 		FillItemSet( SfxItemSet& rSet );
	virtual	void 		Reset( const SfxItemSet& rSet );
};

#endif


