/*************************************************************************
 *
 *  $RCSfile: excsdi.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: os $ $Date: 2001/09/28 07:52:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "filt_pch.hxx"
#endif

#pragma hdrstop

#include "exlpar.hxx"


/*
// -------------------------------------- SwExcelParser::ScanDokuInfos() -
void SwExcelParser::ScanDokuInfos()
	{
	// Sammelt Infos in Arbeitsmappen, um Selektion VOR Import zu ermoeglichen
	USHORT nOpcode, nLen;
	ULONG nLastPos;

	eDateiTyp = BiffX;

	// BOF suchen
	while( !pIn->IsEof() && eDateiTyp == BiffX )
		{
		nLastPos = pIn->Tell();
		*pIn >> nOpcode >> nLen;
		nBytesLeft = nLen;

		switch( nOpcode )
			{
			case 0x09:	Bof2(); break;			// BOF			[ 2   ]
			case 0x0209: Bof3(); break;			// BOF			[  3  ]
			case 0x0409: Bof4(); break;			// BOF			[   4 ]
			case 0x0809: Bof5(); break;			// BOF			[    5]
			}

		pIn->SeekRel( nBytesLeft );
		}

	if( eDateiTyp == Biff2 || eDateiTyp == Biff3 || eDateiTyp == Biff4 )
		{
		aExcDok.Set( nLastPos, 0 );	// Stream-Pos wissen wir schon!
		}

	// aufsplitten in Dateitypen
	switch( eDateiTyp )
		{
		case Biff2:		ScanBiff2();	break;
		case Biff3:		ScanBiff3();	break;
		case Biff3W:	ScanBiff3W();	break;
		case Biff4:		ScanBiff4();	break;
		case Biff4W:	ScanBiff4W();	break;
		case Biff5:
			DBG_ERROR( "+SwExcelParser::ScanDokuInfos(): Formatfehler Biff5" );
			break;
		case Biff5W:	ScanBiff5W();	break;
		default:
			DBG_ERROR( "+SwExcelParser::ScanDokuInfos(): Un' nun?" );
		}

	nTab = 0;
	pIn->Seek( 0 );

	// Daten vom ExcDok in DataPool uebertragen
#ifdef USED
	aDataPool << aExcDok;
#endif
	}
*/

#ifdef USED

// -----  XLS Biff2 - 4  -----
// ------------------------------------------ SwExcelParser::ScanBiff2() -
void SwExcelParser::ScanBiff2()
	{
	// hier brauchen wir nur noch die Dimensions und Namen
	USHORT nOpcode, nLen;
	BOOL bReady = FALSE;

	nTab = 0;

	while( !pIn->IsEof() && !bReady )
		{
		*pIn >> nOpcode >> nLen;
		nBytesLeft = nLen;

		switch( nOpcode )
			{
			case 0x00:	Dimensions(); break;	// DIMENSIONS	[ 2  5]
			case 0x01:							// BLANK		[ 2  5]
			case 0x03:							// NUMBER		[ 2  5]
			case 0x04:							// LABEL		[ 2  5]
			case 0x06:							// FORMULA		[ 2  5]
				bReady = TRUE;
				break;
			case 0x0A:	Eof();					// EOF			[ 2345]
				bReady = TRUE;
				break;
//			case 0x18:	Name25(); break;		// NAME			[ 2  5]
			case 0x1C:							// NOTE			[ 2345]
			case 0x21:							// ARRAY		[ 2  5]
				bReady = TRUE;
				break;
			}

		pIn->SeekRel( nBytesLeft );
		}
	//aExcDok.Set( String( "Table" ), 0 );	// nur eine Tabelle!
	aExcDok.Set( 0UL, 0 );					// ... und die steht...am Anfang!
	}

// ------------------------------------------ SwExcelParser::ScanBiff3() -
void SwExcelParser::ScanBiff3()
	{
	// hier brauchen wir nur noch die Dimensions und Namen
	USHORT nOpcode, nLen;
	BOOL bReady = FALSE;

	nTab = 0;

	while( !pIn->IsEof() && !bReady )
		{
		*pIn >> nOpcode >> nLen;
		nBytesLeft = nLen;

		switch( nOpcode )
			{
			case 0x0A:	Eof();					// EOF			[ 2345]
				bReady = TRUE;
				break;
			case 0x1C:							// NOTE			[ 2345]
				bReady = TRUE;
				break;
			case 0x0200: Dimensions(); break;	// DIMENSIONS	[  34 ]
			case 0x0201:						// BLANK		[  34 ]
			case 0x0203:						// NUMBER		[  34 ]
			case 0x0204:						// LABEL		[  34 ]
			case 0x0206:						// FORMULA		[  3  ]
				bReady = TRUE;
				break;
//			case 0x0218: Name34(); break;		// NAME			[  34 ]
			case 0x0221:						// ARRAY		[  34 ]
			case 0x027E:						// RK			[  34 ]
			case 0x0406:						// FORMULA		[   4 ]
				bReady = TRUE;
				break;
			}

		pIn->SeekRel( nBytesLeft );
		}
	aExcDok.Set( String( "Table" ), 0 );	// nur eine Tabelle!
	aExcDok.Set( 0UL, 0 );					// ... und die steht...am Anfang!
	}

// ------------------------------------------ SwExcelParser::ScanBiff4() -
void SwExcelParser::ScanBiff4()
	{
	ScanBiff3();	// reicht zur Zeit
	}

// -----  XLW Biff3 + 4  -----
// ----------------------------------------- SwExcelParser::ScanBiff3W() -
void SwExcelParser::ScanBiff3W()
	{
	DBG_ERROR( "-SwExcelParser::ScanBiff3W(): Noch nicht implementiert!" );
	}

// ----------------------------------------- SwExcelParser::ScanBiff4W() -
void SwExcelParser::ScanBiff4W()
	{
	//enum Zustand { _Globals, _Ende } eAkt;
	enum { _Globals, _SearchBundleHeader, _SearchDimensions } eAkt;
	USHORT nOpcode, nLen;
	nTab = 0;

	eAkt = _Globals;
	while( !pIn->IsEof() )
		{
		*pIn >> nOpcode >> nLen;
		nBytesLeft = nLen;

		switch( eAkt )
			{
			case _Globals:				// ----------------
				{
				switch( nOpcode )
					{
					case 0x0A:							// EOF			[ 2345]
						Eof();
						DBG_ERROR(
							"-SwExcelParser::ScanBiff4W(): EOF zu frueh!" );
						break;
					case 0x42:	Codepage(); break;		// CODEPAGE		[ 2345]
					case 0x55:	DefColWidth(); break;	// DEFCOLWIDTH	[ 2345]
					case 0x7D:	Colinfo(); break;		// COLINFO		[  345]
//					case 0x8C:	Country(); break;		// COUNTRY		[  345]
					case 0x8F:							// BUNDLEHEADER	[   4 ]
//						Bundleheader();
						eAkt = _SearchBundleHeader;
						break;
//					case 0x0218: Name34(); break;		// NAME			[  34 ]
					case 0x0231: Font34(); break;		// FONT			[  34 ]
					case 0x0443: XF4(); break;			// XF			[   4 ]
					}
				}
				break;
			case _SearchBundleHeader:	// ----------------
				{
				switch( nOpcode )
					{
					case 0x09:							// BOF			[ 2   ]
						DBG_ERROR( "-SwExcelParser::ScanBiff4W(): Biff3!" );
						break;
//					case 0x8F:	Bundleheader(); break;	// BUNDLEHEADER	[   4 ]
					case 0x0209: 						// BOF			[  3  ]
						DBG_ERROR( "-SwExcelParser::ScanBiff4W(): Biff3!" );
						break;
					case 0x0409:						// BOF			[   4 ]
						Bof4();
						eAkt = _SearchDimensions;
						break;
					case 0x0809:						// BOF			[    5]
						DBG_ERROR( "-SwExcelParser::ScanBiff4W(): Biff5!!!!" );
						break;
					}
				}
				break;
			case _SearchDimensions:		// ----------------
				{
				switch( nOpcode )
					{
					case 0x0A:							// EOF			[ 2345]
						Eof();
						eAkt = _SearchBundleHeader;
						break;
					case 0x0200:						// DIMENSIONS	[  34 ]
						Dimensions();
						eAkt = _SearchBundleHeader;
						nTab++;
						break;
					}
				}
				break;
			default:					// ----------------
				DBG_ERROR(
					"-SwExcelParser::ScanBiff4W(): in anderen Zustaenden?" );
			}

		pIn->SeekRel( nBytesLeft );
		}
	}
#endif

/*
// -----  XLS Biff5  -----
// ----------------------------------------- SwExcelParser::ScanBiff5W() -
void SwExcelParser::ScanBiff5W()
	{
	enum { _Globals, _SearchDimensions } eAkt;
	USHORT nOpcode, nLen;
	ExcTabelle *pAktTab = ( ExcTabelle * ) 1;
		// ACHTUNG: muss mit Uebergang von _Globals -> _SearchDimensions
		//				SINNVOLL gesetzt werden
	nTab = 0;

	eAkt = _Globals;
	while( !pIn->IsEof() && pAktTab )
		{
		*pIn >> nOpcode >> nLen;
		nBytesLeft = nLen;

		switch( eAkt )
			{
			case _Globals:				// ----------------
				{
				switch( nOpcode )
					{
					case 0x0A:							// EOF			[ 2345]
						Eof();
						pIn->SeekRel( nBytesLeft );
						eAkt = _SearchDimensions;
						pAktTab = aExcDok.GetFirstTab();
						if( pAktTab )
							pIn->Seek( pAktTab->GetStrPos() );
						nTab = 0;
						break;
//					case 0x18:	Name25(); break;		// NAME			[ 2  5]
					case 0x31:	Font25(); break;		// FONT			[ 2  5]
					case 0x42:	Codepage(); break;		// CODEPAGE		[ 2345]
					case 0x55:	DefColWidth(); break;	// DEFCOLWIDTH	[ 2345]
					case 0x7D:	Colinfo(); break;		// COLINFO		[  345]
					case 0x85:							// BOUNDSHEET	[    5]
						Boundsheet();
						nTab++;
						break;
//					case 0x8C:	Country(); break;		// COUNTRY		[  345]
					case 0x92:	Palette(); break;		// PALETTE		[  345]
					case 0x99:	Standardwidth(); break;	// STANDARDWIDTH[    5]
					case 0xE0:	XF5(); break;			// XF			[    5]
					}
				}
				break;
			case _SearchDimensions:		// ----------------
				{
				switch( nOpcode )
					{
					case 0x00:							// DIMENSIONS	[ 2  5]
						Dimensions();
						//break;
					case 0x01:							// BLANK		[ 2  5]
					case 0x03:							// NUMBER		[ 2  5]
					case 0x04:							// LABEL		[ 2  5]
					case 0x06:							// FORMULA		[ 2  5]
					case 0x0A:							// EOF			[ 2345]
					case 0x1C:							// NOTE			[ 2345]
					case 0x7E:							// RK			[    5]
					case 0xBD:							// MULRK		[    5]
					case 0xBE:							// MULBLANK		[    5]
					case 0xD6:							// RSTRING		[    5]
						pAktTab = aExcDok.GetNextTab();
						if( pAktTab )
							pIn->Seek( pAktTab->GetStrPos() );
						nTab++;
					}
				}
				break;
			default:					// ----------------
				DBG_ERROR(
					"-SwExcelParser::ScanBiff5W(): in anderen Zustaenden?" );
			}

		pIn->SeekRel( nBytesLeft );
		}
	}
*/



