/*************************************************************************
 *
 *  $RCSfile: docinfo.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:08:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _DOCVER_CXX

#pragma hdrstop

 #include <stdlib.h>	// fuer sprintf statt itoa
 #include <stdio.h>
 #include <string.h>

 #include <solar.h>

 #ifdef ZTC
  #include <fstream.hpp>
 #else
  #include <fstream.h>
 #endif

#ifdef UNX
 #include <unistd.h>		// fuer access
#else
// damit werden auch andere Plattformen (MAC!) nicht gluecklich
 #include <io.h>
#endif

#include "dmpstr.hxx"
#include "swgids.hxx"

// Dateikopf bis Version 0x0010

struct OldHeader {					// Dateikopf:
	long nSignature;				// Signatur: "SWG0"
	USHORT nVersion;				// aktuelle Version
	USHORT nFlags;					// Inhibit-Flags (s.u.)
	BYTE cAttrTab [8];				// Start-IDs der Attribute
	BYTE cAttrSiz [8];				// Laengen der Attribut-Gruppen
	BYTE cCodeSet;					// Zeichensatz des Systems
	BYTE cRes;						// Alignment auf Long
	USHORT nNumRules;				// Anzahl Numerierungs-Regeln
	long nAutoFmtOffset;			// Offset der Auto-Formate
	long nDocInfoOffset;			// Offset der Dokument-Info
	long nNumRulesOffset;			// Offset der Numerierungsregeln
	long nLayoutOffset;				// Offset der Layout-Frames
	long nRes [21];
};

class istream;

class MyStrm : public swistream {
public:
	MyStrm( istream& s ) : swistream( s ) {}
	void encode( char* p, USHORT l ) { swstream::encode( p, l ); }
};

class SwgChecker {

	void	LoadHeader();
	void	DumpHeader();
	void    StaticDocInfo();
public:
	MyStrm     r;
	DocHeader  aHdr;
	FileHeader aFile;
	BOOL	   bPasswd;

	SwgChecker( istream& );
	void	LoadFileHeader();
	BOOL	Read();
};

//////////////////////////////////////////////////////////////////////////////

static void DumpDate( long nDate, long nTime )
{
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ( nDate % 100) << ".";
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ((nDate / 100) % 100) << ".";
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ( nDate / 10000L) << " ";
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ((nTime / 1000000) % 100) << ":";
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ((nTime / 10000) % 100) << ":";
	cout.width( 2 );
	cout.fill( '0' );
	cout << (short) ((nTime / 100) % 100);
	cout.width( 0 );
	cout.fill( 0 );
}

SwgChecker::SwgChecker( istream& s ) : r( s )
{}

void SwgChecker::LoadFileHeader()
{
	memset( &aFile, 0, sizeof aFile );
	r.get( &aFile.nSignature, 4 );
	r >> aFile.nVersion;
	if( aFile.nVersion > SWG_VER_OLDHDR )
	{
		r.long4();
		r >> aFile.nFlags
		  >> aFile.nFree1;
		if( aFile.nVersion >= SWG_VER_FMTNAME )
		  r >> aFile.nDocInfo;
		r.get( aFile.cPasswd, 16 );
		r.long3();
	}
}

// Laden der Header-Informationen
// Ab Version 0x0011 ist der Header Bestandtail eines SWG_DOCUMENT-Records.
// Die Position zeigt auf den Beginn der Infos, also entweder hinter die
// Version (s.o.) oder auf den Beginn des SWG_DOCUMENT-Records.

void SwgChecker::LoadHeader()
{
	memset( &aHdr, 0, sizeof aHdr );
	if( aFile.nVersion > SWG_VER_OLDHDR )
	{
		// Ab Version 0x11:
		r.next();
		r >> aHdr.nFlags
		  >> aHdr.nVersion;
		r.get( aHdr.cAttrTab, 8 );
		r.get( aHdr.cAttrSiz, 8 );
		r.long4();
		r >> aHdr.cCodeSet
		  >> aHdr.nNumRules
		  >> aHdr.nDocVersion
		  >> aHdr.cGUIType
		  >> aHdr.cReserved[ 0 ]
		  >> aHdr.cReserved[ 1 ]
		  >> aHdr.cReserved[ 2 ]
		  >> aHdr.nDocInfoOffset
		  >> aHdr.nLayoutOffset;
		if( aHdr.nVersion >= SWG_VER_STAMP )
		  r >> aHdr.nDate >> aHdr.nTime;
		r.long3();
	} else {
		// Bis Version 0x10:
		BYTE cDummy;
		long nDummy;
		aHdr.nVersion = aFile.nVersion;
		r >> aHdr.nFlags;
		r.get( aHdr.cAttrTab, 8 );
		r.get( aHdr.cAttrSiz, 8 );
		r >> aHdr.cCodeSet
		  >> cDummy
		  >> aHdr.nNumRules
		  >> nDummy
		  >> aHdr.nDocInfoOffset
		  >> nDummy
		  >> aHdr.nLayoutOffset;
		r.seek( sizeof( OldHeader ) );
	}
}

/////////////////////////////////////////////////////////////////////////////

void SwgChecker::DumpHeader()
{
	static char* pCharset[] = { "Unbekannt", "ANSI/Windows", "Macintosh",
		"PC 437", "PC 850", "PC 860", "PC 861", "PC 863", "PC 865",
		"System", "Symbol", "PC 850" };
	static char* pGUI[] = { "Unbekannt", "Windows 3.x", "Presentation Manager",
		"Macintosh", "OSF Motif", "Open Windows", "Windows NT 3.x" };
	cout << "Version:        " << (aHdr.nVersion / 256 )
		 << '.' << (aHdr.nVersion % 256 ) << endl;
	if( aHdr.cCodeSet > 11 ) aHdr.cCodeSet = 0;
	if( aHdr.cGUIType > 6 ) aHdr.cGUIType = 0;
	cout << "Betriebssystem: " << pGUI[ aHdr.cGUIType ] << endl;
	cout << "Zeichensatz:    " << pCharset[ aHdr.cCodeSet ] << endl;
	if( aHdr.nDate )
	{
		cout << "Gespeichert am: ";
		DumpDate( aHdr.nDate, aHdr.nTime );
		cout << endl;
	}
	if( bPasswd && ( aFile.nFlags & SWGF_HAS_PASSWD ) )
	{
		static const BYTE cEncode[] =
		{ 0xAB, 0x9E, 0x43, 0x05, 0x38, 0x12, 0x4d, 0x44,
		  0xD5, 0x7e, 0xe3, 0x84, 0x98, 0x23, 0x3f, 0xba };
		r.copypasswd( (const char*) cEncode );
		char buf[ PASSWDLEN+2 ];
		memcpy( buf, aFile.cPasswd, PASSWDLEN );
		r.encode( buf, PASSWDLEN );
		buf[ PASSWDLEN ] = 0;
		cout << "Passwort:       " << buf << endl;
		r.copypasswd( aFile.cPasswd );
	}
	if( aFile.nFlags ) {
		const char* p = "Flags:          ";
		const char* q = "                ";
		if( aFile.nFlags & SWGF_BAD_FILE   )
			cout << p << "Schreibfehler (Datei zerstoert)" << endl, p = q;
		if( aFile.nFlags & SWGF_FIX_FMTS   )
			cout << p << "Nicht alle Formate gespeichert" << endl, p = q;
		if( aFile.nFlags & SWGF_NO_FRAMES  )
			cout << p << "fehlende oder unvollstaendige Layout-Infos" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_BLOCKS )
			cout << p << "Textbausteindatei" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_VERS   )
			cout << p << "enthaelt mehrere Versionen" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_PASSWD )
			cout << p << "passwortgeschuetzt" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_GRFLNK )
			cout << p << "Grafik-Verknuepfungen" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_DDELNK )
			cout << p << "DDE-Verknuepfungen" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_OLELNK )
			cout << p << "OLE-Verknuepfungen" << endl, p = q;
		if( aFile.nFlags & SWGF_PORT_GRAF  )
			cout << p << "Grafiken sind portabel" << endl, p = q;
		if( aFile.nFlags & SWGF_HAS_PGNUMS )
			cout << p << "eigene Seitennumerierung" << endl, p = q;
	}
}

static void InSwStamp( swistream& r, const char* p )
{
	r.long4();
	long nDate, nTime;
	char buf[ 32 ];
	r >> nDate >> nTime;
	r.get( buf, 32 );
	cout << p;
	if( buf[ 0 ] ) cout << buf << ", ";
	DumpDate( nDate, nTime );
	cout << endl;
	r.long3();
}

static void InSwDocString( swistream& r, const char* p, short nLen )
{
	char buf[ 256 ];
	r.get( buf, nLen );
	if( buf[ 0 ] )
		cout << p << buf << endl;
}

// UserKeys:

static void InSwUserKey( swistream& r, short n )
{
	char buf1[20], buf2[20];
	r.get( buf1, 20 );
	r.get( buf2, 20 );
	if( buf1[0] || buf2[0] )
	{
		cout << "Info " << n << ":         ";
		if( buf1[0] ) cout << buf1;
		if( buf2[0] ) cout << ", Keyword = " << buf2;
		cout << endl;
	}
}

// Einlesen der statischen Dokument-Infos in das pInfo-Feld

static void ReadDocSaveInfo( swistream& r )
{
	InSwStamp( r, "Eingerichtet:   " );
	InSwStamp( r, "Geaendert:      " );
	InSwStamp( r, "Gedruckt:       " );
	InSwDocString( r, "Titel:          ", 64 );
	InSwDocString( r, "Thema:          ", 64 );
	InSwDocString( r, "Kommentar:      ", 256 );
	InSwDocString( r, "Schluesselwort: ", 128 );
	USHORT n;
	r >> n;
	for( USHORT i = 0; i < n; i++ )
		InSwUserKey( r, i );
}

void SwgChecker::StaticDocInfo()
{
	USHORT n, i;
	BYTE cGUIType, cCharSet;

	cout << "----------------" << endl;
	r.seek( aFile.nDocInfo - 4 );
	while( r.good() )
	{
		switch( r.next() )
		{
			case SWGINF_DBNAME:
				cout << "Datenbankname:  " << r.text() << endl;
				break;
			case SWGINF_LAYOUTPR:
				cout << "Layoutdrucker:  " << r.text() << endl;
				break;
			case SWGINF_AUTHOR:
				cout << "Autor:          " << r.text() << endl;
			case SWGINF_DOCSTAT: {
				USHORT nTbl, nGrf, nOLE, nPage, nPara;
				ULONG nWord, nChar;
				r >> nTbl >> nGrf >> nOLE >> nPage >> nPara >> nWord >> nChar;
				cout << "Tabellen:       " << nTbl << endl;
				cout << "Grafiken:       " << nGrf << endl;
				cout << "OLE-Ojekte:     " << nOLE << endl;
				cout << "Seiten:         " << nPage << endl;
				cout << "Absaetze:       " << nPara << endl;
				cout << "Worte:          " << nWord << endl;
				cout << "Zeichen:        " << nChar << endl;
				} break;
			case SWGINF_SAVEINFO:
				ReadDocSaveInfo( r ); break;
				break;
			case SWGINF_END:
				return;
			default:
				// wird ignoriert
				r.skip();
		}
	}

}

BOOL SwgChecker::Read()
{
	const char* p;
	LoadHeader();
	if( !r ) return FALSE;
	DumpHeader();
	r.next();
	BOOL bDone = FALSE;
	while( r.good()  && !bDone ) {
		BYTE ch = r.cur();
		switch( ch ) {
			case SWG_COMMENT:
				p = r.text();
				while( *p == ' ' ) p++;
				cout << "Writer-Version: " << p << endl;
			case SWG_EOF:
				bDone = TRUE; break;
			case SWG_TEXT:
			case SWG_DOCINFO:
				StaticDocInfo(); break;
			case SWG_JOBSETUP:
			case SWG_OUTLINE:
			case SWG_NUMRULE:
			case SWG_NUMRULES:
			case SWG_MACROTBL:
			case SWG_LAYOUT:
			case SWG_AUTOFMTS:
			case SWG_NAMEDFMTS:
			case SWG_DFLTFMTS:
			case SWG_FLYFRAMES:
			case SWG_FIELDTYPES:
			case SWG_COLLECTIONS:
			case SWG_COLLDERIVED:
			case SWG_COLLNEXT:
			case SWG_FOOTINFO:
			case SWG_CONTENTS:
			case SWG_FRAMES:
				r.skipnext(); break;
			default:
				cout << "Lesefehler! Record unbekannt: " << dec << ch
					 << hex << " (" << ch << ")" << dec << endl;
				exit( 1 );
		}
	}
	return TRUE;
}

int main( int argc, char** argv )
{
	char cName [80];
	if( argc < 2 || argc > 3 ) {
		cerr << "Aufruf: DOCVER Dateiname" << endl;
		return( 1 );
	}
	BOOL bPass = FALSE;
	strcpy( cName, *++argv );
	if( !strcmp( cName, "-Passwd" ) )
	{
		bPass = TRUE;
		strcpy( cName, *++argv );
	}
	strlwr( cName );
	char* p = cName + strlen( cName );
	do {
		p--;
		if( *p == '\\' || *p == ':' ) {
			p = NULL; break;
		}
		if( *p == '.' ) break;
	} while( p != cName );
	if( p == cName ) p = NULL;
	if( p ) {
		// voller Name
		if( access( cName, 0 ) ) {
			cerr << "Kann Datei " << *argv << " nicht finden!" << endl;
			return( 1 );
		}
	} else {
		p = cName + strlen( cName );
		strcpy( p, ".sdw" );
		if( access( cName, 0 ) ) {
			strcpy( p, ".vor" );
			if( access( cName, 0 ) ) {
				strcpy( p, ".bau" );
				if( access( cName, 0 ) ) {
					cerr << "Kann Datei " << *argv << " nicht finden!" << endl;
					return( 1 );
				}
			}
		}
	}
#if defined( __ZTC__ ) || defined( UNX )
		ifstream f( cName, ios::in );
#else
		ifstream f( cName, ios::in | ios::binary );
#endif
	if( !f ) {
		cerr << "Kann Datei " << cName << " nicht oeffnen!" << endl;
		return( 1 );
	}
	SwgChecker aRdr( f );
	aRdr.bPasswd = bPass;
	aRdr.LoadFileHeader();
	if( strncmp( (const char*) &aRdr.aFile.nSignature, SWG_SIGNATURE, 3 ) )
	{
		cout << "Datei " << cName << " ist keine SW/G-Datei!" << endl;
		return( 1 );
	}
	cout << "Datei:          " << cName << endl;
	aRdr.Read();
	return 0;
}


