/*************************************************************************
 *
 *  $RCSfile: _ximp.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: ka $ $Date: 2001/11/08 13:08:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>
#include <math.h>
#include <vcl/svapp.hxx>
#include <vcl/poly.hxx>
#include <vcl/gradient.hxx>
#include <vcl/virdev.hxx>
#include <vcl/gdimtf.hxx>
#include <vcl/metaact.hxx>
#include <vcl/salbtype.hxx>
#include <vcl/wrkwin.hxx>
#include <goodies/grfmgr.hxx>
#include "xpoly.hxx"
#include "xattr.hxx"
#include "xoutbmp.hxx"
#include "xoutx.hxx"

// -----------
// - Statics -
// -----------

#ifdef MAC
	const BOOL XIMP_bDrawRasterOps = FALSE;
#else
	const BOOL XIMP_bDrawRasterOps = TRUE;
#endif

// -----------
// - Defines -
// -----------

#define FILL_TILE 200

// ----------------
// - XOuputDevice -
// ----------------

void XOutputDevice::DrawFillPolyPolygon( const PolyPolygon& rPolyPoly, BOOL bRect )
{
	if( ( eFillStyle != XFILL_NONE ) && iRotTransGradient() &&
		( eFillStyle != XFILL_SOLID || iRotTransGradient()->GetStartColor() != iRotTransGradient()->GetEndColor() ) )
	{
		XGradient&		rTransGradient = *iRotTransGradient();
		Gradient		aVCLGradient;
		GDIMetaFile		aMtf;
		VirtualDevice	aVDev;
		OutputDevice*	pOldOut = pOut;
		const Rectangle	aBound( rPolyPoly.GetBoundRect() );
		MapMode			aMap( pOldOut->GetMapMode() );

		pOut = &aVDev;
		aVDev.EnableOutput( FALSE );
		aVDev.SetMapMode( pOldOut->GetMapMode() );
		aMtf.Record( &aVDev );
		aVDev.SetLineColor( pOldOut->GetLineColor() );
		aVDev.SetFillColor( pOldOut->GetFillColor() );
		aVDev.SetFont( pOldOut->GetFont() );
		aVDev.SetDrawMode( pOldOut->GetDrawMode() );
		aVDev.SetRefPoint( pOldOut->GetRefPoint() );
		ImpDrawFillPolyPolygon( rPolyPoly, bRect, pOldOut->GetOutDevType() == OUTDEV_PRINTER );
		aMtf.Stop();
		aMtf.WindStart();
		aMap.SetOrigin( aBound.TopLeft() );
		aMtf.SetPrefMapMode( aMap );
		aMtf.SetPrefSize( aBound.GetSize() );
		pOut = pOldOut;

		aVCLGradient.SetStyle((GradientStyle)rTransGradient.GetGradientStyle());
		aVCLGradient.SetStartColor(rTransGradient.GetStartColor());
		aVCLGradient.SetEndColor(rTransGradient.GetEndColor());
		aVCLGradient.SetAngle((USHORT)rTransGradient.GetAngle());
		aVCLGradient.SetBorder(rTransGradient.GetBorder());
		aVCLGradient.SetOfsX(rTransGradient.GetXOffset());
		aVCLGradient.SetOfsY(rTransGradient.GetYOffset());
		aVCLGradient.SetStartIntensity(rTransGradient.GetStartIntens());
		aVCLGradient.SetEndIntensity(rTransGradient.GetEndIntens());
		aVCLGradient.SetSteps(rTransGradient.GetSteps());

		pOut->DrawTransparent( aMtf, aBound.TopLeft(), aBound.GetSize(), aVCLGradient );
	}
	else
		ImpDrawFillPolyPolygon( rPolyPoly, bRect, pOut->GetOutDevType() == OUTDEV_PRINTER );
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawFillPolyPolygon( const PolyPolygon& rPolyPoly, BOOL bRect, BOOL bPrinter )
{
	if( eFillStyle != XFILL_NONE )
	{
		const Color aOldLineColor( pOut->GetLineColor() );
		const ULONG	nDrawMode = pOut->GetDrawMode();

		pOut->SetLineColor();

		if( eFillStyle == XFILL_SOLID )
		{
			if( nFillTransparence )
				pOut->DrawTransparent( rPolyPoly, nFillTransparence );
			else
				pOut->DrawPolyPolygon( rPolyPoly );
		}
		else if( eFillStyle == XFILL_HATCH )
		{
			long		nAngle10 = aHatch.GetAngle() % 3600;
			HatchStyle	eStyle;

			if( nAngle10 < 0 )
				nAngle10 += 3600;

			switch( aHatch.GetHatchStyle() )
			{
				case( XHATCH_TRIPLE ): eStyle = HATCH_TRIPLE; break;
				case( XHATCH_DOUBLE ): eStyle = HATCH_DOUBLE; break;

				default:
					eStyle = HATCH_SINGLE;
				break;
			}

			if( iSolidHatch() )
				pOut->DrawPolyPolygon( rPolyPoly );

			pOut->DrawHatch( rPolyPoly, Hatch( eStyle, aHatch.GetColor(), aHatch.GetDistance(), (USHORT) nAngle10 ) );
		}
		else if( eFillStyle == XFILL_GRADIENT )
		{
			GDIMetaFile*	pMtf = pOut->GetConnectMetaFile();
			Gradient		aVCLGradient;


			aVCLGradient.SetStyle((GradientStyle)aGradient.GetGradientStyle());
			aVCLGradient.SetStartColor(aGradient.GetStartColor());
			aVCLGradient.SetEndColor(aGradient.GetEndColor());
			aVCLGradient.SetAngle((USHORT)aGradient.GetAngle());
			aVCLGradient.SetBorder(aGradient.GetBorder());
			aVCLGradient.SetOfsX(aGradient.GetXOffset());
			aVCLGradient.SetOfsY(aGradient.GetYOffset());
			aVCLGradient.SetStartIntensity(aGradient.GetStartIntens());
			aVCLGradient.SetEndIntensity(aGradient.GetEndIntens());
			aVCLGradient.SetSteps(aGradient.GetSteps());

			if( bRect )
				pOut->DrawGradient( rPolyPoly.GetBoundRect(), aVCLGradient );
			else
				pOut->DrawGradient( rPolyPoly, aVCLGradient );
		}
		else if( eFillStyle == XFILL_BITMAP )
		{
			if( nDrawMode & DRAWMODE_WHITEFILL )
			{
				const Color aOldFillColor( pOut->GetFillColor() );

				pOut->SetFillColor( COL_WHITE );
				pOut->DrawPolyPolygon( rPolyPoly );
				pOut->SetFillColor( aOldFillColor );
			}
			else
			{
				Rectangle       aPolyRect( rPolyPoly.GetBoundRect() );
				GDIMetaFile*    pMtf = pOut->GetConnectMetaFile();

				pOut->Push();
				pOut->SetRasterOp( ROP_OVERPAINT );

				if( pMtf && !bPrinter )
				{
					if( XIMP_bDrawRasterOps )
					{
						pOut->SetRasterOp( ROP_XOR );
						ImpDrawBitmapFill( aPolyRect, bPrinter );

						pOut->Push( PUSH_FILLCOLOR );
						pOut->SetFillColor( COL_BLACK );
						pOut->SetRasterOp( ROP_0 );
						pOut->DrawPolyPolygon( rPolyPoly );
						pOut->Pop();

						pOut->SetRasterOp( ROP_XOR );
						ImpDrawBitmapFill( aPolyRect, bPrinter );
					}
					else
					{
						pOut->IntersectClipRegion( rPolyPoly );
						ImpDrawBitmapFill( aPolyRect, bPrinter );
					}
				}
				else if( bRect || bPrinter || Application::IsRemoteServer() )
				{
					pOut->IntersectClipRegion( rPolyPoly );
					ImpDrawBitmapFill( aPolyRect, bPrinter );
				}
				else
				{
					VirtualDevice   aMemDev;
					PolyPolygon		aPolyPoly( pOut->LogicToPixel( rPolyPoly ) );
                    Rectangle		aPolyRectPix( pOut->LogicToPixel( aPolyRect ) );
					Point			aPoint;
					Rectangle		aOutputRectPix( aPoint, pOut->GetOutputSizePixel() );
                    const BOOL      bOldMap = pOut->IsMapModeEnabled();

                    pOut->EnableMapMode( FALSE );

                    aOutputRectPix.Intersection( aPolyPoly.GetBoundRect() );
                    
					// add one pixel to avoid mapping differences
					aOutputRectPix.Right() += 2, aOutputRectPix.Bottom() += 2;
					const Size aVDevSizePix( aOutputRectPix.GetSize() );

					pOut->IntersectClipRegion( aPolyRectPix );
					aMemDev.SetOutputSizePixel( aVDevSizePix );
					aMemDev.DrawOutDev( Point(), aVDevSizePix, aOutputRectPix.TopLeft(), aVDevSizePix, *pOut );
                    
                    pOut->EnableMapMode( bOldMap );
					ImpDrawBitmapFill( aPolyRect, bPrinter );
                    pOut->EnableMapMode( FALSE );
					
                    aMemDev.SetRasterOp( ROP_XOR );
					aMemDev.DrawOutDev( Point(), aVDevSizePix, aOutputRectPix.TopLeft(), aVDevSizePix, *pOut );

					aMemDev.Push( PUSH_FILLCOLOR );
					aMemDev.SetFillColor( COL_BLACK );
					aMemDev.SetRasterOp( ROP_0 );
					aPolyPoly.Move( -aOutputRectPix.Left(), -aOutputRectPix.Top() );
					aMemDev.DrawPolyPolygon( aPolyPoly );
					aMemDev.Pop();

					pOut->SetRasterOp( ROP_XOR );
					pOut->DrawOutDev( aOutputRectPix.TopLeft(), aVDevSizePix, Point(), aVDevSizePix, aMemDev );

                    pOut->EnableMapMode( bOldMap );
				}

				pOut->Pop();
			}
		}

		pOut->SetLineColor( aOldLineColor );
	}
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawBitmapFill( const Rectangle& rRect, BOOL bPrinter )
{
	// Ausgabe-Position und -Groesse bestimmen
	ImpCalcBmpFillStartValues( rRect, bPrinter );

	if( ( mbBmpTile || !mbBmpStretch ) && ( !maFillBitmapSize.Width() || !maFillBitmapSize.Height() ) )
		return;

	if( !pOut->GetConnectMetaFile() || bPrinter )
	{
		if ( mbBmpTile )
			ImpDrawTiledBitmap( pOut, rRect, maStartPoint, rRect, bPrinter );
		else
		{
			if( mbBmpStretch )
                mpFillGraphicObject->Draw( pOut, rRect.TopLeft(), rRect.GetSize(), NULL, GRFMGR_DRAW_CACHED );
			else
			{
				Point aPos( rRect.TopLeft() );

				aPos.X() += ( rRect.GetWidth() - maFillBitmapSize.Width() ) >> 1;
				aPos.Y() += ( rRect.GetHeight() - maFillBitmapSize.Height() ) >> 1;

                mpFillGraphicObject->Draw( pOut, aPos, maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );
			}
		}
	}
	// Mtf-Aufzeichnung
	else
	{
		pOut->Push();

		if( mbBmpTile )
		{
			VirtualDevice	aVDev;
			MapMode			aMap( pOut->GetMapMode().GetMapUnit() );

			aVDev.SetOutputSizePixel( pOut->LogicToPixel( rRect, aMap ).GetSize() );
			aMap.SetOrigin( Point( -rRect.Left(), -rRect.Top() ) );
			aVDev.SetMapMode( aMap );

			ImpDrawTiledBitmap( &aVDev, rRect, maStartPoint, rRect, bPrinter );
            GraphicObject aTmpGraphic( aVDev.GetBitmap( rRect.TopLeft(), aVDev.GetOutputSize() ) );
            aTmpGraphic.Draw( pOut, rRect.TopLeft(), rRect.GetSize(), NULL, GRFMGR_DRAW_CACHED );
		}
		else
		{
			if( mbBmpStretch )
                mpFillGraphicObject->Draw( pOut, rRect.TopLeft(), rRect.GetSize(), NULL, GRFMGR_DRAW_CACHED );
			else
			{
				Point aPos( rRect.TopLeft() );

				aPos.X() += ( rRect.GetWidth() - maFillBitmapSize.Width() ) >> 1;
				aPos.Y() += ( rRect.GetHeight() - maFillBitmapSize.Height() ) >> 1;

				// in MetaFiles machen wir den Hintergrund weiss
				// das Poppen macht das Selektieren der Brush
				// wieder rueckgaengig
				PolyPolygon	aPolyPoly( 2 );
				aPolyPoly.Insert( Polygon( rRect ) );
				aPolyPoly.Insert( Polygon( Rectangle( aPos, maFillBitmapSize ) ) );

				pOut->SetFillColor( Color( COL_WHITE ) );
				pOut->SetLineColor();
				pOut->DrawPolyPolygon( aPolyPoly );
                mpFillGraphicObject->Draw( pOut, aPos, maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );
			}
		}

		pOut->Pop();
	}
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpCalcBmpFillStartValues( const Rectangle& rRect, BOOL bPrinter )
{
    GDIMetaFile*    pMtf = pOut->GetConnectMetaFile();
	const MapMode	aDstMapMode( pOut->GetMapMode().GetMapUnit() );
	BOOL			bOriginalSize = FALSE, bScaleSize = FALSE;

	// Falls keine Groessen gegeben sind ( z.B. alte Dokumente )
	// berechnen wir uns die Groesse selber aus der Bitmap
	// ==> altes Verhalten;
	// wenn nur eine Groesse gegeben ist, wird die andere
	// Groesse angepasst berechnet
	if( mbBmpLogSize )
	{
		if( !maBmpSize.Width() && !maBmpSize.Height() )
			bOriginalSize = TRUE;
		else if( !maBmpSize.Width() || !maBmpSize.Height() )
			bScaleSize = TRUE;
	}
	else
	{
		if( !mnBmpPerCentX && !mnBmpPerCentY )
			bOriginalSize = TRUE;
		else if( !mnBmpPerCentX || !mnBmpPerCentY )
			bScaleSize = TRUE;
	}

	// entweder Originalgroesse oder angepasste Groesse
	if( bOriginalSize || bScaleSize )
	{
		MapMode aBmpPrefMapMode( maFillBitmap.GetPrefMapMode() );
		Size    aBmpPrefSize( maFillBitmap.GetPrefSize() );

		// Falls keine gesetzt ist, nehmen wir Pixel
		if( !aBmpPrefSize.Width() || !aBmpPrefSize.Height() )
        {
			aBmpPrefSize = maFillBitmap.GetSizePixel();
            aBmpPrefMapMode = MAP_PIXEL;
        }

		if( bOriginalSize )
		{
			if( MAP_PIXEL == aBmpPrefMapMode.GetMapUnit() )
				maBmpOutputSize = Application::GetDefaultDevice()->PixelToLogic( aBmpPrefSize, aDstMapMode );
			else
				maBmpOutputSize = OutputDevice::LogicToLogic( aBmpPrefSize, aBmpPrefMapMode, aDstMapMode );
		}
		else
		{
			if( mbBmpLogSize )
			{
				if( !maBmpSize.Width() )
					maBmpSize.Width() = FRound( (double) maBmpSize.Height() * aBmpPrefSize.Width() / aBmpPrefSize.Height() );
				else
					maBmpSize.Height() = FRound( (double) maBmpSize.Width() * aBmpPrefSize.Height() / aBmpPrefSize.Width() );

				maBmpOutputSize = maBmpSize;
			}
			else
			{
				if( !mnBmpPerCentX )
				{
					maBmpOutputSize.Height() = FRound( (double) rRect.GetHeight() * mnBmpPerCentY / 100. );
					maBmpOutputSize.Width() = FRound( (double) maBmpOutputSize.Height() * aBmpPrefSize.Width() / aBmpPrefSize.Height() );
				}
				else
				{
					maBmpOutputSize.Width() = FRound( (double) rRect.GetWidth() * mnBmpPerCentX / 100. );
					maBmpOutputSize.Height() = FRound( (double) maBmpOutputSize.Width() * aBmpPrefSize.Height() / aBmpPrefSize.Width() );
				}
			}
		}
	}
	// ansonsten koennen wir die Groesse leicht selber berechnen
	else
	{
		if( mbBmpLogSize )
			maBmpOutputSize = maBmpSize;
		else
		{
			maBmpOutputSize.Width() = FRound( (double) rRect.GetWidth() * mnBmpPerCentX / 100. );
			maBmpOutputSize.Height() = FRound( (double) rRect.GetHeight() * mnBmpPerCentY / 100. );
		}
	}

	// nur bei Kachelung die anderen Positionen berechnen
	if( mbBmpTile )
	{
		// Grundposition der ersten Kachel berechen;
		// Diese Position wird spaeter zur Berechnung der absoluten
		// Startposition links oberhalb des Objektes benutzt
		switch( meBmpRectPoint )
		{
			case( RP_MT ):
			{
				maStartPoint.X() = rRect.Left() + ( ( rRect.GetWidth() - maBmpOutputSize.Width() ) >> 1 );
				maStartPoint.Y() = rRect.Top();
			}
			break;

			case( RP_RT ):
			{
				maStartPoint.X() = rRect.Right() - maBmpOutputSize.Width();
				maStartPoint.Y() = rRect.Top();
			}
			break;

			case( RP_LM ):
			{
				maStartPoint.X() = rRect.Left();
				maStartPoint.Y() = rRect.Top() + ( ( rRect.GetHeight() - maBmpOutputSize.Height() ) >> 1  );
			}
			break;

			case( RP_MM ):
			{
				maStartPoint.X() = rRect.Left() + ( ( rRect.GetWidth() - maBmpOutputSize.Width() ) >> 1 );
				maStartPoint.Y() = rRect.Top() + ( ( rRect.GetHeight() - maBmpOutputSize.Height() ) >> 1 );
			}
			break;

			case( RP_RM ):
			{
				maStartPoint.X() = rRect.Right() - maBmpOutputSize.Width();
				maStartPoint.Y() = rRect.Top() + ( ( rRect.GetHeight() - maBmpOutputSize.Height() ) >> 1 );
			}
			break;

			case( RP_LB ):
			{
				maStartPoint.X() = rRect.Left();
				maStartPoint.Y() = rRect.Bottom() - maBmpOutputSize.Height();
			}
			break;

			case( RP_MB ):
			{
				maStartPoint.X() = rRect.Left() + ( ( rRect.GetWidth() - maBmpOutputSize.Width() ) >> 1 );
				maStartPoint.Y() = rRect.Bottom() - maBmpOutputSize.Height();
			}
			break;

			case( RP_RB ):
			{
				maStartPoint.X() = rRect.Right() - maBmpOutputSize.Width();
				maStartPoint.Y() = rRect.Bottom() - maBmpOutputSize.Height();
			}
			break;

			// default linke obere Ecke
			default:
				maStartPoint = rRect.TopLeft();
			break;
		}

		// X- oder Y-Positionsoffset beruecksichtigen
		if( mnBmpOffPosX )
			maStartPoint.X() += ( maBmpOutputSize.Width() * mnBmpOffPosX / 100 );

        if( mnBmpOffPosY )
			maStartPoint.Y() += ( maBmpOutputSize.Height() * mnBmpOffPosY / 100 );

		// echten Startpunkt berechnen ( links oben )
		if( maBmpOutputSize.Width() && maBmpOutputSize.Height() )
		{
			const long nDiffX = maStartPoint.X() - rRect.Left();
			const long nDiffY = maStartPoint.Y() - rRect.Top();

			if ( nDiffX )
			{
				long nCount = nDiffX / maBmpOutputSize.Width() + 1;

				if ( mnBmpOffY && ( nCount & 1L ) )
					nCount++;

				maStartPoint.X() -= ( nCount * maBmpOutputSize.Width() );
			}

			if ( nDiffY )
			{
				long nCount = nDiffY / maBmpOutputSize.Height() + 1;

				if ( mnBmpOffX && ( nCount & 1L ) )
					nCount++;

				maStartPoint.Y() -= ( nCount * maBmpOutputSize.Height() );
			}
		}
	}

    if( mbRecalc )
    {
        mpFillGraphicObject->SetGraphic( maFillBitmap );

        const Size aBmpSizePix( maFillBitmap.GetSizePixel() );

        // create intermediate bitmap if neccessary
        if( mbBmpTile && ( aBmpSizePix.Width() < 70 && aBmpSizePix.Height() < 70 ) && !maFillBitmap.IsEmpty() )
        {
            VirtualDevice   aVDev;
            Point           aPt;
            const long      nIntermediateExtent = 256;
			long            nCountX = (USHORT) ( nIntermediateExtent / aBmpSizePix.Width() + 1 );
			long            nCountY = (USHORT) ( nIntermediateExtent / aBmpSizePix.Height() + 1 );

			if( nCountX & 1 )
				nCountX++;

			if( nCountY & 1 )
				nCountY++;

			const Size      aNewSize( nCountX * aBmpSizePix.Width(), nCountY * aBmpSizePix.Height() );
            const Rectangle aIntermediateRect( aPt, aNewSize );

            aVDev.SetOutputSizePixel( aNewSize );
            maBmpOutputSize.Width() *= nCountX;
            maBmpOutputSize.Height() *= nCountY;
            mbIntermediateBmp = FALSE;
            maFillBitmapSize = aBmpSizePix;
            ImpDrawTiledBitmap( &aVDev, aIntermediateRect, aPt, aIntermediateRect, FALSE );
            mpFillGraphicObject->SetGraphic( aVDev.GetBitmap( aPt, aNewSize ) );
            mbIntermediateBmp = TRUE;
        }
        else
            mbIntermediateBmp = FALSE;

        maFillBitmapSize = maBmpOutputSize;
    }

	if( !pMtf )
    	mbRecalc = FALSE;
}

// ------------------------------------------------------------------------

void XOutputDevice::ImpDrawTiledBitmap( OutputDevice* pOutDev, const Rectangle& rRect,
										const Point& rStartPoint, const Rectangle& rClipRect,
                                        BOOL bPrinter )
{
    Point  		    aPixOrg;
    Point           aOrg;
    const Rectangle aPixRect( pOutDev->LogicToPixel( rRect ) ) ;
    const Rectangle aPixClipRect( pOutDev->LogicToPixel( rClipRect ) ) ;
    const Point     aPixPos( pOutDev->LogicToPixel( rStartPoint ) );
    const Size      aPixSize( pOutDev->LogicToPixel( maFillBitmapSize ) );

	if( mbIntermediateBmp )
	{
        aPixOrg = aPixPos;

		while( aPixOrg.Y() < aPixRect.Bottom() )
		{
			while( aPixOrg.X() < aPixRect.Right() )
			{
				if( !Rectangle( aPixOrg, aPixSize ).Intersection( aPixClipRect ).IsEmpty() )
                    mpFillGraphicObject->Draw( pOutDev, pOutDev->PixelToLogic( aPixOrg ), maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );

				aPixOrg.X() += aPixSize.Width();
			}

            aPixOrg.X() = aPixPos.X();
            aPixOrg.Y() += aPixSize.Height();
		}
	}
	else
	{
		const long	nOffX = aPixSize.Width() - aPixSize.Width() * mnBmpOffX / 100;
		const long	nOffY = aPixSize.Height() - aPixSize.Height() * mnBmpOffY / 100;
		long		nCountX = ( aPixRect.Right() - aPixPos.X() ) / aPixSize.Width() + 1;
		long		nCountY = ( aPixRect.Bottom() - aPixPos.Y() ) / aPixSize.Height() + 1;
		BOOL		bDraw;

		// Falls Kacheln untereinander verschoben,
		// muessen wir noch eine zusaetzliche Zeile
		// oder Spalte ausgeben
		if( mnBmpOffX )
			nCountX++;
		else if( mnBmpOffY )
			nCountY++;

		long nCountX1 = nCountX - 1;
		long nCountY1 = nCountY - 1;

        aPixOrg = aPixPos;

		// Kachelung ausgeben
		for ( long nY = 0; nY < nCountY; nY++ )
		{
			for ( long nX = 0; nX < nCountX; nX++ )
			{
				bDraw = FALSE;

				if( mnBmpOffX && ( nY & 1 ) )
				{
					bDraw = TRUE;
					aOrg = Point( aPixOrg.X() - nOffX, aPixOrg.Y() );
				}
				else if( mnBmpOffY && ( nX & 1 ) )
				{
					bDraw = TRUE;
					aOrg = Point( aPixOrg.X(), aPixOrg.Y() - nOffY );
				}
				else
				{
					if( mnBmpOffX )
					{
						// Nicht-Offset-Tiles ausser in der letzten Spalte immer zeichnen
						if( nX < nCountX1 )
							bDraw = TRUE;
					}
					else if( mnBmpOffY )
					{
						// Nicht-Offset-Tiles ausser in der letzten Zeile immer zeichnen
						if( nY < nCountY1 )
							bDraw = TRUE;
					}
					else
						bDraw = TRUE;

    				aOrg = aPixOrg;
				}

				// ausgeben, wenn innerhalb des Objektes und innerhalb
				// des gueltigen Clipping-Bereiches
				if ( bDraw && !Rectangle( aOrg, aPixSize ).Intersection( aPixClipRect ).IsEmpty() )
                    mpFillGraphicObject->Draw( pOutDev, pOutDev->PixelToLogic( aOrg ), maFillBitmapSize, NULL, GRFMGR_DRAW_CACHED );

                aPixOrg.X() += aPixSize.Width();
			}

            aPixOrg.X() = aPixPos.X();
            aPixOrg.Y() += aPixSize.Height();
		}
	}
}
