/*************************************************************************
 *
 *  $RCSfile: polyob3d.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: thb $ $Date: 2001/07/17 07:04:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "svdstr.hrc"
#include "svdglob.hxx"

#ifndef _INC_FLOAT
#include <float.h>
#endif

#ifndef _SVDOPATH_HXX //autogen
#include "svdopath.hxx"
#endif

#ifndef _SVDITER_HXX //autogen
#include "svditer.hxx"
#endif

#ifndef _SVDPAGE_HXX
#include "svdpage.hxx"
#endif

#ifndef _XATTR_HXX
#include "xattr.hxx"
#endif

#ifndef _SVDHDL_HXX
#include "svdhdl.hxx"
#endif

#ifndef _SVDIO_HXX
#include "svdio.hxx"
#endif

#ifndef _B3D_BASE3D_HXX
#include <goodies/base3d.hxx>
#endif

// FG: wegen der DEBUG-Ausgabe in Dateien (temporaer)
#ifndef _INC_STDIO
#include <stdio.h>
#endif

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_POLYOB3D_HXX
#include "polyob3d.hxx"
#endif

#ifndef _E3D_POLYSC3D_HXX
#include "polysc3d.hxx"
#endif

TYPEINIT1(E3dPolyObj, E3dObject);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D, FASTBOOL bDblSided,
	FASTBOOL bLight) :
	bDoubleSided(bDblSided),
	bBackSideVisible(FALSE),
	bLighted(bLight),
	bOwnAttrs (FALSE),
	bOwnStyle (FALSE),
	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
{
	SetPolyPolygon3D(rPolyPoly3D);
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D,
	const PolyPolygon3D& rPolyNormals3D, FASTBOOL bDblSided,
	FASTBOOL bLight) :
	bDoubleSided(bDblSided),
	bBackSideVisible(FALSE),
	bLighted(bLight),
	bOwnAttrs (FALSE),
	bOwnStyle (FALSE),
	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
{
	SetPolyPolygon3D(rPolyPoly3D);
	SetPolyNormals3D(rPolyNormals3D);
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPolyObj::E3dPolyObj(const PolyPolygon3D& rPolyPoly3D,
	const PolyPolygon3D& rPolyNormals3D,
	const PolyPolygon3D& rPolyTexture3D,
	FASTBOOL bDblSided,
	FASTBOOL bLight) :
	bDoubleSided(bDblSided),
	bBackSideVisible(FALSE),
	bLighted(bLight),
	bOwnAttrs (FALSE),
	bOwnStyle (FALSE),
	nObjectnumber (-1)  // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
{
	SetPolyPolygon3D(rPolyPoly3D);
	SetPolyNormals3D(rPolyNormals3D);
	SetPolyTexture3D(rPolyTexture3D);
}

/*************************************************************************
|*
|* Linien-Konstruktor
|*
\************************************************************************/

E3dPolyObj::E3dPolyObj(const Vector3D& rP1, const Vector3D& rP2) :
	aPolyPoly3D(1),
	bDoubleSided(TRUE),
	bBackSideVisible(FALSE),
	bLighted(FALSE),
	bOwnAttrs (FALSE),
	bOwnStyle (FALSE),
	nObjectnumber (-1)    // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
{
	Polygon3D aPoly3D(2);
	aPoly3D[0] = rP1;
	aPoly3D[1] = rP2;
	aPolyPoly3D.Insert(aPoly3D);
	aLocalBoundVol.Union(rP1);
	aLocalBoundVol.Union(rP2);
	RecalcBoundVolume();
}

/*************************************************************************
|*
|* Leer-Konstruktor
|*
\************************************************************************/

E3dPolyObj::E3dPolyObj() :
	bDoubleSided(FALSE),
	bBackSideVisible(FALSE),
	bLighted(FALSE),
	bOwnAttrs (FALSE),
	bOwnStyle (FALSE),
	nObjectnumber (-1)    // FG: 0 waere eine gueltige Objektnummer, naemlich die erste!
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

E3dPolyObj::~E3dPolyObj()
{
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dPolyObj::GetObjIdentifier() const
{
	return E3D_POLYOBJ_ID;
}

/*************************************************************************
|*
|* Polygon setzen
|*
\************************************************************************/

void E3dPolyObj::SetPolyPolygon3D(const PolyPolygon3D& rNewPolyPoly3D)
{
	if ( aPolyPoly3D != rNewPolyPoly3D )
	{
		// Neues PolyPolygon; kopieren
		aPolyPoly3D = rNewPolyPoly3D;

		// Normale berechnen und BoundVol fuellen
		aLocalBoundVol = Volume3D();
		aNormal = aPolyPoly3D.GetNormal();

		// Teilpolygone einbeziehen
		for ( USHORT nPoly = 0; nPoly < aPolyPoly3D.Count(); nPoly++ )
			for ( USHORT i = 0; i < aPolyPoly3D[nPoly].GetPointCount(); i++ )
				aLocalBoundVol.Union(aPolyPoly3D[nPoly][i]);

		bBoundVolValid = FALSE;
		StructureChanged(this);
	}
}

void E3dPolyObj::SetPolyNormals3D(const PolyPolygon3D& rNewPolyNormals3D)
{
	if ( aPolyNormals3D != rNewPolyNormals3D )
	{
		// Neue Normalen; kopieren
		aPolyNormals3D = rNewPolyNormals3D;
	}
}

void E3dPolyObj::SetPolyTexture3D(const PolyPolygon3D& rNewPolyTexture3D)
{
	if ( aPolyTexture3D != rNewPolyTexture3D )
	{
		// Neue Texturkoordinaten; kopieren
		aPolyTexture3D = rNewPolyTexture3D;
	}
}

/*************************************************************************
|*
|* Get the name of the object (singular)
|*
\************************************************************************/

void E3dPolyObj::TakeObjNameSingul(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNameSingulPoly3d);
}

/*************************************************************************
|*
|* Get the name of the object (plural)
|*
\************************************************************************/

void E3dPolyObj::TakeObjNamePlural(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNamePluralPoly3d);
}

/*************************************************************************
|*
|* Get BoundRect of Object
|*
\************************************************************************/

const Rectangle& E3dPolyObj::GetBoundRect() const
{
	return E3dObject::GetBoundRect();
}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

void E3dPolyObj::WriteData31(SvStream& rOut) const
{
#ifndef SVX_LIGHT
	E3dObject::WriteData(rOut);

	SdrDownCompat aCompat(rOut, STREAM_WRITE);
#ifdef DBG_UTIL
	aCompat.SetID("E3dPolyObj");
#endif

	rOut << aPolyPoly3D;
	rOut << aNormal;
	rOut << BOOL(bDoubleSided);
	rOut << BOOL(bBackSideVisible);
	rOut << BOOL(bLighted);

	rOut << (UINT32) bOwnAttrs;
	rOut << (UINT32) bOwnStyle;
#endif
}

/*************************************************************************
|*
|* sichern: zur 356 wurde das Fileformat freigegeben 11.2.1997 FG
|*
/*************************************************************************/

void E3dPolyObj::WriteData(SvStream& rOut) const
{
#ifndef SVX_LIGHT
	if (rOut.GetVersion() < 3560) // FG: Zu dieser Version erfolgte die Umstellung
	{
		WriteData31(rOut);
	}
	else
	{
		SdrDownCompat aCompat(rOut, STREAM_WRITE);
#ifdef DBG_UTIL
		aCompat.SetID("E3dPolyObj");
#endif
		{
			SdrDownCompat aCompat (rOut, STREAM_WRITE);
#ifdef DBG_UTIL
			aCompat.SetID("PolyPolygon3D");
#endif
			rOut << aPolyPoly3D;
		}
		{
			SdrDownCompat aCompat (rOut, STREAM_WRITE);
#ifdef DBG_UTIL
			aCompat.SetID("PolyPolygon3D");
#endif
			rOut << aNormal;
		}
		rOut << BOOL(bDoubleSided);
		rOut << BOOL(bBackSideVisible);
		rOut << BOOL(bLighted);

		rOut << (UINT32) bOwnAttrs;
		rOut << (UINT32) bOwnStyle;
		rOut << (UINT32) nObjectnumber;
			// Falls das Objekt eigene Attribute hat, wird es rausgeschrieben

		if (OwnAttrs() || OwnStyle())
		{
			E3dObject::WriteData(rOut);
		}

		// Neue PolyPolygone schreiben fuer Normalen und Textur
		if(aPolyNormals3D.Count())
		{
#ifdef DBG_UTIL
			aCompat.SetID("PolyPolygon3D Normals");
#endif
			rOut << aPolyNormals3D;
		}
		if(aPolyTexture3D.Count())
		{
#ifdef DBG_UTIL
			aCompat.SetID("PolyPolygon3D Texturkoordinaten");
#endif
			rOut << aPolyTexture3D;
		}
	}
#endif	// #ifndef SVX_LIGHT
}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

void E3dPolyObj::ReadData31(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	if (ImpCheckSubRecords (rHead, rIn))
	{
		E3dObject::ReadData(rHead, rIn);
		SdrDownCompat aCompat(rIn, STREAM_READ);
#ifdef DBG_UTIL
		aCompat.SetID("E3dPolyObj");
#endif

		BOOL   bTmp;
		UINT32 nTmp;

		// wieviele Bytes werden fuer das Polygon gelesen ?
		long nFilePositionBefore = rIn.Tell ();
		rIn >> aPolyPoly3D;
		long nFilePositionAfter  = rIn.Tell ();

		// wenn anschliessend noch mehr Member gestreamt werden, so muss (!!!!) die
		// folgende Anzahl der Bytes angepasst werden, ansonsten geht das Lesen wieder
		// daneben !
		// Diese Werte werden weiter unten eingelesen.
		long nBytesToRead        = sizeof (aNormal) + sizeof (bTmp) * 3 + sizeof (nTmp) * 2;

		// wieviele Bytes wuerden denn nun gelesen werden ?
		// es kommen noch 4 Bytes hinzu, die vom SdrDownCompat fuer die Laenge belegt werden
		long nWouldRead          = nFilePositionAfter - nFilePositionBefore + nBytesToRead + 4;

		// und um wieviele liegen wir daneben ?
		long nBytesWrong         = nWouldRead - aCompat.GetSubRecordSize();

		// hoffentlich alles ok, sonst korrigiere die Fileposition
		if (nBytesWrong)
		{
			rIn.Seek (nFilePositionAfter - nBytesWrong);
		}

		// so, jetzt kann der Rest unbeschadet gelesen werden.
		// aus den hier gelesenen Werten muss die Groesse nBytesToRead bestimmt werden.
		rIn >> aNormal;
		rIn >> bTmp; bDoubleSided = bTmp;
		rIn >> bTmp; bBackSideVisible = bTmp;
		rIn >> bTmp; bLighted = bTmp;

		// Temporaer: Anzahl der Dreiecke aus der Triangulation
		rIn >> nTmp; bOwnAttrs = (BOOL) nTmp;

		if (aCompat.GetBytesLeft () == sizeof (UINT32)) rIn >> nTmp; bOwnStyle = (BOOL) nTmp;

		SetPolyPolygon3D(aPolyPoly3D);
	}
}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

void E3dPolyObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	if ( rIn.GetError() != SVSTREAM_OK )
		return;

	if ((rHead.GetVersion() < 13) || (rIn.GetVersion() < 3560))
	{
		ReadData31(rHead, rIn);
	}
	else
	{
		BOOL   bTmp;
		UINT32 nTmp;

		SdrDownCompat aCompat(rIn, STREAM_READ);
#ifdef DBG_UTIL
		aCompat.SetID("E3dPolyObj");
#endif

		{
			SdrDownCompat aCompatPolyPolygon (rIn, STREAM_READ);
#ifdef DBG_UTIL
			aCompatPolyPolygon.SetID("PolyPolygon3D");
#endif
			rIn >> aPolyPoly3D;
		}
		{
			SdrDownCompat aCompatPolyPolygon (rIn, STREAM_READ);
#ifdef DBG_UTIL
			aCompatPolyPolygon.SetID("PolyPolygon3D");
#endif
			rIn >> aNormal;
		}

		rIn >> bTmp; bDoubleSided = bTmp;
		rIn >> bTmp; bBackSideVisible = bTmp;
		rIn >> bTmp; bLighted = bTmp;

		// Temporaer: Anzahl der Dreiecke aus der Triangulation
		rIn >> nTmp; bOwnAttrs = (BOOL) nTmp;
		rIn >> nTmp; bOwnStyle = (BOOL) nTmp;
		rIn >> nObjectnumber;

		// Nur falls das Objekt eigene Attribute oder einen eigenen
		// Stil besitzt wird es gelesen.

		if (OwnAttrs() || OwnStyle())
		{
		  E3dObject::ReadData(rHead, rIn);
		}
		else
		{
				// FG: Achtung fuer jedes 3d-Objekt muss eine Subliste existieren, auch wenn
				//     sie keinen Eintrag hat, viele Programmstellen (GetBoundRect) fragen nicht
				//     ab ob dieser Pointer NULL ist.
			pSub = new E3dObjList(NULL, NULL);
			pSub->SetOwnerObj(this);
			pSub->SetListKind(SDROBJLIST_GROUPOBJ);
		}

		if(aCompat.GetBytesLeft())
		{
			// Normalen lesen
			rIn >> aPolyNormals3D;
			SetPolyNormals3D(aPolyNormals3D);
		}

		if(aCompat.GetBytesLeft())
		{
			// Texturen lesen
			rIn >> aPolyTexture3D;
			SetPolyTexture3D(aPolyTexture3D);
		}

		SetPolyPolygon3D(aPolyPoly3D);
	}
}

/*************************************************************************
|*
|* Wireframe erzeugen
|*
\************************************************************************/

void E3dPolyObj::CreateWireframe(Polygon3D& rWirePoly, const Matrix4D* pTf,
	E3dDragDetail eDetail)
{
	// Keine Aktion, da solche Objekte nur noch Hilfsobjekte beim
	// Laden/Speichern von 4.0 Format sind.
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dPolyObj::operator=(const SdrObject& rObj)
{
	E3dObject::operator=(rObj);

	const E3dPolyObj& r3DObj = (const E3dPolyObj&) rObj;

	aPolyPoly3D		 = r3DObj.aPolyPoly3D;
	aPolyNormals3D	 = r3DObj.aPolyNormals3D;
	aPolyTexture3D	 = r3DObj.aPolyTexture3D;
	aNormal			 = r3DObj.aNormal;

	bDoubleSided	 = r3DObj.bDoubleSided;
	bBackSideVisible = r3DObj.bBackSideVisible;
	bLighted		 = r3DObj.bLighted;
	bOwnAttrs        = r3DObj.bOwnAttrs;
	bOwnStyle        = r3DObj.bOwnStyle;

	nObjectnumber    = r3DObj.nObjectnumber;
}

/*************************************************************************
|*
|* Wandle das Objekt in ein Polygon.
|* Es ist nur ein Displayobjekt vorhanden, welches ein (!) Polygon darstellt
|*
\************************************************************************/

SdrObject *E3dPolyObj::DoConvertToPolyObj(BOOL bBezier) const
{
	return NULL;
}

/*************************************************************************
|*
|* erstelle neues GeoData-Objekt
|*
\************************************************************************/

SdrObjGeoData *E3dPolyObj::NewGeoData() const
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (GetParentObj()->ISA (E3dObject))
		return GetParentObj()->E3dObject::NewGeoData ();
	else
		return E3dObject::NewGeoData ();
}

/*************************************************************************
|*
|* uebergebe aktuelle werte an das GeoData-Objekt
|*
\************************************************************************/

void E3dPolyObj::SaveGeoData(SdrObjGeoData& rGeo) const
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (GetParentObj()->ISA (E3dObject))
		GetParentObj()->E3dObject::SaveGeoData (rGeo);
	else
		E3dObject::SaveGeoData (rGeo);
}

/*************************************************************************
|*
|* uebernehme werte aus dem GeoData-Objekt
|*
\************************************************************************/

void E3dPolyObj::RestGeoData(const SdrObjGeoData& rGeo)
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (GetParentObj()->ISA (E3dObject))
		GetParentObj()->E3dObject::RestGeoData (rGeo);
	else
		E3dObject::RestGeoData (rGeo);
}

/*************************************************************************
|*
|* Page neu setzen. Normalerweise geht die Page an das Oberobjekt, wenn
|* dieses Objekt von einer Factory erzeugt wurde, existiert noch kein
|* Parent, also wird die Page selbst gesetzt.
|*
\************************************************************************/

void E3dPolyObj::SetPage(SdrPage* pNewPage)
{
	if (GetParentObj())
	{
		DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

		if (GetParentObj()->ISA (E3dObject))
			GetParentObj()->E3dObject::SetPage (pNewPage);
		SdrAttrObj::SetPage(pNewPage);
	}
	else
	{
		pPage = pNewPage;
		if (pPage)
			pModel = pPage->GetModel ();
	}
}

/*************************************************************************
|*
|* Layer setzen
|*
\************************************************************************/

void E3dPolyObj::SetModel(SdrModel* pNewModel)
{
	SdrAttrObj::SetModel(pNewModel);
}

/*************************************************************************
|*
|* Layer abfragen. Da alle Unterobjekte auf demselben Layer liegen
|* gibt es keinerlei Probleme
|*
\************************************************************************/

SdrLayerID E3dPolyObj::GetLayer() const
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (GetParentObj()->ISA (E3dObject))
		return GetParentObj()->E3dObject::GetLayer ();
	else
		return SdrLayerID(nLayerID);
}

/*************************************************************************
|*
|* Layer setzen
|*
\************************************************************************/

void E3dPolyObj::NbcSetLayer(SdrLayerID nLayer)
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (GetParentObj()->ISA (E3dObject))
		GetParentObj()->SdrAttrObj::NbcSetLayer (nLayer);
	SdrAttrObj::NbcSetLayer(nLayer);
}

/*************************************************************************
|*
|* StyleSheet abfragen
|*
\************************************************************************/

SfxStyleSheet* E3dPolyObj::GetStyleSheet() const
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");

	if (bOwnStyle)
		return SdrAttrObj::GetStyleSheet();
	else
		return GetParentObj()->E3dObject::GetStyleSheet ();
}

/*************************************************************************
|*
|* StyleSheet setzen
|*
\************************************************************************/

void E3dPolyObj::NbcSetStyleSheet(SfxStyleSheet *pNewStyleSheet,
								  FASTBOOL      bDontRemoveHardAttr)
{
	DBG_ASSERT(GetParentObj(), "3D-Polygone ohne Parent ?");
	DBG_ASSERT(GetParentObj()->ISA(E3dScene) || GetParentObj()->ISA(E3dObject), "Parent eines 3D-Polygons ungltig");


	GetParentObj()->E3dObject::SendRepaintBroadcast ();
	ForceDefaultAttrAgain ();
	SdrAttrObj::NbcSetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);
	bOwnAttrs = TRUE;
	bOwnStyle = TRUE;
	StructureChanged(this);
	GetParentObj()->E3dObject::SendRepaintBroadcast ();
}

/*************************************************************************
|*
|* Bestimme die Anzahl der Punkte
|*
\************************************************************************/

USHORT E3dPolyObj::GetPointCount () const
{
	USHORT nResult = 0;

	for (long nPoly = 0;
			  nPoly < aPolyPoly3D.Count();
			  nPoly ++)
		nResult += (USHORT) (aPolyPoly3D[(USHORT)nPoly].GetPointCount());

	return nResult;
}


