/*************************************************************************
 *
 *  $RCSfile: label3d.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: thb $ $Date: 2001/07/17 07:04:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "svdstr.hrc"
#include "svdglob.hxx"

#ifndef _SVDIO_HXX
#include "svdio.hxx"
#endif

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_LABEL3D_HXX
#include "label3d.hxx"
#endif

TYPEINIT1(E3dLabelObj, E3dPointObj);

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

E3dLabelObj::~E3dLabelObj()
{
	// zugehoeriges 2D-SdrObject loeschen
	delete p2DLabelObj;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dLabelObj::GetObjIdentifier() const
{
	return E3D_LABELOBJ_ID;
}

/*************************************************************************
|*
|* virtuelle Methode, die ein 2D-Objekt zurueckgibt, falls moeglich
|*
\************************************************************************/

//E3dDisplayObj* E3dLabelObj::MakeViewTransform(Viewport3D& rViewpt,
//											  E3dLightList&,
//											  E3dDisplayObj* pDispObj)
//{
//	aViewPos = rViewpt.GetViewTransform() * GetTransPosition();
//
//	// 2D-Position des Labels bestimmen
//	Point a2DPos = rViewpt.ProjectAndMap(aViewPos);
//	aViewPos -= rViewpt.GetPRP();
//
//	if ( p2DLabelObj )
//		p2DLabelObj->SetAnchorPos(a2DPos);
//
//	if ( pDispObj )
//	{
//		pDispObj->Set2DObj(p2DLabelObj);
//		pDispObj->Set3DObj(this);
//	}
//	else
//		pDispObj = new E3dDisplayObj(this, p2DLabelObj);
//
//	SetDisplayObj(pDispObj);
//
//	return pDispObj;
//}

/*************************************************************************
|*
|* SdrPage auch an p2DLabelObj setzen
|*
\************************************************************************/

void E3dLabelObj::SetPage(SdrPage* pNewPage)
{
	E3dPointObj::SetPage(pNewPage);
	if ( p2DLabelObj )
		p2DLabelObj->SetPage(pNewPage);
}

/*************************************************************************
|*
|* SdrModel auch an p2DLabelObj setzen
|*
\************************************************************************/

void E3dLabelObj::SetModel(SdrModel* pNewModel)
{
	E3dPointObj::SetModel(pNewModel);
	if ( p2DLabelObj )
		p2DLabelObj->SetModel(pNewModel);
}

/*************************************************************************
|*
|* Anzahl der Handles zurueckgeben
|*
\************************************************************************/

USHORT E3dLabelObj::GetHdlCount() const
{
	if ( p2DLabelObj )	return p2DLabelObj->GetHdlCount();
	else				return E3dPointObj::GetHdlCount();
}

/*************************************************************************
|*
|* Handle-Liste fuellen
|*
\************************************************************************/

void E3dLabelObj::AddToHdlList(SdrHdlList& rHdlList) const
{
	if ( p2DLabelObj )	p2DLabelObj->AddToHdlList(rHdlList);
	else				E3dPointObj::AddToHdlList(rHdlList);
}

/*************************************************************************
|*
|* In Stream schreiben
|*
\************************************************************************/

void E3dLabelObj::WriteData(SvStream& rOut) const
{
#ifndef SVX_LIGHT
	E3dPointObj::WriteData(rOut);

#ifdef E3D_STREAMING

	SdrDownCompat aCompat(rOut, STREAM_WRITE);
#ifdef DBG_UTIL
	aCompat.SetID("E3dLabelObj");
#endif
	DBG_ASSERT(p2DLabelObj, "p2DLabelObj muss vor dem Speichern definiert sein!");

	rOut << *p2DLabelObj;
#endif
#endif	// #ifndef SVX_LIGHT
}

/*************************************************************************
|*
|* Aus Stream laden
|*
\************************************************************************/

void E3dLabelObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	if (ImpCheckSubRecords (rHead, rIn))
	{
		E3dPointObj::ReadData(rHead, rIn);

		SdrDownCompat aCompat(rIn, STREAM_READ);
#ifdef DBG_UTIL
		aCompat.SetID("E3dLabelObj");
#endif

	// loeschen, falls schon vorhanden
		delete p2DLabelObj;
		p2DLabelObj = NULL;

		SdrObjIOHeaderLookAhead aHead(rIn, STREAM_READ);

		p2DLabelObj = SdrObjFactory::MakeNewObject(aHead.nInventor,
												   aHead.nIdentifier, GetPage());
		if ( p2DLabelObj != NULL )
		{
			rIn >> *p2DLabelObj;
			p2DLabelObj->SetModel(GetModel());
		}
		else
		{
			aHead.SkipRecord();
		}
	}
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dLabelObj::operator=(const SdrObject& rObj)
{
	E3dPointObj::operator=(rObj);

	const E3dLabelObj& r3DObj = (const E3dLabelObj&)rObj;
	if ( p2DLabelObj != NULL )
		delete p2DLabelObj;

	p2DLabelObj = r3DObj.p2DLabelObj->Clone();
}

/*************************************************************************
|*
|* Get the name of the object (singular)
|*
\************************************************************************/

void E3dLabelObj::TakeObjNameSingul(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNameSingulLabel3d);
}

/*************************************************************************
|*
|* Get the name of the object (plural)
|*
\************************************************************************/

void E3dLabelObj::TakeObjNamePlural(XubString& rName) const
{
	rName=ImpGetResStr(STR_ObjNamePluralLabel3d);
}


