/*************************************************************************
 *
 *  $RCSfile: spldlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: tl $ $Date: 2001/08/14 12:55:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_SPLDLG_HXX
#define _SVX_SPLDLG_HXX

// include ---------------------------------------------------------------

#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _STDCTRL_HXX //autogen
#include <svtools/stdctrl.hxx>
#endif

#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _MENUBTN_HXX //autogen
#include <vcl/menubtn.hxx>
#endif

#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SV_DECOVIEW_HXX //autogen
#include <vcl/decoview.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif


#ifndef _SVX_BOX_HXX //autogen
#include "svxbox.hxx"
#endif
#ifndef _SVX_LANGBOX_HXX
#include <langbox.hxx>
#endif

// forward ---------------------------------------------------------------

namespace com{namespace sun{namespace star{
namespace linguistic2{
	class XSpellChecker1;
}}}}

class SvxSpellWrapper;
class Menu;
struct SpellCheckDlg_Impl;
class SvxSpellCheckDialog;

// misc functions ---------------------------------------------------------------

void SvxPrepareAutoCorrect( String &rOldText, String &rNewText );

// SvxClickInfoCtr ---------------------------------------------------------------

class SvxClickInfoCtr: public Control
{
private:
	SvxSpellCheckDialog*	pMyParent;
	FixedInfo				aFixedInfo;
	Link					aActivateLink;

public:
	SvxClickInfoCtr( SvxSpellCheckDialog* pParent, const ResId& rResId );
	~SvxClickInfoCtr();

	virtual void		SetText( const XubString& rStr );
	virtual XubString	GetText() const;

	void				SetActivateHdl( const Link& rLink ) { aActivateLink = rLink; }
	const Link&			GetActivateHdl() const { return aActivateLink; }


protected:
	virtual void		MouseButtonDown( const MouseEvent& rMEvt );
	virtual long		PreNotify( NotifyEvent& rNEvt );

};


// class SvxSpellCheckDialog ---------------------------------------------

class SvxSpellCheckDialog : public SfxModalDialog
{
private:
	FixedText       aWordText;
	SvxClickInfoCtr aAktWord;
    
    FixedText       aNewWord;
	Edit            aNewWordED;
	FixedImage 		aStateImage;
	ImageButton     aTestBtn;
	FixedText		aSuggestionFT;
	ListBox         aNewWordLB;
	DecorationView	aDecoView;
	GroupBox        aAuditBox;

	PushButton      aIgnoreBtn;
	PushButton      aIgnoreAllBtn;
	PushButton      aChangeBtn;
	PushButton      aChangeAllBtn;
	PushButton      aAutoCorrBtn;
	PushButton      aThesBtn;
	PushButton      aOptionsBtn;
	FixedText       aLanguageText;
	SvxLanguageBox  aLangLB;
	FixedText       aBookText;
	SvxListBox      aBookDLB;
	PushButton      aAddBtn;
	CheckBox		aBackWdBox;
    
    CancelButton    aCancelBtn;
	HelpButton      aHelpBtn;

	FixedInfo       aStatusText;

	short           nActDict;
	String          aTitel;
	Image			aFalseStateIm;
	Image			aTrueStateIm;
	Size			aOldWordEDSize;
	sal_Bool		bModified;
	String			aErrorStr;
	String			aStateStr;

	SpellCheckDlg_Impl* pImpl;
	::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XSpellChecker1 > 	xSpell;
	String				aOldWord;
	LanguageType		nOldLang;

#ifdef _SVX_SPLDLG_CXX
	DECL_LINK( ChgHdl, Button * );
	DECL_LINK( ChgAllHdl, Button * );
	DECL_LINK( IgnAllHdl, Button * );
	DECL_LINK( IgnHdl, Button * );
	DECL_LINK( AddHdl, Button * );
	DECL_LINK( ExtClickHdl, Button * );
	DECL_LINK( CancelHdl, Button * );
	DECL_LINK( WordSelectHdl, ListBox * );
	DECL_LINK( SelectHdl, ListBox * );
	DECL_LINK( DirectionHdl, CheckBox * );
	DECL_LINK( AuditHdl, Button * );
	DECL_LINK(ModifyHdl, Edit *);
	DECL_LINK(ClickHdl, SvxClickInfoCtr *);
	DECL_LINK(ErrorHdl, void* );

	void            Audit_Impl();
	void            StartSpellOptDlg_Impl();
	void            InitUserDicts();
	void            UpdateBoxes_Impl();
	void            Init_Impl();
	void            SpellContinue_Impl();
	void            StartThesaurus_Impl( sal_Bool bInter = sal_False );
	String          AddPreAndPost_Impl( const String& rStr );

	void			SetAddBtnHelp(const String& rString);
	void			SetChangesHelp(const String& rString);
	void			SetIgnoreHelp(const String& rString);

	void			SetSelectedLang_Impl( LanguageType nLang );
	LanguageType	GetSelectedLang_Impl() const;
#endif

protected:

	virtual void	Paint( const Rectangle& rRect );

public:
	SvxSpellCheckDialog( Window* pParent,
			::com::sun::star::uno::Reference< 
				::com::sun::star::linguistic2::XSpellChecker1 >  &xChecker, 
			SvxSpellWrapper* pWrapper );
	~SvxSpellCheckDialog();

	String			GetNewEditWord(){ return aNewWordED.GetText(); }
	void			SetNewEditWord( const String& rNew )
						{ aNewWordED.SetText( rNew ); }
	void			HideAutoCorrect();
	void			SetLanguage( sal_uInt16 nLang );
	virtual sal_Bool	Close();

};


#endif

