/*************************************************************************
 *
 *  $RCSfile: iodlgimp.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/26 08:57:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes *******************************************************************

#ifndef _HEADBAR_HXX
#include "headbar.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UNOTOOLS_UCBHELPER_HXX
#include <unotools/ucbhelper.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include "ctypeitm.hxx"
#endif
#ifndef _SFXENUMITEM_HXX
#include "eitem.hxx"
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include "viewoptions.hxx"
#endif
#ifndef _SVT_FILEVIEW_HXX
#include "fileview.hxx"
#endif
#ifndef _SVTOOLS_SVTUNO_HXX
#include "svtuno.hxx"
#endif
#ifndef _SVTOOLS_SVTDATA_HXX
#include "svtdata.hxx"
#endif
#ifndef _IODLGIMP_HXX
#include "iodlgimp.hxx"
#endif
#ifndef _IODLGIMPL_HXX
#include "iodlg.hxx"
#endif
#ifndef _SVTOOLS_INETTBC_HXX
#include "inettbc.hxx"
#endif
#ifndef _SVTOOLS_IODLGIMPL_HRC
#include "iodlg.hrc"
#endif

using namespace ::com::sun::star::uno;
using namespace ::utl;

// some stuff for easier changes for SvtViewOptions
static const sal_Char*		pViewOptDataName = "dialog data";
#define VIEWOPT_DATANAME	::rtl::OUString::createFromAscii( pViewOptDataName )

static inline void SetViewOptUserItem( SvtViewOptions& rOpt, const String& rData )
{
	rOpt.SetUserItem( VIEWOPT_DATANAME, makeAny( ::rtl::OUString( rData ) ) );
}

static inline String GetViewOptUserItem( const SvtViewOptions& rOpt )
{
	Any aAny( rOpt.GetUserItem( VIEWOPT_DATANAME ) );
	::rtl::OUString aUserData;
	aAny >>= aUserData;

	return String( aUserData );
}


#define _SVSTDARR_STRINGSSORTDTOR
#define _SVSTDARR_STRINGSDTOR
#define _SVSTDARR_USHORTS
#include "svstdarr.hxx"

// defines f"ur den Style der BrowseBox

#define STYLE_MULTI_SELECTION	\
	CNTVIEWSTYLE_NODE_BUTTONS | \
	CNTVIEWSTYLE_NODE_BUTTONS_AT_ROOT | \
	CNTVIEWSTYLE_SHOW_MESSAGES | \
	CNTVIEWSTYLE_SHOW_FOLDERS | \
	CNTVIEWSTYLE_NO_SMARTHIGHLIGHT | \
	CNTVIEWSTYLE_HIDE_OPENMENU | \
	CNTVIEWSTYLE_DEFAULT_APPEARANCE | \
	CNTVIEWSTYLE_SORT_BY_FOLDER

#define STYLE_SINGLE_SELECTION	\
	STYLE_MULTI_SELECTION | CNTVIEWSTYLE_SINGLE_SELECTION

#define BOOL_NOT_INITIALIZE		((sal_Bool)2)

//*****************************************************************************

String GetRegularExpression_Impl( const String& rFilter )
{
	String aFilter = rFilter;
	aFilter.EraseLeadingChars().EraseTrailingChars();
	String aRegExp = '^';

	for ( const sal_Unicode *pc = aFilter.GetBuffer(); *pc; ++pc )
	{
		if ( '*' == *pc )
			aRegExp += DEFINE_CONST_UNICODE(".*");
		else if ( '?' == *pc )
			aRegExp += '.';
		else
		{
			aRegExp += '\'';

			while ( *pc && *pc != '*' && *pc != '?' )
			{
				if ( '\'' == *pc )
					aRegExp += DEFINE_CONST_UNICODE("\\\'");
				else
					aRegExp += *pc;
				pc++;
			}
			aRegExp += '\'';

			if ( !*pc )
				break;
			else
				pc--;
		}
	}
	aRegExp += '$';
	return aRegExp;
}

//*****************************************************************************
// SvtFileDialogFilter_Impl
//*****************************************************************************

DBG_NAME( SvtFileDialogFilter_Impl )
SvtFileDialogFilter_Impl::SvtFileDialogFilter_Impl( const String& rName, const String& rType )
	:m_aName( rName )
	,m_aType( rType )
{
	DBG_CTOR( SvtFileDialogFilter_Impl, NULL );

	m_aType.ToLowerAscii();
}

//*****************************************************************************

SvtFileDialogFilter_Impl::~SvtFileDialogFilter_Impl()
{
	DBG_DTOR( SvtFileDialogFilter_Impl, NULL );
}

//*****************************************************************************
// SvtFileDialogFilterList_Impl
//*****************************************************************************

SV_IMPL_PTRARR( SvtFileDialogFilterList_Impl, SvtFileDialogFilter_Impl* );

//*****************************************************************************
// SvtUpButton_Impl
//*****************************************************************************

SvtUpButton_Impl::SvtUpButton_Impl( SvtFileDialog* pParent, const ResId& rResId ) :

	MenuButton( pParent, rResId ),
	_pParent		( pParent ),
	_pURLs			( NULL ),
	_pMenu			( new PopupMenu )
{
	SetStyle( GetStyle() | WB_NOPOINTERFOCUS | WB_RECTSTYLE | WB_SMALLSTYLE );
	SetImage( Image( ResId( IMG_FILEDLG_BTN_UP ) ) );
	SetMenuMode( MENUBUTTON_MENUMODE_TIMED );
	SetDropDown( PUSHBUTTON_DROPDOWN_TOOLBOX );
}

//*****************************************************************************

SvtUpButton_Impl::~SvtUpButton_Impl()
{
	delete _pURLs;
	delete _pMenu;
}

//*****************************************************************************

void SvtUpButton_Impl::Activate()
{
	delete _pURLs;
	_pURLs = new SvStringsDtor;
	SvtFileView* pBox;

	pBox = _pParent->GetView();

	_pMenu->Clear();
	sal_uInt16 nItemId = 1;

	// "Ubergeordnete Ebenen bestimmen.
	INetURLObject aObject( pBox->GetViewURL() );
	sal_Int32 nCount = aObject.getSegmentCount();

	while ( nCount >= 1 )
	{
		aObject.removeSegment();
		String* pParentURL = new String( aObject.GetMainURL() );
		String aTitle;
		if ( !UCBContentHelper::GetTitle( *pParentURL, aTitle ) || aTitle.Len() == 0 )
			aTitle = aObject.getName();

//!		if ( !aName && !xParent->GetParentViewURL() )
//!			aName = String( SfxResId( STR_SFX_WORKPLACE ) );

		_pMenu->InsertItem( nItemId++, aTitle, *_pParent->GetFolderImage() );

        _pURLs->Insert( pParentURL, _pURLs->Count() );
		nCount--;
	}

	// Workplace-Submenu
	nItemId--;
	MenuItemBits nBits = _pMenu->GetItemBits( nItemId );
	nBits |= MIB_POPUPSELECT;
	_pMenu->SetItemBits( nItemId, nBits );

	SetPopupMenu( _pMenu );
}

//*****************************************************************************

void SvtUpButton_Impl::Select()
{
	sal_uInt16 nId = GetCurItemId();

	if ( nId )
	{
		--nId;
		DBG_ASSERT( nId <= _pURLs->Count(), "SvtUpButton_Impl:falscher Index" );
		String aURL = *(_pURLs->GetObject( nId ));

		_pParent->OpenURL_Impl( aURL );
	}
}

//*****************************************************************************

void SvtUpButton_Impl::Click()
{
	_pParent->PrevLevel_Impl();
}

//*****************************************************************************
// SvtTravelButton_Impl
//*****************************************************************************

void SvtTravelButton_Impl::OpenURL( const String& rURL )

/*	[Beschreibung]

	Die Methode "offnet den Ordner,
	der durch den gespeicherten URL spezifiziert wird.
*/

{
	INetURLObject aObj( rURL );
	DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );

	_pParent->OpenURL_Impl( aObj.GetMainURL() );
}

//*****************************************************************************

SvtTravelButton_Impl::SvtTravelButton_Impl( SvtFileDialog* pParent, const ResId& rResId ) :

	PushButton( pParent, rResId ),
	_pParent		( pParent )
{
	SetStyle( GetStyle() | WB_NOPOINTERFOCUS | WB_RECTSTYLE | WB_SMALLSTYLE );
	SetImage( Image( ResId( IMG_FILEDLG_BTN_STD ) ) );
}

//*****************************************************************************

SvtTravelButton_Impl::~SvtTravelButton_Impl()
{
}

//*****************************************************************************

void SvtTravelButton_Impl::Click()
{
	OpenURL( _pParent->GetStandardDir() );
}

//*****************************************************************************
// SvtExpFileDlg_Impl
//*****************************************************************************

SvtExpFileDlg_Impl::SvtExpFileDlg_Impl( WinBits nBits )	:

	_pFilter            ( new SvtFileDialogFilterList_Impl() ),
	_pCurFilter         ( NULL ),
	_pDefaultFilter		( NULL ),
	_pUserFilter        ( NULL ),
	_pFtFileName        ( NULL ),
	_pEdFileName        ( NULL ),
	_pFtFileVersion     ( NULL ),
	_pLbFileVersion     ( NULL ),
	_pFtFileType        ( NULL ),
	_pLbFilter          ( NULL ),
	_pBtnFileOpen       ( NULL ),
	_pBtnCancel         ( NULL ),
	_pBtnHelp			( NULL ),
	_pBtnLocal          ( NULL ),
	_pBtnUp             ( NULL ),
	_pBtnNewFolder      ( NULL ),
	_pBtnStandard       ( NULL ),
	_pCbPassword        ( NULL ),
	_pCbAutoExtension   ( NULL ),
	_pCbOptions			( NULL ),
	_pFtCurrentPath     ( NULL ),
	_nState             ( FILEDLG_STATE_REMOTE ),
	_bDoubleClick       ( sal_False ),
	_bMultiSelection	( sal_False ),
	_bFolderHasOpened	( sal_False ),
	_pPathList			( NULL ),
	_pURLList			( NULL ),
	_nFixDeltaHeight    ( 0 ),
	_nStyle				( 0 ),
	m_bNeedDelayedFilterExecute	( sal_False )

{
	_pDocImage = new Image( ResId( IMG_FILEDLG_DOCUMENT ) );
	_pFolderImage = new Image( ResId( IMG_FILEDLG_FOLDER ) );
}

//*****************************************************************************

SvtExpFileDlg_Impl::~SvtExpFileDlg_Impl()
{
	delete _pFtCurrentPath;
	delete _pCbPassword;
	delete _pCbAutoExtension;
	delete _pCbOptions;
	delete _pBtnStandard;
	delete _pBtnNewFolder;
	delete _pBtnUp;
	delete _pBtnLocal;
	delete _pBtnHelp;
	delete _pBtnCancel;
	delete _pBtnFileOpen;
	delete _pLbFilter;
	delete _pFtFileType;
	delete _pLbFileVersion;
	delete _pFtFileVersion;
	delete _pEdFileName;
	delete _pFtFileName;
	delete _pUserFilter;
	delete _pFilter;
	delete _pPathList;
	delete _pURLList;

	delete _pDocImage;
	delete _pFolderImage;
}

//*****************************************************************************

void SvtExpFileDlg_Impl::SetStandardDir( const String& _rDir )
{
	_aStdDir = _rDir;
	if ( 0 == _aStdDir.Len() )
		_aStdDir.AssignAscii( "file:///" );
}

//*****************************************************************************

//-----------------------------------------------------------------------------
namespace {
	String lcl_DecoratedFilter( const String& _rOriginalFilter )
	{
		String aDecoratedFilter = '<';
		aDecoratedFilter += _rOriginalFilter;
		aDecoratedFilter += '>';
		return aDecoratedFilter;
	}
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::ClearFilterList( )
{
	_pLbFilter->Clear();
}

//-----------------------------------------------------------------------------
void SvtExpFileDlg_Impl::SetCurFilter( SvtFileDialogFilter_Impl* _pFilter, const String& _rDisplayName )
{
	DBG_ASSERT( _pFilter, "SvtExpFileDlg_Impl::SetCurFilter: invalid filter!" );
	DBG_ASSERT( ( _rDisplayName == _pFilter->GetName() )
			||	( _rDisplayName == lcl_DecoratedFilter( _pFilter->GetName() ) ),
			"SvtExpFileDlg_Impl::SetCurFilter: arguments are inconsistent!" );

	_pCurFilter = _pFilter;
	m_sCurrentFilterDisplayName = _rDisplayName;
}

//-----------------------------------------------------------------------------
void SvtExpFileDlg_Impl::InsertFilterListEntry( const SvtFileDialogFilter_Impl* _pFilterDesc )
{
	String sName = _pFilterDesc->GetName();
	if ( _pFilterDesc->isGroupSeparator() )
		sName = String::CreateFromAscii( "------------------------------------------" );
	else
		sName = _pFilterDesc->GetName();

	// insert an set user data
	USHORT nPos = _pLbFilter->InsertEntry( sName );
	_pLbFilter->SetEntryData( nPos, const_cast< void* >( static_cast< const void* >( _pFilterDesc ) ) );
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::InitFilterList( )
{
	// clear the current list
	ClearFilterList( );

	// reinit it
	USHORT nPos = _pFilter->Count();

	// search for the first entry which is no group separator
	while ( nPos-- && _pFilter->GetObject( nPos ) && _pFilter->GetObject( nPos )->isGroupSeparator() )
		;

	// add all following entries
	while ( (sal_Int16)nPos >= 0 )
		InsertFilterListEntry( _pFilter->GetObject( nPos-- ) );
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::CreateFilterListControl( Window* _pParent, const ResId& _rId )
{
	DBG_ASSERT( !_pLbFilter, "SvtExpFileDlg_Impl::CreateFilterListControl: already created the control!" );
	if ( !_pLbFilter )
		_pLbFilter = new ListBox( _pParent, _rId );
}

//-----------------------------------------------------------------------------

SvtFileDialogFilter_Impl* SvtExpFileDlg_Impl::FindFilter( const String& _rFilterName )
{
	// simply loop through the filter list and compare names ...
	USHORT nPos = _pFilter->Count();
	while ( nPos-- )
	{
		SvtFileDialogFilter_Impl* pFilter = _pFilter->GetObject( nPos );
		if ( pFilter->GetName() == _rFilterName )
			return pFilter;
	}
	return NULL;
}

#ifdef FILTER_MRU_LIST

//******************************************************************************
//* Ab hier kommen die Methoden zum Cachen der 5 letzten Filter oberhalb des   *
//* <Alle> Filters in der FilterListBox										   *
//******************************************************************************

// Anzahl der zuletzt genutzten Filter die am Anfang der
// FilterBox angezeigt werden sollen
#define CACHE_FILTERS_COUNT	5

// Trennzeichen zum speichern der 5 zuletzt genutzten Filter
#define MULTIFILTER_DELIMITER ';'

//******************************************************************************

void SvtExpFileDlg_Impl::InitFilterCache_Impl()
{
	SvtViewOptions aDlgOpt( E_DIALOG, _aIniKey );
	if ( aDlgOpt.Exists() )
	{
		String aFilters( GetViewOptUserItem( aDlgOpt ) );
		aDlgOpt.GetUserData();

		const sal_Unicode cTok = MULTIFILTER_DELIMITER;
		const xub_StrLen nCount = aFilters.GetTokenCount( cTok );

		// first token is the AutoExtension-flag -> so i = 1 and not i = 0
		for ( xub_StrLen i = 1; i < nCount; i++ )
			_aFilterCacheList.Insert( new String( aFilters.GetToken( i, cTok ) ), LIST_APPEND );

		// Position des <Alle> - Filters, falls er nicht da ist - raus
		String aAll( SvtResId( STR_FILTERNAME_ALL ) );
		sal_uInt16 nAllPos = _pLbFilter->GetEntryPos( aAll );
		if ( nAllPos == LISTBOX_ENTRY_NOTFOUND )
			return;
		// Wenn der <Alle> - Filter der Letzte ist - anhaengen
		if ( ++nAllPos >= _pLbFilter->GetEntryCount() )
			nAllPos = LISTBOX_APPEND;

		// die Top5 Filter in der Box nach oben kopieren
		String* pFilterStr = (String*)_aFilterCacheList.Last();
		while ( pFilterStr )
		{
			// Filter Nur in die Listbox eintragen, wenn er dort
			// bereits vorhanden ist
			sal_uInt16 nPos = _pLbFilter->GetEntryCount();
			while ( nPos-- )
			{
				if ( pFilterStr->CompareTo( _pLbFilter->GetEntry( nPos ) ) == COMPARE_EQUAL )
				{
					SvtFileDialogFilter_Impl* pFilterData = FindFilter( *pFilterStr );
					DBG_ASSERT( pFilterData, "SvtExpFileDlg_Impl::InitFilterCache_Impl: invalid filter name!" );

					if ( pFilterData )
					{
						sal_uInt16 nFilterPos = _pLbFilter->InsertEntry( lcl_DecoratedFilter( *pFilterStr ), nAllPos );
						_pLbFilter->SetEntryData( nFilterPos, pFilterData );
					}
					break;
				}
			}
			pFilterStr = (String*)_aFilterCacheList.Prev();
		}
	}
}

//******************************************************************************

void SvtExpFileDlg_Impl::SaveFilterCache_Impl()

/*	[Beschreibung]

	Filter Cache in die Ini schreiben
*/

{
	String aFilters;
	String* pFilterStr = (String*)_aFilterCacheList.First();
	while ( pFilterStr )
	{
		aFilters += *pFilterStr;
		aFilters += MULTIFILTER_DELIMITER;
		delete pFilterStr;
		pFilterStr = (String*)_aFilterCacheList.Next();
	}
	_aFilterCacheList.Clear();

	SvtViewOptions aDlgOpt( E_DIALOG, _aIniKey );
	String aUserData;
	if ( _pCbAutoExtension )
		aUserData = _pCbAutoExtension->IsChecked() ? '1' : '0';
	else if ( aDlgOpt.Exists() )
		aUserData = String( aDlgOpt.GetUserData() ).GetToken(0);
	else
		aUserData = '1';
	aUserData += ';';
	aUserData += aFilters;
	aUserData.EraseTrailingChars( MULTIFILTER_DELIMITER );
	SetViewOptUserItem( aDlgOpt, aUserData );
}

//******************************************************************************

// Selektierten Filter im Filter Cache merken

void SvtExpFileDlg_Impl::CacheFilter_Impl( const String& aFilter )
{
	// ist der Filter schon im cache, wird er zuerst aus selbigen entfernt.
	String* pFilterStr = (String*)_aFilterCacheList.First();
	while(pFilterStr)
	{
		if(aFilter.CompareTo(*pFilterStr) == COMPARE_EQUAL)
		{
			_aFilterCacheList.Remove();
			delete pFilterStr;
			break;
		}

		pFilterStr = (String*)_aFilterCacheList.Next();
	}

	_aFilterCacheList.Insert((void*)new String(aFilter), (sal_uInt32)0);

	// pruefen, ob der Cache voll ist
	if(_aFilterCacheList.Count() > CACHE_FILTERS_COUNT)
	{
		String* pFilterStr = (String*)_aFilterCacheList.Last();
		_aFilterCacheList.Remove();
		delete pFilterStr;
	}
}

#endif
