#! /bin/sh
#
# checkdll.sh - execute checkdll with all -L arguments to this script
#               prepended to LD_LIBRARY_PATH
# $Id: checkdll.sh,v 1.2 2000/02/07 15:10:31 hr Exp hr $
#
# Copyright (c) 2000, Sun Microsystems, Inc.
#

set -- `getopt "L:" "$@"` ||  {
    echo "Usage: `basename $0` [-L library_path] <shared_library>" 1>&2
    exit 1
}

checkdll="$SOLARVERSION/$INPATH/bin/checkdll"

if [ -x $checkdll ]; then
    while :
    do
	case $1 in 
	    -L) shift; option=$1;;
	    --) break;;
	esac
	case "${libpath+X}" in
	    X) libpath=$libpath:$option;;
	    *) libpath=$option;;
	esac    
	shift
    done
    shift  # remove the trailing ---

    case `uname -s` in
    Darwin) case "${DYLD_LIBRARY_PATH+X}" in
	    X) DYLD_LIBRARY_PATH=$libpath:$DYLD_LIBRARY_PATH;;
	    *) DYLD_LIBRARY_PATH=$libpath;;
        esac
        export DYLD_LIBRARY_PATH;;
    IRIX) case "${LD_LIBRARYN32_PATH+X}" in
	    X) LD_LIBRARYN32_PATH=$libpath:$LD_LIBRARYN32_PATH;;
	    *) LD_LIBRARYN32_PATH=$libpath;;
	esac
        export LD_LIBRARYN32_PATH;;
    IRIX64) case "${LD_LIBRARYN32_PATH+X}" in
	    X) LD_LIBRARYN32_PATH=$libpath:$LD_LIBRARYN32_PATH;;
	    *) LD_LIBRARYN32_PATH=$libpath;;
	esac
        export LD_LIBRARYN32_PATH;;
	*)  case "${LD_LIBRARY_PATH+X}" in
	    X) LD_LIBRARY_PATH=$libpath:$LD_LIBRARY_PATH;;
	    *) LD_LIBRARY_PATH=$libpath;;
        esac
        export LD_LIBRARY_PATH;;
    esac

    $checkdll "$*"
    if [ $? -ne 0 ]; then exit 1 ; fi
    
    for parameter in $*; do
        library=$parameter;
    done
    realname=`echo $library | sed "s/check_//"`
    if [ $library != $realname ]; then
        mv $library $realname
    fi
else
	echo "WARNING: checkdll not found!" 1>&2
fi

exit 0
