/*************************************************************************
 *
 *  $RCSfile: tbxconf.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/08/27 07:57:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXTOOLBOXCONF_HXX
#define _SFXTOOLBOXCONF_HXX

#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif

#include <framework/toolboxconfiguration.hxx>

#include "sfx.hrc"
#include "cfgitem.hxx"
#include "minarray.hxx"
#include "imgmgr.hxx"
#include "chalign.hxx"

class SfxToolBoxManager;

class SfxToolBoxConfig : public SfxConfigItem
{
	static SfxToolBoxConfig*	pTbxConfig;

	::framework::ToolBoxLayoutDescriptor* pPosArr;
	SfxSymbolSet	eSymbolSet;
	USHORT			nOutStyle;
	BOOL			bQuiet;
	BOOL			bStatusBarVisible;

public:
					SfxToolBoxConfig( SfxConfigManager* pCfgMgr );
                    SfxToolBoxConfig( const SfxToolBoxConfig& rOther, SfxConfigManager* pCfgMgr );
					~SfxToolBoxConfig();

                    // for Import/Export
	static BOOL 	Import( SvStream&, SvStream& );
	static BOOL		Export( SotStorage&, SvStream& );
    static BOOL     Load( SvStream&, SvStream& );
    static BOOL     Export( SvStream*, SvStream& );

	virtual int 	Load( SotStorage& );
	virtual BOOL	Store( SotStorage& );
    virtual String  GetStreamName() const;
	virtual	void	UseDefault();

	void			SetToolBoxPositionVisible(USHORT nPos, BOOL bVis);
	BOOL			IsToolBoxPositionVisible(USHORT nPos) const;
//	void			SetToolBoxPositionName(USHORT nPos, const String* pName);
	static String	GetToolBoxPositionName(USHORT nPos);
	void			SetButtonType( USHORT nPos, ButtonType );
	void			SetQuiet(BOOL bSet)
					{ bQuiet = bSet; }
	BOOL			IsQuiet() const
					{ return bQuiet; }
	ButtonType		GetButtonType( USHORT nPos ) const;
	const ::framework::ToolBoxLayoutItemDescriptor* GetCfgItem_Impl( USHORT nPos ) const;
	void 			Configure_Impl( SfxToolBoxManager* );
	WinBits			GetWinBits( USHORT nPos );
	SfxChildAlignment GetAlignment( USHORT nPos ) const;

	void 			SetStatusBarVisible( BOOL bVis )
					{ bStatusBarVisible=bVis; SetDefault( FALSE ); }
	BOOL			IsStatusBarVisible() const
					{ return bStatusBarVisible; }

	static BOOL		GetObjectbarVisibilityDefault( USHORT nPos );
};
#endif
