/*************************************************************************
 *
 *  $RCSfile: eventdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/12/03 17:42:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ***************************************************************

#ifndef _SVEDIT_HXX //autogen
#include <svtools/svmedit.hxx>
#endif
#pragma hdrstop

#include "eventdlg.hxx"

#include "eventdlg.hrc"
#include "sfxresid.hxx"
#include "evntconf.hxx"
#include "macrconf.hxx"
#include "minfitem.hxx"
#include "app.hxx"
#include "objsh.hxx"
#include "objshimp.hxx"
#include "cfg.hxx"

// -----------------------------------------------------------------------

SfxEventConfigPage::SfxEventConfigPage( Window* pParent, const SfxItemSet& rSet ) :

	_SfxMacroTabPage( pParent, SfxResId(TP_CONFIG_EVENT), rSet ),

	aStarOfficeRB		( this, ResId( RB_STAROFFICE ) ),
	aDocumentRB			( this, ResId( RB_DOCUMENT ) ),

	pAppItem	( NULL ),
	pDocItem	( NULL ),
	bAppConfig	( TRUE )
{
    pEventGB = new FixedLine( this, SfxResId( GB_EVENT ) );
	pEventLB = new SvTabListBox( this, SfxResId( LB_EVENT ) );
	pAssignPB = new PushButton( this, SfxResId( PB_ASSIGN ) );
	pDeletePB = new PushButton( this, SfxResId( PB_DELETE ) );
	pScriptTypeLB = new ListBox( this, SfxResId( LB_SCRIPTTYPE ) );
    pMacroGB = new FixedLine( this, SfxResId( GB_MACRO ) );
	pGroupLB = new SfxConfigGroupListBox_Impl( this, SfxResId( LB_GROUP ) );
	pMacroLB = new SfxConfigFunctionListBox_Impl( this, SfxResId( LB_MACROS ) );
	pMacroStr = new String( SfxResId( STR_MACROS ) );

	FreeResource();

    pScriptTypeLB->Hide();

	Link aLink = LINK( this, SfxEventConfigPage, SelectHdl_Impl );
	aStarOfficeRB.SetClickHdl( aLink );
	aDocumentRB.SetClickHdl( aLink );

	InitAndSetHandler();
	SfxEventConfiguration *pEvCfg = SFX_APP()->GetEventConfig();
	pEvCfg->AddEvents( (SfxMacroTabPage*) this );

	pAppItem = new SvxMacroItem;
	pAppItem->SetMacroTable( *pEvCfg->GetAppEventTable() );
	if ( SfxObjectShell::Current() )
	{
		pDocItem = new SvxMacroItem;
		SvxMacroTableDtor* pTable = pEvCfg->GetDocEventTable( SfxObjectShell::Current() );
		if ( !pTable )
			pTable = new SvxMacroTableDtor( 2,2 );
		pDocItem->SetMacroTable( *pTable );
	}

	BOOL bEnable = ( pDocItem != NULL && SfxObjectShell::Current()->Get_Impl()->bSupportsEventMacros );
	aDocumentRB.Enable( bEnable );
	if ( bEnable )
		aDocumentRB.Check();
	else
		aStarOfficeRB.Check();

	((SfxItemSet&)rSet).Put( *pAppItem );
	ScriptChanged( DEFINE_CONST_UNICODE("StarBasic") );
	SelectHdl_Impl( NULL );
}

// -----------------------------------------------------------------------

SfxEventConfigPage::~SfxEventConfigPage()
{
	delete pAppItem;
	delete pDocItem;
}

// -----------------------------------------------------------------------

IMPL_LINK( SfxEventConfigPage, SelectHdl_Impl, RadioButton *, pBtn )
{
	BOOL bApp = aStarOfficeRB.IsChecked();
	if ( bApp == bAppConfig )
		return TRUE;

	if ( pBtn )
	{
		// Zuerst die bisher konfigurierten Events auslesen
		SfxItemSet aSet( SFX_APP()->GetPool(), SID_ATTR_MACROITEM, SID_ATTR_MACROITEM );
		if ( _SfxMacroTabPage::FillItemSet( aSet ) )
		{
			const SfxPoolItem* pItem;
			SfxItemState eState = aSet.GetItemState( SID_ATTR_MACROITEM, FALSE, &pItem );
			if ( eState == SFX_ITEM_SET )
			{
				// Es wurde etwas ver"andert
				if ( bApp )
				{
					// Ver"anderte Doc-Config merken
					delete pDocItem;
					pDocItem = (SvxMacroItem*) pItem->Clone();
				}
				else
				{
					// Ver"anderte App-Config merken
					delete pAppItem;
					pAppItem = (SvxMacroItem*) pItem->Clone();
				}
			}
			else
				DBG_ERROR( "FillItemSet returned TRUE, aber kein Item!" );
		}
	}

	// Die aktuelle Konfiguration in den Dialog einbringen
	pEventLB->SetUpdateMode( FALSE );
	bAppConfig = bApp;
	if ( bApp )
	{
		SetReadOnly( FALSE );
		((SfxItemSet&)GetItemSet()).Put( *pAppItem );
		_SfxMacroTabPage::Reset( GetItemSet() );
	}
	else
	{
		SetReadOnly( SfxObjectShell::Current()->IsReadOnly() );
		((SfxItemSet&)GetItemSet()).Put( *pDocItem );
		_SfxMacroTabPage::Reset( GetItemSet() );
	}

	pEventLB->SetUpdateMode( TRUE );
	return TRUE;
}

// -----------------------------------------------------------------------

BOOL SfxEventConfigPage::FillItemSet( SfxItemSet& rSet )
{
    BOOL bRet = FALSE;
    SfxEventConfiguration *pEC = SFX_APP()->GetEventConfig();
	if ( _SfxMacroTabPage::FillItemSet( rSet ) )
	{
		const SfxPoolItem *pItem;
		SfxItemState eState = rSet.GetItemState( SID_ATTR_MACROITEM, FALSE, &pItem );
		if ( eState == SFX_ITEM_SET )
		{
			if ( bAppConfig )
			{
				// Ver"anderte App-Config merken
				delete pAppItem;
				pAppItem = (SvxMacroItem*) pItem->Clone();
			}
			else
			{
				// Ver"anderte Doc-Config merken
				delete pDocItem;
				pDocItem = (SvxMacroItem*) pItem->Clone();
			}
		}
	}

	if ( ! ( pAppItem->GetMacroTable() == (*pEC->GetAppEventTable()) ) )
	{
		bRet = TRUE;
		pEC->SetAppEventTable( pAppItem->GetMacroTable() );
	}

	SfxObjectShell *pDoc = SfxObjectShell::Current();
	if ( pDoc )
	{
		SvxMacroTableDtor *pTable = pEC->GetDocEventTable(pDoc);
		if ( !pTable && pDocItem->GetMacroTable().Count() || pTable &&
			! ( pDocItem->GetMacroTable() == (*pTable) ) )
		{
			bRet = TRUE;
			pEC->SetDocEventTable( pDoc, pDocItem->GetMacroTable() );
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------

void SfxEventConfigPage::Reset( const SfxItemSet& rSet )
{
	_SfxMacroTabPage::Reset( rSet );
}

// -----------------------------------------------------------------------

// Wird nicht mehr unterst"utzt
void SfxEventConfigPage::SelectMacro(const SfxMacroInfoItem *pItem)
{
}

// -----------------------------------------------------------------------

void SfxEventConfigPage::SelectMacro( const SvxMacro *pMacro )
{
	// Macro und dazugeh"origes BASIC selektieren
	String aBasic( pMacro->GetLibName() );
	String aMacro( pMacro->GetMacName() );
	pGroupLB->SelectMacro( aBasic, aMacro );
}

