/*************************************************************************
 *
 *  $RCSfile: cfgtreelstbox.cxx,v $
 *
 *  $Revision: 1.14.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#ifndef _SBXCLASS_HXX //autogen
#include <svtools/sbx.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif
#ifndef __SBX_SBXMETHOD_HXX //autogen
#include <svtools/sbxmeth.hxx>
#endif
#ifndef _SB_SBMOD_HXX //autogen
#include <basic/sbmod.hxx>
#endif
#ifndef _BASMGR_HXX //autogen
#include <basic/basmgr.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_DECOVIEW_HXX
#include <vcl/decoview.hxx>
#endif
#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>
#include <so3/svstor.hxx>

#pragma hdrstop

#include "cfgtreelstbox.hxx"

#include "dialog.hrc"
#include "cfg.hrc"

#include "app.hxx"
#include "appdata.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "sfxresid.hxx"
#include "macrconf.hxx"
#include "minfitem.hxx"
#include "cfgmgr.hxx"
#include "sfxresid.hxx"
#include "objsh.hxx"
#include "dispatch.hxx"
#include "sfxtypes.hxx"
#include "eventdlg.hxx"
#include "minfitem.hxx"
#include "viewfrm.hxx"
#include "workwin.hxx"
#include "filedlghelper.hxx"
#include "request.hxx"
#include "tbxmgr.hxx"
#include "objface.hxx"

#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

SV_IMPL_PTRARR(SfxCfgGroupInfoArr_Impl, SfxCfgGroupInfoPtr);

SfxConfigTreeListBox_Impl::SfxConfigTreeListBox_Impl(
	Window* pParent, const ResId& rResId, SfxBindings* pBind, ULONG nConfigMode )
		: SvTreeListBox( pParent, rResId )
		, aScriptType( DEFINE_CONST_UNICODE("StarBasic") )
		, nMode( nConfigMode )
		, pBindings( pBind )
		, bDragInProgress( FALSE )
/*	Beschreibung
	Diese Listbox zeigt alle Funktionsgruppen und Basics an, die zur Konfiguration
	zur Verf"ugung stehen. Basics werden noch in Bibliotheken und Module untergliedert.
*/
{
	SetWindowBits( GetStyle() | WB_CLIPCHILDREN | WB_HSCROLL | WB_HASBUTTONS | WB_HASBUTTONSATROOT | WB_HIDESELECTION );
	SetNodeBitmaps( Image( SfxResId( BMP_COLLAPSED )), Image( SfxResId( BMP_EXPANDED )) );
	SetSpaceBetweenEntries( 6 );
	SetEntryHeight( 16 );
	SetHighlightRange();
	SetSelectionMode(SINGLE_SELECTION);
	
	SetDragDropMode( SV_DRAGDROP_CTRL_COPY |
					 SV_DRAGDROP_APP_COPY );

	// Timer for the balloon help
	aTimer.SetTimeout( 200 );
	aTimer.SetTimeoutHdl( LINK( this, SfxConfigTreeListBox_Impl, TimerHdl ) );
}


SfxConfigTreeListBox_Impl::~SfxConfigTreeListBox_Impl()
{
	ClearAll();
}

void SfxConfigTreeListBox_Impl::MouseMove( const MouseEvent& rMEvt )
/*  Beschreibung
	Virtuelle Methode, die gerufen wird, wenn der Mauszeiger "uber der TreeListBox bewegt wurde.
	Wenn die Position des Mauszeigers "uber dem aktuell selektierten Entry liegt, wird ein Timer
	aufgesetzt, um ggf. einen Hilfetext einzublenden.
*/
{
	if ( !bDragInProgress )
	{
		Point aMousePos = rMEvt.GetPosPixel();
		pCurEntry = GetCurEntry();

		if ( pCurEntry && GetEntry( aMousePos ) == pCurEntry )
			aTimer.Start();
		else
		{
			Help::ShowBalloon( this, aMousePos, String() );
			aTimer.Stop();
		}
	}
}

IMPL_LINK( SfxConfigTreeListBox_Impl, TimerHdl, Timer*, pTimer)
/*  Beschreibung
	Timer-Handler f"ur die Einblendung eines Hilfetextes. Wenn nach Ablauf des Timers
	der Mauszeiger immer noch auf dem aktuell selektierten Eintrag steht, wird der
	Helptext des Entries als Balloon-Help eingeblendet.
*/
{
	aTimer.Stop();
	Point aMousePos = GetPointerPosPixel();
	SvLBoxEntry *pEntry = GetCurEntry();
	if ( pEntry && GetEntry( aMousePos ) == pEntry && pCurEntry == pEntry )
		Help::ShowBalloon( this, OutputToScreenPixel( aMousePos ), GetHelpText( pEntry ) );
	return 0L;
}

void SfxConfigTreeListBox_Impl::ClearAll()
/* 	Beschreibung
	L"oscht alle Eintr"age in der FunctionListBox, alle UserDaten und alle evtl.
	vorhandenen MacroInfos.
*/
{
	USHORT nCount = aArr.Count();
	for ( USHORT i=0; i<nCount; i++ )
	{
		SfxCfgGroupInfo_Impl *pData = aArr[i];
		if ( pData->nKind == SFX_CFGFUNCTION_MACRO )
		{
			SfxMacroInfo *pInfo = (SfxMacroInfo*) pData->pObject;
			SFX_APP()->GetMacroConfig()->ReleaseSlotId( pInfo->GetSlotId() );
			delete pInfo;
		}
		delete pData;
	}

	aArr.Remove( 0, nCount );
	Clear();
}

SvLBoxEntry* SfxConfigTreeListBox_Impl::GetEntry_Impl( SvLBoxEntry* pParentEntry, const String& rName )
{
	if ( pParentEntry )
	{
		SvLBoxEntry* pChild = FirstChild( pParentEntry );
		while ( pChild )
		{
			if ( GetEntryText( pChild ) == rName )
				return pChild;
			
			SvLBoxEntry* pSubChild = GetEntry_Impl( pChild, rName );
			if ( !pSubChild )
				pChild = NextSibling( pChild );
			else
				return pSubChild;
		}
	}

	return NULL;
}

SvLBoxEntry* SfxConfigTreeListBox_Impl::GetEntry_Impl( SvLBoxEntry* pParentEntry, USHORT nId )
{
	if ( pParentEntry )
	{
		SvLBoxEntry* pChild = FirstChild( pParentEntry );
		while ( pChild )
		{
			if ( GetId( pChild ) == nId )
				return pChild;
			
			SvLBoxEntry* pSubChild = GetEntry_Impl( pChild, nId );
			if ( !pSubChild )
				pChild = NextSibling( pChild );
			else
				return pSubChild;
		}
	}

	return NULL;
}

SvLBoxEntry* SfxConfigTreeListBox_Impl::GetEntry_Impl( const String& rName )
/* 	Beschreibung
	Ermittelt den SvLBoxEntry zu einem "ubergebenen String. Das setzt voraus, da\s
	die Namen eindeutig sind.
*/
{
	SvLBoxEntry *pEntry = First();
	while ( pEntry )
	{
		if ( GetEntryText( pEntry ) == rName )
			return pEntry;
		pEntry = Next( pEntry );
	}

	return NULL;
}

SvLBoxEntry* SfxConfigTreeListBox_Impl::GetEntry_Impl( USHORT nId )
/* 	Beschreibung
	Ermittelt den SvLBoxEntry zu einer "ubergebenen Id.
*/
{
	SvLBoxEntry *pEntry = First();
	while ( pEntry )
	{
		SfxCfgGroupInfo_Impl *pData = (SfxCfgGroupInfo_Impl*) pEntry->GetUserData();
		if ( pData && pData->nOrd == nId )
			return pEntry;
		pEntry = Next( pEntry );
	}

	return NULL;
}

SfxMacroInfo* SfxConfigTreeListBox_Impl::GetMacroInfo()
/* 	Beschreibung
	Gibt die MacroInfo des selektierten Entry zur"uck ( sofern vorhanden ).
*/
{
	SvLBoxEntry *pEntry = FirstSelected();
	if ( pEntry )
	{
		SfxCfgGroupInfo_Impl *pData = (SfxCfgGroupInfo_Impl*) pEntry->GetUserData();
		if ( pData && pData->nKind == SFX_CFGFUNCTION_MACRO )
			return (SfxMacroInfo*) pData->pObject;
	}

	return 0;
}

USHORT SfxConfigTreeListBox_Impl::GetId( SvLBoxEntry *pEntry )
/*	Beschreibung
	Gibt die Ordnungsnummer ( SlotId oder Macro-Nummer ) des Eintrags zur"uck.
*/
{
	SfxCfgGroupInfo_Impl *pData = pEntry ?
		(SfxCfgGroupInfo_Impl*) pEntry->GetUserData() : 0;
	if ( pData )
		return pData->nOrd;
	return 0;
}

String SfxConfigTreeListBox_Impl::GetHelpText( SvLBoxEntry *pEntry )
/*	Beschreibung
	Gibt den Helptext des selektierten Entry zur"uck.
*/
{
	// Information zum selektierten Entry aus den Userdaten holen
	SfxCfgGroupInfo_Impl *pInfo = pEntry ? (SfxCfgGroupInfo_Impl*) pEntry->GetUserData(): 0;
	if ( pInfo )
	{
		if ( pInfo->nKind == SFX_CFGFUNCTION_SLOT )
		{
			// Eintrag ist eine Funktion, Hilfe aus der Office-Hilfe
			USHORT nId = pInfo->nOrd;
            String aText = Application::GetHelp()->GetHelpText( nId, this );

			if ( !aText.Len() )
				aText = SFX_SLOTPOOL().GetSlotHelpText_Impl( nId );
			return aText;
		}
		else if ( pInfo->nKind == SFX_CFGFUNCTION_MACRO )
		{
			// Eintrag ist ein Macro, Hilfe aus der MacroInfo
			SfxMacroInfo *pMacInfo = (SfxMacroInfo*) pInfo->pObject;
			return pMacInfo->GetHelpText();
		}
	}

	return String();
}

void SfxConfigTreeListBox_Impl::FunctionSelected()
/*	Beschreibung
	Setzt die Balloonhelp zur"uck, da diese immer den Helptext des selektierten
	Entry anzeigen soll.
*/
{
	Help::ShowBalloon( this, Point(), String() );
}

void SfxConfigTreeListBox_Impl::SetScriptType( const String& rScriptType )
{
	aScriptType = rScriptType;
	ULONG nPos=0;
	SvLBoxEntry *pEntry = (SvLBoxEntry*) GetModel()->GetEntryAtAbsPos( nPos++ );
	while ( pEntry )
	{
		SfxCfgGroupInfo_Impl *pInfo = (SfxCfgGroupInfo_Impl*) pEntry->GetUserData();
		if ( pInfo->nKind == SFX_CFGGROUP_BASICLIB && ( IsExpanded( pEntry ) || pInfo->bWasOpened ) )
		{
			Collapse( pEntry );
			SvLBoxEntry *pChild = FirstChild( pEntry );
			while (pChild)
			{
				GetModel()->Remove( pChild );
				pChild = FirstChild( pEntry );
			}

			Expand( pEntry );
		}

		pEntry = (SvLBoxEntry*) GetModel()->GetEntryAtAbsPos( nPos++ );
	}
}

String SfxConfigTreeListBox_Impl::GetGroup()
/*	Beschreibung
	Gibt den Namen der selektierten Funktionsgruppe bzw. des selektierten
	Basics zur"uck.
*/
{
	SvLBoxEntry *pEntry = FirstSelected();
	while ( pEntry )
	{
		SfxCfgGroupInfo_Impl *pInfo = (SfxCfgGroupInfo_Impl*) pEntry->GetUserData();
		if ( pInfo->nKind == SFX_CFGGROUP_FUNCTION )
		{
			return GetEntryText( pEntry );
			break;
		}

		if ( pInfo->nKind == SFX_CFGGROUP_BASICMGR )
		{
			BasicManager *pMgr = (BasicManager*) pInfo->pObject;
			return pMgr->GetName();
			break;
		}

		if ( pInfo->nKind == SFX_CFGGROUP_DOCBASICMGR )
		{
			SfxObjectShell *pDoc = (SfxObjectShell*) pInfo->pObject;
			return pDoc->GetTitle();
			break;
		}

		pEntry = GetParent( pEntry );
	}

	return String();
}

void SfxConfigTreeListBox_Impl::Init( SvStringsDtor *pArr, SfxSlotPool* pPool )
/*  Beschreibung
	Die Groupbox wird mit allen Funktionsgruppen und allen Basics gef"ullt
*/
{
	SetUpdateMode(FALSE);
	SfxApplication *pSfxApp = SFX_APP();

	// Verwendet wird der aktuelle Slotpool
	if ( nMode )
	{
		pSlotPool = pPool ? pPool : &SFX_SLOTPOOL();
		for ( USHORT i=1; i<pSlotPool->GetGroupCount(); i++ )
		{
			// Gruppe anw"ahlen ( Gruppe 0 ist intern )
			String aName = pSlotPool->SeekGroup( i );
			const SfxSlot *pSfxSlot = pSlotPool->FirstSlot();
			if ( pSfxSlot )
			{
				// Check if all entries are not useable. Don't
				// insert a group without any useable function.
				sal_Bool bActiveEntries = sal_False;
				while ( pSfxSlot )
				{
					USHORT nId = pSfxSlot->GetSlotId();
#ifdef UNX
                    if ( nId != SID_DESKTOPMODE && ( pSfxSlot->GetMode() & nMode ) )
#else
                    if ( pSfxSlot->GetMode() & nMode )
#endif
					{
						bActiveEntries = sal_True;
						break;
					}

					pSfxSlot = pSlotPool->NextSlot();
				}

				if ( bActiveEntries )
				{
					// Wenn Gruppe nicht leer
					SvLBoxEntry *pEntry = InsertEntry( aName, NULL );
					SfxCfgGroupInfo_Impl *pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGGROUP_FUNCTION, i );
					aArr.Insert( pInfo, aArr.Count() );
					pEntry->SetUserData( pInfo );
					pEntry->EnableChildsOnDemand( TRUE );
				}
			}
		}
	}

	// Basics einsammeln
	pSfxApp->EnterBasicCall();
	String aMacroName(' ');
	aMacroName += String(SfxResId(STR_BASICMACROS));

	// Zuerst AppBasic
	BasicManager *pAppBasicMgr = pSfxApp->GetBasicManager();
	BOOL bInsert = TRUE;
	if ( pArr )
	{
		bInsert = FALSE;
		for ( USHORT n=0; n<pArr->Count(); n++ )
		{
			if ( *(*pArr)[n] == pSfxApp->GetName() )
			{
				bInsert = TRUE;
				break;
			}
		}
	}

	if ( bInsert )
	{
		pAppBasicMgr->SetName( pSfxApp->GetName() );
		if ( pAppBasicMgr->GetLibCount() )
		{
			// Nur einf"ugen, wenn Bibliotheken vorhanden
			String aAppBasTitle( SfxResId( STR_HUMAN_APPNAME ) );
			aAppBasTitle += aMacroName;
			SvLBoxEntry *pEntry = InsertEntry( aAppBasTitle, 0 );
			SfxCfgGroupInfo_Impl *pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGGROUP_BASICMGR, 0, pAppBasicMgr );
			aArr.Insert( pInfo, aArr.Count() );
			pEntry->SetUserData( pInfo );
			pEntry->EnableChildsOnDemand( TRUE );
//			Expand( pEntry );
		}
	}

	SfxObjectShell *pDoc = SfxObjectShell::GetFirst();
	while ( pDoc )
	{
		BOOL bInsert = TRUE;
		if ( pArr )
		{
			bInsert = FALSE;
			for ( USHORT n=0; n<pArr->Count(); n++ )
			{
				if ( *(*pArr)[n] == pDoc->GetTitle() )
				{
					bInsert = TRUE;
					break;
				}
			}
		}

		if ( bInsert )
		{
			BasicManager *pBasicMgr = pDoc->GetBasicManager();
			if ( pBasicMgr != pAppBasicMgr && pBasicMgr->GetLibCount() )
			{
				pBasicMgr->SetName( pDoc->GetTitle() );

				// Nur einf"ugen, wenn eigenes Basic mit Bibliotheken
				SvLBoxEntry *pEntry = InsertEntry( pDoc->GetTitle().Append(aMacroName), NULL );
				SfxCfgGroupInfo_Impl *pInfo =
					new SfxCfgGroupInfo_Impl( SFX_CFGGROUP_DOCBASICMGR, 0, pDoc );
				aArr.Insert( pInfo, aArr.Count() );
				pEntry->SetUserData( pInfo );
				pEntry->EnableChildsOnDemand( TRUE );
//				Expand( pEntry );
			}
		}

		pDoc = SfxObjectShell::GetNext(*pDoc);
	}

	pSfxApp->LeaveBasicCall();

	// Insert an entry on root for a normal separator and space
	// Insert an entry for a normal separator
	String aSeparatorStr( SfxResId( STR_TOOLBAR_SEPARATOR ) );
	String aSpaceStr( SfxResId( STR_TOOLBAR_SPACE ) );

	SvLBoxEntry *pNewEntry = InsertEntry( aSeparatorStr, NULL );
	SfxCfgGroupInfo_Impl *pInfo =
		new SfxCfgGroupInfo_Impl( SFX_CFGFUNCTION_SEPARATOR, 0, 0 );
	pNewEntry->SetUserData( pInfo );
	
	// Insert an entry on root for a space separator
	pNewEntry = InsertEntry( aSpaceStr, NULL );
	pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGFUNCTION_SPACE, 0, 0 );
	pNewEntry->SetUserData( pInfo );

	MakeVisible( GetEntry( 0,0 ) );
	SetUpdateMode( TRUE );
}

void SfxConfigTreeListBox_Impl::GroupSelected()
/*	Beschreibung
	Eine Funktionsgruppe oder eine Basicmodul wurde selektiert. Alle Funktionen bzw.
	Macros werden in der Functionlistbox anzeigt.
*/
{
}

BOOL SfxConfigTreeListBox_Impl::Expand( SvLBoxEntry* pParent )
{
	BOOL bRet = SvTreeListBox::Expand( pParent );
	if ( bRet )
	{
		// Wieviele Entries k"onnen angezeigt werden ?
		ULONG nEntries = GetOutputSizePixel().Height() / GetEntryHeight();

		// Wieviele Kinder sollen angezeigt werden ?
		ULONG nChildCount = GetVisibleChildCount( pParent );

		// Passen alle Kinder und der parent gleichzeitig in die View ?
		if ( nChildCount+1 > nEntries )
		{
			// Wenn nicht, wenigstens parent ganz nach oben schieben
			MakeVisible( pParent, TRUE );
		}
		else
		{
			// An welcher relativen ViewPosition steht der aufzuklappende parent
			SvLBoxEntry *pEntry = GetFirstEntryInView();
			ULONG nParentPos = 0;
			while ( pEntry && pEntry != pParent )
			{
				nParentPos++;
				pEntry = GetNextEntryInView( pEntry );
			}

			// Ist unter dem parent noch genug Platz f"ur alle Kinder ?
			if ( nParentPos + nChildCount + 1 > nEntries )
				ScrollOutputArea( (short)( nEntries - ( nParentPos + nChildCount + 1 ) ) );
		}
	}

	return bRet;
}

void SfxConfigTreeListBox_Impl::RequestingChilds( SvLBoxEntry *pEntry )
/*	Beschreibung
	Ein Basic oder eine Bibliothek werden ge"offnet
*/
{
	SfxCfgGroupInfo_Impl *pInfo = (SfxCfgGroupInfo_Impl*) pEntry->GetUserData();
	pInfo->bWasOpened = TRUE;
	switch ( pInfo->nKind )
	{
		case SFX_CFGGROUP_FUNCTION:
		{
			if ( !GetChildCount( pEntry ) )
			{
				SfxImageManager* pImgMgr = pBindings->GetImageManager();
				SetUpdateMode( FALSE );

				// 1st time this entry is opened
				USHORT nGroup = pInfo->nOrd;
				String aSelectedGroup = pSlotPool->SeekGroup( nGroup );
				if ( aSelectedGroup != String() )
				{
					const SfxSlot *pSfxSlot = pSlotPool->FirstSlot();
					while ( pSfxSlot )
					{
						USHORT nId = pSfxSlot->GetSlotId();
#ifdef UNX
						if ( nId != SID_DESKTOPMODE && ( pSfxSlot->GetMode() & nMode ) )
#else
						if ( pSfxSlot->GetMode() & nMode )
#endif
						{
							String aName = pSlotPool->GetSlotName_Impl( *pSfxSlot );
							if ( aName.Len() && !GetEntry_Impl( pEntry, nId ) )
							{
#ifdef DBG_UTIL
								if ( GetEntry_Impl( aName ) )
									DBG_WARNINGFILE( "function name already exits" );
#endif
								// Wenn die Namen unterschiedlich sind, dann auch die Funktion, denn zu
								// einer Id liefert der Slotpool immer den gleichen Namen!
								Image aImage = pImgMgr->SeekImage( nId );
								SvLBoxEntry* pFuncEntry = InsertEntry( aName, aImage, aImage, pEntry );
								
								SfxCfgGroupInfo_Impl *pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGFUNCTION_SLOT, nId );
								aArr.Insert( pInfo, aArr.Count() );
								pFuncEntry->SetUserData( pInfo );
							}
						}

						pSfxSlot = pSlotPool->NextSlot();
					}
				}
				
				SetUpdateMode( TRUE );
			}
			break;
		}
		
		case SFX_CFGGROUP_BASICMGR :
		case SFX_CFGGROUP_DOCBASICMGR :
		{
			if ( !GetChildCount( pEntry ) )
			{
				// Erstmaliges "Offnen
				SetUpdateMode( FALSE );

				BasicManager *pMgr;
				if ( pInfo->nKind == SFX_CFGGROUP_DOCBASICMGR )
					pMgr = ((SfxObjectShell*)pInfo->pObject)->GetBasicManager();
				else
					pMgr = (BasicManager*) pInfo->pObject;

				SvLBoxEntry *pLibEntry = 0;
				for ( USHORT nLib=0; nLib<pMgr->GetLibCount(); nLib++)
				{
					StarBASIC* pLib = pMgr->GetLib( nLib );
					pLibEntry = InsertEntry( pMgr->GetLibName( nLib ), pEntry );
					SfxCfgGroupInfo_Impl *pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGGROUP_BASICLIB, nLib, pLib );
					aArr.Insert( pInfo, aArr.Count() );
					pLibEntry->SetUserData( pInfo );
					pLibEntry->EnableChildsOnDemand( TRUE );
				}
				
				SetUpdateMode( TRUE );
			}

			break;
		}

		case SFX_CFGGROUP_BASICLIB :
		{
			if ( !GetChildCount( pEntry ) )
			{
				// Erstmaliges "Offnen
				SetUpdateMode( FALSE );
				StarBASIC *pLib = (StarBASIC*) pInfo->pObject;
				if ( !pLib )
				{
					// Lib mu\s nachgeladen werden
					SvLBoxEntry *pParent = GetParent( pEntry );
					SfxCfgGroupInfo_Impl *pInf =
						(SfxCfgGroupInfo_Impl*) pParent->GetUserData();
					BasicManager *pMgr;
					if ( pInf->nKind == SFX_CFGGROUP_DOCBASICMGR )
						pMgr = ((SfxObjectShell*)pInf->pObject)->GetBasicManager();
					else
						pMgr = (BasicManager*) pInf->pObject;

					if ( pMgr->LoadLib( pInfo->nOrd ) )
						pInfo->pObject = pLib = pMgr->GetLib( pInfo->nOrd );
					else
						break;
				}

				SvLBoxEntry *pModEntry = 0;
				for ( USHORT nMod=0; nMod<pLib->GetModules()->Count(); nMod++ )
				{
					SbModule* pMod = (SbModule*)pLib->GetModules()->Get( nMod );

					BOOL bIsStarScript = FALSE; //pMod->ISA( SbJScriptModule );
					BOOL bWantsStarScript = aScriptType.EqualsAscii("StarScript");
					if ( bIsStarScript != bWantsStarScript )
						continue;
					pModEntry = InsertEntry( pMod->GetName(), pEntry );
					SfxCfgGroupInfo_Impl *pInfo = new SfxCfgGroupInfo_Impl( SFX_CFGGROUP_BASICMOD, 0, pMod );
					aArr.Insert( pInfo, aArr.Count() );
					pModEntry->SetUserData( pInfo );
					pModEntry->EnableChildsOnDemand( TRUE );
				}
				SetUpdateMode( TRUE );
			}

			break;
		}

		case SFX_CFGGROUP_BASICMOD :
		{
			if ( !GetChildCount( pEntry ) )
			{
				SetUpdateMode( FALSE );
				
				SvLBoxEntry *pLibEntry = GetParent( pEntry );
				SfxCfgGroupInfo_Impl *pLibInfo =
					(SfxCfgGroupInfo_Impl*) pLibEntry->GetUserData();
				SvLBoxEntry *pBasEntry = GetParent( pLibEntry );
				SfxCfgGroupInfo_Impl *pBasInfo =
					(SfxCfgGroupInfo_Impl*) pBasEntry->GetUserData();

				StarBASIC *pLib = (StarBASIC*) pLibInfo->pObject;
				SfxObjectShell *pDoc = NULL;
				if ( pBasInfo->nKind == SFX_CFGGROUP_DOCBASICMGR )
					pDoc = (SfxObjectShell*) pBasInfo->pObject;

				SbModule *pMod = (SbModule*) pInfo->pObject;
				for ( USHORT nMeth=0; nMeth < pMod->GetMethods()->Count(); nMeth++ )
				{
					SbxMethod *pMeth = (SbxMethod*)pMod->GetMethods()->Get(nMeth);
					SfxMacroInfoPtr pInf = new SfxMacroInfo( pDoc,
															 pLib->GetName(),
															 pMod->GetName(),
															 pMeth->GetName());
					if ( pMeth->GetInfo() )
						pInf->SetHelpText( pMeth->GetInfo()->GetComment() );
					USHORT nId = SFX_APP()->GetMacroConfig()->GetSlotId( pInf );
					if ( !nId )
						break; 		// Kein Slot mehr frei

					SvLBoxEntry* pFuncEntry = InsertEntry( pMeth->GetName(), pEntry );
					SfxCfgGroupInfo_Impl *pInfo =
						new SfxCfgGroupInfo_Impl( SFX_CFGFUNCTION_MACRO, nId, pInf );
					aArr.Insert( pInfo, aArr.Count() );
					pFuncEntry->SetUserData( pInfo );
				}
				
				SetUpdateMode( TRUE );
			}

			break;
		}

		default:
			DBG_ERROR( "Falscher Gruppentyp!" );
			break;
	}
}

// --------------------------------------------------------

// new d&d
DragDropMode SfxConfigTreeListBox_Impl::NotifyStartDrag( TransferDataContainer& aTransferDataContainer, SvLBoxEntry* pEntry )
{
	bDragInProgress = TRUE;

	Help::ShowBalloon( this, Point(), String() );
	aTimer.Stop();

	if ( pEntry )
	{
		SfxCfgGroupInfo_Impl *pInfo = (SfxCfgGroupInfo_Impl*)pEntry->GetUserData();
		if ( pInfo )
		{
			if ( pInfo->nKind >= SFX_CFGFUNCTION_MACRO && 
				 pInfo->nKind <= SFX_CFGFUNCTION_SPACE )
				return GetDragDropMode();
		}
	}
	
	return SV_DRAGDROP_NONE;
}

BOOL SfxConfigTreeListBox_Impl::NotifyAcceptDrop( SvLBoxEntry* pEntry )
{
	return FALSE;
}

sal_Int8 SfxConfigTreeListBox_Impl::AcceptDrop( const AcceptDropEvent& rEvt )
{
	return SvTreeListBox::AcceptDrop( rEvt );
}

sal_Int8 SfxConfigTreeListBox_Impl::ExecuteDrop( const ExecuteDropEvent& rEvt )
{
	return SvTreeListBox::ExecuteDrop( rEvt );
}

void SfxConfigTreeListBox_Impl::DragFinished( sal_Int8 nDropAction )
{
	bDragInProgress = FALSE;
	SvTreeListBox::DragFinished( nDropAction );
}

// --------------------------------------------------------


class ToolbarLBoxString_Impl : public SvLBoxString
{
public:
	ToolbarLBoxString_Impl( SvLBoxEntry* pEntry, USHORT nFlags,	const String& rTxt ) :
		SvLBoxString( pEntry, nFlags, rTxt ) {}

	virtual void Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags, SvLBoxEntry* pEntry );
};

// -----------------------------------------------------------------------

void ToolbarLBoxString_Impl::Paint( const Point& rPos, SvLBox& rDev, USHORT, SvLBoxEntry* pEntry )
{
	Font aOldFont( rDev.GetFont() );
	Font aFont( aOldFont );
	DBG_ASSERT( pEntry && pEntry->GetUserData(), "Entry or UserData invalid" );
	
	BOOL bVisible = ( (SfxToolbarEntryInfo_Impl*)pEntry->GetUserData() )->bVisible;
	if ( !bVisible )
	{
		aFont.SetColor( Application::GetSettings().GetStyleSettings().GetDeactiveTextColor() );
	}
	rDev.SetFont( aFont );
	rDev.DrawText( rPos, GetText() );
	rDev.SetFont( aOldFont );
}

// -----------------------------------------------------------------------

SV_IMPL_PTRARR(SfxToolbarEntryInfoArr_Impl, SfxToolbarEntryInfoPtr);

SfxToolbarTreeListBox_Impl::SfxToolbarTreeListBox_Impl( 
	Window* pParent, const ResId& aResId, SfxBindings* pBindings ) : 
	SvTreeListBox( pParent, aResId ),
	m_pBindings( pBindings ),
	m_pCurEntry( 0 ),
	m_pTbxMgr( 0 ),
	m_pIFace( 0 ),
	m_bDragSource( FALSE )
{
	SetWindowBits( GetStyle() | WB_CLIPCHILDREN | WB_HSCROLL | WB_HIDESELECTION );
	SetSpaceBetweenEntries( 0 ); // SetSpaceBetweenEntries( 6 );
	SetEntryHeight( 16 );
	SetHighlightRange(); // SetHighlightRange( 1, 0xffff );
	SetSelectionMode(SINGLE_SELECTION);
	
	SetDragDropMode( SV_DRAGDROP_CTRL_MOVE	|
					 SV_DRAGDROP_APP_COPY	|
					 SV_DRAGDROP_ENABLE_TOP |
					 SV_DRAGDROP_APP_DROP);

	m_pButtonData = new SvLBoxButtonData();
	BuildCheckBoxButtonImages( m_pButtonData );
	EnableCheckButton( m_pButtonData );

	m_aSeparator = String::CreateFromAscii( "---------------------------" );
	m_aSpace	 = String::CreateFromAscii( "~~~~~~~~~~~~~~~~" );
	
	// Timer for the balloon help
	m_aTimer.SetTimeout( 200 );
	m_aTimer.SetTimeoutHdl( LINK( this, SfxToolbarTreeListBox_Impl, TimerHdl ) );
}

// --------------------------------------------------------

SfxToolbarTreeListBox_Impl::~SfxToolbarTreeListBox_Impl()
{
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::BuildCheckBoxButtonImages( SvLBoxButtonData* pData )
{
	// Build checkbox images according to the current application settings. This is necessary to
	// be able to have correct colors in all color modes, like high contrast.
	const AllSettings& rSettings = Application::GetSettings();

	// 
	VirtualDevice	aDev;
	Size			aSize( 26, 20 );

	aDev.SetOutputSizePixel( aSize );

	Image aImage = GetSizedImage( aDev, aSize, CheckBox::GetCheckImage( rSettings, BUTTON_DRAW_DEFAULT ));

	// Fill button data struct with new images
	pData->aBmps[SV_BMP_UNCHECKED]		= aImage;
	pData->aBmps[SV_BMP_CHECKED]		= GetSizedImage( aDev, aSize, CheckBox::GetCheckImage( rSettings, BUTTON_DRAW_CHECKED ));
	pData->aBmps[SV_BMP_HICHECKED]		= GetSizedImage( aDev, aSize, CheckBox::GetCheckImage( rSettings, BUTTON_DRAW_CHECKED | BUTTON_DRAW_PRESSED ));
	pData->aBmps[SV_BMP_HIUNCHECKED]	= GetSizedImage( aDev, aSize, CheckBox::GetCheckImage( rSettings, BUTTON_DRAW_DEFAULT | BUTTON_DRAW_PRESSED));
	pData->aBmps[SV_BMP_TRISTATE]		= GetSizedImage( aDev, aSize, Image() ); // Use tristate bitmaps to have no checkbox for separator entries
	pData->aBmps[SV_BMP_HITRISTATE]		= GetSizedImage( aDev, aSize, Image() );
	
	// Get image size
	m_aCheckBoxImageSizePixel = aImage.GetSizePixel();
}

Image SfxToolbarTreeListBox_Impl::GetSizedImage( VirtualDevice& aDev, const Size& aNewSize, const Image& aImage )
{	
	// Create new checkbox images for treelistbox. They must have a decent width to have a clear column for the
	// visibility checkbox.
	
	// Standard transparent color is light magenta as is won't be used for other things
	Color	aFillColor( COL_LIGHTMAGENTA ); 
	 
	// Position image at the center of (width-2),(height) rectangle. We need 2 pixels to have a bigger border
	// to the next button image
	USHORT	nPosX = std::max( (USHORT) (((( aNewSize.Width() - 2 ) - aImage.GetSizePixel().Width() ) / 2 ) - 1), (USHORT) 0 );
	USHORT	nPosY = std::max( (USHORT) (((( aNewSize.Height() - 2 ) - aImage.GetSizePixel().Height() ) / 2 ) + 1), (USHORT) 0 );
	Point	aPos( nPosX > 0 ? nPosX : 0, nPosY > 0 ? nPosY : 0 );
	aDev.SetFillColor( aFillColor );
	aDev.SetLineColor( aFillColor );
	aDev.DrawRect( Rectangle( Point(), aNewSize ));
	aDev.DrawImage( aPos, aImage );
	
	// Draw separator line 2 pixels left from the right border
	aDev.SetLineColor( Application::GetSettings().GetStyleSettings().GetDeactiveTextColor() );
	aDev.DrawLine( Point( aNewSize.Width()-3, 0 ), Point( aNewSize.Width()-3, aNewSize.Height()-1 ));

	// Create new image that uses the fillcolor as transparent
	return Image( aDev.GetBitmap( Point(), aNewSize ), aFillColor );
}

void SfxToolbarTreeListBox_Impl::DataChanged( const DataChangedEvent& rDCEvt )
{
	SvTreeListBox::DataChanged( rDCEvt );

	if (( rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( rDCEvt.GetFlags() & SETTINGS_STYLE			))
    {
		BuildCheckBoxButtonImages( m_pButtonData );
        Invalidate();
    }
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::Init( SfxToolBoxManager* pTbxMgr, SfxInterface* pIFace, SfxSlotPool* pSlotPool )
{
	USHORT			nId = 0;
	USHORT			nItemCount	= 0;
	ToolBoxItemType nInsertSepType = TOOLBOXITEM_DONTKNOW;

	// Set internal members for the new toolbox
	m_pTbxMgr	= pTbxMgr;
	pSlotPool	= ( pSlotPool == 0 ) ? &SFX_SLOTPOOL() : pSlotPool;
	m_pIFace	= pIFace;

	// Retrieve all toolbox items and insert them into our toolbox SvTreeListBox
	ToolBox& rToolBox = pTbxMgr->GetToolBox();
	
	nItemCount = rToolBox.GetItemCount();
	for ( USHORT n = 0; n < nItemCount; n++ )
	{
		nId = rToolBox.GetItemId( n );
		ToolBoxItemType nType = rToolBox.GetItemType( n );
		if ( nType == TOOLBOXITEM_BUTTON )
		{
			String			aItemText;
			SvLBoxEntry*	pTbEntry;
			
			const SfxSlot* pSfxSlot = pSlotPool->GetSlot( nId );
			if ( pSfxSlot )
				aItemText	= pSlotPool->GetSlotName_Impl( *pSfxSlot );
			else if ( SfxMacroConfig::IsMacroSlot( nId ) )
				aItemText = rToolBox.GetItemText( nId );

			Image	aImage = rToolBox.GetItemImage( nId );
			BOOL	bVisible = rToolBox.IsItemVisible( nId );
			SfxToolbarEntryInfo_Impl* pData = new SfxToolbarEntryInfo_Impl( TOOLBOXITEM_BUTTON, nId, bVisible );
			m_aArr.Insert( pData, m_aArr.Count() );
				
			if ( !!aImage )
				pTbEntry = InsertEntry( aItemText, aImage, aImage, NULL, FALSE, LIST_APPEND, pData );
			else
				pTbEntry = InsertEntry( aItemText, NULL, FALSE, LIST_APPEND, pData );
			
			SetCheckButtonState( pTbEntry, bVisible ? SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED );
		}
		else if ( nType == TOOLBOXITEM_SEPARATOR )
		{
			SfxToolbarEntryInfo_Impl* pData = new SfxToolbarEntryInfo_Impl( TOOLBOXITEM_SEPARATOR, 0 );
			m_aArr.Insert( pData, m_aArr.Count() );
			SvLBoxEntry* pTbEntry = InsertEntry( m_aSeparator );
			pTbEntry->SetUserData( pData );
			SetCheckButtonState( pTbEntry, SV_BUTTON_TRISTATE );
		}
		else
		{
			SfxToolbarEntryInfo_Impl* pData = new SfxToolbarEntryInfo_Impl( TOOLBOXITEM_SPACE, 0 );
			m_aArr.Insert( pData, m_aArr.Count() );
			SvLBoxEntry* pTbEntry = InsertEntry( m_aSpace );
			pTbEntry->SetUserData( pData );
			SetCheckButtonState( pTbEntry, SV_BUTTON_TRISTATE );
		}
	}
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::ClearAll()
{
	USHORT nCount = m_aArr.Count();
	for ( USHORT i=0; i<nCount; i++ )
	{
		SfxToolbarEntryInfo_Impl *pData = m_aArr[i];
		// Don't delete MacroInfo as this is done by the SfxConfigTreeListBox_Impl 
		// implementation
		delete pData; 
	}

	m_aArr.Remove( 0, nCount );
	Clear();
}

// --------------------------------------------------------

USHORT SfxToolbarTreeListBox_Impl::GetId( SvLBoxEntry *pEntry )
{
	SfxToolbarEntryInfo_Impl *pInfo = pEntry ? (SfxToolbarEntryInfo_Impl*) pEntry->GetUserData(): 0;
	if ( pInfo )
	{
		if ( pInfo->nKind == TOOLBOXITEM_BUTTON )
			return pInfo->nId;
	}

	return 0;
}

// --------------------------------------------------------

String SfxToolbarTreeListBox_Impl::GetHelpText( SvLBoxEntry *pEntry )
{
	// Information zum selektierten Entry aus den Userdaten holen
	SfxToolbarEntryInfo_Impl *pInfo = pEntry ? (SfxToolbarEntryInfo_Impl*) pEntry->GetUserData(): 0;
	if ( pInfo && pInfo->nKind == TOOLBOXITEM_BUTTON )
	{
		// Eintrag ist eine Funktion, Hilfe aus der Office-Hilfe
		USHORT			nId = pInfo->nId;
		SfxMacroInfo*	pMacroInfo = pInfo->pMacroInfo;
            
		if ( pMacroInfo )
			return pMacroInfo->GetHelpText();
		else
		{
			String aText = Application::GetHelp()->GetHelpText( nId, this );
			
			if ( !aText.Len() )
				aText = SFX_SLOTPOOL().GetSlotHelpText_Impl( nId );
			
			return aText;
		}
	}

	return String();
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::GetPos( ULONG& nPos, SvLBoxEntry* pEntry )
{
	for ( ULONG n = 0; n < GetEntryCount(); n++ )
	{
		if ( GetEntry( 0, n ) == pEntry )
		{
			nPos = n;
			return TRUE;
		}
	}

	return FALSE;
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::InitEntry( SvLBoxEntry* pEntry, const XubString& rTxt, const Image& rImg1, const Image& rImg2 )
{
	SvTreeListBox::InitEntry( pEntry, rTxt, rImg1, rImg2 );
	USHORT nTabCount = TabCount();

	for ( USHORT nCol = 2; nCol < nTabCount; ++nCol )
	{
		// Initialize text column with own class (Col 0 == Checkox |Col 1 == Bitmap )
		SvLBoxString* pCol = (SvLBoxString*)pEntry->GetItem( nCol );
		ToolbarLBoxString_Impl* pStr = new ToolbarLBoxString_Impl( pEntry, 0, pCol->GetText() );
		pEntry->ReplaceItem( pStr, nCol );
	}
}

// --------------------------------------------------------

// new d&d
DragDropMode SfxToolbarTreeListBox_Impl::NotifyStartDrag( TransferDataContainer& aTransferDataContainer, SvLBoxEntry* pEntry )
{
	Help::ShowBalloon( this, Point(), String() );
	m_aTimer.Stop();

	m_bDragSource = TRUE;
	return GetDragDropMode();
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::NotifyAcceptDrop( SvLBoxEntry* pEntry )
{
	return SvTreeListBox::NotifyAcceptDrop( pEntry );
}

// --------------------------------------------------------

sal_Int8 SfxToolbarTreeListBox_Impl::AcceptDrop( const AcceptDropEvent& rEvt )
{
	if ( m_bDragSource )
	{
		if ( rEvt.mnAction == DND_ACTION_MOVE )
			return SvTreeListBox::AcceptDrop( rEvt );
		else
			return DND_ACTION_NONE;
	}

	// Always do COPY instead of MOVE if D&D comes from outside!
	AcceptDropEvent aNewAcceptDropEvent( rEvt );
	aNewAcceptDropEvent.mnAction = DND_ACTION_COPY;
	return SvTreeListBox::AcceptDrop( aNewAcceptDropEvent );
}

// --------------------------------------------------------

sal_Int8 SfxToolbarTreeListBox_Impl::ExecuteDrop( const ExecuteDropEvent& rEvt )
{
	return SvTreeListBox::ExecuteDrop( rEvt );
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::DragFinished( sal_Int8 nDropAction )
{
	m_bDragSource = FALSE;
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::NotifyMoving(
	SvLBoxEntry*  pTarget,
	SvLBoxEntry*  pEntry,
	SvLBoxEntry*& rpNewParent,
	ULONG&		  rNewChildPos )
{
	if ( m_bDragSource )
	{
		ULONG	nOldPos = 0;
		ULONG	nNewPos = 0;
		
		// Support for D&D on the top position
		if ( pTarget != 0 )
			GetPos( nNewPos, pTarget );
		GetPos( nOldPos, pEntry );

		if ( nOldPos != nNewPos )
		{
			ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
			
			USHORT nOldTbxPos = (USHORT)nOldPos;
			USHORT nNewTbxPos = (USHORT)nNewPos+1;
			
			if ( SvTreeListBox::NotifyMoving( pTarget, pEntry, rpNewParent, rNewChildPos ))
			{
				if ( rToolBox.GetItemId( nOldTbxPos ) != 0 )
					rToolBox.MoveItem( rToolBox.GetItemId( nOldTbxPos ), nNewTbxPos );
				else
				{
					// Can't move separators because the do not have a unique id!
					rToolBox.RemoveItem( nOldTbxPos );
					SfxToolbarEntryInfo_Impl* pInfo = (SfxToolbarEntryInfo_Impl*)pEntry->GetUserData();
					if ( nOldTbxPos < nNewTbxPos )
						--nNewTbxPos ;
					if ( pInfo->nKind == TOOLBOXITEM_SEPARATOR )
						rToolBox.InsertSeparator( nNewTbxPos );
					else
						rToolBox.InsertSpace( nNewTbxPos );
				}
				
				m_pTbxMgr->SetDefault( FALSE );
				if ( m_aChangedListener.IsSet() )
					m_aChangedListener.Call( this );
				return TRUE;
			}
		}	
	}
	
	return FALSE;
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::NotifyCopying(
	SvLBoxEntry*  pTarget,		 
	SvLBoxEntry*  pEntry,		 
	SvLBoxEntry*& rpNewParent,   
	ULONG&		  rNewChildPos ) 
{
	if ( !m_bDragSource )
	{
		SvLBox* pDragSource = GetSourceView();
		if ( pDragSource == m_pSVLBoxFunctions )
		{
			// This is my special drag&drop partner tree list box. I know his SvLBoxEntry format!
			SfxCfgGroupInfo_Impl *pInfo = pEntry ? (SfxCfgGroupInfo_Impl*)pEntry->GetUserData(): 0;
			if ( pInfo )
			{
				// Support fro D&D on the top position
				BOOL bFront = ( pTarget == 0 );
				BOOL bSuccess = TRUE;
				if ( pInfo->nKind == SFX_CFGFUNCTION_MACRO )
					bSuccess = AddFunction( pTarget, pInfo->nKind, pInfo->nOrd, (SfxMacroInfo *)pInfo->pObject, bFront );
				else if ( pInfo->nKind == SFX_CFGFUNCTION_SLOT )
					bSuccess = AddFunction( pTarget, pInfo->nKind, pInfo->nOrd, 0, bFront );
				else if ( pInfo->nKind == SFX_CFGFUNCTION_SEPARATOR )
					AddSeparator( pTarget, TOOLBOXITEM_SEPARATOR, bFront );
				else if (pInfo->nKind == SFX_CFGFUNCTION_SPACE )
					AddSeparator( pTarget, TOOLBOXITEM_SPACE, bFront );

				if ( !bSuccess )
				{
					// asynchronous error message, because of MessBoxes
					PostUserEvent( LINK( this, SfxToolbarTreeListBox_Impl, AsyncInfoMsg ), 
									new String( SfxResId( STR_FUNCTION_ALREADY_IN_TOOLBOX ) ) );
				}
				else if ( m_aChangedListener.IsSet() )
					m_aChangedListener.Call( this ); // Call listener if set
			}
		}
	}
	
	// I want to do all within the tree list box
	return FALSE;
}

// --------------------------------------------------------

void  SfxToolbarTreeListBox_Impl::CheckButtonHdl()
{
	SvLBoxEntry* pEntry = GetHdlEntry();
	
	if ( pEntry )
	{
		SfxToolbarEntryInfo_Impl* pInfo = (SfxToolbarEntryInfo_Impl*)pEntry->GetUserData();
		if ( pInfo->nKind == TOOLBOXITEM_BUTTON )
		{
			USHORT nId = pInfo->nId;
			ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
			if ( GetCheckButtonState( pEntry ) == SV_BUTTON_CHECKED )
			{
				pInfo->bVisible = TRUE;
				rToolBox.ShowItem( nId );
			}
			else
			{
				pInfo->bVisible = FALSE;
				rToolBox.HideItem( nId );
			}
			
			PaintEntry( pEntry );

			m_pTbxMgr->SetModified( TRUE );
			m_pTbxMgr->SetDefault( FALSE );
			
			// Call listener if set
 			if ( m_aChangedListener.IsSet() )
				m_aChangedListener.Call( this );
		}
		else
			SetCheckButtonState( pEntry, SV_BUTTON_TRISTATE ); // Cannot uncheck separator/space!
	}
}

// --------------------------------------------------------

IMPL_LINK( SfxToolbarTreeListBox_Impl, AsyncInfoMsg, String*, pMsg )
{
	// Asynchronous msg because of D&D
    Window * pWin = Window::GetParent();
	InfoBox( pWin, *pMsg ).Execute();
	delete pMsg;

	return 0;
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::RemoveItem( SvLBoxEntry* pEntry )
{
	if ( pEntry )
	{
		// Add entry behind the current position
		ULONG nPos;
		if ( !GetPos( nPos, pEntry ))
			return FALSE;
		
		SfxToolbarEntryInfo_Impl *pInfo = pEntry ? (SfxToolbarEntryInfo_Impl*) pEntry->GetUserData(): 0;

		ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
		m_pTbxMgr->RemoveItem( pInfo ? pInfo->nId : 0, (USHORT)nPos );

		SvTreeList* pModel = GetModel();
		pModel->Remove( pEntry );

		// Call listener if set
		if ( m_aChangedListener.IsSet() )
			m_aChangedListener.Call( this );
		
		return TRUE;
	}
	
	return FALSE;
}

// --------------------------------------------------------

BOOL SfxToolbarTreeListBox_Impl::AddFunction( SvLBoxEntry* pEntry, USHORT nKind, USHORT nId, SfxMacroInfo* pMacroInfo, BOOL bFront )
{
	SfxImageManager* pImgMgr	= m_pBindings->GetImageManager();
	SfxSlotPool*	 pSlotPool	= &SFX_SLOTPOOL();
	
	BOOL	bMoveEntry	= FALSE;
	ULONG	nPos		= 0;
	USHORT	nTbxPos		= 0;

	ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
	
	// Check if function is already in the toolbox, this is not allowed!
	USHORT nTmpPos = rToolBox.GetItemPos( nId );
	if ( nTmpPos != TOOLBOX_ITEM_NOTFOUND )
		return FALSE;
	
	if ( pEntry )
	{
		// Add entry behind the give entry
		if ( !GetPos( nPos, pEntry ))
			return FALSE; // impossible case: we cannot find the entry
		
 		++nPos; // Add it behind the current position
		nTbxPos = (USHORT)nPos;
	}
	else
	{
		if ( bFront )
		{
			// Support for D&D on the top position
			nPos = 0;
			nTbxPos = 0;
		}
		else
		{
			// Append entry at the end
			nPos = LIST_APPEND;
			nTbxPos = TOOLBOX_APPEND;
		}
	}

	String aName;
	if ( pMacroInfo )
		aName = pMacroInfo->GetMethodName();
	else
		aName = pSlotPool->GetSlotName_Impl( nId );

	SfxToolbarEntryInfo_Impl* pData = new SfxToolbarEntryInfo_Impl( TOOLBOXITEM_BUTTON, nId, TRUE, pMacroInfo );
			
	Image aImage = pImgMgr->SeekImage( nId );
	
	SvLBoxEntry* pTbEntry;
	if ( !!aImage )
		pTbEntry = InsertEntry( aName, aImage, aImage, 0, FALSE, nPos, pData );
	else
		pTbEntry = InsertEntry( aName, 0, FALSE, nPos, pData );

	SetCheckButtonState( pTbEntry, SV_BUTTON_CHECKED );

	if ( nPos == LIST_APPEND )
		m_aArr.Insert( pData, m_aArr.Count() );
	else
		m_aArr.Insert( pData, (USHORT)nPos );
	MakeVisible( pTbEntry );
			
	// Get Image for new function
	Image aNewImage;
	if ( !!aImage )
	{
		// Try to get it from our module
		aNewImage = pImgMgr->GetAndLockImage_Impl( nId, m_pIFace ? m_pIFace->GetModule() : 0 );
		if ( !aNewImage )
			aNewImage = pImgMgr->MakeUserImage( nId, aImage, FALSE ); // We need to copy the image to our user image list
	}

	// Insert entry in our hidden toolbox
	m_pTbxMgr->InsertItem( nId, aNewImage, nTbxPos, nId, aName );

	// Mark toolbox as modified
	m_pTbxMgr->SetModified( TRUE );
	m_pTbxMgr->SetDefault( FALSE );
	
	// Call listener if set
	if ( m_aChangedListener.IsSet() )
		m_aChangedListener.Call( this );

	return TRUE;
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::AddSeparator( SvLBoxEntry*	pEntry, ToolBoxItemType nType, BOOL bFront )
{
	ULONG	nPos	= 0;
	USHORT	nTbxPos	= 0;

	ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
	
	if ( pEntry )
	{
		// Add entry behind the current position
		if ( !GetPos( nPos, pEntry ))
			return; // impossible case: we cannot find the entry
		
 		++nPos; // Add it behind the current position
		nTbxPos = (USHORT)nPos;
	}
	else
	{
		if ( bFront )
		{
			// Support for D&D on the top position
			nPos = 0;
			nTbxPos = 0;
		}
		else
		{
			// Append entry at the end
			nPos = LIST_APPEND;
			nTbxPos = TOOLBOX_APPEND;
		}
	}
	
	SfxToolbarEntryInfo_Impl* pData = new SfxToolbarEntryInfo_Impl( nType, 0 );	

	SvLBoxEntry* pTbEntry;
	if ( nType == TOOLBOXITEM_SEPARATOR )
		pTbEntry = InsertEntry( m_aSeparator, 0, FALSE, nPos, pData );
	else if ( nType == TOOLBOXITEM_SPACE )
		pTbEntry = InsertEntry( m_aSpace, 0, FALSE, nPos, pData );

	SetCheckButtonState( pTbEntry, SV_BUTTON_TRISTATE );

	if ( nPos == LIST_APPEND )
		m_aArr.Insert( pData, m_aArr.Count() );
	else
		m_aArr.Insert( pData, (USHORT)nPos );
	MakeVisible( pTbEntry );
			
	if ( nType == TOOLBOXITEM_SEPARATOR )
		rToolBox.InsertSeparator( nTbxPos );
	else
		rToolBox.InsertSpace( nTbxPos );
	
	// Mark toolbox as modified
	m_pTbxMgr->SetModified( TRUE );
	m_pTbxMgr->SetDefault( FALSE );
	
	// Call listener if set
	if ( m_aChangedListener.IsSet() )
		m_aChangedListener.Call( this );
}

// --------------------------------------------------------
// Move a selected entry one position up, does nothing if entry was the first already
void SfxToolbarTreeListBox_Impl::MoveUpCurEntry()
{
	SvLBoxEntry* pEntry = GetCurEntry();
	
	if ( pEntry )
	{
		ULONG nPos = 0;
		
		BOOL bFound = GetPos( nPos, pEntry );

		if ( bFound && nPos > 0 )
		{
			SvButtonState aButtonState = GetCheckButtonState( pEntry );
			SvLBoxEntry* pNewEntry = CloneEntry( pEntry );
			SvTreeList* pModel = GetModel();
			pModel->Remove( pEntry );
			pModel->Insert( pNewEntry, nPos-1 );
			SetCheckButtonState( pNewEntry, aButtonState );
			
			ToolBox&	rToolBox = m_pTbxMgr->GetToolBox();
			USHORT		nTbxPos	 = (USHORT)nPos;
			USHORT		nItemId	 = rToolBox.GetItemId( nTbxPos );
			if ( nItemId != 0 )
				rToolBox.MoveItem( rToolBox.GetItemId( nTbxPos ), nTbxPos-1 );
			else
			{
				// Special handling for separators because MoveItem can only be used
				// for moving buttons!!
				ToolBoxItemType nType = rToolBox.GetItemType( nTbxPos );
				rToolBox.RemoveItem( nTbxPos );
				if ( nType == TOOLBOXITEM_SEPARATOR )
					rToolBox.InsertSeparator( nTbxPos-1 );
				else
					rToolBox.InsertSpace( nTbxPos-1 );
			}
			
			// Mark toolbox as modified
			m_pTbxMgr->SetModified( TRUE );
			m_pTbxMgr->SetDefault( FALSE );
			Select( pNewEntry, TRUE );
			MakeVisible( pNewEntry );

			// Call listener if set
			if ( m_aChangedListener.IsSet() )
				m_aChangedListener.Call( this );
		}
	}
}

// --------------------------------------------------------
// Move a selected entry one position down, does nothing if entry was the last one already
void SfxToolbarTreeListBox_Impl::MoveDownCurEntry()
{
	SvLBoxEntry* pEntry = GetCurEntry();
	
	if ( pEntry )
	{
		ULONG nPos = 0;
		
		BOOL bFound = GetPos( nPos, pEntry );

		if ( bFound && nPos < ( GetEntryCount()-1 ))
		{
			SvButtonState aButtonState = GetCheckButtonState( pEntry );
			SvLBoxEntry* pNewEntry = CloneEntry( pEntry );
			SvTreeList* pModel = GetModel();
			pModel->Remove( pEntry );
			pModel->Insert( pNewEntry, nPos+1 );
			SetCheckButtonState( pNewEntry, aButtonState );
			
			ToolBox&	rToolBox = m_pTbxMgr->GetToolBox();
			USHORT		nTbxPos	 = (USHORT)nPos;
			USHORT		nItemId	 = rToolBox.GetItemId( nTbxPos );
			if ( nItemId != 0 )
				rToolBox.MoveItem( rToolBox.GetItemId( nTbxPos ), nTbxPos+1 );
			else
			{
				// Special handling for separators because MoveItem can only be used
				// for moving buttons!!
				ToolBoxItemType nType = rToolBox.GetItemType( nTbxPos );
				rToolBox.RemoveItem( nTbxPos );
				if ( nType == TOOLBOXITEM_SEPARATOR )
					rToolBox.InsertSeparator( nTbxPos+1 );
				else
					rToolBox.InsertSpace( nTbxPos+1 );
			}
			
			// Mark toolbox as modified
			m_pTbxMgr->SetModified( TRUE );
			m_pTbxMgr->SetDefault( FALSE );
			Select( pNewEntry, TRUE );
			MakeVisible( pNewEntry );

			// Call listener if set
			if ( m_aChangedListener.IsSet() )
				m_aChangedListener.Call( this );
		}
	}
}

// --------------------------------------------------------

IMPL_LINK( SfxToolbarTreeListBox_Impl, TimerHdl, Timer*, pTimer)
{
	// Show balloon help if timer expires and the mouse pointer is over the current entry
	m_aTimer.Stop();
	Point aMousePos = GetPointerPosPixel();
	SvLBoxEntry *pEntry = GetCurEntry();
	if ( pEntry && GetEntry( aMousePos ) == pEntry && m_pCurEntry == pEntry )
		Help::ShowBalloon( this, OutputToScreenPixel( aMousePos ), GetHelpText( pEntry ) );
	return 0L;
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::MouseMove( const MouseEvent& rMEvt )
{
	if ( !m_bDragSource )
	{
		// Support balloon help
		Point aMousePos = rMEvt.GetPosPixel();
		m_pCurEntry = GetCurEntry();

		if ( m_pCurEntry && GetEntry( aMousePos ) == m_pCurEntry )
			m_aTimer.Start();
		else
		{
			Help::ShowBalloon( this, aMousePos, String() );
			m_aTimer.Stop();
		}
	}
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::KeyInput( const KeyEvent& rKEvt )
{
	SvLBoxEntry* pCurEntry = GetCurEntry();
	if ( pCurEntry )
	{
		// Support key "DELETE" for removing the current entry
		if ( rKEvt.GetKeyCode() == KEY_DELETE )
		{
			RemoveItem( pCurEntry );
			return;
		}
		else if ( rKEvt.GetKeyCode() == KEY_SPACE )
		{
			// Support key "SPACE" for checking/unchecking an entry
			SfxToolbarEntryInfo_Impl* pInfo = (SfxToolbarEntryInfo_Impl*)pCurEntry->GetUserData();
			if ( pInfo->nKind == TOOLBOXITEM_BUTTON )
			{
				USHORT nId = pInfo->nId;
				ToolBox& rToolBox = m_pTbxMgr->GetToolBox();
				if ( GetCheckButtonState( pCurEntry ) == SV_BUTTON_CHECKED )
				{
					SetCheckButtonState( pCurEntry, SV_BUTTON_UNCHECKED );
					pInfo->bVisible = FALSE;
					rToolBox.HideItem( nId );
				}
				else
				{
					SetCheckButtonState( pCurEntry, SV_BUTTON_CHECKED );
					pInfo->bVisible = TRUE;
					rToolBox.ShowItem( nId );
				}
				
				PaintEntry( pCurEntry );

				m_pTbxMgr->SetModified( TRUE );
				m_pTbxMgr->SetDefault( FALSE );
				
				// Call listener if set
 				if ( m_aChangedListener.IsSet() )
					m_aChangedListener.Call( this );
			}
			else
				SetCheckButtonState( pCurEntry, SV_BUTTON_TRISTATE ); // Cannot uncheck separator/space!
			return;
		}
	}
	
	SvTreeListBox::KeyInput( rKEvt );
}

// --------------------------------------------------------

void SfxToolbarTreeListBox_Impl::CommitChanges()
{
    SfxConfigManager* pCfgMgr = m_pTbxMgr->GetConfigManager();
	if ( pCfgMgr )
	{
		pCfgMgr->StoreConfigItem( *m_pTbxMgr );
		pCfgMgr->StoreConfiguration();
        pCfgMgr->ReInitialize( m_pTbxMgr->GetType() );
	}
}
