/*************************************************************************
 *
 *  $RCSfile: rmacceptorwrapper.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <uno/mapping.hxx>

#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include "rmacceptorwrapper.hxx"
#include "rmacceptor.hxx"


namespace sfx2_rmacceptor {

	
	void AcceptorWrapper::startAccepting( const XMultiServiceFactoryRef &rSMgr,
										  const ::rtl::OUString &sConnectionDescription )
	{
		// do the mapping
		::com::sun::star::uno::Mapping map( "smart" , CPPU_CURRENT_LANGUAGE_BINDING_NAME );

		::com::sun::star::lang::XMultiServiceFactory *pSMgr = 0;
 		pSMgr = ( ::com::sun::star::lang::XMultiServiceFactory * ) map.mapInterface(
			( XMultiServiceFactory * ) rSMgr , ::getCppuType(
				( ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > * ) 0 ) );
		
		::com::sun::star::uno::Reference < ::com::sun::star::lang::XMultiServiceFactory > rNewSMgr = pSMgr;

		pSMgr->release();
		
		m_pThread = new OAcceptorThread( rNewSMgr ,  sConnectionDescription );

		// start the thread
		m_pThread->create();
	}
	
	void AcceptorWrapper::stopAccepting()
	{
		if( m_pThread )
		{
			m_pThread->stopAccepting();
			m_pThread->join();
			delete m_pThread;
		}
	}

}

