/*************************************************************************
 *
 *  $RCSfile: applicat.cxx,v $
 *
 *  $Revision: 1.56 $
 *
 *  last change: $Author: as $ $Date: 2001/08/22 13:03:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "app.hxx"

#pragma hdrstop

#include <stdio.h>

#if defined(UNX)
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#ifndef _COM_SUN_STAR_SYSTEM_XSYSTEMSHELLEXECUTE_HPP_
#include <com/sun/star/system/XSystemShellExecute.hpp>
#endif
#ifndef _COM_SUN_STAR_SYSTEM_SYSTEMSHELLEXECUTEFLAGS_HPP_
#include <com/sun/star/system/SystemShellExecuteFlags.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XCONNECTCALLBACK_HPP_
#include <com/sun/star/bridge/XConnectCallback.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XCONNECTIONSERVERSIDE_HPP_
#include <com/sun/star/bridge/XConnectionServerSide.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XCONNECTIONBROKER_HPP_
#include <com/sun/star/bridge/XConnectionBroker.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XCONNECTIONCLIENTSIDE_HPP_
#include <com/sun/star/bridge/XConnectionClientSide.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HPP_
#include <com/sun/star/container/XIndexContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HPP_
#include <com/sun/star/container/XContainerListener.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HPP_
#include <com/sun/star/container/ContainerEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HPP_
#include <com/sun/star/container/XIndexReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HPP_
#include <com/sun/star/loader/XImplementationLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HPP_
#include <com/sun/star/loader/CannotActivateFactoryException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATION_HPP_
#include <com/sun/star/container/XEnumeration.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COMPHELPER_REGPATHHELPER_HXX_
#include <comphelper/regpathhelper.hxx>
#endif
#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif
#ifndef _CPPUHELPER_BOOTSTRAP_HXX_
#include <cppuhelper/bootstrap.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDESKTOP_HPP_
#include <com/sun/star/frame/XDesktop.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef  _COM_SUN_STAR_VIEW_XPRINTABLE_HPP_
#include <com/sun/star/view/XPrintable.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XTASKSSUPPLIER_HPP_
#include <com/sun/star/frame/XTasksSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATION_HPP_
#include <com/sun/star/container/XEnumeration.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XConnection_HPP_
#include <com/sun/star/connection/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XBridgeFactory_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#if SUPD>637
#include <rtl/logfile.hxx>
#endif
#include <unotools/configmgr.hxx>
#include <unotools/localfilehelper.hxx>
#include <unotools/ucbhelper.hxx>
#include <unotools/tempfile.hxx>
#include <svtools/startoptions.hxx>
#include <svtools/pathoptions.hxx>
#include <svtools/helpopt.hxx>
#include <unotools/bootstrap.hxx>
#include <ucbhelper/contentbroker.hxx>
#include <toolkit/helper/vclunohelper.hxx>
//#include <svtools/moduleoptions.hxx>
#include <svtools/internaloptions.hxx>
#include <framework/imageproducer.hxx>
#include <unotools/configitem.hxx>
#include <tools/tempfile.hxx>
#include <tools/urlobj.hxx>
#include <vos/process.hxx>
#include <vos/thread.hxx>
#include <vos/timer.hxx>
#include <vos/process.hxx>
#include <vos/pipe.hxx>
#include <vos/signal.hxx>
#include <osl/file.hxx>
#include <ucbhelper/configurationkeys.hxx>
#include <rtl/textenc.h>
#include <rtl/uri.h>
#include <rtl/uri.hxx>
#include <rtl/ustring.hxx>
#include <rtl/ustrbuf.hxx>
#include <vcl/window.hxx>
#include <vcl/msgbox.hxx>
#include <svtools/testtool.hxx>
#include <vcl/apptypes.hxx>

// "real" sfx headers
#include "ucbhelp.hxx"                  // just for Init/DeInit

//#include <daemons/cryptor.hxx>
#define LOGIN_DECRYPT_PASSWORD			"U^gZ~@s2"

// connectivity (rvp/scripting)
#include "officeacceptthread.hxx"
#include "rmacceptor.hxx"
#include "shutdownicon.hxx"
#include "cmdlineargs.hxx"

/*-* HACK FOR PLUGIN ******************************************************************************************************************/
#include "oinstanceprovider.hxx"
#include "pluginacceptthread.hxx"

using namespace ::com::sun::star::connection;
using namespace ::com::sun::star::bridge;
/*-* HACK FOR PLUGIN ******************************************************************************************************************/

using namespace ::vos;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::system;
using namespace ::com::sun::star::registry;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::document;
using namespace ::com::sun::star::view;

static ::sfx2::CommandLineArgs* GetCommandLineArgs()
{
    static ::sfx2::CommandLineArgs* pArgs = 0;
    if ( !pArgs )
    {
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if ( !pArgs )
            pArgs = new ::sfx2::CommandLineArgs( ::vos::OExtCommandLine() );
    }

    return pArgs;
}

class ImplForeignAppEventClass
{
public:
	DECL_STATIC_LINK( ImplForeignAppEventClass, CallEvent, void* pEvent );
};

void HandleAppEvent( const ApplicationEvent& rAppEvent );
IMPL_STATIC_LINK( ImplForeignAppEventClass, CallEvent, void*, pEvent )
{
    HandleAppEvent( *((ApplicationEvent*)pEvent) );
	delete (ApplicationEvent*)pEvent;
	return 0;
}

void ImplPostForeignAppEvent( ApplicationEvent* pEvent )
{
	Application::PostUserEvent( STATIC_LINK( NULL, ImplForeignAppEventClass, CallEvent ), pEvent );
}

extern void FATToVFat_Impl( String& );

String GetURL_Impl( const String& rName )
{
    // if the filename is a physical name, it is the client file system, not the file system
    // of the machine where the office is running ( if this are different machines )
    // so in the remote case we can't handle relative filenames as arguments, because they
    // are parsed relative to the program path
    // the file system of the client is addressed through the "file:" protocol
    ::rtl::OUString aProgName, aTmp;
    ::vos::OStartupInfo aInfo;
    aInfo.getExecutableFile( aProgName );
	aTmp = aProgName;
    INetURLObject aObj( aTmp );
    bool bWasAbsolute;
    INetURLObject aURL = aObj.smartRel2Abs( rName, bWasAbsolute );
    return aURL.GetMainURL(INetURLObject::NO_DECODE);
}

void OpenDefault()
{
    DBG_WARNING( "Not supported any longer! Code moved to Desktop project ..." );
    /*
    String aName;
    if ( !aName.Len() )
    {
        aName = String( DEFINE_CONST_UNICODE("private:factory/" ) );
        SvtModuleOptions aOpt;
        if ( aOpt.IsWriter() )
            aName += DEFINE_CONST_UNICODE("swriter");
        else if ( aOpt.IsCalc() )
            aName += DEFINE_CONST_UNICODE("scalc");
        else if ( aOpt.IsImpress() )
            aName += DEFINE_CONST_UNICODE("simpress");
        else if ( aOpt.IsDraw() )
            aName += DEFINE_CONST_UNICODE("sdraw");
        else
            return;
    }

    Sequence < PropertyValue > aNoArgs;
    Reference< XComponentLoader > xDesktop(
            ::comphelper::getProcessServiceFactory()->createInstance( OUSTRING(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
            ::com::sun::star::uno::UNO_QUERY );
    xDesktop->loadComponentFromURL( aName, ::rtl::OUString::createFromAscii( "_blank" ), 0, aNoArgs );
    */
}

void HandleAppEvent( const ApplicationEvent& rAppEvent )
{
    if ( rAppEvent.IsOpenEvent() || rAppEvent.IsPrintEvent() )
    {
        String aPrinterName;
        Reference< XComponentLoader > xDesktop(
                ::comphelper::getProcessServiceFactory()->createInstance( OUSTRING(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
                ::com::sun::star::uno::UNO_QUERY );

        // create parameter array
        sal_Int32 nCount = rAppEvent.IsPrintEvent() ? 5 : 1;
        Sequence < PropertyValue > aArgs( nCount );
        aArgs[0].Name = ::rtl::OUString::createFromAscii("Referer");

        if ( rAppEvent.IsPrintEvent() )
        {
            aArgs[1].Name = ::rtl::OUString::createFromAscii("ReadOnly");
            aArgs[2].Name = ::rtl::OUString::createFromAscii("OpenNewView");
            aArgs[3].Name = ::rtl::OUString::createFromAscii("Hidden");
            aArgs[4].Name = ::rtl::OUString::createFromAscii("Silent");
        }

        // mark request as user interaction from outside
        aArgs[0].Value <<= ::rtl::OUString::createFromAscii("private:OpenEvent");

        for( sal_uInt16 i=0; i<rAppEvent.GetParamCount(); i++ )
        {
            // get file name
            String aName( rAppEvent.GetParam(i) );

            // is the parameter a printername ?
            if( aName.Len()>1 && *aName.GetBuffer()=='@' )
            {
                aPrinterName = aName.Copy(1);
                continue;
            }

#ifdef WNT
            FATToVFat_Impl( aName );
#endif
            aName = GetURL_Impl(aName);

            if ( rAppEvent.IsPrintEvent() )
            {
                // documents opened for printing are opened readonly because they must be opened as a new document and this
                // document could be open already
                aArgs[1].Value <<= sal_True;

                // always open a new document for printing, because it must be disposed afterwards
                aArgs[2].Value <<= sal_True;

                // printing is done in a hidden view
                aArgs[3].Value <<= sal_True;

                // load document for printing without user interaction
                aArgs[4].Value <<= sal_True;
            }

            // load the document
            Reference < XPrintable > xDoc ( xDesktop->loadComponentFromURL( aName, ::rtl::OUString::createFromAscii( "_blank" ), 0, aArgs ), UNO_QUERY );
            if ( rAppEvent.IsPrintEvent() )
            {
                if( aPrinterName.Len() && xDoc.is() )
                {
                    // create the printer
                    Sequence < PropertyValue > aPrinterArgs( 1 );
                    aPrinterArgs[0].Name = ::rtl::OUString::createFromAscii("Name");
                    aPrinterArgs[0].Value <<= ::rtl::OUString( aPrinterName );
                    xDoc->setPrinter( aPrinterArgs );

                    // print ( also without user interaction )
                    aPrinterArgs[0].Name = ::rtl::OUString::createFromAscii("Silent");
                    aPrinterArgs[0].Value <<= ( sal_Bool ) sal_True;
                    xDoc->print( aPrinterArgs );
                }
                else
                {
                    // place error message here ...
                }

                // remove the document
                Reference < XComponent > xComp( xDoc, UNO_QUERY );
                if ( xComp.is() )
                    xComp->dispose();
            }
        }
    }
    else if ( rAppEvent.GetEvent() == "APPEAR" )
    {
        // find active task - the active task is always a visible task
        ::com::sun::star::uno::Reference< ::com::sun::star::frame::XTasksSupplier >
                xDesktop( ::comphelper::getProcessServiceFactory()->createInstance( OUSTRING(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
                ::com::sun::star::uno::UNO_QUERY );
        ::com::sun::star::uno::Reference< ::com::sun::star::frame::XTask > xTask = xDesktop->getActiveTask();
        if ( !xTask.is() )
        {
            // get any task if there is no active one
            ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration > xList = xDesktop->getTasks()->createEnumeration();
            while( xList->hasMoreElements() )
            {
                xList->nextElement() >>= xTask;
                Window* pWindow = VCLUnoHelper::GetWindow( xTask->getContainerWindow() );
                if ( pWindow->IsVisible() )
                    // activate task, if it is visible
                    break;
                else
                    xTask = NULL;
            }
        }

        if ( xTask.is() )
        {
            Window* pWindow = VCLUnoHelper::GetWindow( xTask->getContainerWindow() );
            pWindow->ToTop();
        }
        else
            // no visible task that could be activated found
            OpenDefault();
    }
}

// "real" sfx headers
#include "app.hrc"
#include "sfxresid.hxx"

void SfxApplicationClass::OpenClients()
{
    // check if a document has been recovered - if there is one of if a document was loaded by cmdline, no default document
    // should be created
    Reference < XComponent > xFirst;
    BOOL bLoaded = FALSE;

    ::sfx2::CommandLineArgs* pArgs = GetCommandLineArgs();
    SvtInternalOptions  aInternalOptions;
    if ( !pArgs->IsServer() && !aInternalOptions.IsRecoveryListEmpty() )
    {
        // crash recovery
        sal_Bool bUserCancel = sal_False;
        ::rtl::OUString sURL;
        ::rtl::OUString sFilter;
        ::rtl::OUString sTempName;

        Reference< XComponentLoader > xDesktop(
                ::comphelper::getProcessServiceFactory()->createInstance( OUSTRING(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
                ::com::sun::star::uno::UNO_QUERY );

        // create the parameter array
        Sequence < PropertyValue > aArgs( 4 );
        aArgs[0].Name = ::rtl::OUString::createFromAscii("Referer");
        aArgs[1].Name = ::rtl::OUString::createFromAscii("AsTemplate");
        aArgs[2].Name = ::rtl::OUString::createFromAscii("FilterName");
        aArgs[3].Name = ::rtl::OUString::createFromAscii("SalvagedFile");

        // mark it as a user request
        aArgs[0].Value <<= ::rtl::OUString::createFromAscii("private:user");

        while(  !aInternalOptions.IsRecoveryListEmpty() && !bUserCancel )
		{
            // Read and delete top recovery item from list
			aInternalOptions.PopRecoveryItem( sURL, sFilter, sTempName );

            sal_Bool bIsURL = ( INetURLObject( sURL ).GetProtocol() != INET_PROT_NOT_VALID );
            String sRealFileName( sURL );
            String sTempFileName( sTempName );

            String aMsg( SfxResId( STR_RECOVER_QUERY ) );
            aMsg.SearchAndReplaceAscii( "$1", sRealFileName );
            MessBox aBox( NULL, WB_YES_NO_CANCEL | WB_DEF_YES | WB_3DLOOK, String( SfxResId( STR_RECOVER_TITLE ) ), aMsg );
            switch( aBox.Execute() )
            {
                case RET_YES:
                {
                    // recover a file
                    aArgs[2].Value <<= ::rtl::OUString( sFilter );
                    if ( bIsURL )
                    {
                        // get the original URL for the recovered document
                        aArgs[1].Value <<= sal_False;
                        aArgs[3].Value <<= ::rtl::OUString( sRealFileName );
                    }
                    else
                    {
                        // this was an untitled document ( open as template )
                        aArgs[1].Value <<= sal_True;
                        aArgs[3].Value <<= ::rtl::OUString();
                    }

                    // load the document
                    Reference < XComponent > xDoc = xDesktop->loadComponentFromURL( sTempFileName, ::rtl::OUString::createFromAscii( "_blank" ), 0, aArgs );
                    if ( !xFirst.is() )
                        // remember the first successfully recovered file
                        xFirst = xDoc;

                    // remove saved copy
                    ::utl::UCBContentHelper::Kill( sTempFileName );
                    break;
                }

                case RET_NO:
				{
                    // skip this file
                    ::utl::UCBContentHelper::Kill( sTempFileName );
                    break;
				}

                case RET_CANCEL:
				{
                    // cancel recovering
                    ::utl::UCBContentHelper::Kill( sTempFileName );
                    bUserCancel = sal_True;

                    // delete recovery list and all files
					while( aInternalOptions.IsRecoveryListEmpty() == sal_False )
					{
						aInternalOptions.PopRecoveryItem( sURL, sFilter, sTempName );
                        ::utl::UCBContentHelper::Kill( sTempName );
					}

                    break;
				}
            }
        }

        // make sure that the new Recoverylist ist written to disc
        ::utl::ConfigManager::GetConfigManager()->StoreConfigItems();
    }

    // check for open parameters
    String aEmptyStr;
    ::rtl::OUString aOpenList;
    if ( pArgs->GetOpenList( aOpenList ) )
    {
        bLoaded = TRUE;
        ApplicationEvent* pAppEvt = new ApplicationEvent( aEmptyStr, aEmptyStr,
                                        APPEVENT_OPEN_STRING,
                                        aOpenList );
        HandleAppEvent( *pAppEvt );
        delete pAppEvt;
    }


    // check for print parameters
    ::rtl::OUString aPrintList;
    if ( pArgs->GetPrintList( aPrintList ) )
    {
        bLoaded = TRUE;
        ApplicationEvent* pAppEvt = new ApplicationEvent( aEmptyStr, aEmptyStr,
                                        APPEVENT_PRINT_STRING,
                                        aPrintList );
        HandleAppEvent( *pAppEvt );
        delete pAppEvt;
    }

    // no default document if a document was loaded by recovery or by command line or if soffice is used as server
    if ( bLoaded || xFirst.is() || pArgs->IsServer() )
        return;

    if( pArgs->IsInvisible() )
        // soffice was started as tray icon
        return;

//(mba/task): neu zu implementieren
//  if ( SvtSaveOptions().IsSaveWorkingSet() )
//            SfxTaskManager::RestoreWorkingSet();
//  else
    {
        OpenDefault();
    }
}

class OfficeIPCThread : public OThread
{
  private:
	static OfficeIPCThread* pGlobalOfficeIPCThread;

    OPipe            maPipe;
    OStreamPipe      maStreamPipe;
    static OSecurity     maSecurity;
	String							maPipeIdent;

	OfficeIPCThread();

  protected:
	/// Working method which should be overridden
    virtual void SAL_CALL run();
  public:
    virtual ~OfficeIPCThread();

    static BOOL EnableOfficeIPCThread();
	// return FALSE if second office
	static void DisableOfficeIPCThread();
};

#define TERMINATION_SEQUENCE "InternalIPC::TerminateThread"
#define TERMINATION_LENGTH 28

class SalMainPipeExchangeSignalHandler : public OSignalHandler
{
    virtual TSignalAction SAL_CALL signal(TSignalInfo *pInfo);
};

OSignalHandler::TSignalAction SAL_CALL SalMainPipeExchangeSignalHandler::signal(TSignalInfo *pInfo)
{
    if( pInfo->Signal == osl_Signal_Terminate )
		OfficeIPCThread::DisableOfficeIPCThread();
	return (TAction_CallNextHandler);
}

OfficeIPCThread* OfficeIPCThread::pGlobalOfficeIPCThread = 0;
OSecurity OfficeIPCThread::maSecurity;

BOOL OfficeIPCThread::EnableOfficeIPCThread()
{
	if( pGlobalOfficeIPCThread )
		return TRUE;

    ::rtl::OUString aOfficeInstallPath;
	::rtl::OUString aUserInstallPath;
	::rtl::OUString aLastIniFile;
    ::rtl::OUString aDummy;

	::vos::OStartupInfo aInfo;
	OfficeIPCThread* pThread = new OfficeIPCThread;

	pThread->maPipeIdent = String::CreateFromAscii(  RTL_CONSTASCII_STRINGPARAM( "SingleOfficeIPC" ) );
	pThread->maPipeIdent += '_';

	::utl::BootstrapRetVal aLocateResult = ::utl::bootstrap_locateUserInstallationPath( aOfficeInstallPath, aUserInstallPath, aLastIniFile );
	if ( aLocateResult == ::utl::BOOTSTRAP_OK )
	{
		aDummy = aUserInstallPath;
	}
	else
	{
		delete pThread;
		return FALSE;
	}

    // look if we are the first Office: try to open the pipe
    // this should prevent multiple access to the user directory !
    pThread->maPipeIdent += String::CreateFromInt32( aDummy.hashCode() );
    if( pThread->maPipe.create( pThread->maPipeIdent.GetBuffer(), OPipe::TOption_Open, maSecurity ) )
	{
		pThread->maStreamPipe = pThread->maPipe;

		// seems another office is running. pipe arguments to it
		// and self terminate
		ByteString aArguments;
        ULONG nCount = aInfo.getCommandArgCount();
        for( ULONG i=0; i < nCount; i++ )
        {
            aInfo.getCommandArg( i, aDummy );
            aArguments += ByteString( String( aDummy ), osl_getThreadTextEncoding() );
            aArguments += '|';
        }

		pThread->maStreamPipe.write( aArguments.GetBuffer(), aArguments.Len() );
		delete pThread;
		return FALSE;
	}

	// seems we are the one and only, so start listening thread
    pThread->maPipe = OPipe( pThread->maPipeIdent, OPipe::TOption_Create, maSecurity );
	if( pThread->maPipe.isValid() )
	{
		pGlobalOfficeIPCThread = pThread;
		pThread->create(); // starts thread
	}

	return TRUE;
}

void OfficeIPCThread::DisableOfficeIPCThread()
{
	if( pGlobalOfficeIPCThread )
	{
		// send thread a termination message
		// this is done so the subsequent join will not hang
		// because the thread hangs in accept of pipe
        OPipe Pipe( pGlobalOfficeIPCThread->maPipeIdent, OPipe::TOption_Open, maSecurity );
		Pipe.send( TERMINATION_SEQUENCE, TERMINATION_LENGTH );
		Pipe.close();
		// close the pipe so that the streampipe on the other
		// side produces EOF

		// exit gracefully
		pGlobalOfficeIPCThread->join();
		delete pGlobalOfficeIPCThread;
	}
}

OfficeIPCThread::OfficeIPCThread()
{
}

OfficeIPCThread::~OfficeIPCThread()
{
	maPipe.close();
	maStreamPipe.close();
	pGlobalOfficeIPCThread = 0;
}

void SAL_CALL OfficeIPCThread::run()
{
	while (schedule())
	{
        OPipe::TPipeError
			nError = maPipe.accept( maStreamPipe );
        if( nError == OStreamPipe::E_None )
		{
			ByteString aArguments;
			char pBuf[ 2049 ];
			int nBytes;
			do
			{
				nBytes = maStreamPipe.read( pBuf, 2048 );
				pBuf[ nBytes ] = 0;
				aArguments += pBuf;
			} while( ! maStreamPipe.isEof() || nBytes > 0 );
			maStreamPipe.close();

			// is this a termination message ? if so, terminate
			if( aArguments.CompareTo( TERMINATION_SEQUENCE,
									  TERMINATION_LENGTH ) == COMPARE_EQUAL )
				return;

			// parse command line arguments
			// dispatch open and print events
			int		nToken = aArguments.GetTokenCount( '|' );
			BOOL	bPrintEvent = FALSE;
			BOOL	bOpenEvent  = TRUE;
			String	aOpenList;
			String	aPrintList;
			String	aEmpty;

			for( int n=0; n<nToken; n++ )
			{
				String aArg( aArguments.GetToken( n, '|' ), gsl_getSystemTextEncoding() );
				if ( aArg.Len() > 0 )
				{
					if ( aArg.GetChar(0) == '-' )
					{
						// handle this argument as an option
						if ( aArg.EqualsIgnoreCaseAscii( "-p" ))
						{
							bPrintEvent = TRUE;
							bOpenEvent = FALSE;    // Ab hier keine OpenEvents mehr
						}
					}
					else
					{
						// handle this argument as a filename
						if ( bOpenEvent )
						{
							// Open Event anhaengen
							if ( aOpenList.Len() )
								aOpenList += APPEVENT_PARAM_DELIMITER;
							aOpenList += aArg;
						}
						else if ( bPrintEvent )
						{
							// Print Event anhaengen
							if( aPrintList.Len() )
								aPrintList += APPEVENT_PARAM_DELIMITER;
							aPrintList += aArg;
						}
					}
				}
			}

			if( aOpenList.Len() )
			{
				// open file(s)
				ApplicationEvent* pAppEvent =
					new ApplicationEvent( aEmpty, aEmpty,
										  APPEVENT_OPEN_STRING, aOpenList );
				ImplPostForeignAppEvent( pAppEvent );
			}

			if ( aPrintList.Len() )
			{
				// print file(s)
				ApplicationEvent* pAppEvent =
					new ApplicationEvent( aEmpty, aEmpty,
										  APPEVENT_PRINT_STRING, aPrintList );
				ImplPostForeignAppEvent( pAppEvent );
			}

			if ( aPrintList.Len() == 0 && aOpenList.Len() == 0 )
			{
				// no document was send, just bring Office to front
				ApplicationEvent* pAppEvent =
					new ApplicationEvent( aEmpty, aEmpty,
										  "APPEAR", aEmpty );
				ImplPostForeignAppEvent( pAppEvent );
			}
		}
		else
		{
#if defined DEBUG || defined DBG_UTIL
			fprintf( stderr, "Error on accept: %d\n", (int)nError );
#endif
			TimeValue tval;
			tval.Seconds = 1;
			tval.Nanosec = 0;
			sleep( tval );
		}
	}
};

static bool configureUcb(bool bServer, rtl::OUString const & rPortalConnect)
{
	Reference< XMultiServiceFactory >
        xServiceFactory(comphelper::getProcessServiceFactory());
	if (!xServiceFactory.is())
	{
		DBG_ERROR("configureUcb(): No XMultiServiceFactory");
		return false;
	}

	rtl::OUString aPipe;
	vos::OSecurity().getUserIdent(aPipe);

	rtl::OUStringBuffer aPortal;
	if (rPortalConnect.getLength() != 0)
	{
		aPortal.append(sal_Unicode(','));
		aPortal.append(rPortalConnect);
	}

	Sequence< Any > aArgs(6);
	aArgs[0]
		<<= rtl::OUString::createFromAscii(bServer ?
										       UCB_CONFIGURATION_KEY1_SERVER :
										       UCB_CONFIGURATION_KEY1_LOCAL);
	aArgs[1]
		<<= rtl::OUString::createFromAscii(UCB_CONFIGURATION_KEY2_OFFICE);
	aArgs[2] <<= rtl::OUString::createFromAscii("PIPE");
	aArgs[3] <<= aPipe;
	aArgs[4] <<= rtl::OUString::createFromAscii("PORTAL");
	aArgs[5] <<= aPortal.makeStringAndClear();

    return ::ucb::ContentBroker::initialize( xServiceFactory, aArgs ) != false;
}

sfx2::OOfficeAcceptorThread*	pOfficeAcceptThread = 0;
static PluginAcceptThread* pPluginAcceptThread = 0;

#define SFX_TEMPNAMEBASE_DIR        "$(userpath)/temp/soffice.tmp"
#define SFX_KEY_TEMPNAMEBASE		"Temp-Dir"

static String aTempNameBaseDir;
static String aTempBase;

/*-* HACK FOR PLUGIN ******************************************************************************************************************/
#define	COMMANDARGUMENT_PLUGIN					OUString(RTL_CONSTASCII_USTRINGPARAM("/plugin"								))
#define	NAME_PLUGINBRIDGE						OUString(RTL_CONSTASCII_USTRINGPARAM("mozilla plugin bridge"				))
#define	PROTOCOL_PLUGINBRIDGE					OUString(RTL_CONSTASCII_USTRINGPARAM("urp"									))
#define	SERVICENAME_BRIDGEFACTORY				OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.bridge.BridgeFactory"	))
/*-* HACK FOR PLUGIN ******************************************************************************************************************/

::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > createApplicationServiceManager()
{
	try
	{
        ::rtl::OUString localRegistry = ::comphelper::getPathToUserRegistry();
        ::rtl::OUString systemRegistry = ::comphelper::getPathToSystemRegistry();

        Reference< XSimpleRegistry > xLocalRegistry( ::cppu::createSimpleRegistry() );
        Reference< XSimpleRegistry > xSystemRegistry( ::cppu::createSimpleRegistry() );
        if ( xLocalRegistry.is() && (localRegistry.getLength() > 0) )
        {
            try
            {
                xLocalRegistry->open( localRegistry, sal_False, sal_True);
            }
            catch ( InvalidRegistryException& )
            {
            }

            if ( !xLocalRegistry->isValid() )
                xLocalRegistry->open(localRegistry, sal_True, sal_True);
        }

        if ( xSystemRegistry.is() && (systemRegistry.getLength() > 0) )
            xSystemRegistry->open( systemRegistry, sal_True, sal_False);

        if ( (xLocalRegistry.is() && xLocalRegistry->isValid()) &&
             (xSystemRegistry.is() && xSystemRegistry->isValid()) )
        {
            Reference < XSimpleRegistry > xReg( ::cppu::createNestedRegistry() );
            Sequence< Any > seqAnys(2);
            seqAnys[0] <<= xLocalRegistry ;
            seqAnys[1] <<= xSystemRegistry ;
            Reference< XInitialization > xInit( xReg, UNO_QUERY );
            xInit->initialize( seqAnys );

            Reference< XComponentContext > xContext( ::cppu::bootstrap_InitialComponentContext( xReg ) );
            return Reference< XMultiServiceFactory >( xContext->getServiceManager(), UNO_QUERY );
        }
	}
	catch( ::com::sun::star::uno::Exception& )
	{
	}

	return ::cppu::createServiceFactory();
}

void RegisterServices()
{
#if SUPD>637
	RTL_LOGFILE_CONTEXT( aLog, "RegisterServices()" );
#endif
#if 0	//(dv!)
	UNO_setJavaEnvironment(getJavaVM_sj2,
						   enterJavaCall_sj2,
						   leaveJavaCall_sj2,
						   calledFromJavaBegin_sj2,
						   calledFromJavaEnd_sj2);
#endif	//(dv!)

	//::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xSMgr = createApplicationServiceManager();
    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xSMgr = ::comphelper::getProcessServiceFactory();
    if( ! xSMgr.is() )
	{
		fprintf( stderr , "Failed to load necessary components\n" );
		exit(0);
	}

    ::comphelper::setProcessServiceFactory( xSMgr );

	if ( !Application::IsRemoteServer() )
	{
		// read command line parameters
		::rtl::OUString conDcp;
		::rtl::OUString aClientDisplay;
		::rtl::OUString aUserDir;

		// read accept string from configuration
		conDcp = SvtStartOptions().GetConnectionURL();

		// Anderes Flag setzen, wenn der Server von Hand gestartet wird...
		::vos::OExtCommandLine aCmdLine;
		ULONG nArgs = aCmdLine.getCommandArgCount();
		for( ULONG n=0; n<nArgs; n++ )
		{
			String aParam;
			::rtl::OUString aDummy;
			aCmdLine.getCommandArg( n, aDummy );
			aParam = aDummy;
			if ( (aParam.GetChar( 0 ) == '/') || (aParam.GetChar( 0 ) == '-') )
			{
				aParam.SetChar( 0 ,  (sal_Unicode)'-' );
				if( aParam.Copy(0, 8).EqualsIgnoreCaseAscii("-accept="))
				{
					conDcp = aParam.Copy(8);
#ifdef DEBUG
					::rtl::OString tmp = ::rtl::OUStringToOString(conDcp, RTL_TEXTENCODING_ASCII_US);
					OSL_TRACE("accept = %s", tmp.getStr());
#endif
				}
				else if ( aParam.Copy( 0, 7 ).EqualsIgnoreCaseAscii( "-userid" ))
				{
					::rtl::OUString aUserId = aParam;

					sal_Int32 nPos = aUserId.indexOf( '[' );
					sal_Int32 nEndpos = aUserId.lastIndexOf( ']' );
					if( nPos != -1 && nEndpos != -1 )
						aUserDir = Uri::decode(
							aUserId.copy( nPos + 1, nEndpos - nPos - 1 ),
							rtl_UriDecodeWithCharset,
							RTL_TEXTENCODING_UTF8 );
#ifdef DEBUG
					::rtl::OString tmp = ::rtl::OUStringToOString(aUserDir, RTL_TEXTENCODING_ASCII_US);
					OSL_TRACE("userDir = %s", tmp.getStr());
#endif
				}
			}
		}

		if ( conDcp.getLength() > 0 )
		{
			// accept incoming connections (scripting and one rvp)
#if SUPD>637
			RTL_LOGFILE_CONTEXT( aLog, "create sfx2::OOfficeAcceptorThread" );
#endif
			pOfficeAcceptThread = new sfx2::OOfficeAcceptorThread( xSMgr, conDcp, sal_False, aClientDisplay, aUserDir );
			pOfficeAcceptThread->create();
		}
	}

	// try to start OLE registration service.
	// on success (WIN32 only) this process will work
	// as OLE automation server for standard UNO objects.
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start createInstance com.sun.star.bridge.OleApplicationRegistration" );
#endif
	xSMgr->createInstance(DEFINE_CONST_UNICODE("com.sun.star.bridge.OleApplicationRegistration"));

    bool bServer=FALSE;
    String aPortalConnect;
    ::vos::OExtCommandLine aCmdLine;
    ULONG nCount = aCmdLine.getCommandArgCount();
    for( ULONG i=0; i<nCount; i++ )
	{
        String aArg;
        ::rtl::OUString aDummy;
        aCmdLine.getCommandArg( i, aDummy );
        aArg = aDummy;
        if ( aArg.EqualsIgnoreCaseAscii("-server") )
            bServer = true;
		else if ( aArg.CompareIgnoreCaseToAscii("-portal,",
												RTL_CONSTASCII_LENGTH(
													"-portal,"))
				      == COMPARE_EQUAL )
            aPortalConnect = aArg.Copy(RTL_CONSTASCII_LENGTH("-portal,"));
	}

#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start configureUcb" );
#endif
    if (!configureUcb(bServer, aPortalConnect))
	{
        DBG_ERROR("Can't configure UCB");
		exit(-1);
	}

#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "end configureUcb" );
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start UCB_Helper::Initialize()" );
#endif

	UCB_Helper::Initialize();

#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "end UCB_Helper::Initialize()" );
#endif

    // remove old temp dir
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start remove old temp dir" );
#endif

    SvtPathOptions aOpt;
    String aTemp( DEFINE_CONST_UNICODE( SFX_TEMPNAMEBASE_DIR ) );
    aTempNameBaseDir = aOpt.SubstituteVariable( aTemp );
    String aOldTempBase( aOpt.GetTempPath() );
    if ( STRING_NOTFOUND != aOldTempBase.Search( aTempNameBaseDir ) )
    {
        String aRet;
        ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aOldTempBase, aRet );
        ::utl::UCBContentHelper::Kill( aRet );
    }

#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "end remove old temp dir" );
#endif

	// set temp base directory
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start set temp base directory" );
#endif

    ::rtl::OUString aRet;
    ::osl::FileBase::getFileURLFromSystemPath( aTempNameBaseDir, aRet );
    TempFile::SetTempNameBaseDirectory( aRet );
    aTempBase = ::utl::TempFile::SetTempNameBaseDirectory( aRet );
    aOpt.SetTempPath( aTempBase );
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "end set temp base directory" );
#endif
}

//***********************************************************************************************************************

static SalMainPipeExchangeSignalHandler* pSignalHandler=0;
void SfxApplicationClass::Init()
{
#if SUPD>637
	RTL_LOGFILE_CONTEXT( aLog, "SfxApplicationClass::Init()" );
#endif
	// intialize service manager for office application
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "start createApplicationServiceManager()" );
#endif
	Reference < XMultiServiceFactory > rSMgr = createApplicationServiceManager();
	if( ! rSMgr.is() )
	{
		fprintf( stderr , "Failed to load necessary components\n" );
		exit(0);
	}
	::comphelper::setProcessServiceFactory( rSMgr );
#if SUPD>637
	RTL_LOGFILE_CONTEXT_TRACE( aLog, "end createApplicationServiceManager()" );
#endif

    if ( !Application::IsRemoteServer() )
	{
		// start ipc thread only for non-remote offices
#if SUPD>637
		RTL_LOGFILE_CONTEXT( aLog, "OfficeIPCThread::EnableOfficeIPCThread" );
#endif
        if( !OfficeIPCThread::EnableOfficeIPCThread( ) )
			exit( 0 );
		pSignalHandler = new SalMainPipeExchangeSignalHandler;
	}
	else
	{
		// remote office - read command line parameters for headless office/accept thread
		::rtl::OUString conDcp;
		::rtl::OUString aClientDisplay;
		::rtl::OUString aUserDir;

		sal_Bool bHeadlessMode = sal_False;

		::vos::OExtCommandLine aCmdLine;
		ULONG nArgs = aCmdLine.getCommandArgCount();
		for( ULONG n=0; n<nArgs; n++ )
		{
			String aParam;
			::rtl::OUString aDummy;
			aCmdLine.getCommandArg( n, aDummy );
			aParam = aDummy;
			if ( (aParam.GetChar( 0 ) == '/') || (aParam.GetChar( 0 ) == '-') )
			{
				aParam.SetChar( 0 ,  (sal_Unicode)'-' );
				if ( aParam.EqualsIgnoreCaseAscii( "-headless" ))
				{
					bHeadlessMode = sal_True;
					OSL_TRACE("headless mode on" );
				}
				else if ( aParam.Copy( 0, 15).EqualsIgnoreCaseAscii( "-clientdisplay=" ))
				{
					aClientDisplay = aParam.Copy(15);
#ifdef DEBUG
					::rtl::OString tmp = ::rtl::OUStringToOString(aClientDisplay, RTL_TEXTENCODING_ASCII_US);
					OSL_TRACE("clientdisplay = %s", tmp.getStr());
#endif
				}
				else if( aParam.Copy(0, 8).EqualsIgnoreCaseAscii("-accept="))
				{
					conDcp = aParam.Copy(8);

#ifdef DEBUG
					::rtl::OString tmp = ::rtl::OUStringToOString(conDcp, RTL_TEXTENCODING_ASCII_US);
					OSL_TRACE("accept = %s", tmp.getStr());
#endif
				}
				else if ( aParam.Copy( 0, 7 ).EqualsIgnoreCaseAscii( "-userid" ))
				{
					::rtl::OUString aUserId = aParam;

					sal_Int32 nPos = aUserId.indexOf( '[' );
					sal_Int32 nEndpos = aUserId.lastIndexOf( ']' );
					if( nPos != -1 && nEndpos != -1 )
						aUserDir = Uri::decode(
							aUserId.copy( nPos + 1, nEndpos - nPos - 1 ),
							rtl_UriDecodeWithCharset,
							RTL_TEXTENCODING_UTF8 );
#ifdef DEBUG
					::rtl::OString tmp = ::rtl::OUStringToOString(aUserDir, RTL_TEXTENCODING_ASCII_US);
					OSL_TRACE("userDir = %s", tmp.getStr());
#endif
				}
			}
		}

		if ( bHeadlessMode )
			Application::EnableHeadlessMode();

		if ( conDcp.getLength() > 0 )
		{
			// accept incoming connections (scripting and one rvp)
#if SUPD>637
			RTL_LOGFILE_CONTEXT( aLog, "create sfx2::OOfficeAcceptorThread" );
#endif
			pOfficeAcceptThread = new sfx2::OOfficeAcceptorThread( rSMgr, conDcp, bHeadlessMode, aClientDisplay, aUserDir );
			pOfficeAcceptThread->create();
		}

		// improves parallel processing on Sun ONE Webtop
		// servicemanager up -> copy user installation
		Any aAny;
		Reference <XInterface> xRef =  rSMgr->createInstanceWithArguments(
			OUString::createFromAscii( "com.sun.star.portal.InstallUser" ),
			Sequence<Any>( &aAny, 1 ) );
	}
}

//***********************************************************************************************************************

void SfxApplicationClass::DeInit()
{
    // try to dispose component context
    Reference< beans::XPropertySet > xProps( ::comphelper::getProcessServiceFactory(), UNO_QUERY );
    if (xProps.is())
    {
        try
        {
            Reference< lang::XComponent > xComp;
            if (xProps->getPropertyValue( OUString( RTL_CONSTASCII_USTRINGPARAM("DefaultContext") ) ) >>= xComp)
            {
                xComp->dispose();
            }
        }
        catch (beans::UnknownPropertyException &)
        {
        }
    }

    if( !Application::IsRemoteServer() )
	{
		OfficeIPCThread::DisableOfficeIPCThread();
		if( pSignalHandler )
            DELETEZ( pSignalHandler );
	}
}

//***********************************************************************************************************************

// "real" sfx headers
#include "imagemgr.hxx"
#include "sfxhelp.hxx"

void SfxApplicationClass::Main( )
{
#if SUPD>637
	RTL_LOGFILE_CONTEXT( aLog, "SfxApplicationClass::Main()" );
#endif
    Application::SetSystemWindowMode( SYSTEMWINDOW_MODE_DIALOG );

    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >    xSMgr = ::comphelper::getProcessServiceFactory();
	::com::sun::star::uno::Reference< ::com::sun::star::bridge::XConnectionBroker >		xServiceManagerBroker;
	::com::sun::star::uno::Reference< ::com::sun::star::bridge::XConnectionBroker >		xPalmPilotManagerBroker;

	RemoteControl aControl;

	// At the moment a SfxApplication is used for application services
	SfxApplication *pApp = SFX_APP();

    Reference < XComponent > xDesktop( xSMgr->createInstance(OUString::createFromAscii("com.sun.star.frame.Desktop")), UNO_QUERY );

    // the shutdown icon sits in the systray and allows the user to keep
    // the office instance running for quicker restart
    // this will only be activated if -invisible was specified on cmdline
    Reference < XDesktop > aDesktopRef ( xDesktop, UNO_QUERY );
    ::sfx2::CommandLineArgs* pArgs = GetCommandLineArgs();

    if( !Application::IsRemoteServer() && ( pArgs->IsInvisible() || ShutdownIcon::GetAutostart() ) )
    {
        ShutdownIcon::create( aDesktopRef, pApp->GetSfxResManager() );
        if ( aDesktopRef.is() )
            aDesktopRef->addTerminateListener( ShutdownIcon::getInstance() );
    }

    if ( pArgs->IsPlugin() )
	{
		OUString    aAcceptString( RTL_CONSTASCII_USTRINGPARAM( "pipe,name=soffice_plugin" ));
		OUString	aUserIdent;
		OSecurity	aSecurity;

		aSecurity.getUserIdent( aUserIdent );
		aAcceptString += aUserIdent;

		pPluginAcceptThread = new PluginAcceptThread(	xSMgr,
														new OInstanceProvider( xSMgr ),
														aAcceptString );

        // We have to acquire the plugin accept thread object to be sure
		// that the instance is still alive after an exception was thrown
		pPluginAcceptThread->acquire();
		pPluginAcceptThread->create();
	}

    {
        // use one scope for Help instance because it must be destroyed before Deinit (sends AppEvent in DTOR)
        SfxHelp aHelp;
        rtl::OUString aDescription;
        if ( pOfficeAcceptThread )
        {
            aDescription = pOfficeAcceptThread->GetDescriptionString();
        }
        else
        {
            ::vos::OExtCommandLine aCmdLine;
            ULONG nArgs = aCmdLine.getCommandArgCount();
            for( ULONG n=0; n<nArgs; n++ )
            {
                String aParam;
                ::rtl::OUString aDummy;
                aCmdLine.getCommandArg( n, aDummy );
                aParam = aDummy;
                if ( aParam.Copy( 0, 7 ).EqualsIgnoreCaseAscii( "-portal" ) )
                {
                    aDescription = aParam.Erase( 0,7 );
                    break;
                }
            }
        }

        if ( aDescription.getLength())
        {
            sal_Int32   index;
            sal_Int32   lastIndex = 0;
            do
            {
                index = aDescription.indexOf((sal_Unicode) ',', lastIndex);
                OUString token = (index == -1) ? aDescription.copy(lastIndex) : aDescription.copy(lastIndex, index - lastIndex);
                lastIndex = index + 1;
                sal_Int32 eindex = token.indexOf((sal_Unicode)'=');
                OUString left = token.copy(0, eindex).toAsciiLowerCase().trim();
                OUString right = token.copy(eindex + 1).trim();
                if(left.equals(OUString(RTL_CONSTASCII_USTRINGPARAM("ticket"))))
                {
                    aHelp.SetTicket( right );
                }
                if(left.equals(OUString(RTL_CONSTASCII_USTRINGPARAM("user"))))
                {
                    aHelp.SetUser( right );
                }
            }
            while(index != -1);
        }

        ::framework::SetImageProducer( GetImage );

        Application::SetHelp( &aHelp );
		if ( SvtHelpOptions().IsExtendedHelp() )
			Help::EnableBalloonHelp();
		else
			Help::DisableBalloonHelp();
		if ( SvtHelpOptions().IsHelpTips() )
			Help::EnableQuickHelp();
		else
			Help::DisableQuickHelp();

		if ( !Application::IsRemoteServer() )
		{
			// Create TypeDetection service to have filter informations for quickstart feature
			Reference< XTypeDetection > xTypeDetection( xSMgr->createInstance(
															OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.document.TypeDetection" ))),
														UNO_QUERY );
		}

		// call Application::Execute to process messages in vcl message loop
#if SUPD>637
		Application::WaitForClientConnect();
		RTL_LOGFILE_CONTEXT_TRACE( aLog, "call Application::Execute()" );
#endif
        Execute();
    }

    if ( aDesktopRef.is() && ShutdownIcon::getInstance() )
    {
        aDesktopRef->removeTerminateListener( ShutdownIcon::getInstance() );
        aDesktopRef = NULL;
    }

    ShutdownIcon::destroy();

	// remove temp directory
    if ( STRING_NOTFOUND != aTempBase.Search( aTempNameBaseDir ) )
	{
        String aRet;
        ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aTempBase, aRet );
        if ( ::utl::UCBContentHelper::Kill( aRet ) )
		{
            SvtPathOptions().SetTempPath( String() );
            ::utl::LocalFileHelper::ConvertPhysicalNameToURL( aTempNameBaseDir, aRet );
            ::utl::UCBContentHelper::Kill( aRet );
		}
	}

	if( xPalmPilotManagerBroker.is() )
		xPalmPilotManagerBroker->stopAccepting();
	if( xServiceManagerBroker.is() )
		xServiceManagerBroker->stopAccepting();

	if( pOfficeAcceptThread )
	{
		pOfficeAcceptThread->stopAccepting();
#ifndef LINUX
        pOfficeAcceptThread->join();
        delete pOfficeAcceptThread;
#endif
		pOfficeAcceptThread = 0;
	}

	if ( pPluginAcceptThread )
	{
		pPluginAcceptThread->terminate();
		pPluginAcceptThread->release();
	}

	UCB_Helper::Deinitialize();
    ::ucb::ContentBroker::deinitialize();
}

sal_uInt16 SfxApplicationClass::Exception( sal_uInt16 nError )
{
	// protect against recursive calls
	static BOOL bInException = FALSE;

	sal_uInt16 nOldMode = Application::GetSystemWindowMode();
	Application::SetSystemWindowMode( nOldMode & ~SYSTEMWINDOW_MODE_NOAUTOMODE );
	Application::SetDefModalDialogParent( NULL );

	if ( bInException )
	{
		String aDoubleExceptionString;
        Application::Abort( aDoubleExceptionString );
	}

	bInException = TRUE;

    // save all modified documents
    if( Application::IsInExecute() )
    {
		// store to backup path
		String aSavePath( SvtPathOptions().GetBackupPath() );
		SvtInternalOptions aOpt;

		// iterate tasks
		Reference< ::com::sun::star::frame::XTasksSupplier >
                xDesktop( ::comphelper::getProcessServiceFactory()->createInstance( OUSTRING(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.Desktop")) ),
                UNO_QUERY );
        Reference< ::com::sun::star::frame::XTask > xTask;
        Reference< ::com::sun::star::container::XEnumeration > xList = xDesktop->getTasks()->createEnumeration();
        while( xList->hasMoreElements() )
        {
			xList->nextElement() >>= xTask;

			// ask for controller
			Reference< ::com::sun::star::frame::XController > xCtrl = xTask->getController();
			if ( xCtrl.is() )
			{
				// ask for model
				Reference< ::com::sun::star::frame::XModel > xModel( xCtrl->getModel(), UNO_QUERY );
				Reference< ::com::sun::star::util::XModifiable > xModifiable( xModel, UNO_QUERY );
				if ( xModifiable.is() && xModifiable->isModified() )
				{
					// ask if modified
					Reference< ::com::sun::star::frame::XStorable > xStor( xModel, UNO_QUERY );
					if ( xStor.is() )
					{
						// get the media descriptor and retrieve filter name and password
						::rtl::OUString aOrigPassword, aOrigFilterName;
						Sequence < PropertyValue > aArgs( xModel->getArgs() );
            			sal_Int32 nProps = aArgs.getLength();
            			for ( sal_Int32 nProp = 0; nProp<nProps; nProp++ )
            			{
                			const PropertyValue& rProp = aArgs[nProp];
							if( rProp.Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
								rProp.Value >>= aOrigFilterName;
							if( rProp.Name == OUString(RTL_CONSTASCII_USTRINGPARAM("Password")) )
								rProp.Value >>= aOrigPassword;
						}

						// save document as tempfile in backup directory
						// remember old name or title
						::rtl::OUString aOrigURL = xModel->getURL();
						::rtl::OUString aOldName, aSaveURL;
						if ( aOrigURL.getLength() )
						{
							::utl::TempFile aTempFile( &aSavePath );
							aSaveURL = aTempFile.GetURL();
                			aOldName = aOrigURL;
						}
						else
						{
							// untitled document
							String aExt( DEFINE_CONST_UNICODE( ".sav" ) );
							::utl::TempFile aTempFile( DEFINE_CONST_UNICODE( "exc" ), &aExt, &aSavePath );
							aSaveURL = aTempFile.GetURL();
							// aOldName = Title;
						}

						if ( aOrigPassword.getLength() )
						{
							// if the document was loaded with a password, it should be stored with password
							Sequence < PropertyValue > aSaveArgs(1);
							aSaveArgs[0].Name = DEFINE_CONST_UNICODE("Password");
							aSaveArgs[0].Value <<= aOrigPassword;

							xStor->storeToURL( aSaveURL, aSaveArgs );
						}
						else
							xStor->storeToURL( aSaveURL, Sequence < PropertyValue >() );

						// remember original name and filter
						aOpt.PushRecoveryItem(	aOldName, aOrigFilterName, aSaveURL );
					}
				}
			}
		}

        if ( ( nError & EXC_MAJORTYPE ) != EXC_DISPLAY && ( nError & EXC_MAJORTYPE ) != EXC_REMOTE )
            WarningBox( NULL, SfxResId(STR_RECOVER_PREPARED) ).Execute();
    }

	// store configuration data
	::utl::ConfigManager::GetConfigManager()->StoreConfigItems();

	// because there is no method to flush the condiguration data, we must dispose the ConfigManager
	Reference < XComponent > xComp( ::utl::ConfigManager::GetConfigManager()->GetConfigurationProvider(), UNO_QUERY );
	xComp->dispose();

    switch( nError & EXC_MAJORTYPE )
    {
/*
        case EXC_USER:
			if( nError == EXC_OUTOFMEMORY )
			{
				// not possible without a special NewHandler!
				String aMemExceptionString;
            	Application::Abort( aMemExceptionString );
			}
            break;
*/
        case EXC_RSCNOTLOADED:
		{
			String aResExceptionString;
            Application::Abort( aResExceptionString );
            break;
		}

        case EXC_SYSOBJNOTCREATED:
		{
			String aSysResExceptionString;
            Application::Abort( aSysResExceptionString );
            break;
		}

		default:
		{
			if( !pPluginAcceptThread && !Application::IsRemoteServer() )
			{
				OfficeIPCThread::DisableOfficeIPCThread();
				if( pSignalHandler )
            		DELETEZ( pSignalHandler );

    			::rtl::OUString aProgName, aTmp;
    			::vos::OStartupInfo aInfo;
    			aInfo.getExecutableFile( aProgName );

				Reference< XSystemShellExecute > xSystemShellExecute( ::comphelper::getProcessServiceFactory()->createInstance(
						::rtl::OUString::createFromAscii( "com.sun.star.system.SystemShellExecute" )), UNO_QUERY );
				if ( xSystemShellExecute.is() )
				{
					::rtl::OUString aSysPathFileName;
					::osl::FileBase::RC nError = ::osl::FileBase::getSystemPathFromFileURL( aProgName, aSysPathFileName );
					if ( nError == ::osl::FileBase::E_None )
			 			xSystemShellExecute->execute( aSysPathFileName, ::rtl::OUString(), SystemShellExecuteFlags::DEFAULTS );
				}
			}

			exit( 333 );
//            Application::Abort( String() );
			break;
		}
    }

	return TRUE;

	// ConfigManager is disposed, so no way to continue
	// bInException = sal_False;
	// return Application::Exception( nError );
}

#if SUPD<638
void SfxApplicationClass::ShowStatusText( const String& rText )
{
}

void SfxApplicationClass::HideStatusText()
{
}

void SfxApplicationClass::FocusChanged()
{
}

void SfxApplicationClass::AppEvent( const ApplicationEvent& rAppEvent )
{
    HandleAppEvent( rAppEvent );
}

#endif
