/*************************************************************************
 *
 *  $RCSfile: preadme.cxx,v $
 *
 *  $Revision: 1.5.4.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "script.hxx"

#include "preadme.hxx"
#include "preadme.hrc"

#define PROP_ONLINEREG_NO	1
#define PROP_ONLINEREG_YES	2

PageReadme::PageReadme( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aTextEdit	   	( this, ResId(ME_README, rResId.GetResMgr()) ),
	aCBOnlineReg   	( this, ResId(CB_ONLINEREG, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	aText = aFTInfo1.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo1.SetText( aText );

	SiInstallMode eMode = GETDLG()->GetEnv()->GetInstallMode();

/*
 * 	alte Registrierung fuer first Drop 5.0
 *
 * 	if( !GETDLG()->GetEnv()->IsLocal() ||
		eMode == IM_APPSERVER	||
		eMode == IM_NETWORK		||
		eMode == IM_WORKSTATION )
	{
		aCBOnlineReg.Hide();
		aCBOnlineReg.Check(FALSE);
	}
	else
		aCBOnlineReg.Check(TRUE);
*/
	aCBOnlineReg.Hide();
	aCBOnlineReg.Check(FALSE);

    aTextEdit.SetLeftMargin( 5 );
}

PageReadme::~PageReadme()
{
}

SvAgentPage* PageReadme::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageReadme( pParent, rResId );
}

ULONG PageReadme::GetProperty()
{
	return PROP_ONLINEREG_NO;
}

void PageReadme::InitProperty(ULONG nProp)
{
}

BOOL PageReadme::SetReadmeFile( const String& rFileName )
{
    SvFileStream aReadStrm(rFileName, STREAM_READ);
	if( !aReadStrm.IsOpen() )
		return FALSE;

    aReadStrm.Seek( STREAM_SEEK_TO_END );
    ULONG nLength = aReadStrm.Tell();
    aReadStrm.Seek( STREAM_SEEK_TO_BEGIN );

    char* pBuf1 = new char[nLength+1];
    char* pBuf2 = pBuf1;
	ULONG nRead = aReadStrm.Read( pBuf1, nLength );
	aReadStrm.Close();
	pBuf1[nRead] = 0x00;

    // Skip leading byte order mark if present #104965#
    if ( ( nRead > 2 ) && ( 0 == strncmp( pBuf1, "\xEF\xBB\xBF", 3 ) ) )
        pBuf2 += 3;

	UniString aStr( pBuf2, RTL_TEXTENCODING_UTF8 );
	delete pBuf1;

	ULONG nPos;
	while ( ( nPos = aStr.Search( (char) 12 ) ) != STRING_NOTFOUND )
		aStr.Erase( (USHORT)nPos, 1 );
	aTextEdit.SetText( aStr );

    return TRUE;
}


