/*************************************************************************
 *
 *  $RCSfile: registry.hxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 10:05:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _REGISTRY_HXX_
#define _REGISTRY_HXX_

#include <windows.h>
#include <memory>
#include <rtl/ustring.hxx>

//---------------------------------------
// constants
//---------------------------------------

class CRegistryKey
{
public:   

    // factory methods
    static CRegistryKey* Create( HKEY hRootKey, const rtl::OUString& aSubKeyName, REGSAM samDesired, LONG* pErrorCode = NULL );
    static CRegistryKey* Open(   HKEY hRootKey, const rtl::OUString& aSubKeyName, REGSAM samDesired, LONG* pErrorCode = NULL );

    virtual ~CRegistryKey();

    virtual LONG Create() = 0;
    virtual LONG Delete() = 0;
    virtual LONG Open()   = 0;
    virtual LONG Close();
    
    virtual LONG SetValue( const rtl::OUString& aValueName, const rtl::OUString& aValue) = 0;
    virtual LONG SetValue( const rtl::OUString& aValueName, const rtl::OUString& aValue, const rtl::OUString& aFallbackValue) = 0;        

    virtual LONG GetValue( const rtl::OUString& aValueName, rtl::OUString& aValue ) = 0;

    virtual LONG SetValue( const rtl::OUString& aValueName, const sal_Int32 aValue) = 0;
    virtual LONG GetValue( const rtl::OUString& aValueName, int* pValue ) = 0;
    
    bool IsOpen() const;

    virtual LONG DeleteValue( const rtl::OUString& aValueName ) = 0;

    HKEY GetHKEY() const;

    operator HKEY() const;

protected:
    CRegistryKey( HKEY hRootKey, const rtl::OUString& aSubKeyName, REGSAM samDesired );

    static CRegistryKey* CreateInstance( HKEY hRootKey, const rtl::OUString& aSubKeyName, REGSAM samDesired );

protected: 
    HKEY            m_hRootKey;
    HKEY            m_hSubKey;
    rtl::OUString   m_SubKeyName;
    REGSAM          m_samDesired;

// prevent copy/assignment
private:
    CRegistryKey( const CRegistryKey& );
    CRegistryKey& operator=( const CRegistryKey& );
};

typedef std::auto_ptr< CRegistryKey > CRegistryKeyPtr;

#endif