/*************************************************************************
 *
 *  $RCSfile: reg4msdoc.cxx,v $
 *
 *  $Revision: 1.7.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 10:05:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>

#define VCL_NEED_BASETSD

#ifndef _REG4MSDOCMAINDLG_HXX
#include "reg4msdocmaindlg.hxx"
#endif

#include "environ.hxx"
#include "sicustom.hxx" 
#include <osl/diagnose.h>
#include <rtl/ustring.hxx>

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include <memory>

#include "register.hxx"

#include "preg4msdoc.hrc"

//---------------------------------------
// namespace directives 
//---------------------------------------

using namespace osl;
using namespace rtl;

//---------------------------------------
// extern declarations
//---------------------------------------

extern "C" BOOL _SV_CALL CustomInit( SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc );

//---------------------------------------
//
//---------------------------------------

typedef std::auto_ptr<ResMgr> ResMgrPtr_t;

//---------------------------------------
// forwards
//---------------------------------------

int QuerySelectedModules( SiCustomModuleList* pModuleList, bool bInstallModules = false );
void HandleAfterInstallation( SiCustomEnvironment* pEnv );

//---------------------------------------
// defines
//---------------------------------------

#define RES_NAME reg4msdoc

//---------------------------------------
// globals 
//---------------------------------------

SiSetupFnc aSetupFnc;

static int g_UserPreferences  = 0;
static int g_UninstallModules = 0;

//---------------------------------------
// constants
//---------------------------------------
 
const OString WRITER_MODULE_ID  = "gid_Module_Prg_Wrt_Bin";
const OString CALC_MODULE_ID    = "gid_Module_Prg_Calc_Bin";
const OString IMPRESS_MODULE_ID = "gid_Module_Prg_Impress_Bin";

const bool INSTALL_MODULES   = false;
const bool UNINSTALL_MODULES = true;

const OUString BACKSLASH = OUString::createFromAscii( "\\" );

const OString REG4MSDOC_GROUP_NAME( "Windows_Desktop_Integration" );

const OString RESPKEY_REG4MSWORD( "RegisterForMsWord" );
const OString RESPKEY_REG4MSEXCEL( "RegisterForMsExcel" );
const OString RESPKEY_REG4MSPOWERPOINT( "RegisterForMsPowerPoint" );
const OString RESPKEY_REG4DEFHTMLEDT( "RegisterAsDefaultHtmlEditor" );

const OString NO( "no" );

//---------------------------------------
//
//---------------------------------------

inline bool IsBeforeInstallation( SiCustomEnvironment *pEnv )
{
    return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsInstallation() && pEnv->IsPre() );
}
    
//---------------------------------------
//
//---------------------------------------

inline bool IsAfterInstallation( SiCustomEnvironment *pEnv )
{
    return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsInstallation() && pEnv->IsPost() );
}

//---------------------------------------
//
//---------------------------------------

inline bool IsDeinstallation( SiCustomEnvironment *pEnv )
{
    return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsDeinstallation() );
}

//---------------------------------------
//
//---------------------------------------

inline bool IsSetupModifyBefore(SiCustomEnvironment *pEnv)
{
    return (pEnv->IsModify() && pEnv->IsPre());
}

//---------------------------------------
//
//---------------------------------------

inline bool IsSetupModifyAfter(SiCustomEnvironment *pEnv)
{
    return (pEnv->IsModify() && pEnv->IsPost());
}

//---------------------------------------
//
//---------------------------------------

inline bool IsSetupRepair( SiCustomEnvironment *pEnv )
{
    return  pEnv->IsRepair();
}

//---------------------------------------
//
//---------------------------------------

inline bool IsWriterModule(const OString& aModuleId)
{
    return ( aModuleId.equalsIgnoreAsciiCase(WRITER_MODULE_ID));
}

//---------------------------------------
//
//---------------------------------------

inline bool IsCalcModule(const OString& aModuleId)
{
    return ( aModuleId.equalsIgnoreAsciiCase( CALC_MODULE_ID ) );
}

//---------------------------------------
//
//---------------------------------------

inline bool IsImpressModule(const OString& aModuleId)
{
    return (aModuleId.equalsIgnoreAsciiCase(IMPRESS_MODULE_ID));
}

//---------------------------------------
//
//---------------------------------------

inline int QueryInstallModules(SiCustomModuleList* pModuleList)
{
    return QuerySelectedModules(pModuleList);
}

//---------------------------------------
//
//---------------------------------------

inline int QueryUninstallModules(SiCustomModuleList* pModuleList)
{
    return QuerySelectedModules(pModuleList, true);
}

//---------------------------------------
//
//---------------------------------------

void SetupQueryReg4MsDocDialog(int aModules, Reg4MsDocMainDialog& aDialog)
{
    OSL_PRECOND(aModules > 0, "no modules selected");

    aDialog.Reg4MsWord(false);
    aDialog.EnableReg4MsWord(false);

    aDialog.Reg4MsExcel(false);
    aDialog.EnableReg4MsExcel(false);

    aDialog.Reg4MsPowerPoint(false);
    aDialog.EnableReg4MsPowerPoint(false);

    aDialog.Reg4DefHtmlEdt(false);
    aDialog.EnableReg4DefHtmlEdt(false);
                  
    if (aModules & MOD_WRITER)
    {
        aDialog.Reg4MsWord(true);
        aDialog.EnableReg4MsWord(true);

        aDialog.Reg4DefHtmlEdt(true);
        aDialog.EnableReg4DefHtmlEdt(true);
    }

    if (aModules & MOD_CALC)
    {
        aDialog.Reg4MsExcel(true);
        aDialog.EnableReg4MsExcel(true);
    }
    
    if (aModules & MOD_IMPRESS)
    {
        aDialog.Reg4MsPowerPoint(true);
        aDialog.EnableReg4MsPowerPoint(true);
    }
}

//---------------------------------------
//
//---------------------------------------

bool ResponseFileQueryUserPreferences( SiCustomEnvironment* pEnv, SiCustomModuleList* pList, int& UserPref )
{
    int aModules = QueryInstallModules( pList );

    UserPref = 0;

    if (aModules & MOD_WRITER)
    {
        UserPref |= REG4MSWORD;
        UserPref |= REG4DEFHTMLEDT;
		UserPref |= REG4HTMLEDT;
    }

    if (aModules & MOD_CALC)
        UserPref |= REG4MSEXCEL;

    if (aModules & MOD_IMPRESS)
        UserPref |= REG4MSPOWERPOINT;

    OUString aRespFileName = OUString(pEnv->GetResponseFileName().GetBuffer(),
				pEnv->GetResponseFileName().Len(), osl_getThreadTextEncoding());

    Config aRespFile(aRespFileName);

    if (aRespFile.HasGroup(REG4MSDOC_GROUP_NAME))
    {
        aRespFile.SetGroup(REG4MSDOC_GROUP_NAME);

        OString Response = aRespFile.ReadKey(RESPKEY_REG4MSWORD);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~REG4MSWORD;            

        Response = aRespFile.ReadKey(RESPKEY_REG4MSEXCEL);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~REG4MSEXCEL;

        Response = aRespFile.ReadKey(RESPKEY_REG4MSPOWERPOINT);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~REG4MSPOWERPOINT;

        Response = aRespFile.ReadKey(RESPKEY_REG4DEFHTMLEDT);

        if (Response.matchIgnoreAsciiCase(NO))
            UserPref &= ~REG4DEFHTMLEDT;
    }

    return true;
}

//---------------------------------------
// traverses the module list and returns
// a number identifying which modules
// should be installed
// the number has to be interpreted as
// bit field
// 0x1 means Writer
// 0x2 means Calc
// 0x4 means Impress
//---------------------------------------

int QuerySelectedModules( SiCustomModuleList* pModuleList, bool bInstallModules )
{
    int nRet = 0;

    sal_Int32 nModules = pModuleList->Count();
    
    for (sal_Int32 i = 0; i < nModules; i++)
    {                
        SiCustomModuleInfo* pCustModInf = pModuleList->GetObject(i);

        if ( pCustModInf->IsSelected() && (pCustModInf->IsInstalled() == bInstallModules))
        {
            ByteString strModID = pModuleList->GetObject(i)->GetModuleID();

            if (IsWriterModule( strModID))
                nRet |= MOD_WRITER;
            else if (IsCalcModule(strModID))
                nRet |= MOD_CALC;
            else if ( IsImpressModule(strModID))
                nRet |= MOD_IMPRESS;
        }
    }

    return nRet;
}

//---------------------------------------
//
//---------------------------------------

bool DialogQueryUserPreferences( SiCustomModuleList* pList, int& UserPref )
{ 
    OSL_ASSERT( pList );

    UserPref = 0;
    
    bool bResult = true;

    int aModuleSelection = QueryInstallModules(pList);

    if (aModuleSelection > 0)
    {
        ResMgr *pResMgr = CREATEVERSIONRESMGR(RES_NAME);

        OSL_ENSURE(pResMgr, "could not create res-manager");

        Reg4MsDocMainDialog reg4MsDocDlg(NULL, pResMgr);
    
        SetupQueryReg4MsDocDialog(aModuleSelection, reg4MsDocDlg);

        reg4MsDocDlg.StartAgentDlg();  
        reg4MsDocDlg.SetHelpAvailable(String(ResId(STR_HELP_TEXT, pResMgr)));
        reg4MsDocDlg.Show();
    
        bResult = reg4MsDocDlg.DoModal();

		// we always register for html
		// edit if writer is installed
		// because there's no harm if
		// we do so 
		if (aModuleSelection & MOD_WRITER)
			UserPref |= REG4HTMLEDT;

        if (reg4MsDocDlg.Reg4MsWord())
            UserPref |= REG4MSWORD;

        if (reg4MsDocDlg.Reg4MsExcel())
            UserPref |= REG4MSEXCEL;

        if (reg4MsDocDlg.Reg4MsPowerPoint())
            UserPref |= REG4MSPOWERPOINT;

        if (reg4MsDocDlg.Reg4DefHtmlEdt())
            UserPref |= REG4DEFHTMLEDT;
    }

    return bResult;
}

//---------------------------------------
//
//---------------------------------------

bool QueryUserPreferences( SiCustomEnvironment* pEnv, SiCustomModuleList* pList, int& UserPref )
{
    bool bResult;

    if (pEnv->IsResponseFileMode())
        bResult = ResponseFileQueryUserPreferences(pEnv, pList, UserPref);
    else
        bResult = DialogQueryUserPreferences(pList, UserPref);

    return bResult;
}

//---------------------------------------
//
//---------------------------------------

OUString GetFullProgramPath(SiCustomEnvironment* pEnv)
{
    OUString path;

    if (pEnv->IsInstallation())
    {
		SiInstallType InstType = pEnv->GetBigEnv()->GetInstallType();

		BOOL bItWorkstation  = (InstType == IT_WORKSTATION);
		BOOL bItRecover      = (InstType == IT_RECOVER);
		BOOL bItChange		 = (InstType == IT_CHANGE);
		BOOL bInstallFromNet = pEnv->GetBigEnv()->InstallFromNet();

		if (bInstallFromNet && (bItWorkstation || bItRecover || bItChange))
			path = OStringToOUString(pEnv->GetBigEnv()->GetSourcePath(), osl_getThreadTextEncoding());
		else
			path = OStringToOUString(pEnv->GetDestPath(), osl_getThreadTextEncoding());        

        if (path.lastIndexOf(BACKSLASH) != (path.getLength() - 1))
            path += BACKSLASH;

        path += OUString::createFromAscii( "program\\soffice.exe");
    }

    return path;
}

//---------------------------------------
//
//---------------------------------------

bool HandleBeforeInstallation(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{   
    return QueryUserPreferences(pEnv, pList, g_UserPreferences);
}

//---------------------------------------
// called after the installation of the
// modules finished in case of 
// Installation or Modification
//---------------------------------------

void HandleAfterInstallation(SiCustomEnvironment* pEnv)
{
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));
    Register4MsDoc(g_UserPreferences, GetFullProgramPath(pEnv), aResMgrPtr.get());
}

//---------------------------------------
//
//---------------------------------------

void HandleDeinstallation()
{
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));
    Unregister4MsDocAll(aResMgrPtr.get());
}

//---------------------------------------
//
//---------------------------------------

bool HandleSetupModifyBefore(SiCustomEnvironment* pEnv, SiCustomModuleList* pModuleList)
{            
	g_UninstallModules = QueryUninstallModules(pModuleList);
    return QueryUserPreferences(pEnv, pModuleList, g_UserPreferences);
}

//---------------------------------------
//
//---------------------------------------

void HandleSetupRepair(SiCustomEnvironment* pEnv)
{
    ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));
    RepairRegister4MsDocSettings(GetFullProgramPath(pEnv), aResMgrPtr.get());
}

//---------------------------------------
// EntryPoint for setup plug-ins
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return false;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 		     = pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup	     = pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup	     = pSetupFnc->fncShowSetup;
    aSetupFnc.fncGetCodeFilename = pSetupFnc->fncGetCodeFilename;

	return true;
}

//---------------------------------------
// CustomMain of setup plug-in
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
    bool bRet = true;

    if (IsBeforeInstallation(pEnv))
    {
        bRet = HandleBeforeInstallation(pEnv, pList);
    }
    else if (IsAfterInstallation(pEnv))
    {
        HandleAfterInstallation(pEnv);
    }	
	else if (IsSetupModifyAfter(pEnv))
	{
		ResMgrPtr_t aResMgrPtr(CREATEVERSIONRESMGR( RES_NAME));

		Register4MsDoc(
			g_UserPreferences, 
			GetFullProgramPath(pEnv), 
			aResMgrPtr.get());

		Unregister4MsDoc(g_UninstallModules,aResMgrPtr.get());
	}
    else if (IsDeinstallation(pEnv))
    {
        HandleDeinstallation();
    }
    else if (IsSetupModifyBefore(pEnv))
    {
        HandleSetupModifyBefore(pEnv, pList);
    }    
    else if (IsSetupRepair(pEnv))
    {
        HandleSetupRepair(pEnv);
    }
    else
    {
        OSL_ENSURE(false, "impossible case?");
    }
    
    return bRet;
}


