/*************************************************************************
 *
 *  $RCSfile: siprof.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiProfile,SiDeclarator)
TYPEINIT1(SiProfileItem,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiProfile
//

SiProfile::SiProfile( SiIdentifier const& ID, SiCompiler* pCompiler ) :
	SiDeclarator( ID, pCompiler )
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( Name );
	INIT_MULTI_LANG_MEMBER( pDirectory );
	INIT_MULTI_LANG_MEMBER( bNetwork );
	INIT_MULTI_LANG_MEMBER( bDontDelete );
	INIT_MULTI_LANG_MEMBER( bIsServerINI );
	INIT_MULTI_LANG_MEMBER( nUnixRights );

	m_pModule		= NULL;
	m_pDirectory	= NULL;
	m_bNetwork		= FALSE;
	m_bDontDelete	= FALSE;
	m_bIsServerINI	= FALSE;
	m_nUnixRights	= 755;
}

// ----------------------------------------------------------------------------

void SiProfile::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiProfile* pParent = (SiProfile*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( Name );
	JOIN_MULTI_LANG_MEMBER( pDirectory );
	JOIN_MULTI_LANG_MEMBER( bNetwork );
	JOIN_MULTI_LANG_MEMBER( bDontDelete );
	JOIN_MULTI_LANG_MEMBER( bIsServerINI );
	JOIN_MULTI_LANG_MEMBER( nUnixRights );
}

// ----------------------------------------------------------------------------

SiProfile::~SiProfile()
{
}

// ----------------------------------------------------------------------------

BOOL SiProfile::SetProperty( ByteString const& aProperty, ByteString const& aValue )
{
	if( aProperty == PROPERTY_NAME )
	{
		SET_MULTI_LANG_MEMBER( Name, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_FLAGS )
	{
		if( aValue == VALUE_NETWORK )
		{
			SET_MULTI_LANG_MEMBER( bNetwork, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_DONT_DELETE )
		{
			SET_MULTI_LANG_MEMBER( bDontDelete, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_SERVER_INI )
		{
			SET_MULTI_LANG_MEMBER( bIsServerINI, TRUE );
			return TRUE;
		}

		Error("illegal value");
		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfile::SetProperty( ByteString const& aProperty, long aValue )
{
	if( aProperty == PROPERTY_UNIX_RIGHTS )
	{
		SET_MULTI_LANG_MEMBER( nUnixRights, (int)aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfile::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_DIR )
	{
		m_pDirectory = PTR_CAST(SiDirectory,aValue);
		if( m_pDirectory == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );

			return FALSE;
		}
		else
			m_pDirectory->AddRefCount();
		m_IspDirectory = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if( m_pModule == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );

			return FALSE;
		}

		// Profile in die Liste des Moduls haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfile::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_Name,       PROPERTY_NAME);
	bOk = bOk && CheckField(m_pDirectory, PROPERTY_DIR);

	if( !InstallOnNetwork() &&
		m_pDirectory != NULL &&
		!m_pDirectory->InstallOnWorkstation() )
	{
		Warning("local profile lays in net-directory");
		// Bloss nicht aendern, sonst werden alle Dateien
		// in diesem Verzeichnis auch lokal kopiert ...
		//
		// m_pDirectory->DoInstallOnWorkstation();
	}
	return SiDeclarator::Check();
}

// ----------------------------------------------------------------------------

BOOL SiProfile::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Profile", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );
	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, Name );
	// PROPERTY_DIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_DIR, pDirectory );
	// PROPERTY_UNIX_RIGHTS
	WRITE_MULTI_LANG_MEMBER( PROPERTY_UNIX_RIGHTS, nUnixRights );

	if( m_bNetwork || m_bDontDelete || m_bIsServerINI )
	{
		aStream.BeginProperty( PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();
		if( m_bNetwork )
			aStream.AddListValue(SiIdentifier(VALUE_NETWORK));
		if( m_bDontDelete )
			aStream.AddListValue(SiIdentifier(VALUE_DONT_DELETE));
		if( m_bIsServerINI )
			aStream.AddListValue(SiIdentifier(VALUE_SERVER_INI));
		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiProfile* pProfile = (SiProfile*) m_aLangRefs.GetObject(nIdx);
		pProfile->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();

	return TRUE;
}

// ----------------------------------------------------------------------------

ByteString SiProfile::GetNaturalID() const
{
	ByteString aNatID  = GetDirectory()->GetNaturalID();
		   aNatID += NSEP;
		   aNatID += m_Name;
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiProfileItem
//

SiProfileItem::SiProfileItem( SiIdentifier const& ID, SiCompiler *pCompiler ) :
		SiDeclarator( ID,pCompiler )
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( pProfile );
	INIT_MULTI_LANG_MEMBER( Section );
	INIT_MULTI_LANG_MEMBER( Key );
	INIT_MULTI_LANG_MEMBER( Value );
	INIT_MULTI_LANG_MEMBER( WorkstationValue );
	INIT_MULTI_LANG_MEMBER( bIsDocLang );
	INIT_MULTI_LANG_MEMBER( bDontDelete );
	INIT_MULTI_LANG_MEMBER( bDontOverwrite );
	INIT_MULTI_LANG_MEMBER( nOrder );
	INIT_MULTI_LANG_MEMBER( bInstallInfo );

	m_pModule		= NULL;
	m_pProfile		= NULL;
	m_bInstallInfo	= FALSE;
	m_bDontDelete	= FALSE;
	m_bDontOverwrite = FALSE;
	m_bIsDocLang    = FALSE;
	m_nOrder		= USHRT_MAX;
}

// ----------------------------------------------------------------------------

void SiProfileItem::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiProfileItem* pParent = (SiProfileItem*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( pProfile );
	JOIN_MULTI_LANG_MEMBER( Section );
	JOIN_MULTI_LANG_MEMBER( Key );
	JOIN_MULTI_LANG_MEMBER( Value );
	JOIN_MULTI_LANG_MEMBER( WorkstationValue );
	JOIN_MULTI_LANG_MEMBER( bIsDocLang );
	JOIN_MULTI_LANG_MEMBER( bDontDelete );
	JOIN_MULTI_LANG_MEMBER( bDontOverwrite );
	JOIN_MULTI_LANG_MEMBER( nOrder );
	JOIN_MULTI_LANG_MEMBER( bInstallInfo );
}

// ----------------------------------------------------------------------------

BOOL SiProfileItem::SetProperty( ByteString const& aProperty, long aValue )
{
	if( aProperty == PROPERTY_ORDER )
	{
		SET_MULTI_LANG_MEMBER( nOrder, (int)aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfileItem::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_SECTION )
	{
		SET_MULTI_LANG_MEMBER( Section, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_KEY )
	{
		SET_MULTI_LANG_MEMBER( Key, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_VALUE )
	{
		SET_MULTI_LANG_MEMBER( Value, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_WORKSTATIONVALUE )
	{
		SET_MULTI_LANG_MEMBER( WorkstationValue, aValue );
		return TRUE;
	}

	if( aProperty == PROPERTY_FLAGS )
	{
		if( aValue == VALUE_INSTALL_INFO )
		{
			SET_MULTI_LANG_MEMBER( bInstallInfo, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_DONT_DELETE )
		{
			SET_MULTI_LANG_MEMBER( bDontDelete, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_DONT_OVERWRITE )
		{
			SET_MULTI_LANG_MEMBER( bDontOverwrite, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_DOCLANG )
		{
			SET_MULTI_LANG_MEMBER( bIsDocLang, TRUE );
			return TRUE;
		}
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfileItem::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_PROFILEID )
	{
		m_pProfile = PTR_CAST(SiProfile,aValue);
		if (m_pProfile == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a file";
			Error( aMsg );
			return FALSE;
		}
		m_IspProfile = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if (m_pModule == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );
			return FALSE;
		}

		// SiProfileItem in die Liste des Modules haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;

		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiProfileItem::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_pProfile, PROPERTY_PROFILEID);
	bOk = bOk && CheckField(m_pModule,  PROPERTY_MODULEID);
//	bOk = bOk && CheckField(m_Section,  PROPERTY_SECTION);
	bOk = bOk && CheckField(m_Key,      PROPERTY_KEY);

	ByteString aValue = m_Value;
	aValue.ToUpperAscii();
	USHORT nFoundAt = aValue.Search("<WORKPATH>");

	while (nFoundAt != STRING_NOTFOUND)
	{
		ByteString aMacro = m_Value.Copy(nFoundAt,10);
		if( !aMacro.IsLowerAscii() )
			Warning("macros have to be lower case");
		nFoundAt = aValue.Search("<WORKPATH>",nFoundAt+1);
	}
	return bOk ? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiProfileItem::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("ProfileItem", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );
	// PROPERTY_PROFILEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PROFILEID, pProfile );
	// PROPERTY_SECTION
	WRITE_MULTI_LANG_MEMBER( PROPERTY_SECTION, Section );
	// PROPERTY_KEY
	WRITE_MULTI_LANG_MEMBER( PROPERTY_KEY, Key );
	// PROPERTY_VALUE
	WRITE_MULTI_LANG_MEMBER( PROPERTY_VALUE, Value );
	// PROPERTY_WORKSTATIONVALUE
	if( m_WorkstationValue.Len() )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_WORKSTATIONVALUE, WorkstationValue );
	// PROPERTY_ORDER
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ORDER, nOrder );

	if( m_bInstallInfo || m_bDontDelete || m_bDontOverwrite || m_bIsDocLang )
	{
		aStream.BeginProperty( PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();

		if( m_bInstallInfo )
			aStream.AddListValue(SiIdentifier(VALUE_INSTALL_INFO));
		if( m_bDontDelete )
			aStream.AddListValue(SiIdentifier(VALUE_DONT_DELETE));
		if( m_bDontOverwrite )
			aStream.AddListValue(SiIdentifier(VALUE_DONT_OVERWRITE));
		if( m_bIsDocLang )
			aStream.AddListValue(SiIdentifier(VALUE_DOCLANG));

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiProfileItem* pProfileItem = (SiProfileItem*) m_aLangRefs.GetObject(nIdx);
		pProfileItem->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

ByteString SiProfileItem::GetNaturalID() const
{
	ByteString aNatID  = GetProfile()->GetNaturalID();
		   aNatID += NSEP;
		   aNatID += m_Section;
		   aNatID += m_Key;
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

