/*************************************************************************
 *
 *  $RCSfile: os2os.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dv $ $Date: 2001/11/15 12:34:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS	1
#ifndef _SVPM_H
#define INCL_BASE
#include <tools/svpm.h>
#endif
#ifndef _SV_SYSDATA_HXX
#include <vcl/sysdata.hxx>
#endif

#include "os.hxx"  // fr diese Quelle

#define INCL_DOSFILEMGR
#define INCL_DOS
#define INCL_WINERRORS
#define INCL_WINWORKPLACE
#define INCL_WINSHELLDATA
#define INCL_GPILCIDS
#include <sys/stat.h>
#include <sys/types.h>
#include <io.h>
#ifndef ICC
#include <dos.h>
#endif
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <sifsys.hxx>
#include <tools/stream.hxx>
#include <vcl/sysdep.hxx>
#include <vcl/system.hxx>
#include <tools/config.hxx>
#include <vcl/msgbox.hxx>
#include <svtools/extattr.hxx>
#include <ctype.h>

#include "error.hrc"

const char SETUP_TEMPFILE[] = "_setup.tmp";
const char PM_FONTS[]       = "PM_Fonts";


extern "C" {
// undoc. APICall OS2
APIRET APIENTRY DosReplaceModule(PSZ,PSZ,PSZ);
};

#ifdef INTEL
static BOOL bIllegalInstruction;
extern "C"
{
#if defined( __BORLANDC__ )
	void _pascal IMPAI486INSTRUCTION( void );
	void _pascal IMPAPENTIUMINSTRUCTION( void );
#else
	void _Pascal IMPAI486INSTRUCTION( void );
	void _Pascal IMPAPENTIUMINSTRUCTION( void );
#endif
}
#endif

// lokale Typen ----------------------------------------------------------

struct DriveAllocInfo
{
	ULONG  nFileID;
	ULONG  nSectors;
	ULONG  nAll;
	ULONG  nAvail;
	USHORT nBytes;
};

// class OS --------------------------------------------------------------
//
// Hier stehen die Funktionen, die auf allen Plattformen vorhanden sind,
// aber unterschiedlich implementiert werden.

const char* OS::GetAllFilesWildCard()
{
	return "*";
}

// -----------------------------------------------------------------------

ByteString OS::GetSystemPath()
{
	return Os2OS::GetBootDrive();
}

ByteString OS::GetSystemFontPath()
{
	return GetSystemPath() + ByteString( "psfonts" );
}

// -----------------------------------------------------------------------

ByteString OS::GetGUIPath()
{
	// get os/2 ini path
	Config aTmp;
	ByteString aIniPath = aTmp.GetPathName();
	BOOL bFound = FALSE;
	USHORT nPos = aIniPath.Len() - 1;
	while ( !bFound && nPos )
	{
		if ( aIniPath[nPos] == '\\' )
			bFound = TRUE;
		else
			nPos--;
	}
	if ( bFound )
		aIniPath.Erase( nPos + 1 );
	return aIniPath;
}

// -----------------------------------------------------------------------

ULONG OS::GetDriveSize(SiDirEntry const& aSiDirEntry)
// Achtung: idenitsch mit der Windows-Version
{
	SiDirEntry aTmp( aSiDirEntry );
	aTmp.ToAbs();

	USHORT nDrive = (char)aTmp.GetFull().Upper() - 'A';
	ULONG nSize = OS::GetFreeDriveSize( nDrive );

	// dec freesize if system drive
	if ( tolower((char)aTmp.GetFull()) == tolower((char)OS::GetSystemPath()))
	{
		if (nSize > 100)
			nSize -= 100;
		else
			nSize = 0;
	}
	return nSize;
}

ULONG OS::GetClusterSize(SiDirEntry const& aSiDirEntry)
{
	SiDirEntry aTmp( aSiDirEntry );
	aTmp.ToAbs();

	USHORT nDrive = (char)aTmp.GetFull().Upper() - 'A';

	DriveAllocInfo aInfo;

	APIRET rc = DosQueryFSInfo( nDrive + 1, FSIL_ALLOC, &aInfo, sizeof(aInfo) );

	if (rc != 0)
		return 4096;

	return aInfo.nSectors * aInfo.nBytes;
}

// -----------------------------------------------------------------------

ULONG OS::GetFreeDriveSize( USHORT nDrive )
{
	DriveAllocInfo aInfo;

	APIRET rc = DosQueryFSInfo( nDrive + 1, FSIL_ALLOC, &aInfo, sizeof(aInfo) );

	if (rc != 0)
		return 0;

	float 	nSz	 = (float) aInfo.nSectors;
			nSz	*= (float)((float)aInfo.nBytes / 1024);
			nSz *= (float) aInfo.nAvail;

	ULONG lSize  = (ULONG) nSz;
/*	ULONG lSize  = aInfo.nSectors;
		  lSize *= aInfo.nBytes;
		  lSize *= aInfo.nAvail;
		  lSize /= 1024;
*/
	return lSize;
}

void OS::SetDateTime
(
	ByteString const& rFilename,
	Date   const& rDate,
	Time   const& rTime
)
{
	// open file
	ULONG  nAction = FILE_EXISTED;
	HFILE  hFile   = 0;

	ULONG  nFlags = OPEN_FLAGS_WRITE_THROUGH |
					OPEN_FLAGS_FAIL_ON_ERROR |
					OPEN_FLAGS_NO_CACHE      |
					OPEN_FLAGS_RANDOM        |
					OPEN_FLAGS_NOINHERIT     |
					OPEN_SHARE_DENYNONE      |
					OPEN_ACCESS_READWRITE;

	APIRET nRet = DosOpen
				  (
					  (PSZ)rFilename.GetBuffer(),
					  &hFile,
					  (PULONG)&nAction,
					  0, /* size */
					  FILE_NORMAL,
					  OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
					  nFlags,
					  0  /* ea */
				  );

	if (nRet == 0)
	{
		FILESTATUS3 FileInfoBuffer;

		nRet = DosQueryFileInfo( hFile, /*Level*/1, &FileInfoBuffer,
					sizeof(FileInfoBuffer) );

		if (nRet == 0)
		{
			FDATE aNewDate;
			FTIME aNewTime;

			 // create date and time words
			aNewDate.day     = rDate.GetDay();
			aNewDate.month   = rDate.GetMonth();
			aNewDate.year    = rDate.GetYear() - 1980;
			aNewTime.twosecs = 0;
			aNewTime.minutes = rTime.GetMin();
			aNewTime.hours   = rTime.GetHour();

			// set file date and time
			FileInfoBuffer.fdateCreation   = aNewDate;
			FileInfoBuffer.ftimeCreation   = aNewTime;
			FileInfoBuffer.fdateLastAccess = aNewDate;
			FileInfoBuffer.ftimeLastAccess = aNewTime;
			FileInfoBuffer.fdateLastWrite  = aNewDate;
			FileInfoBuffer.ftimeLastWrite  = aNewTime;

			DosSetFileInfo(hFile, /*Level*/1, &FileInfoBuffer,
				sizeof(FileInfoBuffer) );
		}
		DosClose(hFile);
	}
}

BOOL OS::MakeWritable(ByteString const& rFile)
{
	return chmod(rFile, S_IWRITE) == 0;
}

BOOL OS::IsFontInstalled (ByteString const& rFontFile, ByteString const& /* rFontName */)
{
	ByteString aKey    = rFontFile; // "starbats.ofm"

//    ByteString aValue  = GetSystemFontPath().Copy(2); // ohne Laufwerk!
//           aValue += '\\';
//           aValue += aKey;                        // "\psfonts\starbats.ofm"

	ByteString aValue = Os2OS::ReadOS2Ini(PM_FONTS, aKey.Upper());

	return aValue.Len() > 0;
}

BOOL OS::InstallFont (ByteString const& rFontFile, ByteString const& /* rFontName */)
// pre:  Fontdateien stehen bereits im Font-Verzeichnis
// post: Font wurde angemeldet
{
	ByteString aKey    = rFontFile; 			// "starbats.ofm"
	ByteString aValue  = GetSystemFontPath();
		   aValue += '\\';
		   aValue += aKey;					// "e:\psfonts\starbats.ofm"

	if (Os2OS::WriteOS2Ini(PM_FONTS, aKey.Upper(), aValue.Upper()))
		return GpiLoadPublicFonts( Sysdepen::GethAB(), (PSZ)aValue.GetBuffer());

	return FALSE;
}

BOOL OS::UnInstallFont(ByteString const& rFontFile, ByteString const& /* rFontName */)
{
	return Os2OS::WriteOS2Ini(PM_FONTS, rFontFile.Upper(), ByteString());
}

static ULONG GetFreeMemory()
{
	UCHAR Databuf[10];
	APIRET rc;
	ULONG nFreeMem = 0;
	rc = DosQuerySysInfo( QSV_TOTPHYSMEM, QSV_TOTPHYSMEM, Databuf, sizeof(Databuf) );

	if ( !rc )
		nFreeMem  = *((ULONG*)(Databuf));
	return nFreeMem >> 10;
}

#ifdef INTEL
static ULONG APIENTRY ExceptionHandler( PEXCEPTIONREPORTRECORD pERepRec,
										PEXCEPTIONREGISTRATIONRECORD,
										PCONTEXTRECORD pCtxRec,
										PVOID )
{
	if ( pERepRec->ExceptionNum == XCPT_ILLEGAL_INSTRUCTION  )
	{
		bIllegalInstruction = TRUE;

		// illegalen Befehl ueberspringen
		pCtxRec->ctx_RegEip += 2L;

		// neuen EIP im Thread setzen
		pCtxRec->ContextFlags = CONTEXT_CONTROL;
		return XCPT_CONTINUE_EXECUTION;
	}

	return XCPT_CONTINUE_SEARCH;
}
#endif

BOOL OS::IsConfigurationValid(Window* pParent)
{
	CPUType eCPU = CPU_I386;
#ifdef INTEL
	EXCEPTIONREGISTRATIONRECORD aExcptHandler = { 0, ExceptionHandler };

	bIllegalInstruction = FALSE;
	DosError( FERR_DISABLEEXCEPTION );
	DosSetExceptionHandler( &aExcptHandler );
	IMPAI486INSTRUCTION();
	if ( !bIllegalInstruction )
	{
		eCPU = CPU_I486;
		IMPAPENTIUMINSTRUCTION();
		if ( !bIllegalInstruction )
			eCPU = CPU_PENTIUM;
	}
	DosUnsetExceptionHandler( &aExcptHandler );
	DosError( FERR_ENABLEEXCEPTION );
#else
	eCPU = CPU_POWERPC;
#endif
	PM_ULONG nMayor;
	PM_ULONG nMinor;
	DosQuerySysInfo( QSV_VERSION_MAJOR, QSV_VERSION_MAJOR, &nMayor, sizeof( nMayor ) );
	DosQuerySysInfo( QSV_VERSION_MINOR, QSV_VERSION_MINOR, &nMinor, sizeof( nMinor ) );

	ByteString aVerStr = (USHORT)(nMayor*10 + nMinor);
	USHORT nGUIVersion = (USHORT)aVerStr * 100;
	nGUIVersion += (USHORT)aVerStr.Erase( aVerStr.Search( "." ) + 1 );

	if ( eCPU != CPU_I386 &&
		 eCPU != CPU_I486 &&
		 eCPU != CPU_PENTIUM )
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_CPU_OS2 ) ) ).Execute();

	if ( nGUIVersion < 200 )
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_VER ) ) ).Execute();

	if (GetFreeMemory() < 7000)
		WarningBox( pParent, WB_OK, ByteString( ResId( ERR_CONFIG_MEM ) ) ).Execute();

	return TRUE;
}


// -----------------------------------------------------------------------
//
//  OS/2 spezifische Methioden
//
ByteString Os2OS::GetBootDrive()
{
	UCHAR Databuf[5];
	APIRET rc;
	ByteString aDrive;

	rc = DosQuerySysInfo( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, Databuf, sizeof(Databuf) );

	if ( !rc )
		aDrive = ByteString( (char)( Databuf[0] + 'A' - 1 ) ) + ByteString( ":\\" );
	return aDrive;
}

// -----------------------------------------------------------------------

void Os2OS::Shutdown()
{
	char* pVar = getenv("AUTOSTART");

	// Wenn Os2 mit automatischem Programmstart konfiguriert ist
	// als Kennung beim Shutdown eine Datei anlegen.
	//
	if (pVar != NULL
	&& (strstr(pVar,"programs") || strstr(pVar,"PROGRAMS")))
	{
		SvFileStream aStrm((SiDirEntry(GetBootDrive())+SiDirEntry(SETUP_TEMPFILE)).GetFull(), STREAM_WRITE );
		aStrm.WriteLine( "123" );
		aStrm.Close();
	}
	Window* pVCLWin = Application::GetAppWindow();
	const SystemEnvData* pSysData = pVCLWin->GetSystemData();

	HWND hWndFrame = WinQueryWindow( pSysData->hWnd, QW_PARENT );
	if( WinWindowFromID(hWndFrame,FID_CLIENT) == pSysData->hWnd )
		hWndFrame = pSysData->hWnd;

	HAB hab = WinQueryAnchorBlock( hWndFrame );
	ULONG hmq = WinQueryWindowULong( hWndFrame, QWL_HMQ );

	WinCancelShutdown( hmq, 1 );
	WinShutdownSystem( hab, hmq );
/*	WinPostMsg( hWndFrame, WM_QUIT, (MPARAM)0,(MPARAM)0 );
	WinDestroyMsgQueue( hmq );
*/
}

BOOL Os2OS::DoesTempFileExists()
// Temp-Datei suchen die ggf. nach einem Shutdown
// angelegt wurde.
{
	SiDirEntry aTmp  = Os2OS::GetBootDrive();
			 aTmp += SiDirEntry(SETUP_TEMPFILE);

	return aTmp.Exists();
 }

 void Os2OS::KillTempFile()
 {
	SiDirEntry aTmp  = Os2OS::GetBootDrive();
			 aTmp += SiDirEntry(SETUP_TEMPFILE);

	aTmp.Kill();
 }

// -----------------------------------------------------------------------

ByteString Os2OS::ReadOS2Ini(ByteString const& rAppName, ByteString const& rKey)
{
	ByteString aKeyValue;
	char szBuffer[256];
	szBuffer[0] = '\0';

	PrfQueryProfileByteString( HINI_USERPROFILE, (PSZ)rAppName.GetBuffer(),
		(PSZ)rKey.GetBuffer(), 0, (PSZ)szBuffer, sizeof(szBuffer));

	if ( szBuffer[0] )
		aKeyValue = ByteString( szBuffer );
	return aKeyValue;
}

BOOL Os2OS::WriteOS2Ini
(
	ByteString const& rAppName,
	ByteString const& rKey,
	ByteString const& rValue
)
{
	if ( rKey.Len() && rValue.Len() )
		return (BOOL)PrfWriteProfileByteString( HINI_USERPROFILE,
			(PSZ)rAppName.GetBuffer(), (PSZ)rKey.GetBuffer(), (PSZ)rValue.GetBuffer() );
	else if ( !rKey )
		return (BOOL)PrfWriteProfileByteString( HINI_USERPROFILE,
			(PSZ)rAppName.GetBuffer(), 0, (PSZ)rValue.GetBuffer() );
	else
		return (BOOL)PrfWriteProfileByteString( HINI_USERPROFILE,
			(PSZ)rAppName.GetBuffer(), (PSZ)rKey.GetBuffer(), 0 );
}


ULONG Os2OS::RegisterClass(ByteString const& rClass, ByteString const& rDLL)
{
	// try to create a hidden object of the class to register
	HOBJECT hObject = WinCreateObject((PSZ)rClass.GetBuffer(), "", "OBJECTID=<SO_TMP>",
									  "<WP_NOWHERE>", CO_REPLACEIFEXISTS);

	if(!hObject)
	{
		USHORT nIndex;
		ByteString aDLL(rDLL);

		nIndex = aDLL.SearchCharBackward("\\/");

		// remove leading path information
		if(nIndex != STRING_NOTFOUND)
		{
			aDLL.Erase(0, nIndex + 1);
		}

		nIndex = aDLL.SearchCharBackward(".");

		// remove extension ".DLL"
		if(nIndex != STRING_NOTFOUND)
		{
			aDLL.Erase(nIndex);
		}

		// register object class
		if (!WinRegisterObjectClass((PSZ)rClass.GetBuffer(), (PSZ)aDLL.GetBuffer()))
			return WinGetLastError(Sysdepen::GethAB());
	}
	else
	{
		WinDestroyObject(hObject);
	}

	return 0;
}


ULONG Os2OS::DeregisterClass(ByteString const& rClass)
{
	if (!WinDeregisterObjectClass ((PSZ)rClass.GetBuffer()))
		return WinGetLastError(Sysdepen::GethAB());
	else
		return 0;
}


ULONG Os2OS::RegisterTemplateIcon( const ByteString& aClassID, const ByteString& aTemplateID,
								   const ByteString& aIconPath)
{
	ByteString aStr( "TEMPLATE=YES;" );
	aStr += "OBJECTID=";
	aStr += aTemplateID;

	if(!WinCreateObject( aClassID.GetBuffer(), aClassID.GetBuffer(), aStr.GetBuffer(), "<WP_TEMPS>",
						 CO_REPLACEIFEXISTS) )
		return FALSE;

	return TRUE;
}

ByteString Os2OS::GetFavoritesFolderName()
{
	ByteString aReturn;
	HOBJECT hObject = WinQueryObject("<WP_COOLURLSFOLDER>");
	if( hObject != NULLHANDLE )
	{
		char szPath[CCHMAXPATH +1];
		if( WinQueryObjectPath(hObject, szPath, sizeof(szPath)) )
			aReturn = szPath;
	}
	return aReturn;
}

BOOL Os2OS::DeleteTemplate(ByteString const& anTemplateID)
{
	HOBJECT hObject = WinQueryObject(anTemplateID.GetBuffer());
	if (hObject == NULLHANDLE)
		return FALSE;

	return WinDestroyObject(hObject);
}

BOOL Os2OS::CreateFolder
(
	ByteString const& aFolderID,    // <OFFICE_FOLDER3>
	ByteString const& aFolderName,  // "StarOffice 3.1"
	ByteString const& aOpenIcon,
	ByteString const& aCloseIcon
)
{
	ByteString Str;

	if (aOpenIcon.Len() != 0)
	{
		Str += "ICONFILE=";
		Str += aCloseIcon;
		Str += ";";
	}

	if (aCloseIcon.Len() != 0)
	{
	   Str += "ICONNFILE=1,";
	   Str += aOpenIcon;
	   Str += ";";
	}

	Str += "OBJECTID=<";
	Str += aFolderID;
	Str += ">";

	HOBJECT hobjFolder
		= WinCreateObject
				(
					(PSZ)"WPFolder",
					aFolderName,
					Str,
					(PSZ)"<WP_DESKTOP>",
					CO_REPLACEIFEXISTS
				);

	return hobjFolder != NULLHANDLE;
}

BOOL Os2OS::DeleteFolder(ByteString const& rFolderID)
{
	ByteString anID  = '<';
		   anID += rFolderID;
		   anID += '>';

	HOBJECT hObject = WinQueryObject(anID);

	if (hObject == NULLHANDLE)
		return FALSE;

	return WinDestroyObject(hObject);
}

BOOL Os2OS::IsFolderInstalled(ByteString const& rFolderID)
{
	ByteString anID  = '<';
		   anID += rFolderID;
		   anID += '>';

	return WinQueryObject(anID) != NULLHANDLE;
}

BOOL Os2OS::CreateFolderItem
(
	ByteString const& aFolderID,    // <OFFICE_FOLDER3>
	ByteString const& anItemID,     // <WRITER3_EXE>
	ByteString const& anItemName,   // StarWriter 3.0
	ByteString const& aClassName,   // WPStOfExe
	ByteString const& aCreater,     // StarWriter 3.0
	ByteString const& aFile,
	ByteString const& aFilterList   // *.sdd, *.var
)
{
	ByteString Str  = "EXENAME=";
		   Str += aFile;
		   Str += ";OBJECTID=<";
		   Str += anItemID;
		   Str += '>';

	if (aCreater.Len() > 0)
	{
		Str += ";ASSOCTYPE=";
		Str += aCreater;
	}

	if (aFilterList.Len() > 0)
	{
		Str += ";ASSOCFILTER=";
		Str += aFilterList;
	}

	HOBJECT hobject = WinCreateObject
			(
				aClassName,
				anItemName,
				Str,
				ByteString("<") + aFolderID + ByteString(">"),
				CO_REPLACEIFEXISTS
			);

	 return hobject != NULLHANDLE;
}

BOOL Os2OS::CreateFolderItem
(
	ByteString const& aFolderID,    // <OFFICE_FOLDER3>
	ByteString const& anItemID,     // <WRITER3_EXE>
	ByteString const& anItemName,   // StarWriter 3.0
	ByteString const& aReference
)
{
	ByteString Str = "SHADOWID=<";
		   Str += aReference;
		   Str += ">;OBJECTID=<";
		   Str += anItemID;
		   Str += ">";

	HOBJECT hobject = WinCreateObject
	(
		(PSZ)"WPShadow",
		anItemName,
		Str,
		ByteString("<") + aFolderID + ByteString(">"),
		CO_REPLACEIFEXISTS
	);

	return hobject != NULLHANDLE;
}

BOOL Os2OS::DeleteFolderItem(ByteString const& rItemID)
{
	ByteString anID  = '<';
		   anID += rItemID;
		   anID += '>';

	HOBJECT hObject = WinQueryObject(anID);

	if (hObject == NULLHANDLE)
		return FALSE;

	return WinDestroyObject(hObject);
}

BOOL Os2OS::IsFolderItemInstalled(ByteString const& rItemID)
{
	ByteString anID  = '<';
		   anID += rItemID;
		   anID += '>';

	return WinQueryObject(anID) != NULLHANDLE;
}


BOOL Os2OS::SetFileTypeAndIcon
(
	ByteString const& aFile,
	ByteString const& aFileType,
	ByteString const& anIcon
)
{
	SvEaMgr anEAMgr = aFile;

	anEAMgr.SetFileType(aFileType);
	return anEAMgr.SetIcon(anIcon);
}

BOOL Os2OS::IsFATFileSystem(const ByteString& rPath)
{
	BYTE		fsqBuffer[ sizeof(FSQBUFFER2) + 3 * CCHMAXPATHCOMP ];
	PFSQBUFFER2 pFSQBuffer = (PFSQBUFFER2) &fsqBuffer;
	ULONG		n = sizeof( fsqBuffer );
	APIRET		rc;
	PSZ			cp;
	char		szDrive[3];

	SiDirEntry aEntry( rPath );
	aEntry.ToAbs();

	szDrive[0] = aEntry.GetFull().GetChar(0);
	szDrive[1] = ':';
	szDrive[2] = 0x00;

	rc = DosQueryFSAttach( szDrive, 0, FSAIL_QUERYNAME, pFSQBuffer, &n );
	if( rc )
		return FALSE;

	cp = (PSZ) pFSQBuffer->szName + pFSQBuffer->cbName + 1;
	return strcmp( cp, "FAT" ) == 0;
}

BOOL Os2OS::JoinEAs(ByteString const& aFile, ByteString const& anEAFile)
// Uebernommener Code aus altem Setup!
{
	EAOP2 eaop; // extended attributes
	eaop.fpGEA2List = NULL;
	int nSize = 0;

	int fh = open(anEAFile, O_RDONLY | O_BINARY );
	if( -1 == fh )
		return FALSE;
	for(;;)
	{
		int nRead = read( fh, &nSize, sizeof(nSize) );
		if( nRead != sizeof(nSize) )
			break;
		char* pBuf = new char[nSize];
		nRead = read( fh, pBuf, nSize );
		if ( nRead != nSize )
			break;
		eaop.fpFEA2List = (PFEA2LIST)pBuf;
		APIRET rc = DosSetPathInfo ( (PSZ)aFile.GetBuffer(), 2, (PVOID)&eaop, sizeof(EAOP2),
			DSPI_WRTTHRU );
		delete pBuf;
		if ( rc )
		{
			close(fh);
			return FALSE;
		}
	}
	close(fh);
	return TRUE;
}

BOOL Os2OS::ReplaceModule(const char* pDest, const char* pSource)
{
	APIRET nErr = DosReplaceModule( (PSZ)pDest, (PSZ)pSource, NULL );
	return nErr == 0;
}

USHORT Os2OS::GetOSVersion()
{
	PM_ULONG nMayor;
	PM_ULONG nMinor;
	DosQuerySysInfo( QSV_VERSION_MAJOR, QSV_VERSION_MAJOR, &nMayor, sizeof( nMayor ) );
	DosQuerySysInfo( QSV_VERSION_MINOR, QSV_VERSION_MINOR, &nMinor, sizeof( nMinor ) );

	USHORT nVersion = (USHORT)(nMayor*10 + nMinor);
	return nVersion;
}
