/*************************************************************************
 *
 *  $RCSfile: nunxos.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/10 16:36:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <utime.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#if defined(NETBSD) || defined(FREEBSD)
#include <sys/param.h>
#include <sys/mount.h>
#elif defined(MACOSX)
#include <sys/mount.h>
#else
#include <sys/statvfs.h>
#endif

#include "svunzip.h"

#ifndef _NUNXOS_HXX
#include "nunxos.hxx"
#endif

// ============================================================================
// ============================================================================
// ============================================================================

unsigned short _WildcardMatch( const char *pWild, const char *pStr )
{
    int    pos=0;
    int    flag=0;

    while ( *pWild || flag )
    {
        switch (*pWild)
        {
            case '?':
                if ( *pStr == '\0' )
                    return 0;
                break;

            default:
                if ( (*pWild == '\\') && ((*(pWild+1)=='?') || (*(pWild+1) == '*')) )
                    pWild++;
                if ( *pWild != *pStr )
                    if ( !pos )
                        return 0;
                    else
                        pWild += pos;
                else
                    break;          // ACHTUNG laeuft unter bestimmten
                                    // Umstaenden in den nachsten case rein!!
            case '*':
                while ( *pWild == '*' )
                    pWild++;
                if ( *pWild == '\0' )
                    return 1;
                flag = 1;
                pos  = 0;
                if ( *pStr == '\0' )
                    return ( *pWild == '\0' );
                while ( *pStr && *pStr != *pWild )
                {
                    if ( *pWild == '?' ) {
                        pWild++;
                        while ( *pWild == '*' )
                            pWild++;
                    }
                    pStr++;
                    if ( *pStr == '\0' )
                        return ( *pWild == '\0' );
                }
                break;
        }
        if ( *pWild != '\0' )
            pWild++;
        if ( *pStr != '\0' )
            pStr++;
        else
            flag = 0;
        if ( flag )
            pos--;
    }
    return ( *pStr == '\0' ) && ( *pWild == '\0' );
}

// ============================================================================
// ============================================================================
// ============================================================================

UnxOS::UnxOS( int argc, char* argv[] )
{
}

//DONE
int UnxOS::Startup( int argc, char* argv[] )
{
	return 0;
}

//DONE
void UnxOS::Terminate()
{
}

//DONE
void UnxOS::GetSVersion( char* buf, int len )
{
	strcpy( buf, getenv("HOME") );
	strcat( buf, "/.sversionrc" );
}

//DONE
BOOL UnxOS::makeDir( char* path, int rights )
{
	mode_t  mode;
	int     right;

	// rights z.B. 644
	right = rights / 100;
	rights %= 100;
	if ( right == 7 )
	{
		mode = S_IRWXU;
	}
	else if ( right == 6 )
	{
		mode = S_IRUSR | S_IWUSR;
	}
	else if ( right == 5 )
	{
		mode = S_IRUSR | S_IXUSR;
	}
	else if ( right == 4 )
	{
		mode = S_IRUSR;
	}
	else if ( right == 3 )
	{
		mode = S_IWUSR | S_IXUSR;
	}
	else if ( right == 2 )
	{
		mode = S_IWUSR;
	}
	else if ( right == 1 )
	{
		mode = S_IXUSR;
	}
	right = rights / 10;
	rights %= 10;
	if ( right == 7 )
	{
		mode |= S_IRWXG;
	}
	else if ( right == 6 )
	{
		mode |= S_IRGRP | S_IWGRP;
	}
	else if ( right == 5 )
	{
		mode |= S_IRGRP | S_IXGRP;
	}
	else if ( right == 4 )
	{
		mode |= S_IRGRP;
	}
	else if ( right == 3 )
	{
		mode |= S_IWGRP | S_IXGRP;
	}
	else if ( right == 2 )
	{
		mode |= S_IWGRP;
	}
	else if ( right == 1 )
	{
		mode |= S_IXGRP;
	}
	right = rights;
	if ( right == 7 )
	{
		mode |= S_IRWXO;
	}
	else if ( right == 6 )
	{
		mode |= S_IROTH | S_IWOTH;
	}
	else if ( right == 5 )
	{
		mode |= S_IROTH | S_IXOTH;
	}
	else if ( right == 4 )
	{
		mode |= S_IROTH;
	}
	else if ( right == 3 )
	{
		mode |= S_IWOTH | S_IXOTH;
	}
	else if ( right == 2 )
	{
		mode |= S_IWOTH;
	}
	else if ( right == 1 )
	{
		mode |= S_IXOTH;
	}

	return mkdir( path, mode ) == 0 ? TRUE : FALSE;
}

//DONE
BOOL UnxOS::removeDir( char* path )
{
	return rmdir( path ) == 0 ? TRUE : FALSE;
}

//DONE
BOOL UnxOS::deleteFile( char* path, char* pattern, BOOL testdate,
						int hour, int min, int sec, int day, int month, int year )
{
	DIR*			dirp = opendir(path);
	struct dirent*	dp = NULL;
	char   			file[1024];

	while( dirp && ( dp = readdir(dirp) ) )
		if ( strcmp( dp->d_name, "." ) == 0 || strcmp( dp->d_name, ".." ) == 0 )
		  continue;
	        else if( _WildcardMatch(pattern, dp->d_name) )
		{
			sprintf( file, "%s/%s", path, dp->d_name );

			BOOL deletefile = TRUE;
			if( testdate )
			{
				struct stat filestat;
				stat( file, &filestat );

				tm atm;
    			tm *pTime;

				pTime = localtime_r( &filestat.st_mtime, &atm );

				if( pTime->tm_hour != hour		||
					pTime->tm_min  != min	   	||
					pTime->tm_sec  != sec		||
					pTime->tm_mday != day		||
					(pTime->tm_mon+1)  != month		||
					(pTime->tm_year+1900) != year )
					deletefile = FALSE;
			}

			if( deletefile )
			{
				unlink(file);
			}
		}

 	if ( dirp ) closedir(dirp);
	return TRUE;
}

BOOL UnxOS::copyFile(char* source, char* destination)
{
	FILE*  file1 = fopen( source, "rb" );
	FILE*  file2 = fopen( destination, "wb" );
	char   buf[1024];
	int    num = 0;

	if ( ( file1 != NULL) && ( file2 != NULL ) )
	{
		while ( ( num = fread( buf, sizeof( char ), 1024, file1 ) ) > 0 )
		{
			fwrite( buf, sizeof( char ), num, file2 );
		}
		fclose( file1 );
		fclose( file2 );
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

BOOL UnxOS::unzipFile(char* source, char* pattern, char* destination)
{
/*    if( chdir(destination) == -1 ) return FALSE;
    ::SVUnzip( source, pattern, (const char*)"qq", NULL );
*/
	return TRUE;
}

//DONE
void UnxOS::setDateTime(char* filename, int hour, int min, int sec, int day, int month, int year )
{
	if( day == 17 && month == 2 && year == 1969 ) return;

	time_t  t;
	struct tm times, *t1, *t2;

	t1 = localtime( &t ); // get time adjusted to local timezone and daylightsavings
	t2 = gmtime( &t );	  // get the internal time
	times.tm_year = year  - 1900 + t2->tm_year - t1->tm_year;  	// 1997 -> 97
	times.tm_mon  = month - 1 + t2->tm_mon - t1->tm_mon;		// 0=Januar!
	times.tm_mday = day + t2->tm_mday - t1->tm_mday;

	times.tm_hour = hour + t2->tm_hour - t1->tm_hour;
	times.tm_min  = min + t2->tm_min - t1->tm_min;
	times.tm_sec  = 0;

	times.tm_wday  = 0;
	times.tm_yday  = 0;
#ifdef SOLARIS
	times.tm_isdst = -1;
#else
	times.tm_isdst = 0;
#endif

	time_t time = mktime (&times);
	if (time != (time_t) -1)
	{
		struct utimbuf u_time;
		u_time.actime = time;
		u_time.modtime = time;
		utime (filename, &u_time);
	}
}

void UnxOS::setRights(char* filename, int rights)
{
	int nOctal = 0;
	int nRights = rights;

	nOctal 	 = nRights / 100;
	nRights %= 100;

	nOctal  *= 8;
	nOctal  += nRights / 10;
	nRights %= 10;

	nOctal  *= 8;
	nOctal  += nRights;

	chmod( filename, nOctal );
}

#if defined(FREEBSD) || defined(NETBSD)
#define statvfs statfs
#endif

//DONE
unsigned long UnxOS::GetFreeDriveSize( char* _cDrive )
{
#ifdef MACOSX
    long size, i;
    struct statfs *buf;

    size = getmntinfo(&buf, MNT_NOWAIT);
    for (i = 0; i < size; i++) {
        if (!strcmp(buf[i].f_mntonname, _cDrive))
        {
            const unsigned long nSize = buf[i].f_bsize;
            return (nSize < 1024 ? buf[i].f_bavail / (1024 / nSize)
                : nSize > 1024 ? buf[i].f_bavail * (nSize / 1024)
                : buf[i].f_bavail);
        }
    }
    return 0;
#else

  	struct statvfs buf;
	char*  pDir = _cDrive;

	while (( pDir != NULL) && ( statvfs (pDir, &buf) == -1 ) )
	{
		char*  pPart = strrchr(pDir, '/');

		if ( pPart == NULL )
			pDir = NULL;
		else
			pDir[strlen( pDir ) - strlen( pPart )] = '\0';
	}
	if ( pDir == NULL )
		return 0;
#if defined(LINUX) || defined(NETBSD) || defined(FREEBSD)
	const unsigned long nSize = buf.f_bsize;
#else
	const unsigned long nSize = (buf.f_frsize ? buf.f_frsize : buf.f_bsize);
#endif

	return (nSize < 1024 ? buf.f_bavail / (1024 / nSize)
		: nSize > 1024 ? buf.f_bavail * (nSize / 1024)
		: buf.f_bavail);
#endif
}

//DONE
unsigned long UnxOS::GetClusterSize( char* _cDrive )
{
#ifdef MACOSX
    long size, i;
    struct statfs *buf;

    size = getmntinfo(&buf, MNT_NOWAIT);
    for (i = 0; i < size; i++) {
        if (!strcmp(buf[i].f_mntonname, _cDrive))
            return (buf[i].f_bsize);
    }
    return 32768;

#else
  	unsigned long nReturn;
	struct statvfs buf;
	char*  pDir = _cDrive;

	while (( pDir != NULL) && ( statvfs (pDir, &buf) == -1 ) )
	{
		char*  pPart = strrchr(pDir, '/');

		if ( pPart == NULL )
			pDir = NULL;
		else
			pDir[strlen( pDir ) - strlen( pPart )] = '\0';
	}
	if ( pDir == NULL )
		return 32768;


#if defined(LINUX) || defined(NETBSD) || defined(FREEBSD)
	nReturn = buf.f_bsize;
#else
	nReturn = (buf.f_frsize ? buf.f_frsize : buf.f_bsize);
#endif //LINUX

	if( !nReturn ) nReturn = 32768;
	return nReturn;
#endif
}

//DONE
void UnxOS::getNSPluginDir(char* buf)
{
	const char* pEnv = getenv( "HOME" );
	if( pEnv )
	{
		strcpy( buf, pEnv );
		strcat( buf, "/.netscape/plugins" );

		if ( access( buf, F_OK ) != 0 )
		{	// create the directory
			strcpy( buf, pEnv );
			strcat( buf, "/.netscape" );
			makeDir( buf, 755 );

			strcat( buf, "/plugins" );
			makeDir( buf, 755 );
		}
		return;
	}

	pEnv = getenv( "NPX_PLUGIN_PATH" );
	if( pEnv )
	{
		strcpy( buf, pEnv );
		if ( access( buf, F_OK ) == 0 )
		{
			return;
		}
	}

	strcpy( buf, "/usr/lib/netscape/plugins" );
	if ( access( buf, F_OK ) == 0 )
	{
		return;
	}
	// plugin directory not found
	strcpy( buf, "" );
	return;
}

void UnxOS::getNS6PluginDir(char* buf)
{
	const char* pEnv = getenv( "HOME" );
	if( pEnv )
	{
		strcpy( buf, pEnv );
		strcat( buf, "/.netscape6/plugins" );

		if ( access( buf, F_OK ) != 0 )
		{	// create the directory
			strcpy( buf, pEnv );
			strcat( buf, "/.netscape6" );
			makeDir( buf, 755 );

			strcat( buf, "/plugins" );
			makeDir( buf, 755 );
		}
		return;
	}

	pEnv = getenv( "NPX_PLUGIN_PATH" );
	if( pEnv )
	{
		strcpy( buf, pEnv );
		if ( access( buf, F_OK ) == 0 )
		{
			return;
		}
	}

	strcpy( buf, "/usr/lib/netscape6/plugins" );
	if ( access( buf, F_OK ) == 0 )
	{
		return;
	}
	// plugin directory not found
	strcpy( buf, "" );
	return;
}

//DONE
void UnxOS::getOSDir(char* buf)
{
	strcpy( buf, "" );
}

//DONE
void UnxOS::getOSSystemDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getOSsystemFontDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getHomeDir(char* buf)
{
	strcpy( buf, getenv("HOME") );
}

void UnxOS::getConfigDir(char* buf)
{
	strcpy( buf, getenv("HOME") );
}

void UnxOS::getServiceDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getOSShellnewDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getAutoStart(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getOSDesktopDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getBookmarkDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getPersonalDir(char* buf)
{
	strcpy( buf, "" );
}

void UnxOS::getIEPluginDir(char* buf, BOOL bPlugin )
{
}

void UnxOS::getIEDir(char* buf)
{
}

void UnxOS::createShortcut(char* source, char* destination, char* path, char* description, char* parameters)
{
	symlink( source, destination );
}

void UnxOS::createProgramFolder(char* name, BOOL user)
{
}

void UnxOS::createProgramFolderItem(char* foldername, char* itemname, char* destpath, char* destexec, char* param, BOOL user )
{
}

void UnxOS::removeProgramFolder(char* name, BOOL user)
{
}

void UnxOS::removeProgramFolderItem(char* foldername, char* itemname, BOOL user)
{
}

void UnxOS::winRegistry(char* key, char* subkey, char* name, char* value, BOOL create, BOOL hex, BOOL deleteall, BOOL expand, BOOL bKeyOnly )
{
}

void UnxOS::addFont(char* fontfile, char* fontname )
{
}

void UnxOS::removeFont(char* fontfile, char* fontname )
{
}

void UnxOS::getDriveList(char* buf)
{
	strcpy( buf, "/" );
}

